/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.CRSShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;

public class SIHAStartupAction
extends CRSShutDownStartupAction {
    public SIHAStartupAction() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    @Override
    public List<ExecutionStep> generateCRSSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateCRSSteps(patchTarget);
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        List<ExecutionStep> steps = null;
        boolean actsOnclone = false;
        ServiceStatus serviceStatus = ServiceStatus.UP;
        if (patchTarget.getHomeClone() != null) {
            actsOnclone = true;
            serviceStatus = ServiceStatus.DOWN;
            if (!this.getPatchSession().isRollback()) {
                String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
                generatedSteps.addAll(this.getUpdateBootStrappingInClone(patchTarget, targetHome));
            }
            DBPatchingSummaryCreator summaryCreator = this.getProductSupport().getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            String summary = "[Note]: Please verify the database is running from the desired Oracle home, if not then manually execute \n $ORACLE_HOME/bin/srvctl modify database command to fix the problem";
            if (this.getSupportedProductTypes().contains(patchTarget.getProductType().getType())) {
                summaryCreator.storePatchingSummary(0, SummaryID.patching_warning, patchTarget, summary);
            }
        }
        if (!actsOnclone) {
            steps = this.getRootAddRDBMSCommandExecutionSteps(this.configGraph, patchTarget, "siha");
            generatedSteps.addAll(steps);
        }
        ArrayList<String> readMeMsg = new ArrayList<String>();
        if (isTwelveVersion) {
            boolean isRollback = this.getPatchSession().isRollback();
            if (isRollback) {
                readMeMsg.add("Rootcrs-Postpatch-Rollback-Title");
                readMeMsg.add("Rootcrs-Postpatch-Rollback-Reboot-Message");
            } else {
                readMeMsg.add("Rootcrs-Postpatch-Title");
                readMeMsg.add("Rootcrs-Postpatch-Reboot-Message");
            }
            steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "siha", serviceStatus, readMeMsg, DBCommandActionType.rootcrs.toString(), actsOnclone, DBCommandParameters.POSTPATCH.getValue());
            generatedSteps.addAll(steps);
        } else {
            readMeMsg.add("Rootcrs-Patch-Title");
            readMeMsg.add("Rootcrs-Patch-Message");
            steps = this.getrootCRSCommandExecutionSteps(this.configGraph, patchTarget, "siha", serviceStatus, readMeMsg, CommandActionType.shell.toString(), false, DBCommandParameters.PATCH.getValue());
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        return targetList;
    }
}

