/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionGroup;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.TrackOOPSessions;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.idprocessor.PatchIDProcessor;
import com.oracle.glcm.patch.auto.db.framework.patchinfostore.PatchingSessionInfoStore;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.CloneCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.MakeCloneHome;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.PatchZipConstructor;
import com.oracle.glcm.patch.auto.db.integration.controller.action.CloneOracleHomeAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.CloneOracleHomeStartupAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBPrereqAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DeleteInactivePatchesInPlace;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DeletePatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.GILockPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.GIMRPostPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.GIMRPrePatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.GIOnlinePostPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.GIOnlinePrePatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.GIUnlockPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.OJVMPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.OPatchAutoBinaryAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.RHPPostPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.RHPPrePatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.RRPInPlacePrePatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.RemoteDeleteAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.RunRootAddRDBMSPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.SwitchAnalyzeAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.TwoStagePostApplyInPlaceAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.UpdateRuntimeData;
import com.oracle.glcm.patch.auto.db.integration.controller.action.ValidationPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.GIShutDownAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.GIStartupAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.RACFinalizeStartAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.RACOneAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.RACOnlineAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.RACPatchingAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.RACPrepareShutDownAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.RACShutDownAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.RACStartupAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.crs.RemoteGIStopAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.ClusterStartupFinalizeAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.CopyDatapatchLibsAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.CopyHomePatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.CopyOBHPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.CopyOOPSessionFilePatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.DatabaseStartupFinalizeAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.DeleteInactivePatchesOOP;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.GIMRPrePostOOPPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.PostCloneOracleHomeAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.TwoStageOOPPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.TwoStagePostApplyOOPAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.sidb.SIDBSwitchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIDBFinalizeStartAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIDBOnlineAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIDBPatchingAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIDBPrePostScriptAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIDBPrepareShutDownAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIDBShutDownAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIDBStartupAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIHAShutDownAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.siha.SIHAStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBCommonSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.GIProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.ProductSupportHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.RACNonSharedProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.RACProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.RACSharedProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.SIDBProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.SIHAProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.helper.ProductSupportAgent;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.CRSTopologyBuilder;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.report.patches.DBPatchReporting;
import com.oracle.glcm.patch.auto.db.product.summary.AdminPolicyManagedHomeDetails;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationController;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationPhase;
import com.oracle.glcm.patch.auto.db.utils.BootstrapUtil;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.report.OPatchAutoReporting;
import com.oracle.glcm.patch.auto.report.OPatchAutoReportingManager;
import com.oracle.glcm.patch.auto.session.MutablePatchTarget;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Topology;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;

public class DBBaseProductSupport
extends DBCommonSupport {
    private static final Logger _log = Logger.getLogger(DBBaseProductSupport.class.getName());
    boolean skipGridHome = false;

    @Override
    public Set<ProductType> loadProductTypes() {
        LinkedHashSet<ProductType> productTypes = new LinkedHashSet<ProductType>();
        productTypes.add(new GIProductType());
        productTypes.add(new RACProductType());
        productTypes.add(new RACSharedProductType());
        productTypes.add(new RACNonSharedProductType());
        productTypes.add(new SIHAProductType());
        productTypes.add(new SIDBProductType());
        if (_log.isLoggable(Level.INFO)) {
            _log.log(Level.INFO, "Product types loaded...");
        }
        return productTypes;
    }

    @Override
    public void loadTopology(OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        if (this.getTopology() == null) {
            List<ValidationResult> failedValidations;
            this._topologyBuilder.setDefaultProductTypeRequired(this.isDefaultTopologyDisable(options));
            super.loadTopology(options, credentialManager);
            PatchPlanner.getInstance().getLogger().setupLogs();
            IOUtils.chownAllLogFiles();
            this._topologyBuilder.buildTopology(credentialManager);
            this.handleOOPSession(options, credentialManager);
            this.libPathMap.putAll(this._topologyBuilder.getLibPathMap());
            this.storeAdminPolicyManagedSkippedDBSummary();
            this.setTopology(this._topologyBuilder.getTopology());
            if (this.isPatchCompressionRequired(options)) {
                if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "Creating zip from patch...");
                }
                String patchLocation = DBPatchingHelper.getPatchLocation(options);
                PatchZipConstructor patchZipConstructor = new PatchZipConstructor();
                patchZipConstructor.createzip(this.getTopology(), patchLocation);
            }
            OPatchAutoOption deployOnlyOption = options.getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue());
            Boolean isDeployOnly = Boolean.valueOf(deployOnlyOption.getValue());
            int status = 0;
            Object payLoad = null;
            if (!(isDeployOnly.booleanValue() || this.command.isReport() || (failedValidations = this.validate(options)).isEmpty())) {
                status = failedValidations.get(0).getFailureReason().getErrorCode();
                payLoad = failedValidations.get(0).getPayload();
            }
            if (status != 0) {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(status), (Object[])new Object[]{payLoad}), new Object[0]);
            }
        }
    }

    private List<ValidationResult> validate(OPatchAutoOptions options) throws OPatchAutoException {
        boolean sidbOnlyOption;
        ValidationParam params = new ValidationParam();
        params.set(ValidationParamKey.TOPOLOGY.ordinal(), this.getTopology());
        params.set(ValidationParamKey.CONFIG_GRAPH.ordinal(), PatchPlanner.getInstance().getConfigGraph());
        params.set(ValidationParamKey.PERL_LIB_MAP.ordinal(), this.getLibPathMap());
        params.set(ValidationParamKey.VALIDATION_PHASE.ordinal(), (Object)ValidationPhase.POST_TOPOLOGY);
        OPatchAutoOption option = options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue());
        boolean isRemote = Boolean.valueOf(option.getValue());
        params.set(ValidationParamKey.REMOTE_PATCHING.ordinal(), isRemote);
        boolean isAnalyzeSession = options.getOption("analyze").isSwitchEnabled();
        params.set(ValidationParamKey.ANALYZE_OPTION.ordinal(), isAnalyzeSession);
        params.set(ValidationParamKey.OOP_ENABLED.ordinal(), DBPatchingHelper.isOOPPatchingSession(options));
        params.set(ValidationParamKey.OOP_OPERATION_TYPE.ordinal(), (Object)DBPatchingHelper.getOperationType(options));
        params.set(ValidationParamKey.WALLET_LOC.ordinal(), DBPatchingHelper.getWalletLocation(options));
        params.set(ValidationParamKey.GENERATE_STEP_OPTION.ordinal(), DBPatchingHelper.isGenerateStepCommand(options));
        params.set(ValidationParamKey.NONROLLING_OPTION.ordinal(), options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled());
        boolean bl = sidbOnlyOption = Boolean.valueOf(options.getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue()) != false || options.getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
        if (sidbOnlyOption) {
            params.set(ValidationParamKey.SIDB_ONLY.ordinal(), true);
        }
        if (!(this.command.isRollback() && !StringUtil.isNullOrEmpty((String)options.getOption("id").getValue()) || DBPatchingHelper.isOOPSwitchPatchingSession(options))) {
            params.set(ValidationParamKey.PATCH_LOC.ordinal(), DBPatchingHelper.getPatchLocation(options));
        }
        DBValidationController validationController = new DBValidationController();
        List<ValidationResult> failedValidations = validationController.invoke(params);
        return failedValidations;
    }

    private void handleOOPSession(OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        String oopSessionFilePath = OPatchAutoHelper.getOPatchAutoHome() + sessionInfoFile;
        if (DBPatchingHelper.isOOPPatchingSession(options)) {
            OOPSessionInfoHandler oopSessionInfoHandler = OOPSessionInfoHandler.getInstance();
            oopSessionInfoHandler.setCredentialManager(credentialManager);
            File systemInstanceFileObj = ((CRSTopologyBuilder)this._topologyBuilder).getSystemInstanceFile();
            if ((DBPatchingHelper.isSingleOOPPatchingSession(options) || DBPatchingHelper.isOOPPreparePatchingSession(options)) && !this.command.isResumed()) {
                String patchDirName = this.getPatchDirName(options);
                String cloneHomePathPropertiesFile = this.getClonePropertiesFilePath(options);
                String sessionID = options.getOption("session").getValue();
                String systemInstanceFile = systemInstanceFileObj.getAbsolutePath();
                oopSessionInfoHandler.initializeSessionInfo(systemInstanceFile, patchDirName, this._topologyBuilder.getTopology(), DBPatchingHelper.getOperationType(options), cloneHomePathPropertiesFile, options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue()).isSwitchEnabled(), options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled(), DBPatchingHelper.getPatchLocation(options), sessionID);
            } else if (DBPatchingHelper.isOOPSwitchPatchingSession(options) && !this.command.isResumed()) {
                OOPSessionCookie.OOPOperationType oopOperationType = OOPSessionCookie.OOPOperationType.SWITCH;
                boolean rollback = options.getCommand().isRollback();
                if (rollback) {
                    oopOperationType = OOPSessionCookie.OOPOperationType.ROLLBACK;
                }
                String systemInstanceFile = null;
                if (systemInstanceFileObj != null) {
                    systemInstanceFile = systemInstanceFileObj.getAbsolutePath();
                }
                oopSessionInfoHandler.initializeSwitchSession(systemInstanceFile, this._topologyBuilder.getTopology(), oopOperationType, options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue()).isSwitchEnabled(), options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled());
            }
        }
    }

    private String getClonePropertiesFilePath(OPatchAutoOptions options) throws OPatchAutoException {
        OPatchAutoOption silentOpt = options.getOption(DBProductParameterConstants.OUT_OF_PLACE_SILENT.getValue());
        String clonePropertiesFile = null;
        if (silentOpt != null && silentOpt.hasValue()) {
            clonePropertiesFile = silentOpt.getValue();
        }
        return clonePropertiesFile;
    }

    private String getPatchDirName(OPatchAutoOptions options) throws OPatchAutoException {
        PatchInfo patchInfo = this.getPatchInfo(options);
        String patchName = null;
        if (!StringUtil.isNullOrEmpty((String)patchInfo.getPatchLocation())) {
            patchName = new File(patchInfo.getPatchLocation()).getName();
        } else if (!StringUtil.isNullOrEmpty((String)patchInfo.getPatchBaseDirectory())) {
            patchName = new File(patchInfo.getPatchBaseDirectory()).getName();
        }
        return patchName;
    }

    @Override
    protected void initializePatchData(OPatchAutoOptions options, CredentialManager credentialMgr) throws OPatchAutoException {
        super.initializePatchData(options, credentialMgr);
        if (this.command.isResumed() && this.isPatchIDForRollback(options)) {
            PatchIDProcessor.getInstance().updatePatchPackage();
        }
    }

    private boolean isPatchCompressionRequired(OPatchAutoOptions options) throws OPatchAutoException {
        OPatchAutoOption remoteOption = options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue());
        boolean isRemote = Boolean.valueOf(remoteOption.getValue());
        String currentUser = System.getProperty("user.name");
        boolean isRootUser = "root".equals(currentUser);
        boolean isPatchAccessAvailable = DBPatchingHelper.isGenerateStepCommand(options) || this.isPatchIDForRollback(options) || isRootUser || DBPatchingHelper.isOOPSwitchPatchingSession(options) || options.getCommand().isReport() || !isRemote && this.isSameHomeOwnersForLocalExecution(currentUser);
        _log.info("Is patch access available=" + isPatchAccessAvailable);
        return !isPatchAccessAvailable;
    }

    private boolean isSameHomeOwnersForLocalExecution(String currentUser) {
        boolean isSameOwner = true;
        try {
            Topology topology = this.getTopology();
            for (Home home : topology.getHomes()) {
                Path file = Paths.get(home.getLocation(), "oraInst.loc");
                UserPrincipal userPrincipal = Files.getOwner(file, new LinkOption[0]);
                if (currentUser.equals(userPrincipal.getName())) continue;
                isSameOwner = false;
            }
        }
        catch (IOException e) {
            isSameOwner = false;
        }
        _log.info("Is oracle homes owned by same owner=" + isSameOwner);
        return isSameOwner;
    }

    private boolean isPatchIDForRollback(OPatchAutoOptions options) {
        boolean isPatchID = false;
        try {
            isPatchID = !StringUtil.isNullOrEmpty((String)options.getOption("id").getValue());
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        return isPatchID;
    }

    public Set<OPatchAutoOption> getOptions() {
        OPatchAutoOption nonrolling = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.NONROLLING_MODE_KEY.getValue(), (String)"-nonrolling", (String)"opatchauto.option.nonrolling.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        nonrolling.setDefaultValue("false");
        OPatchAutoOption generateSteps = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.GENERATE_STEPS_KEY.getValue(), (String)"-generatesteps", (String)"opatchauto.option.generateSteps.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption systemSnapshotFilePath = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SYSTEM_SNAPSHOT_FILE_PATH_KEY.getValue(), (String)"-systemsnapshotfilepath", (String)"opatchauto.option.systemsnapshotfilepath.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        systemSnapshotFilePath.setVisible(false);
        OPatchAutoOption customConfigDir = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.CUSTOM_CONFIG_DIR.getValue(), (String)"-customConfigDir", (String)"opatchauto.option.customconfigdir.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report});
        customConfigDir.setVisible(false);
        OPatchAutoOption noRestart = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.NORESTART_KEY.getValue(), (String)"-norestart", (String)"opatchauto.option.norestart.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption database = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.DATABASE_KEY.getValue(), (String)"-database", (String)"opatchauto.option.database.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption remote = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.REMOTE_KEY.getValue(), (String)"-shardremote", (String)"opatchauto.option.remote.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report});
        remote.setVisible(false);
        OPatchAutoOption sidbOnly = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SIDB_ONLY.getValue(), (String)"-sidbonly", (String)"opatchauto.option.sidbonly.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption family = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.FAMILY.getValue(), (String)"-family", (String)"opatchauto.option.family.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption inPlace = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.IN_PLACE_KEY.getValue(), (String)"-inplace", (String)"opatchauto.option.inplace.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption reportAnalyzeFailure = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue(), (String)"-report-analyze-failure", (String)"opatchauto.option.reportAnalyzeFailure.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption deployOnly = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.DEPLOY_ONLY.getValue(), (String)"-deployonly", (String)"opatchauto.option.deployOnly.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption outofPlace = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue(), (String)"-outofplace", (String)"opatchauto.option.outofplace.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption prepareClone = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.PREPARE_CLONE_KEY.getValue(), (String)"-prepare-clone", (String)"opatchauto.option.prepareClone.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        OPatchAutoOption switchClone = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SWITCH_CLONE_KEY.getValue(), (String)"-switch-clone", (String)"opatchauto.option.switchClone.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        OPatchAutoOption silentKey = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.OUT_OF_PLACE_SILENT.getValue(), (String)"-silent", (String)"opatchauto.option.silentkey.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        OPatchAutoOption sidb = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SIDB.getValue(), (String)"-sidb", (String)"opatchauto.option.sidbonly.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report});
        OPatchAutoOption sid = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.SID.getValue(), (String)"-sid", (String)"opatchauto.option.sid.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report});
        OPatchAutoOption port = OPatchAutoOption.getCommandOption((String)DBProductParameterConstants.PORT.getValue(), (String)"-port", (String)"opatchauto.option.port.description", (boolean)false, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        LinkedHashSet<OPatchAutoOption> options = new LinkedHashSet<OPatchAutoOption>();
        options.add(remote);
        options.add(nonrolling);
        options.add(generateSteps);
        options.add(systemSnapshotFilePath);
        options.add(customConfigDir);
        options.add(noRestart);
        options.add(database);
        options.add(sidbOnly);
        options.add(family);
        options.add(inPlace);
        options.add(reportAnalyzeFailure);
        options.add(deployOnly);
        options.add(sidb);
        options.add(sid);
        options.add(port);
        options.add(outofPlace);
        options.add(prepareClone);
        options.add(switchClone);
        options.add(silentKey);
        return options;
    }

    public Set<OPatchAutoOptionGroup> getOptionGroups(OPatchAutoOptions options) {
        LinkedHashSet<OPatchAutoOptionGroup> optionGroups = new LinkedHashSet<OPatchAutoOptionGroup>();
        try {
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.OH_DATABASE_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.mutually_exclusive, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption("home"), options.getOption(DBProductParameterConstants.DATABASE_KEY.getValue())}));
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.NORESTART_REMOTE_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.mutually_exclusive, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption(DBProductParameterConstants.NORESTART_KEY.getValue()), options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue())}));
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.PREPARE_SWITCH_INPLACE_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.mutually_exclusive, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption(DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue()), options.getOption(DBProductParameterConstants.PREPARE_CLONE_KEY.getValue()), options.getOption(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue()), options.getOption(DBProductParameterConstants.IN_PLACE_KEY.getValue())}));
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.OUTOFPLACE_INVALID_OPT_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_exclude_all, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption(DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue()), options.getOption(DBProductParameterConstants.ROLLING_MODE_KEY.getValue()), options.getOption(DBProductParameterConstants.NORESTART_KEY.getValue()), options.getOption(DBProductParameterConstants.DATABASE_KEY.getValue())}));
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.PREPARE_CLONE_INVALID_OPT_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_exclude_all, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption(DBProductParameterConstants.PREPARE_CLONE_KEY.getValue()), options.getOption(DBProductParameterConstants.ROLLING_MODE_KEY.getValue()), options.getOption(DBProductParameterConstants.NORESTART_KEY.getValue()), options.getOption(DBProductParameterConstants.DATABASE_KEY.getValue())}));
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.SWITCH_CLONE_INVALID_OPT_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_exclude_all, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue()), options.getOption("force.conflict"), options.getOption("skip.conflict"), options.getOption("no.relink"), options.getOption(DBProductParameterConstants.ROLLING_MODE_KEY.getValue()), options.getOption(DBProductParameterConstants.DATABASE_KEY.getValue()), options.getOption("patch.base.directory"), options.getOption("patch.location")}));
            optionGroups.add(OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)DBProductParameterConstants.PREPARE_APPLY_OOP_SILENT_MODE_GROUP_KEY.getValue(), (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_at_least_one_required, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{options.getOption(DBProductParameterConstants.OUT_OF_PLACE_SILENT.getValue()), options.getOption(DBProductParameterConstants.PREPARE_CLONE_KEY.getValue()), options.getOption(DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue())}));
        }
        catch (OPatchAutoException e) {
            Reporting.report((String)e.getMessage());
        }
        return optionGroups;
    }

    @Override
    public Set<Class<? extends PatchAction>> getPatchActions(OPatchAutoCommand command, OPatchAutoOptions options) {
        HashSet<Class<? extends PatchAction>> actions = new HashSet<Class<? extends PatchAction>>();
        actions.add(GIShutDownAction.class);
        actions.add(RACPrepareShutDownAction.class);
        actions.add(RACShutDownAction.class);
        actions.add(DBPrereqAction.class);
        actions.add(SIDBPrepareShutDownAction.class);
        actions.add(SIDBShutDownAction.class);
        actions.add(RACPatchingAction.class);
        actions.add(SIDBPrePostScriptAction.class);
        actions.add(SIDBPatchingAction.class);
        actions.add(GIStartupAction.class);
        actions.add(RACStartupAction.class);
        actions.add(RACFinalizeStartAction.class);
        actions.add(SIDBStartupAction.class);
        actions.add(SIDBFinalizeStartAction.class);
        actions.add(RACOnlineAction.class);
        actions.add(SIDBOnlineAction.class);
        actions.add(SIHAShutDownAction.class);
        actions.add(SIHAStartupAction.class);
        actions.add(RACOneAction.class);
        actions.add(RemoteGIStopAction.class);
        actions.add(OPatchAutoBinaryAction.class);
        actions.add(OJVMPatchAction.class);
        actions.add(RunRootAddRDBMSPatchAction.class);
        actions.add(RRPInPlacePrePatchAction.class);
        actions.add(TwoStageOOPPatchAction.class);
        actions.add(GIMRPrePatchAction.class);
        actions.add(RHPPrePatchAction.class);
        actions.add(GIOnlinePrePatchAction.class);
        actions.add(ValidationPatchAction.class);
        actions.add(UpdateRuntimeData.class);
        actions.add(GIMRPostPatchAction.class);
        actions.add(RHPPostPatchAction.class);
        actions.add(GIOnlinePostPatchAction.class);
        actions.add(GIUnlockPatchAction.class);
        actions.add(GILockPatchAction.class);
        actions.add(DeletePatchAction.class);
        actions.add(RemoteDeleteAction.class);
        actions.add(DeleteInactivePatchesInPlace.class);
        actions.add(TwoStagePostApplyInPlaceAction.class);
        actions.add(DeleteInactivePatchesOOP.class);
        actions.add(TwoStagePostApplyOOPAction.class);
        actions.add(CopyHomePatchAction.class);
        actions.add(CopyOBHPatchAction.class);
        actions.add(CopyDatapatchLibsAction.class);
        actions.add(GIMRPrePostOOPPatchAction.class);
        actions.add(CloneOracleHomeAction.class);
        actions.add(PostCloneOracleHomeAction.class);
        actions.add(CloneOracleHomeStartupAction.class);
        actions.add(ClusterStartupFinalizeAction.class);
        actions.add(DatabaseStartupFinalizeAction.class);
        actions.add(CopyOOPSessionFilePatchAction.class);
        actions.add(SwitchAnalyzeAction.class);
        actions.add(SIDBSwitchAction.class);
        if (_log.isLoggable(Level.INFO)) {
            _log.log(Level.INFO, "Actions loaded...");
        }
        return actions;
    }

    @Override
    public void updateOptions(OPatchAutoOptions options) throws OPatchAutoException {
        super.updateOptions(options);
        if (options.getCommand().isReport()) {
            options.getOption("home").setVisible(Boolean.FALSE.booleanValue());
        } else {
            OPatchAutoOption snapshotFilePath = options.getOption(DBProductParameterConstants.SYSTEM_SNAPSHOT_FILE_PATH_KEY.getValue());
            OPatchAutoOption generateSteps = options.getOption(DBProductParameterConstants.GENERATE_STEPS_KEY.getValue());
            if (snapshotFilePath.getValue() != null) {
                generateSteps.setValue("true");
            }
            OPatchAutoOption plan = options.getOption("patch.plan");
            OPatchAutoOption nonrolling = options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue());
            boolean hasSIHAProductType = this.hasSIHAProductType(options);
            boolean isNonRolling = Boolean.parseBoolean(nonrolling.getValue());
            if (hasSIHAProductType && isNonRolling) {
                throw new OPatchAutoException(Integer.toString(72056), new Object[0]);
            }
            if (DBPatchingHelper.isSingleOOPRollbackPatchingSession(options) && !StringUtil.isNullOrEmpty((String)DBPatchingHelper.getPatchLocation(options))) {
                throw new OPatchAutoException(Integer.toString(72175), new Object[0]);
            }
            if (DBPatchingHelper.isOOPPatchingSession(options)) {
                if (isNonRolling) {
                    plan.setValue(DBPatchPlan.PATCH_PLAN_OOP_NON_ROLLING.getValue());
                } else {
                    plan.setValue(DBPatchPlan.PATCH_PLAN_OOP_ROLLING.getValue());
                }
            } else if (!DBPatchingHelper.isCustomPlan(options)) {
                if (hasSIHAProductType) {
                    plan.setValue(DBPatchPlan.PATCH_PLAN_SIHA.getValue());
                } else if (isNonRolling) {
                    plan.setValue(DBPatchPlan.PATCH_PLAN_CRS_NONROLLING.getValue());
                } else {
                    plan.setValue(DBPatchPlan.PATCH_PLAN_CRS_ROLLING.getValue());
                }
            }
        }
    }

    @Override
    public void initialize(OPatchAutoCommand command, OPatchAutoOptions options) throws OPatchAutoException {
        boolean isDescriptionCommand;
        super.initialize(command, options);
        if (command.isAction()) {
            String containerPath = options.getOption("container").getValue();
            PatchActionExecutorContainer container = DBBaseProductSupport.deserializePath(containerPath.trim());
            Object skipGridObj = container.getPatchActionParameterValue(DBProductParameterConstants.SKIP_GRID_HOME.getValue());
            if (skipGridObj != null) {
                this.skipGridHome = (Boolean)skipGridObj;
            }
        } else if (Boolean.parseBoolean(options.getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue()) || options.getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled()) {
            this.skipGridHome = true;
        }
        boolean bl = isDescriptionCommand = command.isLsPhases() || command.isLsPlans();
        if (!isDescriptionCommand) {
            String configDir = options.getOption(DBProductParameterConstants.CUSTOM_CONFIG_DIR.getValue()).getValue();
            SessionData.setConfigDir(configDir);
            String invPtrLocStr = null;
            if (!command.isAction()) {
                invPtrLocStr = options.getOption("inventory.pointer.location").getValue();
            }
            DBPatchingHelper.setupEnvironment(System.getProperty("ORACLE_HOME"), invPtrLocStr);
            String logFile = options.getOption("log").getValue();
            String logDir = new File(logFile).getParentFile().getAbsolutePath();
            _log.info("logDir is set to : " + logDir);
            if (null != logDir) {
                IOUtils.copyOwnerGroup(new File(PatchPlanner.getInstance().getOPlanEnv().getOracleHome(), "oraInst.loc"), new File(logDir));
                IOUtils.chmodTo775(new File(logDir), null);
            }
            if (this.skipGridHome) {
                System.setProperty("ORACLE_HOME", OPatchAutoHelper.getOPatchAutoHome());
            } else {
                System.setProperty("ORACLE_HOME", ClusterInformationLoader.getInstance().getGridHome());
            }
            if (!command.isAction()) {
                String sessionID = options.getOption("session").getValue();
                OPatchAutoOption walletPassword = options.getOption("wallet.password");
                char[] walletPwdKey = walletPassword.getPasswordValue();
                OPatchAutoOption deployOnlyOption = options.getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue());
                boolean isDeployOnly = Boolean.valueOf(deployOnlyOption.getValue());
                if (isDeployOnly) {
                    SessionData.getSerializedInstance(null);
                } else if (command.isResumed() && null == SessionData.getSerializedInstance(sessionID)) {
                    SessionData.getInstance().setSessionID(sessionID);
                    SessionData.getInstance().setWalletLoc(DBPatchingHelper.getWalletLocation(options));
                    SessionData.getInstance().setWalletPwd(walletPwdKey);
                }
                if (this._summaryCreator == null) {
                    this._summaryCreator = new DBPatchingSummaryCreator();
                    this._summaryCreator.initializePatchingSummary(command, sessionID);
                }
                if (DBPatchingHelper.isOOPPatchingSession(options)) {
                    TrackOOPSessions.initialize(options);
                }
                if (DBPatchingHelper.isOOPSwitchPatchingSession(options) || DBPatchingHelper.isOOPPatchingSession(options) && command.isResumed()) {
                    this.initializeOOPSessionData(options);
                }
                this._topologyBuilder = new CRSTopologyBuilder(command, options);
                this._topologyBuilder.createSystemInstance();
                if (isDeployOnly) {
                    _log.info("Session data already collected for the deploy-only session.");
                } else if (command.isResumed()) {
                    _log.info("Session data already collected for the resume session.");
                } else {
                    SessionData.getInstance().setSessionID(sessionID);
                    SessionData.getInstance().setWalletLoc(DBPatchingHelper.getWalletLocation(options));
                    SessionData.getInstance().setWalletPwd(walletPwdKey);
                    if (StringUtil.isNullOrEmpty((String)SessionData.getInstance().getCrsHome())) {
                        _log.info("Collecting CRS info ...");
                        SessionData.getInstance().collectCrsInfo();
                    }
                }
                if (!command.isResumed() && ProductSupportHelper.isGIValidationRequired()) {
                    DBPatchingHelper.updateSessionDataWithGIStatus(options);
                }
                boolean isPatchIDForRollback = command.isRollback() && this.isPatchIDForRollback(options);
                String patchInfo = DBPatchingHelper.getPatchLocation(options);
                PatchingSessionInfoStore.getInstance().initialize(sessionID, patchInfo);
                if (isPatchIDForRollback) {
                    PatchIDProcessor.getInstance().initialize(sessionID);
                }
                if (!command.isResumed()) {
                    new ProductSupportHelper().handleRootSessionInfoFile(options);
                }
            }
        }
    }

    private void initializeOOPSessionData(OPatchAutoOptions options) throws OPatchAutoException {
        OOPSessionInfoHandler oopSessionInfoHandler = OOPSessionInfoHandler.getInstance();
        boolean rollback = this.command.isRollback();
        String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        String filePath = OPatchAutoHelper.getOPatchAutoHome() + sessionInfoFile;
        if (rollback && !this.command.isResumed()) {
            String switchbackFilePath;
            String sbSessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
            sbSessionInfoFile = sbSessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
            filePath = switchbackFilePath = OPatchAutoHelper.getOPatchAutoHome() + sbSessionInfoFile;
        }
        if (!new File(filePath).exists()) {
            String currentOP = null;
            String previousOPReq = null;
            if (DBPatchingHelper.isOOPSwitchPatchingSession(options)) {
                if (rollback) {
                    currentOP = OOPSessionCookie.OOPOperationType.ROLLBACK.name().toLowerCase();
                    previousOPReq = OOPSessionCookie.OOPOperationType.APPLY.name().toLowerCase() + "/" + OOPSessionCookie.OOPOperationType.SWITCH.name().toLowerCase();
                } else {
                    currentOP = OOPSessionCookie.OOPOperationType.SWITCH.name().toLowerCase();
                    previousOPReq = OOPSessionCookie.OOPOperationType.PREPARE.name().toLowerCase();
                }
                throw new OPatchAutoException(Integer.toString(72114), new Object[]{currentOP, previousOPReq});
            }
            throw new OPatchAutoException(Integer.toString(72113), new Object[0]);
        }
        OOPSessionCookie cookie = oopSessionInfoHandler.initializeCookie(new File(filePath));
        OOPSessionInfo oopSessionInfo = cookie.getOOPSessionInfo(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()));
        if (oopSessionInfo != null) {
            _log.info(oopSessionInfo.toString());
        }
        PatchPlanner.getInstance().setPrimaryPatchVersion(oopSessionInfo.getPatchInfo().getPrimaryPatchVersion());
        PatchPlanner.getInstance().setEngSysPatch(oopSessionInfo.getPatchInfo().getPatchType().isENGSystemPatch());
    }

    private OOPHomeInfo getOOPHomeInfo(List<OOPHomeInfo> infos, String originalHome) {
        OOPHomeInfo info = null;
        _log.info("originalHome: " + originalHome);
        for (OOPHomeInfo homeInfo : infos) {
            _log.info("Iteration home location : " + homeInfo.getOriginalHome());
            if (!originalHome.equals(homeInfo.getOriginalHome())) continue;
            info = homeInfo;
            break;
        }
        return info;
    }

    public void postPatchSessionInit(PatchSession patchSession) {
        List<OOPHomeInfo> infos;
        Object oopSessionInfo;
        boolean isDescriptionCommand;
        super.postPatchSessionInit(patchSession);
        boolean bl = isDescriptionCommand = this.command.isLsPhases() || this.command.isLsPlans();
        if (!isDescriptionCommand && !this.command.isAction()) {
            try {
                OPatchAutoOptions options = patchSession.getOptions();
                String sessionID = options.getOption("session").getValue();
                this.storeSessionFile(sessionID, options);
            }
            catch (OPatchAutoException e) {
                _log.log(Level.WARNING, "Session id option not found");
            }
        }
        DBPatchingSummaryCreator summaryCreator = this.getDBPatchingSummaryCreator(patchSession.getCommand());
        OPatchAutoOptions options = patchSession.getOptions();
        if (DBPatchingHelper.isOOPSwitchPatchingSession(options) || this.command.isResumed() && DBPatchingHelper.isOOPPatchingSession(options)) {
            oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
            infos = ((OOPSessionInfo)oopSessionInfo).getHomeInfoList();
            for (PatchTarget patchTarget : patchSession.getPatchPlanManager().getPatchTargets()) {
                String originalHomeLoc = patchTarget.getHome(true).getLocation();
                OOPHomeInfo homeInfo = this.getOOPHomeInfo(infos, originalHomeLoc);
                if (homeInfo == null) continue;
                if (!this.command.isResumed()) {
                    this.fillCloneHome(homeInfo, patchTarget, originalHomeLoc);
                    continue;
                }
                if (patchTarget.getHomeClone() == null) continue;
                _log.info("Original home location: " + originalHomeLoc);
                _log.info("Clone home location : " + patchTarget.getHomeClone().getLocation());
                OOPSessionInfoHandler.getInstance().updateCloneHomePath(patchTarget);
            }
            this.fillMakeCloneCacheMap(infos);
        } else if (DBPatchingHelper.isOOPPreparePatchingSession(options) || DBPatchingHelper.isSingleOOPPatchingSession(options)) {
            oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
            infos = ((OOPSessionInfo)oopSessionInfo).getHomeInfoList();
            this.fillMakeCloneCacheMap(infos);
        }
        if (DBPatchingHelper.isOOPPatchingSession(options) && patchSession.isAnalyze()) {
            for (PatchTarget patchTarget : patchSession.getPatchPlanManager().getPatchTargets()) {
                if (!this.getSupportedProductTypes().contains(patchTarget.getProductType().getType())) continue;
                summaryCreator.storePatchingSummary(0, SummaryID.oop_summary, patchTarget, "clone information");
            }
        }
        boolean sidbOnlyMode = DBPatchingHelper.isSidbOnlyMode(patchSession.getOptions());
        if (!(this.isGenerateStepSession || this.command.isAction() || sidbOnlyMode)) {
            SessionData.getInstance().saveDataObject();
            if (!patchSession.isAnalyze() && !this.skipGridHome && ProductSupportHelper.isGIValidationRequired()) {
                new ProductSupportHelper().createSessionInitFile();
            }
        }
    }

    private Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    private void fillCloneHome(OOPHomeInfo info, PatchTarget patchTarget, String originalHomeLoc) {
        Home clonePatchTarget = patchTarget.getHome().getShallowCopy();
        clonePatchTarget.setLocation(info.getCloneHome());
        ((MutablePatchTarget)patchTarget).setHomeClone(clonePatchTarget);
        patchTarget.setUsingHomeClone(true);
    }

    private void fillMakeCloneCacheMap(List<OOPHomeInfo> infos) {
        MakeCloneHome makeCloneHome = PatchPlanner.getInstance().getMakeCloneHome();
        List<OracleHome> ohList = PatchPlanner.getInstance().getConfigGraph().getTargets(OracleHome.class);
        if (infos == null || infos.isEmpty()) {
            return;
        }
        for (OracleHome oh : ohList) {
            OOPHomeInfo info = this.getOOPHomeInfo(infos, oh.getPath());
            if (info == null || StringUtil.isNullOrEmpty((String)info.getCloneHome(), (boolean)true)) continue;
            CloneCookie cloneCookie = new CloneCookie();
            String clonePath = info.getCloneHome();
            cloneCookie.setClonePath(clonePath);
            oh.setProperty(CloneCookie.class, (Object)cloneCookie);
            makeCloneHome.getHomeClone(oh);
        }
    }

    private boolean hasSIHAProductType(OPatchAutoOptions options) {
        ConfigGraph graph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> homes = graph.getTargets(OracleHome.class);
        boolean hasCrs = false;
        for (OracleHome home : homes) {
            if (home.getHomeType().equalsIgnoreCase(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) || home.getHomeType().equalsIgnoreCase(DBProductTypes.PRODUCT_TYPE_RAC.getValue())) {
                hasCrs = true;
                break;
            }
            if (!home.getHomeType().equalsIgnoreCase(DBProductTypes.PRODUCT_TYPE_SIHA.getValue())) continue;
            hasCrs = false;
            break;
        }
        return !hasCrs;
    }

    @Override
    public void closeSession(OPatchAutoCommand command, boolean isSuccessful) {
        try {
            IOUtils.chownAllLogFiles();
            String opatchAutoHome = OPatchAutoHelper.getOPatchAutoHome();
            File homeFile = new File(opatchAutoHome);
            long space1 = homeFile.getFreeSpace();
            _log.info("Space available after session: " + space1 / 0x100000L + " MB");
        }
        catch (OPatchAutoException e1) {
            _log.warning("Couldn't check space left due to " + e1.getMessage());
        }
        TrackOOPSessions.endSession();
        super.closeSession(command, isSuccessful);
        if (isSuccessful && !command.isAction()) {
            try {
                if (!this.isAnalyzeSession && !this.isGenerateStepSession) {
                    if (!this.skipGridHome && ProductSupportHelper.isGIValidationRequired() && !SessionData.getInstance().isRemoteStateUnknown()) {
                        new ProductSupportHelper().deleteSessionInitFile(this.isRemoteSession, SessionData.getInstance().getWalletLoc(), SessionData.getInstance().getWalletPwd());
                    }
                    String directoryPath = OPatchAutoHelper.getOPatchAutoHome() + ProductDriverConstants.CFGTOOLLOGS_OPATCHAUTODB;
                    DBPatchingHelper.deleteZeroByteFilesAndEmptyDirectories(directoryPath);
                }
            }
            catch (OPatchAutoException e) {
                Reporting.report((String)e.getMessage());
            }
            if (this.getDBPatchingSummaryCreator(command) != null) {
                this._summaryCreator.generateSummary(command);
            }
            this.deleteAdditionalFile();
            try {
                File sessionFile;
                if (SessionData.getInstance().getDeleteSessionXML() && (sessionFile = SessionData.getInstance().getSessionFile()).exists()) {
                    SessionData.getInstance().getSessionFile().delete();
                    _log.info("Session file deleted : " + sessionFile);
                }
            }
            catch (Exception e) {
                _log.warning("Unable to delete session file due to " + e.getMessage());
            }
        }
        ProductSupportAgent productSupportAgent = new ProductSupportAgent();
        if (!command.isAction()) {
            productSupportAgent.copySummaryFileToDBSessionInfo();
            productSupportAgent.saveAnalyzeStatus(PatchPlanner.getInstance().isAnalyzeFailed());
            if (!isSuccessful) {
                IOUtils.zipLogFiles();
            }
        }
        PatchPlanner.getInstance().cleanup();
        this._topologyBuilder = null;
        this.command = null;
    }

    private void deleteAdditionalFile() {
        String analyzedPatchInfoFile = PatchIDProcessor.getInstance().getAnalyzedPatchInfoFile();
        new File(analyzedPatchInfoFile).delete();
    }

    @Override
    public String getId() {
        return "";
    }

    public Set<String> getPatchPlans() {
        LinkedHashSet<String> patchPlans = new LinkedHashSet<String>();
        patchPlans.add(DBPatchPlan.PATCH_PLAN_SIHA.getValue());
        patchPlans.add(DBPatchPlan.PATCH_PLAN_CRS_ROLLING.getValue());
        patchPlans.add(DBPatchPlan.PATCH_PLAN_CRS_NONROLLING.getValue());
        patchPlans.add(DBPatchPlan.PATCH_PLAN_OOP_ROLLING.getValue());
        patchPlans.add(DBPatchPlan.PATCH_PLAN_OOP_NON_ROLLING.getValue());
        return patchPlans;
    }

    public String getPatchPlanDescription(String patchPlan) {
        if (DBPatchPlan.PATCH_PLAN_SIHA.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)DBPatchPlan.PATCH_PLAN_SIHA.getDescription());
        }
        if (DBPatchPlan.PATCH_PLAN_CRS_ROLLING.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)DBPatchPlan.PATCH_PLAN_CRS_NONROLLING.getDescription());
        }
        if (DBPatchPlan.PATCH_PLAN_CRS_NONROLLING.getValue().equals(patchPlan)) {
            return ResourceBundleManager.getString((String)"opatchauto", (String)DBPatchPlan.PATCH_PLAN_CRS_ROLLING.getDescription());
        }
        return super.getPatchPlanDescription(patchPlan);
    }

    protected List<String> loadUnSupportedOptions(OPatchAutoOptions options) throws OPatchAutoException {
        UNSUPPORTED_OPTIONS.add("phases");
        UNSUPPORTED_OPTIONS.add("instance");
        UNSUPPORTED_OPTIONS.add("username");
        UNSUPPORTED_OPTIONS.add("password");
        UNSUPPORTED_OPTIONS.add("parallel");
        UNSUPPORTED_OPTIONS.add("out.of.place");
        UNSUPPORTED_OPTIONS.add("image.location");
        UNSUPPORTED_OPTIONS.add("create.image");
        UNSUPPORTED_OPTIONS.add("apply.image");
        UNSUPPORTED_OPTIONS.add("wallet.password");
        UNSUPPORTED_OPTIONS.add("backup.location");
        UNSUPPORTED_OPTIONS.add("sshuserequivalence");
        UNSUPPORTED_OPTIONS.add("sshaccesskey");
        this.handleVersionSpecificOptions(options);
        return UNSUPPORTED_OPTIONS;
    }

    protected List<String> loadUnVisibleOptions() {
        UNVISIBLE_OPTIONS.add("patch.plan");
        UNVISIBLE_OPTIONS.add("session");
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.SIDB_ONLY.getValue());
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.GENERATE_STEPS_KEY.getValue());
        UNVISIBLE_OPTIONS.add("topology");
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.FAMILY.getValue());
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue());
        UNVISIBLE_OPTIONS.add(DBProductParameterConstants.DEPLOY_ONLY.getValue());
        return UNVISIBLE_OPTIONS;
    }

    private void handleVersionSpecificOptions(OPatchAutoOptions options) throws OPatchAutoException {
        String gridHomeVersion;
        Properties prop = new Properties();
        try {
            String patchingInfoLocation = System.getProperty("OPatch.PATCH_INFO_LOCATION");
            if (!StringUtil.isNullOrEmpty((String)patchingInfoLocation)) {
                prop = BootstrapUtil.loadPropertiesFile(patchingInfoLocation);
            }
        }
        catch (FileNotFoundException e) {
            throw new OPatchAutoException(e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new OPatchAutoException(e.getMessage(), (Throwable)e, new Object[0]);
        }
        if (prop.containsKey("IS_HELP_SESSION") && Boolean.valueOf(prop.getProperty("IS_HELP_SESSION")).booleanValue()) {
            String currentHome = OPatchAutoHelper.getOPatchAutoHome();
            if (!this.containsDBTwelveTwoAboveHome(new String[]{currentHome})) {
                this.handleOOPOptionInDBTwelveOne();
            }
            if (this.containsDBTwentyThreeAboveHome(new String[]{currentHome})) {
                this.handleOOPOptionInDBTwentyThree();
            }
        } else if (prop.containsKey("HOME_LIST")) {
            String homeList = prop.getProperty("HOME_LIST");
            if (this.isPatchingOnlyDBTwelveOne(homeList)) {
                this.handleOOPOptionInDBTwelveOne();
            }
        } else if (prop.containsKey("GRID_HOME_VERSION") && !DBPatchingUtil.isVersionEqalOrlater(gridHomeVersion = prop.getProperty("GRID_HOME_VERSION"), "12.2.0.1.0")) {
            this.handleOOPOptionInDBTwelveOne();
        }
    }

    private boolean isPatchingOnlyDBTwelveOne(String homeList) throws OPatchAutoException {
        boolean isPatchingOnlyDBTwelveOne = false;
        String[] homes = homeList.split(",");
        if (!this.containsDBTwelveTwoAboveHome(homes)) {
            isPatchingOnlyDBTwelveOne = true;
        }
        return isPatchingOnlyDBTwelveOne;
    }

    private void handleOOPOptionInDBTwelveOne() {
        UNSUPPORTED_OPTIONS.add(DBProductParameterConstants.IN_PLACE_KEY.getValue());
        UNSUPPORTED_OPTIONS.add(DBProductParameterConstants.PREPARE_CLONE_KEY.getValue());
        UNSUPPORTED_OPTIONS.add(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue());
        UNSUPPORTED_OPTIONS.add(DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue());
        UNSUPPORTED_OPTIONS.add(DBProductParameterConstants.OUT_OF_PLACE_SILENT.getValue());
    }

    private void handleOOPOptionInDBTwentyThree() {
    }

    private boolean containsDBTwelveTwoAboveHome(String[] homeList) {
        ArrayList<String> ohList = new ArrayList<String>();
        for (String home : homeList) {
            ohList.add(home.trim());
        }
        List homes = OUIDriver.getLocalInfo(ohList);
        for (OracleHome oh : homes) {
            _log.finest("oh: " + oh.getPath());
            List ouiComp = oh.getTopLevelOUI();
            String version = ((OUIComponent)ouiComp.get(0)).getVersion();
            _log.finest("version: " + version);
            if (!DBPatchingUtil.isVersionEqalOrlater(version, "12.2.0.1.0")) continue;
            return true;
        }
        return false;
    }

    private boolean containsDBTwentyThreeAboveHome(String[] homeList) {
        ArrayList<String> ohList = new ArrayList<String>();
        for (String home : homeList) {
            ohList.add(home.trim());
        }
        List homes = OUIDriver.getLocalInfo(ohList);
        for (OracleHome oh : homes) {
            _log.info("oh: " + oh.getPath());
            List ouiComp = oh.getTopLevelOUI();
            String version = ((OUIComponent)ouiComp.get(0)).getVersion();
            _log.info("version: " + version);
            if (!DBPatchingUtil.isVersionEqalOrlater(version, "23.0.0.0.0")) continue;
            return true;
        }
        return false;
    }

    private boolean containsDBTwentyThreeAboveHome() {
        ConfigGraph graph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> homes = graph.getTargets(OracleHome.class);
        for (OracleHome oh : homes) {
            _log.info("oh: " + oh.getPath());
            List ouiComp = oh.getTopLevelOUI();
            String version = ((OUIComponent)ouiComp.get(0)).getVersion();
            _log.info("version: " + version);
            if (!DBPatchingUtil.isVersionEqalOrlater(version, "23.0.0.0.0")) continue;
            return true;
        }
        return false;
    }

    protected void storeAdminPolicyManagedSkippedDBSummary() {
        AdminPolicyManagedHomeDetails dbDetails = new AdminPolicyManagedHomeDetails();
        dbDetails.retrieveInformation();
        Map<String, String> dbInfo = dbDetails.getHomeInformation();
        if (dbInfo != null && !dbInfo.isEmpty()) {
            Iterator<String> skippedItr = dbInfo.keySet().iterator();
            String dbType = "";
            ArrayList<String> summaryList = new ArrayList<String>();
            while (skippedItr.hasNext()) {
                String key = skippedItr.next();
                dbType = dbInfo.get(key).equals("adminManagedDB") ? "admin" : "policy";
                summaryList.add(OPatchAutoHelper.getLocalizedString((String)"Summary.adminpolicy.managed.skippedhome.message", (Object[])new Object[]{dbType, key}));
            }
            this._summaryCreator.storePatchingSummary(0, SummaryID.skipped_admin_policy_home_summary, summaryList);
        }
    }

    public Set<PatchTarget> getSortedPatchTargets(Set<PatchTarget> patchTargets) {
        LinkedHashSet<PatchTarget> sortedPatchTargets = new LinkedHashSet<PatchTarget>();
        Iterator<PatchTarget> iterator = patchTargets.iterator();
        try {
            String currentHomeLoc = OPatchAutoHelper.getOPatchAutoHome();
            String currentUser = System.getProperty("user.name");
            while (iterator.hasNext()) {
                PatchTarget patchTarget = iterator.next();
                String patchTargetLoc = patchTarget.getHome(true).getLocation();
                String patchTargetOwner = patchTarget.getHome(true).getOwner();
                if (!this.compareFilePath(currentHomeLoc, patchTargetLoc) && !currentUser.equalsIgnoreCase(patchTargetOwner) || sortedPatchTargets.contains(patchTarget)) continue;
                sortedPatchTargets.add(patchTarget);
            }
            for (PatchTarget patchTarget : patchTargets) {
                if (sortedPatchTargets.contains(patchTarget)) continue;
                sortedPatchTargets.add(patchTarget);
            }
        }
        catch (OPatchAutoException e) {
            return null;
        }
        return sortedPatchTargets;
    }

    public void initializeOPatchAutoReporting(String reportingType) throws OPatchAutoException {
        super.initializeOPatchAutoReporting(reportingType);
        OPatchAutoReportingManager.getInstance().setReportingHandler(reportingType, (OPatchAutoReporting)new DBPatchReporting());
    }

    private boolean compareFilePath(String src, String dest) {
        return FileUtils.getFile((String)src).equals(FileUtils.getFile((String)dest));
    }

    static enum DBPatchPlan {
        PATCH_PLAN_SIHA("siha", "opatchauto.plan.siha.desc"),
        PATCH_PLAN_CRS_ROLLING("crs-rolling", "opatchauto.plan.crs-rolling.desc"),
        PATCH_PLAN_CRS_NONROLLING("crs-nonrolling", "opatchauto.plan.crs-nonrolling.desc"),
        PATCH_PLAN_OOP_ROLLING("oop-rolling", "opatchauto.plan.oop-rolling.desc"),
        PATCH_PLAN_OOP_NON_ROLLING("oop-non-rolling", "opatchauto.plan.oop-rolling.desc");

        private String patchPlan;
        private String desc;

        private DBPatchPlan(String type, String desc) {
            this.patchPlan = type;
            this.desc = desc;
        }

        public String getValue() {
            return this.patchPlan;
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

