/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.common.IListComparator;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.GIProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.RACNonSharedProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.RACProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.RACSharedProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.SIDBProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.SIHAProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.AbstractTopologyBuilder;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.driver.crs.CRSDummyProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.sidb.SIDBProductDriver;
import com.oracle.glcm.patch.auto.db.product.graphlib.CRSConfigGraph;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.sequence.HostListComparator;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationController;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationPhase;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.product.ProductTypeImpl;
import com.oracle.glcm.patch.auto.product.SupportType;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.sysman.oii.oiii.OiiiVersion;

public class CRSTopologyBuilder
extends AbstractTopologyBuilder {
    private Map<String, List<OracleHome>> hostVsHomeMap = null;
    private CRSDummyProductDriver crsPD;
    private boolean isSidbOnly = false;
    private String gimrPath;
    private String OPATCH_AUTO_DB_NAMESPACE = "opatchautodb";
    private File systemInstanceFile = null;

    public CRSTopologyBuilder(OPatchAutoCommand command, OPatchAutoOptions options) {
        super(command, options);
    }

    @Override
    public void buildTopology(CredentialManager credentialManager) throws OPatchAutoException {
        this.hostVsHomeMap = new HashMap<String, List<OracleHome>>();
        super.buildTopology(credentialManager);
        this.logger.info("\nSystem information captured::\n");
        if (!this.isSidbOnly && !this.command.isReport()) {
            this.logger.info(ReadmeFactory.getInstance().getConfigTreeText() + "\n");
        }
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        this.gimrPath = DBPatchingHelper.getGIMRHomePath();
        try {
            List<dbmodel.common.Host> hostModelList = configGraph.getTargets(dbmodel.common.Host.class);
            List<OracleHome> homeModelList = configGraph.getTargets(OracleHome.class);
            for (dbmodel.common.Host host : hostModelList) {
                this.hostVsHomeMap.put(host.getHostName(), new ArrayList());
            }
            for (OracleHome oh : homeModelList) {
                for (dbmodel.common.Host host : oh.getHosts()) {
                    List<OracleHome> homeList = this.hostVsHomeMap.get(host.getHostName());
                    if (homeList == null) continue;
                    homeList.add(oh);
                }
            }
            OPatchAutoOption remoteOption = this.options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue());
            Boolean isRemote = Boolean.valueOf(remoteOption.getValue());
            IListComparator<dbmodel.common.Host> hostListComparator = this.getHostListComparator();
            if (isRemote.booleanValue() && hostListComparator != null) {
                hostModelList = hostListComparator.sequence(hostModelList);
            }
            ArrayList<Host> hostList = new ArrayList<Host>();
            for (dbmodel.common.Host host : hostModelList) {
                hostList.add(this.getHost(host));
            }
            for (Host host : hostList) {
                this.logger.info("hostList: " + host.getHost());
            }
            ArrayList<Host> completeHostList = new ArrayList<Host>();
            completeHostList.addAll(hostList);
            for (Host h : hostList) {
                this.logger.info("completeHostList: " + h.getHost());
            }
            if (!this._linkedHomeList.isEmpty()) {
                this.fillSharedHomeInformation(hostList);
            }
            if (!isRemote.booleanValue()) {
                Iterator iterator = hostList.iterator();
                while (iterator.hasNext()) {
                    Host host = (Host)iterator.next();
                    if (!host.isRemote()) continue;
                    iterator.remove();
                }
            }
            for (Host h : hostList) {
                this.logger.info("Post remote check hostList: " + h.getHost());
            }
            this.topology = this.getTopology(hostList);
        }
        catch (OPatchAutoException e) {
            this.logger.log(Level.SEVERE, "Failed to create topology :: Unable to determine opatch auto home :: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void createSystemInstance() throws OPatchAutoException {
        File file;
        SystemInstance systemInstance = null;
        CRSConfigGraph configGraph = null;
        OPatchAutoOption systemSnapShotFileOption = this.options.getOption(DBProductParameterConstants.SYSTEM_SNAPSHOT_FILE_PATH_KEY.getValue());
        OPatchAutoOption topologyOption = this.options.getOption("topology");
        OPatchAutoOption sidbOnlyOption = this.options.getOption(DBProductParameterConstants.SIDB_ONLY.getValue());
        String customLogDir = this.options.getOption("customLogDir").getValue();
        boolean sidbPatching = this.options.getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
        this.isSidbOnly = Boolean.parseBoolean(sidbOnlyOption.getValue()) || sidbPatching;
        this.logger.info("SIDBonly is set to " + this.isSidbOnly);
        File systemInstanceFile = null;
        boolean canDeleteSystemFile = false;
        if (DBPatchingHelper.isOOPSwitchPatchingSession(this.options) && this.command.isApply()) {
            OOPSessionInfo oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
            systemInstanceFile = new File(oopSessionInfo.getSystemInstanceFilePath());
        } else if (this.command.isResumed()) {
            file = this.readSystemInstanceXML();
            if (file.exists()) {
                systemInstanceFile = file;
            }
            PatchPlanner.getInstance().setSystemInstanceFilePath(systemInstanceFile.getAbsolutePath());
        } else if (systemSnapShotFileOption != null && systemSnapShotFileOption.getValue() != null) {
            file = new File(systemSnapShotFileOption.getValue());
            if (file.exists()) {
                systemInstanceFile = file;
            }
        } else if (topologyOption != null && topologyOption.getValue() != null) {
            file = null;
            if (this.isSidbOnly) {
                this.logger.info("Going to create sidb system instance.");
                file = this.createCompleteSIDBInstance(this.command.name(), topologyOption.getValue());
            } else {
                file = new File(topologyOption.getValue());
            }
            if (file.exists()) {
                systemInstanceFile = file;
            }
        } else {
            file = new File(customLogDir.trim() + File.separator + this.OPATCH_AUTO_DB_NAMESPACE + File.separator + "opatch_gi_" + this.command.name() + "_config.xml");
            this.logger.info("system instance xml file " + file.getPath());
            if (file.exists()) {
                systemInstanceFile = file;
            }
            canDeleteSystemFile = true;
        }
        if (this.isSidbOnly && !sidbPatching) {
            try {
                SIDBProductDriver sidbProductDriver = new SIDBProductDriver();
                sidbProductDriver.createSIDBSystemInstance(systemInstanceFile);
            }
            catch (FileNotFoundException fe) {
                throw new OPatchAutoException("System instance file not found: " + fe.getMessage(), new Object[0]);
            }
        } else {
            if (systemInstanceFile == null) {
                throw new OPatchAutoException(Integer.toString(72050, 245), new Object[0]);
            }
            this.crsPD = new CRSDummyProductDriver();
            this.crsPD.setDummyConfigFile(systemInstanceFile);
            systemInstance = this.crsPD.constructSystemInstance();
            LocalInfo localInfo = this.crsPD.getLocalInfo();
            PatchPlanner.getInstance().setLocalInfo(localInfo);
            this.logger.log(Level.INFO, "Creating config graph from instance");
            configGraph = new CRSConfigGraph(systemInstance, localInfo.getLocalHost());
            PatchPlanner.getInstance().setSystemInstance(systemInstance);
            PatchPlanner.getInstance().setConfigGraph(configGraph);
        }
        if (canDeleteSystemFile) {
            systemInstanceFile.delete();
        }
    }

    @Override
    public List<ValidationResult> validate(SystemInstance systemInstance, ConfigGraph configGraph) throws OPatchAutoException {
        boolean sidbOnlyOption;
        ValidationParam params = new ValidationParam();
        params.set(ValidationParamKey.SYSTEM_INST.ordinal(), systemInstance);
        params.set(ValidationParamKey.CONFIG_GRAPH.ordinal(), configGraph);
        OPatchAutoOption option = this.options.getOption(DBProductParameterConstants.REMOTE_KEY.getValue());
        boolean isRemote = Boolean.valueOf(option.getValue());
        params.set(ValidationParamKey.REMOTE_PATCHING.ordinal(), isRemote);
        boolean isAnalyzeSession = this.options.getOption("analyze").isSwitchEnabled();
        params.set(ValidationParamKey.ANALYZE_OPTION.ordinal(), isAnalyzeSession);
        params.set(ValidationParamKey.OOP_ENABLED.ordinal(), DBPatchingHelper.isOOPPatchingSession(this.options));
        params.set(ValidationParamKey.OOP_OPERATION_TYPE.ordinal(), (Object)DBPatchingHelper.getOperationType(this.options));
        params.set(ValidationParamKey.WALLET_LOC.ordinal(), DBPatchingHelper.getWalletLocation(this.options));
        params.set(ValidationParamKey.GENERATE_STEP_OPTION.ordinal(), DBPatchingHelper.isGenerateStepCommand(this.options));
        params.set(ValidationParamKey.VALIDATION_PHASE.ordinal(), (Object)ValidationPhase.BUILD_TOPOLOGY);
        if (!(this.command.isRollback() && !StringUtil.isNullOrEmpty((String)this.options.getOption("id").getValue()) || DBPatchingHelper.isOOPSwitchPatchingSession(this.options))) {
            PatchPlanner patchPlanner = PatchPlanner.getInstance();
            PatchPackagesBag patchPackagesBag = patchPlanner.getOPlanEnv().getPatchesBag();
            params.set(ValidationParamKey.PATCHPACKAGESBAG.ordinal(), patchPackagesBag);
        }
        params.set(ValidationParamKey.OPERATION.ordinal(), this.command);
        boolean bl = sidbOnlyOption = Boolean.valueOf(this.options.getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue()) != false || this.options.getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
        if (sidbOnlyOption) {
            params.set(ValidationParamKey.SIDB_ONLY.ordinal(), true);
        }
        boolean isOhOptionSpecified = false;
        try {
            isOhOptionSpecified = DBPatchingHelper.isOHOrDatabaseOptionSpecified(this.options);
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        params.set(ValidationParamKey.HOME_KEY_OPTION.ordinal(), isOhOptionSpecified);
        try {
            params.set(ValidationParamKey.NONROLLING_OPTION.ordinal(), this.options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled());
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        DBValidationController validationController = new DBValidationController();
        List<ValidationResult> failedValidations = validationController.invoke(params);
        return failedValidations;
    }

    private File createCompleteSIDBInstance(String command, String fileName) throws OPatchAutoException {
        SystemInstance systemInstance = this.createSIDBSystemInstance(fileName);
        String owner = OUIDriver.checkFileOwner((File)new File(System.getProperty("ORACLE_HOME"), DBCommonPatchingConstants.OPATCHAUTO_DB_SCRIPT));
        boolean ok = DBPatchingUtil.mkdirs(this.getSystemInstanceFilePath(), owner, null);
        String filePath = this.getSystemInstanceFilePath() + File.separator + this.getSystemInstanceFileName();
        ok = DBPatchingUtil.createNewFile(filePath, owner, null);
        if (!ok) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72035), (Object[])new Object[]{this.getSystemInstanceFilePath()}), new Object[0]);
        }
        File configXML = new File(filePath);
        try {
            systemInstance.writeFile(configXML);
        }
        catch (FileNotFoundException e) {
            throw new OPatchAutoException(Integer.toString(72050, 245), new Object[0]);
        }
        return configXML;
    }

    private SystemInstance createSIDBSystemInstance(String topologyFile) throws OPatchAutoException {
        SIDatabase sidb = new SIDatabase();
        SystemInstance sysInst = new SystemInstance();
        try {
            String oh;
            SIDBProductDriver sidbPrdDr;
            sysInst = sysInst.readFile(new File(topologyFile));
            List sidbs = sysInst.getTargetsOfType(SIDatabase.class);
            if (sidbs != null) {
                sidb = (SIDatabase)sidbs.get(0);
            }
            if ((sysInst = (sidbPrdDr = new SIDBProductDriver(sidb, oh = this.options.getOption("home").getValue())).buildSystemInstance()) == null) {
                throw new OPatchAutoException(Integer.toString(72050, 245), new Object[0]);
            }
        }
        catch (OPatchAutoException e) {
            this.logger.throwing("Detailed Exception : ", e.getMessage(), e);
            throw new OPatchAutoException(Integer.toString(72050), 245);
        }
        catch (FileNotFoundException e) {
            this.logger.throwing("Detailed Exception : ", e.getMessage(), e);
            throw new OPatchAutoException(Integer.toString(72050), 245);
        }
        return sysInst;
    }

    @Override
    protected String getSystemInstanceFileName() throws OPatchAutoException {
        if (this.isSidbOnly) {
            return "opatch_sidb_config.xml";
        }
        return "opatch_gi_" + this.options.getOption("session").getValue() + "_config.xml";
    }

    private IListComparator<dbmodel.common.Host> getHostListComparator() {
        return new HostListComparator();
    }

    private Host getHost(dbmodel.common.Host hostModel) throws OPatchAutoException {
        HostImpl host = new HostImpl();
        String hostName = hostModel.getHostName();
        if (!StringUtil.isNullOrEmpty((String)hostName, (boolean)true)) {
            host.setHost(hostName);
            host.setRemoteConnectionType("linuxclisshuserequivalence");
            if (this.credentialManager != null) {
                String currentUser = System.getProperty("user.name");
                Credential credential = null;
                try {
                    credential = this.credentialManager.getCredential(host.getHost(), null, currentUser);
                }
                catch (OPatchAutoException e) {
                    this.logger.info("Unable to get credential from the wallet for user " + currentUser);
                }
                if (credential == null) {
                    credential = this.credentialManager.getCredential(host.getHost());
                }
                host.setCredential(credential);
            }
            if (this.hostVsHomeMap.get(hostModel.getHostName()) != null) {
                this.addHomeToHost(hostModel, host);
            }
        }
        return host;
    }

    private void addHomeToHost(dbmodel.common.Host hostModel, HostImpl host) throws OPatchAutoException {
        List<OracleHome> list = this.hostVsHomeMap.get(hostModel.getHostName());
        String usrName = null;
        if (host.getCredential() != null) {
            usrName = host.getCredential().getUsername();
        }
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        this.gimrPath = DBPatchingHelper.getGIMRHomePath();
        String version = null;
        if (!this.command.isReport()) {
            version = PatchPlanner.getInstance().getPrimaryPatchVersion();
        }
        for (OracleHome oracleHome : list) {
            if (!this.command.isReport() && !DBPatchingUtil.canIncludeTargetByVersion(configGraph, (AbstractBaseTarget)oracleHome, version)) {
                this.logger.info("Skipping home :: " + oracleHome.getPath() + " in host::" + host.getHost());
                PatchPlanner.getInstance().getOPlanEnv().getPatchingStatusOfOracleHome().put(oracleHome.getPath(), "skipped");
                continue;
            }
            String hostName = host.getHost();
            if (host.isRemote()) {
                if (oracleHome.getOwner().equalsIgnoreCase(usrName) && !this.getLibPathMap().containsKey(hostName)) {
                    this.putLibPath(hostName, oracleHome.getPath());
                }
            } else {
                this.putLibPath(hostName, OPatchAutoHelper.getOPatchAutoHome());
            }
            HomeImpl home = new HomeImpl();
            home.setHost((Host)host);
            home.setInvPtrLoc(oracleHome.getInventoryLocation());
            home.setLocation(oracleHome.getPath());
            home.setOwner(oracleHome.getOwner());
            home.setVersion(this.findHomeVersion((Home)home, configGraph));
            ProductType productType = null;
            switch (oracleHome.getHomeType()) {
                case "rac": {
                    productType = new RACProductType();
                    break;
                }
                case "crs": {
                    productType = new GIProductType();
                    break;
                }
                case "siha": {
                    productType = new SIHAProductType();
                    break;
                }
                case "sidb": {
                    productType = new SIDBProductType();
                    break;
                }
                default: {
                    this.logger.log(Level.SEVERE, "Home of type ::" + oracleHome.getHomeType() + " is not supported.");
                    throw new UnsupportedOperationException("Home of type ::" + oracleHome.getHomeType() + " is not supported.");
                }
            }
            home.addProductType(productType);
            if (oracleHome.getHomeType().equals("rac")) {
                if (oracleHome.getIsShared()) {
                    home.addProductType((ProductType)new RACSharedProductType());
                } else {
                    home.addProductType((ProductType)new RACNonSharedProductType());
                }
            }
            if (this.isDefaultProductTypeRequired) {
                ProductTypeImpl _defaultProductType = new ProductTypeImpl("default", SupportType.home, this.getMarkerFilePaths(), true);
                home.addProductType((ProductType)_defaultProductType);
            }
            if (oracleHome.getIsShared()) {
                this.addToLinkedHomeList((Home)home);
            }
            this.logger.info("GIMR home location " + this.gimrPath);
            this.logger.info("Oracle home location " + oracleHome.getPath());
            this.logger.info("Oracle home type " + oracleHome.getHomeType());
            if (this.gimrPath != null && oracleHome.getPath().equals(this.gimrPath) && !oracleHome.getHomeType().equals("crs")) {
                home.setGIMR(true);
                this.logger.info("GIMR home detected at " + oracleHome.getPath());
            }
            host.addHome((Home)home);
            this.logger.info("home: " + home.getLocation() + " in host: " + host.getHost());
        }
    }

    private Set<String> getMarkerFilePaths() {
        LinkedHashSet<String> markers = new LinkedHashSet<String>();
        markers.add("inventory/registry.xml");
        markers.add("inventory/ContentsXML/comps.xml");
        return markers;
    }

    @Override
    protected File createSystemInstanceXML() throws OPatchAutoException {
        String oracleHome = PatchPlanner.getInstance().getOPlanEnv().getOracleHome();
        String crsOwner = OUIDriver.checkFileOwner((File)new File(oracleHome, "oraInst.loc"));
        String path = this.getSystemInstanceFilePath();
        Credential credential = null;
        String host = "";
        if (this.isSidbOnly) {
            host = OPatchAutoHelper.getOPatchAutoHost();
            if (host != null && host.indexOf(".") != -1) {
                host = host.substring(0, host.indexOf("."));
            }
        } else {
            host = this.crsPD.getLocalInfo().getLocalHostName();
        }
        credential = DBPatchingHelper.getOwnerOrCurrentUserCred(host, crsOwner, this.credentialManager);
        boolean ok = DBPatchingUtil.mkdirs(path, crsOwner, credential);
        String sysInstanceConfigXML = path + File.separator + this.getSystemInstanceFileName();
        ok = DBPatchingUtil.createNewFile(sysInstanceConfigXML, crsOwner, credential);
        if (!ok) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72035), (Object[])new Object[]{sysInstanceConfigXML}), new Object[0]);
        }
        this.systemInstanceFile = new File(sysInstanceConfigXML);
        PatchPlanner.getInstance().setSystemInstanceFilePath(sysInstanceConfigXML);
        return this.systemInstanceFile;
    }

    public File getSystemInstanceFile() {
        return this.systemInstanceFile;
    }

    private String findHomeVersion(Home home, ConfigGraph graph) {
        String version = null;
        List<OracleHome> targets = graph.getTargets(OracleHome.class);
        for (OracleHome ohTarget : targets) {
            AbstractBaseTarget siha;
            if (!PatchPlanUtils.removeFileSeperatorAtEnd(ohTarget.getPath()).equals(PatchPlanUtils.removeFileSeperatorAtEnd(home.getLocation())) || this.findHostFromHome(home.getHost(), ohTarget) == null) continue;
            if ("crs".equals(ohTarget.getHomeType())) {
                AbstractBaseTarget crs = graph.getRootVertex();
                if (crs != null) {
                    version = new OiiiVersion(crs.getVersion()).getVerString();
                }
            } else if ("rac".equals(ohTarget.getHomeType())) {
                List<RACDBInstance> racInst = graph.getConnectedTargets((AbstractBaseTarget)ohTarget, RACDBInstance.class);
                if (racInst != null && racInst.size() > 0) {
                    version = new OiiiVersion(racInst.get(0).getVersion()).getVerString();
                } else if ((OUIComponent)ohTarget.getTopLevelOUI().get(0) != null) {
                    version = new OiiiVersion(((OUIComponent)ohTarget.getTopLevelOUI().get(0)).getVersion()).getVerString();
                }
            } else if ("sidb".equals(ohTarget.getHomeType())) {
                List<SIDatabase> sidb = graph.getConnectedTargets((AbstractBaseTarget)ohTarget, SIDatabase.class);
                if (sidb != null && sidb.size() != 0) {
                    version = new OiiiVersion(sidb.get(0).getVersion()).getVerString();
                }
            } else if ("siha".toString().equals(ohTarget.getHomeType()) && (siha = graph.getRootVertex()) != null) {
                version = new OiiiVersion(siha.getVersion()).getVerString();
            }
            if (StringUtil.isNullOrEmpty(version)) continue;
            break;
        }
        this.logger.info("Version for home:" + home.getLocation() + ", Host:" + home.getHost().getHost() + "=" + version);
        return version;
    }

    private dbmodel.common.Host findHostFromHome(Host selectedHost, OracleHome oh) {
        dbmodel.common.Host targetHost = null;
        for (dbmodel.common.Host host : oh.getHosts()) {
            if (!this.getHostName(host.getHostName()).equals(this.getHostName(selectedHost.getHost()))) continue;
            targetHost = host;
            break;
        }
        return targetHost;
    }

    private String getHostName(String hostName) {
        String currentHostName = hostName;
        if (currentHostName != null && currentHostName.indexOf(".") != -1) {
            currentHostName = currentHostName.substring(0, currentHostName.indexOf("."));
        }
        return currentHostName;
    }
}

