/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.patchinfostore.PatchingSessionInfoStore;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.CommandExecutionThread;
import com.oracle.glcm.patch.auto.db.integration.controller.ExecutionCommand;
import com.oracle.glcm.patch.auto.db.integration.controller.ParallelExecution;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.helper.util.HelperUtility;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.db_crs.DBInstance;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.cmdtools.SRVCTLUtil;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.gridhome.GridHomeFactory;
import oracle.cluster.oc4j.OC4JFactory;
import oracle.cluster.server.Node;
import oracle.cluster.util.NotExistsException;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.HostData;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.RemoteNodes;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import oracle.opatchauto.core.binary.SessionPatches;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class DBPatchingHelper {
    private static final Logger _logger = Logger.getLogger(DBPatchingHelper.class.getName());

    public static void setupEnvironment(String oracleHomePath, String invPtrStr) {
        StringBuffer ouiLocation = null;
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        if (cmdOuiLocation == null || cmdOuiLocation.trim().length() == 0) {
            ouiLocation = new StringBuffer(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        } else {
            ouiLocation = new StringBuffer(cmdOuiLocation);
        }
        System.setProperty("oracle.installer.oui_loc", ouiLocation.toString());
        System.setProperty("oracle.installer.startup_location", ouiLocation.toString());
        String sLibraryLoc = OiixPathOps.concatPath((String)ouiLocation.toString(), (String)"lib");
        String dirName = OUIDriver.Platform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)dirName);
        sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
        HelperUtility.setSLibLocn((String)sLibraryLoc);
        if (!StringUtil.isNullOrEmpty((String)invPtrStr)) {
            System.setProperty("oracle.installer.invPtrLoc", invPtrStr);
        }
    }

    public static boolean isGenerateStepCommand(OPatchAutoOptions options) {
        boolean isGenerateStep = false;
        try {
            OPatchAutoOption generateStep;
            if (options != null && (generateStep = options.getOption(DBProductParameterConstants.GENERATE_STEPS_KEY.getValue())) != null && Boolean.TRUE.toString().equals(generateStep.getValue())) {
                isGenerateStep = true;
            }
        }
        catch (OPatchAutoException e) {
            isGenerateStep = false;
        }
        return isGenerateStep;
    }

    public static boolean isStaticConfiguration(OPatchAutoOptions options) {
        boolean staticConfig = false;
        try {
            OPatchAutoOption snapShotFileOpt;
            if (options != null && (snapShotFileOpt = options.getOption(DBProductParameterConstants.SYSTEM_SNAPSHOT_FILE_PATH_KEY.getValue())) != null && !StringUtil.isNullOrEmpty((String)snapShotFileOpt.getValue())) {
                staticConfig = true;
            }
        }
        catch (OPatchAutoException e) {
            staticConfig = false;
        }
        return staticConfig;
    }

    public static boolean isNonRollingMode(OPatchAutoOptions options) {
        boolean isNonRolling = false;
        try {
            OPatchAutoOption nonRollingMode;
            if (options != null && (nonRollingMode = options.getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue())) != null) {
                isNonRolling = Boolean.parseBoolean(nonRollingMode.getValue().trim());
            }
        }
        catch (OPatchAutoException e) {
            isNonRolling = false;
        }
        return isNonRolling;
    }

    public static boolean isNoRestartEnable(OPatchAutoOptions options) {
        boolean isEnable = false;
        try {
            OPatchAutoOption noRestart;
            if (options != null && (isEnable = Boolean.parseBoolean((noRestart = options.getOption(DBProductParameterConstants.NORESTART_KEY.getValue())).getValue()))) {
                String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
                boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
                isEnable = isEnable && isTwelveVersion;
            }
        }
        catch (OPatchAutoException e) {
            isEnable = false;
        }
        return isEnable;
    }

    public static boolean isOHOrDatabaseOptionSpecified(OPatchAutoOptions options) throws OPatchAutoException {
        boolean isOHOrDatabaseOptionSpecified = false;
        String no_Oh = "NO_OH";
        OPatchAutoOption oh = options.getOption("home");
        String home = oh.getValue("NO_OH");
        OPatchAutoOption database = options.getOption(DBProductParameterConstants.DATABASE_KEY.getValue());
        String db = database.getValue();
        if (!home.equals("NO_OH")) {
            isOHOrDatabaseOptionSpecified = true;
        } else {
            oh.setValue(null);
        }
        if (!StringUtil.isNullOrEmpty((String)db, (boolean)true)) {
            isOHOrDatabaseOptionSpecified = true;
        }
        return isOHOrDatabaseOptionSpecified;
    }

    public static Set<String> getDBResourceBundles() {
        LinkedHashSet<String> bundles = new LinkedHashSet<String>();
        bundles.add("resources/opatchautodb/usage");
        bundles.add("resources/opatchautodb/messages");
        bundles.add("resources/opatchautodb/opatchauto-db");
        bundles.add("resources/opatchautodb/Bundle");
        bundles.add("resources/opatchautodb/AutomationBundle");
        bundles.add("resources/opatchautodb/readme/Bundle");
        return bundles;
    }

    public static boolean findWholeWord(String command, String word) {
        return command.matches(".*?\\b" + word + "\\b.*?");
    }

    public static String getDBVersion(AbstractBaseTarget target) {
        String version = null;
        if (target == null) {
            return version;
        }
        if (target instanceof DBInstance) {
            version = ((DBInstance)target).getVersion();
        } else if (target instanceof RACDatabase) {
            version = ((RACDatabase)target).getVersion();
        }
        return version;
    }

    public static boolean isCustomPlan(OPatchAutoOptions options) throws OPatchAutoException {
        boolean isCustom = false;
        OPatchAutoOption binary = options.getOption("binary");
        if (Boolean.parseBoolean(binary.getValue())) {
            isCustom = true;
        }
        return isCustom;
    }

    public static boolean isAutoBinaryOption(OPatchAutoOptions options) {
        boolean isAutoBinary = false;
        try {
            OPatchAutoOption binary = options.getOption("binary");
            if (Boolean.parseBoolean(binary.getValue())) {
                isAutoBinary = true;
            }
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        return isAutoBinary;
    }

    public static String getPatchLocation(PatchSession session) {
        String patchLocation = session.getPatchLocation();
        if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
            patchLocation = session.getPatchBaseDirectory();
        }
        return patchLocation;
    }

    public static boolean isRollbackUsingPatchId(PatchSession session) {
        boolean isPatchID = false;
        if (session.isRollback() && !StringUtil.isNullOrEmpty((String)session.getPatchId())) {
            isPatchID = true;
        }
        return isPatchID;
    }

    public static boolean isRHPPatchingSession(String home, PatchSession session, ArrayList<OPatchPatchInfo> patchList) {
        boolean isRHPPatchingSession = true;
        if (!StringUtil.isNullOrEmpty((String)SessionData.getInstance().isRHPPatching())) {
            isRHPPatchingSession = Boolean.valueOf(SessionData.getInstance().isRHPPatching());
            _logger.info("RHP Patching session: " + isRHPPatchingSession);
            return isRHPPatchingSession;
        }
        ArrayList<OPatchPatchInfo> actualPatchList = patchList;
        if (patchList != null && !patchList.isEmpty()) {
            for (OPatchPatchInfo individualPatchInfo : actualPatchList) {
                String individualPatch = individualPatchInfo.getPatchLocation();
                if (session.isRollback()) {
                    _logger.info("Identifying RHP for rollback");
                    String pid = individualPatchInfo.getPatchID();
                    if (null == pid) {
                        _logger.info("PID is null");
                        if (null != individualPatch) {
                            File patch = new File(individualPatch);
                            pid = patch.getName();
                            _logger.info("PID from path is " + pid);
                        } else {
                            _logger.info("PID not found");
                            return false;
                        }
                    }
                    _logger.info("PID being checked : " + pid);
                    try {
                        if (SessionPatches.isRHPPatchForRollback((String)home, (String)pid)) continue;
                        isRHPPatchingSession = false;
                        _logger.info("Non RHP Patches detected in rollback");
                        break;
                    }
                    catch (Exception e) {
                        isRHPPatchingSession = false;
                        _logger.info("Unable to determine RHP Patch " + e.getMessage());
                        continue;
                    }
                }
                try {
                    if (SessionPatches.isRHPPatchForApply((String)individualPatch)) continue;
                    isRHPPatchingSession = false;
                    _logger.info("Non RHP Patches detected in apply");
                    break;
                }
                catch (Exception e) {
                    isRHPPatchingSession = false;
                    _logger.info("Unable to determine RHP Patch " + e.getMessage());
                }
            }
            SessionData.getInstance().setRHPPatching(isRHPPatchingSession);
            _logger.info("RHP Patching session: " + isRHPPatchingSession);
            return isRHPPatchingSession;
        }
        return false;
    }

    public static boolean isJDKPatchingSession(String home, PatchSession session, ArrayList<OPatchPatchInfo> patchList) {
        boolean isJDKPatchingSession = true;
        if (!StringUtil.isNullOrEmpty((String)SessionData.getInstance().isJDKPatching())) {
            isJDKPatchingSession = Boolean.valueOf(SessionData.getInstance().isJDKPatching());
            _logger.info("Jdk patching session: " + isJDKPatchingSession);
            return isJDKPatchingSession;
        }
        ArrayList<OPatchPatchInfo> actualPatchList = patchList;
        if (patchList != null && !patchList.isEmpty()) {
            for (OPatchPatchInfo individualPatchInfo : actualPatchList) {
                String individualPatch = individualPatchInfo.getPatchLocation();
                if (session.isRollback()) {
                    _logger.info("Identifying JDK for rollback");
                    String pid = individualPatchInfo.getPatchID();
                    if (null == pid) {
                        _logger.info("PID is null");
                        if (null != individualPatch) {
                            File patch = new File(individualPatch);
                            pid = patch.getName();
                            _logger.info("PID from path is " + pid);
                        } else {
                            _logger.info("PID not found");
                            return false;
                        }
                    }
                    _logger.info("PID being checked : " + pid);
                    try {
                        if (!SessionPatches.isJDKPatchForRollback((String)home, (String)pid, (String)individualPatch)) {
                            isJDKPatchingSession = false;
                            _logger.info("Non JDK patch detected in rollback " + individualPatch);
                            break;
                        }
                        _logger.info("JDK patch detected in rollback: " + individualPatch);
                    }
                    catch (Exception e) {
                        isJDKPatchingSession = false;
                        _logger.info("Unable to determine JDK Patch " + e.getMessage());
                    }
                    continue;
                }
                try {
                    if (!SessionPatches.isJDKPatchForApply((String)individualPatch)) {
                        isJDKPatchingSession = false;
                        _logger.info("Non JDK patch detected in apply " + individualPatch);
                        break;
                    }
                    _logger.info("JDK patch detected in apply " + individualPatch);
                }
                catch (Exception e) {
                    isJDKPatchingSession = false;
                    _logger.info("Unable to determine JDK Patch " + e.getMessage());
                }
            }
            SessionData.getInstance().setJDKPatching(isJDKPatchingSession);
            _logger.info("jdk patching session: " + isJDKPatchingSession);
            return isJDKPatchingSession;
        }
        return false;
    }

    public static boolean isTomcatPatchingSession(String home, PatchSession session, ArrayList<OPatchPatchInfo> patchList) {
        boolean isTomcatPatchingSession = true;
        if (!StringUtil.isNullOrEmpty((String)SessionData.getInstance().isTomcatPatching())) {
            isTomcatPatchingSession = Boolean.valueOf(SessionData.getInstance().isTomcatPatching());
            _logger.info("Tomcat/Micronaut Patching session: " + isTomcatPatchingSession);
            return isTomcatPatchingSession;
        }
        ArrayList<OPatchPatchInfo> actualPatchList = patchList;
        if (patchList != null && !patchList.isEmpty()) {
            for (OPatchPatchInfo individualPatchInfo : actualPatchList) {
                String individualPatch = individualPatchInfo.getPatchLocation();
                if (session.isRollback()) {
                    _logger.info("Identifying Tomcat/Micronaut patches for rollback");
                    String pid = individualPatchInfo.getPatchID();
                    if (null == pid) {
                        _logger.info("PID is null");
                        if (null != individualPatch) {
                            File patch = new File(individualPatch);
                            pid = patch.getName();
                            _logger.info("PID from path is " + pid);
                        } else {
                            _logger.info("PID not found");
                            return false;
                        }
                    }
                    _logger.info("PID being checked : " + pid);
                    try {
                        if (!SessionPatches.isTomcatPatchForRollback((String)home, (String)pid)) {
                            isTomcatPatchingSession = false;
                            _logger.info("Patches with online_gi_installable=false detected in rollback");
                            break;
                        }
                        _logger.info("Patches with online_gi_installable=true detected in rollback");
                    }
                    catch (Exception e) {
                        isTomcatPatchingSession = false;
                        _logger.info("Unable to determine online_gi_installable patch metadata " + e.getMessage());
                    }
                    continue;
                }
                try {
                    if (!SessionPatches.isTomcatPatchForApply((String)individualPatch)) {
                        isTomcatPatchingSession = false;
                        _logger.info("Patches with online_gi_installable=false detected in apply");
                        break;
                    }
                    _logger.info("Patches with online_gi_installable=true detected in apply " + individualPatch);
                }
                catch (Exception e) {
                    isTomcatPatchingSession = false;
                    _logger.info("Unable to determine Tomcat/Micronaut Patch " + e.getMessage());
                }
            }
            SessionData.getInstance().setTomcatPatching(isTomcatPatchingSession);
            _logger.info("Tomcat/Micronaut Patching session: " + isTomcatPatchingSession);
            return isTomcatPatchingSession;
        }
        return false;
    }

    public static boolean isTwoStageRollingPatchSession(String home, PatchSession session, ArrayList<OPatchPatchInfo> patchList) {
        boolean isTwoStageRollingPatchingSession = false;
        if (!StringUtil.isNullOrEmpty((String)SessionData.getInstance().isTwoStageRollingPatching())) {
            isTwoStageRollingPatchingSession = Boolean.valueOf(SessionData.getInstance().isTwoStageRollingPatching());
            _logger.info("Two Stage Rolling Patching session: " + isTwoStageRollingPatchingSession);
            return isTwoStageRollingPatchingSession;
        }
        ArrayList<OPatchPatchInfo> actualPatchList = patchList;
        if (patchList != null && !patchList.isEmpty()) {
            for (OPatchPatchInfo individualPatchInfo : actualPatchList) {
                String individualPatch = individualPatchInfo.getPatchLocation();
                if (session.isRollback()) {
                    _logger.info("Identifying Two Stage rolling patch for rollback");
                    String pid = individualPatchInfo.getPatchID();
                    if (null == pid) {
                        _logger.info("PID is null");
                        if (null != individualPatch) {
                            File patch = new File(individualPatch);
                            pid = patch.getName();
                            _logger.info("PID from path is " + pid);
                        } else {
                            _logger.info("PID not found");
                            return false;
                        }
                    }
                    _logger.info("PID being checked : " + pid);
                    try {
                        if (!SessionPatches.isTwoStageRPForRollback((String)home, (String)pid)) continue;
                        isTwoStageRollingPatchingSession = true;
                        _logger.info("Two Stage Rolling Patches detected in rollback");
                        break;
                    }
                    catch (Exception e) {
                        isTwoStageRollingPatchingSession = false;
                        _logger.info("Unable to determine Two Stage rolling Patch for rollback " + e.getMessage());
                        continue;
                    }
                }
                try {
                    if (!SessionPatches.isTwoStageRPForApply((String)individualPatch)) continue;
                    isTwoStageRollingPatchingSession = true;
                    _logger.info("Two Stage rolling patches detected in apply");
                    break;
                }
                catch (Exception e) {
                    isTwoStageRollingPatchingSession = false;
                    _logger.info("Unable to determine Two Stage rolling Patching session for apply " + e.getMessage());
                }
            }
            SessionData.getInstance().setTwoStageRollingPatching(isTwoStageRollingPatchingSession);
            _logger.info("Two Stage Rolling Patching session: " + isTwoStageRollingPatchingSession);
            return isTwoStageRollingPatchingSession;
        }
        return false;
    }

    public static String getRUVersionForApply(String home) {
        String ru = "";
        for (OPatchPatchInfo patchInfo : SessionData.getInstance().getAnalyzedPatchList(home)) {
            String patchLocation = patchInfo.getPatchLocation();
            String version = SessionPatches.getRUVersionForApply((String)patchLocation);
            if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) continue;
            _logger.info("RU Version is " + version);
            ru = version;
            break;
        }
        if (StringUtil.isNullOrEmpty((String)ru, (boolean)true) || ru.equalsIgnoreCase("null")) {
            return null;
        }
        return ru;
    }

    public static String getRUVersionForRollback(String home, ArrayList<OPatchPatchInfo> patchList) {
        String ru = "";
        for (OPatchPatchInfo patchInfo : patchList) {
            String patchID = patchInfo.getPatchID();
            String version = SessionPatches.getRUVersionForRollback((String)home, (String)patchID);
            if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) continue;
            _logger.info("RU Version is " + version);
            ru = version;
            break;
        }
        if (StringUtil.isNullOrEmpty((String)ru, (boolean)true) || ru.equalsIgnoreCase("null")) {
            return null;
        }
        return ru;
    }

    public static String getRUVersion(String home, PatchSession session, ArrayList<OPatchPatchInfo> patchList) {
        String getRUVersion = "";
        ArrayList<OPatchPatchInfo> actualPatchList = patchList;
        if (patchList != null && !patchList.isEmpty()) {
            for (OPatchPatchInfo individualPatchInfo : actualPatchList) {
                String individualPatch = individualPatchInfo.getPatchLocation();
                if (session.isRollback()) {
                    _logger.info("Retrieving RU version for Two Stage rolling patch for rollback");
                    String pid = individualPatchInfo.getPatchID();
                    if (null == pid) {
                        _logger.info("PID is null");
                        if (null != individualPatch) {
                            File patch = new File(individualPatch);
                            pid = patch.getName();
                            _logger.info("PID from path is " + pid);
                        } else {
                            _logger.info("PID not found");
                            return getRUVersion;
                        }
                    }
                    _logger.info("PID being checked : " + pid);
                    try {
                        if (StringUtil.isNullOrEmpty((String)SessionPatches.getRUVersionForRollback((String)home, (String)pid))) continue;
                        getRUVersion = SessionPatches.getRUVersionForRollback((String)home, (String)pid);
                        _logger.info("RU version in rollback " + getRUVersion);
                        break;
                    }
                    catch (Exception e) {
                        getRUVersion = "";
                        _logger.info("Unable to determine RU version in rollback " + e.getMessage());
                        continue;
                    }
                }
                try {
                    if (StringUtil.isNullOrEmpty((String)SessionPatches.getRUVersionForApply((String)individualPatch))) continue;
                    getRUVersion = SessionPatches.getRUVersionForApply((String)individualPatch);
                    _logger.info("RU version in apply " + getRUVersion);
                    break;
                }
                catch (Exception e) {
                    getRUVersion = "";
                    _logger.info("Unable to determine RU version in apply " + e.getMessage());
                }
            }
        }
        return getRUVersion;
    }

    public static boolean isLastNodeOfPatching(PatchTarget patchTarget, boolean isRollback) {
        String type = patchTarget.getProductType().getType();
        boolean isSharedRAC = type.equals(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        String home = patchTarget.getHome().getLocation();
        String host = patchTarget.getHost().getHost();
        HashMap<Object, Object> homePatchDataMap = new HashMap();
        homePatchDataMap = SessionData.getInstance().getHomePatchDataMap();
        HashMap<String, String> hostPatchDataMap = SessionData.getInstance().getHostPatchDataMap(home);
        _logger.info("hostPatchDataMap: " + hostPatchDataMap);
        ArrayList<String> patchIDList = new ArrayList<String>();
        ArrayList<OPatchPatchInfo> patchList = SessionData.getInstance().getAnalyzedPatchList(home);
        if (patchList != null && !patchList.isEmpty()) {
            if (isSharedRAC) {
                _logger.info("First node of patching for shared RAC.");
                return true;
            }
            for (OPatchPatchInfo patchInfo : patchList) {
                if (DBPatchingHelper.identifyNodeOfPatching(home, patchInfo.getPatchID(), hostPatchDataMap, isRollback) == NodeOfPatching.LAST) {
                    _logger.info("This is the last node for patch " + patchInfo.getPatchID());
                    patchIDList.add(patchInfo.getPatchID());
                    continue;
                }
                _logger.info("This is not the last node of the session.");
                return false;
            }
            _logger.info("This is the last node of patching for the session.");
            return true;
        }
        return false;
    }

    public static NodeOfPatching identifyNodeOfPatching(String home, String patchId, HashMap<String, String> hostPatchDataMap, boolean isRollback) {
        int count = 0;
        if (hostPatchDataMap == null) {
            _logger.info("The host-patch map is null.");
            return NodeOfPatching.LAST;
        }
        int nodecount = hostPatchDataMap.size();
        if (nodecount == 0) {
            _logger.info("There are no nodes in the host-patch map.");
            return NodeOfPatching.LAST;
        }
        for (String values : hostPatchDataMap.values()) {
            if (values != null) {
                _logger.info("Host patch data map values are : " + values);
                if (!values.contains(patchId)) continue;
                ++count;
                continue;
            }
            _logger.info("There are no patches in the host-patch map values.");
        }
        _logger.info("There are " + count + " nodes with this patch " + patchId + " already applied.");
        if (count == 0) {
            return isRollback ? NodeOfPatching.LAST : NodeOfPatching.FIRST;
        }
        if (count == nodecount) {
            return isRollback ? NodeOfPatching.FIRST : NodeOfPatching.LAST;
        }
        if (count < nodecount) {
            return NodeOfPatching.MIDDLE;
        }
        return null;
    }

    public static boolean isFirstNodeOfPatchingForAnyPatch(String home, HashMap<String, String> hostPatchMap, boolean isRollback) {
        ArrayList<OPatchPatchInfo> patchList = SessionData.getInstance().getAnalyzedPatchList(home);
        if (patchList == null || patchList.isEmpty()) {
            _logger.info("There are no patches in the session");
            return false;
        }
        for (OPatchPatchInfo patchInfo : patchList) {
            if (DBPatchingHelper.identifyNodeOfPatching(home, patchInfo.getPatchID(), hostPatchMap, isRollback) == NodeOfPatching.FIRST) {
                _logger.info("This is the first node of patching for patch " + patchInfo.getPatchID());
                return true;
            }
            _logger.info("This is not the first node of patching for patch " + patchInfo.getPatchID());
        }
        return false;
    }

    public static boolean isLastNodeOfPatchingForAnyPatch(String home, HashMap<String, String> hostPatchMap, boolean isRollback) {
        ArrayList<OPatchPatchInfo> patchList = SessionData.getInstance().getAnalyzedPatchList(home);
        if (patchList == null || patchList.isEmpty()) {
            _logger.info("There are no patches in the session");
            return false;
        }
        for (OPatchPatchInfo patchInfo : patchList) {
            if (DBPatchingHelper.identifyNodeOfPatching(home, patchInfo.getPatchID(), hostPatchMap, isRollback) == NodeOfPatching.LAST) {
                _logger.info("This is last node of patching for patch " + patchInfo.getPatchID());
                return true;
            }
            _logger.info("This is not the last node of patching for patch " + patchInfo.getPatchID());
        }
        return false;
    }

    public static boolean isFirstNodeForAllPatches(String home, HashMap<String, String> hostPatchMap, boolean isRollback) {
        ArrayList<OPatchPatchInfo> patchList = SessionData.getInstance().getAnalyzedPatchList(home);
        if (patchList == null || patchList.isEmpty()) {
            _logger.info("There are no patches in the session");
            return false;
        }
        for (OPatchPatchInfo patchInfo : patchList) {
            if (DBPatchingHelper.identifyNodeOfPatching(home, patchInfo.getPatchID(), hostPatchMap, isRollback) == NodeOfPatching.FIRST) continue;
            return false;
        }
        return true;
    }

    private static boolean containsLastNodeDB(PatchTarget target, ExecutionStep step, String command, boolean isRollback) {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        String instName = DBPatchingUtil.getInstNameUsingCommand(command);
        _logger.info("Instance Name: " + instName);
        String dbname = DBPatchingUtil.getRACDBNameFromInstancename(instName, target);
        _logger.info("DB Name: " + dbname);
        if (null == dbname) {
            return true;
        }
        String home = target.getHome(true).getLocation();
        HashMap<String, String> hostPatchDataMap = SessionData.getInstance().getHostPatchDataMap(home);
        List<RACDatabase> racDBs = configGraph.getTargets(RACDatabase.class);
        for (RACDatabase racDB : racDBs) {
            if (!racDB.getDatabaseName().equals(dbname)) continue;
            HashMap<String, String> hostPatchMap = new HashMap<String, String>();
            List instances = racDB.getDbInstances();
            for (RACDBInstance instance : instances) {
                if (instance.getHost().getHostName().equals(target.getHost().getHost())) continue;
                _logger.info("Checking for instance name " + instance.getInstanceName());
                hostPatchMap.put(instance.getHost().getHostName(), hostPatchDataMap.get(instance.getHost().getHostName()));
            }
            _logger.info("Identifying last node of patching for DB " + dbname);
            return DBPatchingHelper.isLastNodeOfPatchingForAnyPatch(home, hostPatchMap, isRollback);
        }
        return true;
    }

    public static List<ExecutionStep> filterLastNodeSteps(PatchTarget target, List<ExecutionStep> steps, boolean isRollback) {
        _logger.info("Filtering datapatch steps");
        ArrayList<ExecutionStep> lastNodeDBSteps = new ArrayList<ExecutionStep>();
        if (target.getProductType().getType().equals(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue())) {
            _logger.info("This is shared RAC so adding all steps.");
            return steps;
        }
        for (ExecutionStep step : steps) {
            boolean containsDP = false;
            String command = "";
            for (ExecutionStep.Command cmd : step.getCommand()) {
                command = cmd.getValue();
                _logger.info("datapatch related Command is : " + command);
                if (!command.contains("ORACLE_HOME=") || !command.contains("ORACLE_SID=") || !command.contains("datapatch")) continue;
                _logger.info("Found datapatch command ");
                containsDP = true;
                break;
            }
            if (!containsDP || !DBPatchingHelper.containsLastNodeDB(target, step, command, isRollback)) continue;
            _logger.info("Adding step with cmd : " + command);
            lastNodeDBSteps.add(step);
        }
        return lastNodeDBSteps;
    }

    public static String getPatchPath(String patchLoc, String phBaseDir) {
        if (patchLoc != null && patchLoc.length() > 0) {
            String patchLocation = patchLoc;
            patchLocation = patchLocation.replaceAll("/+$", "");
            return patchLocation;
        }
        if (phBaseDir != null) {
            String patchLocation = phBaseDir;
            patchLocation = patchLocation.replaceAll("/+$", "");
            return patchLocation;
        }
        return null;
    }

    public static String getPatchIDList(ArrayList<OPatchPatchInfo> patchList) {
        String patchIDList = null;
        if (patchList != null && !patchList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (OPatchPatchInfo individualPatchInfo : patchList) {
                String individualPatchID = individualPatchInfo.getPatchID();
                sb.append(individualPatchID).append(",");
            }
            if (sb.toString().endsWith(",")) {
                patchIDList = sb.toString().substring(0, sb.toString().length() - 1);
            }
            return patchIDList;
        }
        return null;
    }

    public static ArrayList<OPatchPatchInfo> getPatchListForOOPSwitchback(String home) {
        ArrayList<Object> patchListForSwitchback = new ArrayList<OPatchPatchInfo>();
        _logger.info("Checking patch list for home " + home);
        try {
            OOPSessionInfo oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
            OracleHomePatchLevel ohpl = oopSessionInfo.getIncomingPatchesOnNodes();
            if (ohpl == null || ohpl.getOracleHomePatchLevel().get(home) == null || ohpl.getOracleHomePatchLevel().get(home).size() == 0) {
                _logger.info("Incoming patch data not available in cookie.");
                return patchListForSwitchback;
            }
            patchListForSwitchback = new ArrayList(ohpl.getOracleHomePatchLevel().get(home));
            for (OPatchPatchInfo oPatchPatchInfo : patchListForSwitchback) {
                _logger.info("Patch location : " + oPatchPatchInfo.getPatchLocation());
                _logger.info("Patch ID : " + oPatchPatchInfo.getPatchID());
                if (!StringUtil.isNullOrEmpty((String)oPatchPatchInfo.getPatchLocation())) continue;
                oPatchPatchInfo.setPatchLocation(oPatchPatchInfo.getPatchID());
            }
        }
        catch (Exception e) {
            _logger.info("Unable to identify patches of previous session.");
        }
        return patchListForSwitchback;
    }

    public static ArrayList<OPatchPatchInfo> getPatchListForOOPApplySwitchClone(String home) {
        ArrayList<Object> patchListForSwitchClone = new ArrayList<OPatchPatchInfo>();
        _logger.info("Checking patch list for switching home " + home);
        try {
            OOPSessionInfo oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
            OracleHomePatchLevel ohpl = oopSessionInfo.getIncomingPatchesOnNodes();
            if (ohpl == null || ohpl.getOracleHomePatchLevel().get(home) == null || ohpl.getOracleHomePatchLevel().get(home).size() == 0) {
                _logger.info("Incoming patch data not available from prepare session cookie.");
                return patchListForSwitchClone;
            }
            patchListForSwitchClone = new ArrayList(ohpl.getOracleHomePatchLevel().get(home));
            for (OPatchPatchInfo oPatchPatchInfo : patchListForSwitchClone) {
                _logger.info("Patch location : " + oPatchPatchInfo.getPatchLocation());
                _logger.info("Patch ID : " + oPatchPatchInfo.getPatchID());
                if (!StringUtil.isNullOrEmpty((String)oPatchPatchInfo.getPatchLocation())) continue;
                oPatchPatchInfo.setPatchLocation(oPatchPatchInfo.getPatchID());
            }
        }
        catch (Exception e) {
            _logger.info("Unable to identify patches of prepare session.");
        }
        return patchListForSwitchClone;
    }

    public static String getOJVMPatchPathOrID(String home, PatchSession session) {
        ArrayList<OPatchPatchInfo> actualPatchList = SessionData.getInstance().getAnalyzedPatchList(home);
        OPatchAutoOptions options = session.getOptions();
        if (session.getPatchId() != null) {
            _logger.log(Level.INFO, "The patch ID passed is " + session.getPatchId());
        }
        if (DBPatchingHelper.isRollbackUsingPatchId(session)) {
            if (session.getPatchId() == null) {
                _logger.log(Level.INFO, "Unable to find patch ID for Rollback action with patch ID ");
                return null;
            }
            if (DBPatchingHelper.isOOPSwitchbackSession(options) && (actualPatchList = DBPatchingHelper.getPatchListForOOPSwitchback(home)).size() < 1) {
                _logger.info("Patch list for switchback is empty");
                return null;
            }
        } else if (session.getPatchLocation() == null && session.getPatchBaseDirectory() == null && !DBPatchingHelper.isRollbackUsingPatchId(session)) {
            _logger.log(Level.INFO, "Patch location or patch base directory or Patch ID not passed for the session.");
            if (DBPatchingHelper.isOOPSwitchbackSession(options)) {
                actualPatchList = DBPatchingHelper.getPatchListForOOPSwitchback(home);
                if (actualPatchList.size() < 1) {
                    _logger.info("Patch list for switchback is empty");
                    return null;
                }
            } else if (DBPatchingHelper.isOOPApplySwitchCloneSession(options)) {
                String switchHome = OOPSessionInfoHandler.getInstance().getCloneHomePath(home);
                actualPatchList = DBPatchingHelper.getPatchListForOOPApplySwitchClone(switchHome);
                if (actualPatchList.size() < 1) {
                    _logger.info("Patch list for switch-clone is empty");
                    return null;
                }
            } else {
                _logger.info("This is not an OOP switch-clone or switchback session.");
                return null;
            }
        }
        if (actualPatchList == null || actualPatchList.size() < 1) {
            _logger.info("Patch list for OJVM check is empty");
            return null;
        }
        return SessionPatches.getOJVMPatchPathOrID((String)home, (boolean)DBPatchingHelper.isRollbackUsingPatchId(session), (boolean)session.isRollback(), (String)session.getPatchId(), (String)session.getPatchLocation(), (String)session.getPatchBaseDirectory(), actualPatchList);
    }

    public static String getOJVMLibForApply(String patch) {
        return SessionPatches.getFileLocationForPatchApply((String)patch, (String)"classes.bin");
    }

    public static String getOJVMLibForRollback(String home, String patchIDOrPath) {
        File patch = new File(patchIDOrPath);
        String patchID = patch.getName();
        return SessionPatches.getFileLocationForPatchRollback((String)home, (String)"classes.bin", (String)patchID);
    }

    public static String getTargetHomeFromProductType(PatchTarget target) {
        String targetHome = null;
        String type = target.getProductType().getType();
        if (type.equals(DBProductTypes.PRODUCT_TYPE_RAC.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue())) {
            targetHome = "rac";
        } else if (type.equals(DBProductTypes.PRODUCT_TYPE_SIDB.getValue())) {
            targetHome = "sidb";
        } else if (type.equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue())) {
            targetHome = "siha";
        } else if (type.equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) {
            targetHome = "crs";
        }
        return targetHome;
    }

    public static String getStripeName(PatchTarget target) {
        String stripeName = null;
        String type = target.getType();
        if (type.equals(DBProductTypes.PRODUCT_TYPE_RAC.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue())) {
            stripeName = "oracle.server";
        } else if (type.equals(DBProductTypes.PRODUCT_TYPE_SIDB.getValue())) {
            stripeName = "oracle.server";
        } else if (type.equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue())) {
            stripeName = "oracle.siha";
        } else if (type.equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) {
            stripeName = "oracle.crs";
        }
        return stripeName;
    }

    public static boolean isDatabaseHomeTarget(PatchTarget target) {
        boolean isDBTarget = false;
        String type = target.getType();
        if (type.equals(DBProductTypes.PRODUCT_TYPE_RAC.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_SIDB.getValue())) {
            isDBTarget = true;
        }
        return isDBTarget;
    }

    public static boolean unloadAIXfiles(PatchTarget patchTarget, byte[] password) throws OPatchAutoException {
        boolean isSuccessful = false;
        try {
            _logger.log(Level.INFO, "Executing command: \n/usr/sbin/slibclean");
            GISystemCall.ExecReturn er = GISystemCall.process("/usr/sbin/slibclean", password);
            String normalMsg = er.getNormalMessage();
            if (!er.isOK()) {
                String errorMsg = er.getErrorMessage();
                _logger.log(Level.WARNING, "\nCOMMAND EXECUTION FAILURE :\n" + normalMsg + "\nERROR:\n" + errorMsg);
                StringBuffer errorBuff = new StringBuffer("Command \"/usr/sbin/slibclean\" execution failed");
                if (errorMsg != null && !errorMsg.equals("")) {
                    errorBuff.append(": \n");
                    errorBuff.append(errorMsg.trim() + "\n");
                } else {
                    errorBuff.append(".\n");
                }
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72042), (Object[])new Object[0]), new Object[0]);
            }
            isSuccessful = true;
            _logger.log(Level.INFO, "Output from the command:");
            _logger.log(Level.INFO, normalMsg);
            _logger.log(Level.INFO, "\nSuccessfully executed the command: \n/usr/sbin/slibclean\n");
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "\nEXCEPTION CAUGHT:\n" + t.getMessage());
            _logger.log(Level.WARNING, "Failed to run this command :\n/usr/sbin/slibclean");
            StringBuffer errorBuff = new StringBuffer("Failed to run the command :\n/usr/sbin/slibclean\n");
            if (t.getMessage() != null && !t.getMessage().equals("")) {
                errorBuff.append(t.getMessage() + "\n");
            }
            OPatchAutoException re = new OPatchAutoException(errorBuff.toString(), new Object[0]);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return isSuccessful;
    }

    public static boolean isRacOneDatabaseConfigured(PatchTarget target) {
        RACDatabase racDB;
        boolean isRacOneDB = false;
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<RACDatabase> racDBList = configGraph.getTargets(RACDatabase.class);
        Iterator<RACDatabase> iterator = racDBList.iterator();
        while (iterator.hasNext() && !(isRacOneDB = DBPatchingHelper.isRacOneDatabase(racDB = iterator.next(), target))) {
        }
        return isRacOneDB;
    }

    public static boolean areAllRacOneDatabase(PatchTarget target) {
        RACDatabase racDB;
        boolean isRacOneOnlyDB = true;
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<RACDatabase> racDBs = configGraph.getTargets(RACDatabase.class);
        Iterator<RACDatabase> iterator = racDBs.iterator();
        while (iterator.hasNext() && (isRacOneOnlyDB = DBPatchingHelper.isRacOneDatabase(racDB = iterator.next(), target))) {
        }
        _logger.info("is racone only database::" + isRacOneOnlyDB);
        return isRacOneOnlyDB;
    }

    public static boolean isRacOneDatabase(RACDatabase racDB, PatchTarget target) {
        boolean isRacOneDB = false;
        for (RACDBInstance racDBInst : racDB.getDbInstances()) {
            if (!racDBInst.getRuns_from().getPath().equals(target.getHome(true).getLocation()) || !racDBInst.getHost().getHostName().equals(target.getHost().getHost()) || !racDBInst.getDbRAC().getDatabaseType().equals("racone")) continue;
            isRacOneDB = true;
            break;
        }
        _logger.log(Level.INFO, "Is " + racDB.getDatabaseName() + " RACOne database:" + isRacOneDB);
        return isRacOneDB;
    }

    public static void createPatchDirectory(String homeLoc, String location, Credential credential, String permission) throws OPatchAutoException {
        _logger.info("Permissions: " + permission);
        File patchStorage = new File(location);
        GISystemCall.ExecReturn ret = null;
        String user = null;
        String folderOwner = null;
        String homeOwner = FileUtility.checkFileOwner((File)new File(homeLoc, "oraInst.loc"));
        if (ClusterInformationLoader.isGridHome((String)homeLoc)) {
            user = "root";
        } else {
            user = FileUtility.checkFileOwner((File)new File(homeLoc, "oraInst.loc"));
            if (patchStorage.exists() && !homeOwner.equalsIgnoreCase(folderOwner = FileUtility.checkFileOwner((File)new File(location)))) {
                DBPatchingHelper.changeOwner(homeLoc, credential, patchStorage);
            }
        }
        ret = !patchStorage.exists() ? GISystemCall.process("mkdir -p -m  " + permission + " " + patchStorage.getAbsolutePath(), user, credential) : GISystemCall.process("chmod " + permission + " " + patchStorage.getAbsolutePath(), user, credential);
        if (ret.isOK()) {
            folderOwner = FileUtility.checkFileOwner((File)new File(location));
            if (!homeOwner.equalsIgnoreCase(folderOwner)) {
                DBPatchingHelper.changeOwner(homeLoc, credential, patchStorage);
            }
        } else {
            throw new OPatchAutoException(ret.getErrorMessage(), new Object[0]);
        }
    }

    public static boolean changeOwner(String homeLoc, Credential credential, File fileLocation) throws OPatchAutoException {
        _logger.info("Changing owner for file : " + fileLocation);
        String currentOwner = FileUtility.checkFileOwner((File)fileLocation);
        String user = FileUtility.checkFileOwner((File)new File(homeLoc, "oraInst.loc"));
        String group = OiixEnvironmentOps.ssgetCurrentGroupOfUserux((String)user);
        if (currentOwner.equalsIgnoreCase(user)) {
            return true;
        }
        GISystemCall.ExecReturn ret = GISystemCall.process(" chown -R " + user + ":" + group + " " + fileLocation.getAbsolutePath() + "  > /dev/null", "root", credential);
        if (!ret.isOK()) {
            throw new OPatchAutoException(ret.getErrorMessage(), new Object[0]);
        }
        return true;
    }

    public static boolean isSidbOnlyMode(OPatchAutoOptions options) {
        boolean isSidbOnly = false;
        try {
            if (options != null) {
                OPatchAutoOption sidbOnlyMode = options.getOption(DBProductParameterConstants.SIDB_ONLY.getValue());
                boolean sidb = options.getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
                isSidbOnly = sidbOnlyMode != null ? sidbOnlyMode.isSwitchEnabled() || sidb : sidb;
            }
        }
        catch (OPatchAutoException e) {
            isSidbOnly = false;
        }
        return isSidbOnly;
    }

    public static boolean isOOPPatchingSession(OPatchAutoOptions optAutoOptions) {
        boolean oopEnabled = false;
        if (DBPatchingHelper.isSingleOOPPatchingSession(optAutoOptions) || DBPatchingHelper.isOOPPreparePatchingSession(optAutoOptions) || DBPatchingHelper.isOOPSwitchPatchingSession(optAutoOptions)) {
            oopEnabled = true;
        }
        _logger.info("oopEnabled: " + oopEnabled);
        return oopEnabled;
    }

    public static boolean isOOPPreparePatchingSession(OPatchAutoOptions optAutoOptions) {
        boolean prepareSession = false;
        try {
            prepareSession = optAutoOptions.getOption(DBProductParameterConstants.PREPARE_CLONE_KEY.getValue()).isSwitchEnabled();
        }
        catch (OPatchAutoException e) {
            prepareSession = false;
        }
        _logger.info("prepareSession: " + prepareSession);
        return prepareSession;
    }

    public static boolean isOOPApplySwitchCloneSession(OPatchAutoOptions optAutoOptions) {
        boolean switchSession = false;
        try {
            switchSession = optAutoOptions.getCommand().isApply() && optAutoOptions.getOption(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue()).isSwitchEnabled();
        }
        catch (OPatchAutoException e) {
            switchSession = false;
        }
        _logger.info("Apply switch-clone Session: " + switchSession);
        return switchSession;
    }

    public static boolean isOOPRollbackSwitchCloneSession(OPatchAutoOptions optAutoOptions) {
        boolean switchSession = false;
        try {
            switchSession = optAutoOptions.getCommand().isRollback() && optAutoOptions.getOption(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue()).isSwitchEnabled();
        }
        catch (OPatchAutoException e) {
            switchSession = false;
        }
        _logger.info("Rollback switch-clone Session: " + switchSession);
        return switchSession;
    }

    public static boolean isOOPSwitchPatchingSession(OPatchAutoOptions optAutoOptions) {
        boolean switchSession = false;
        try {
            switchSession = optAutoOptions.getOption(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue()).isSwitchEnabled() || optAutoOptions.getCommand().isRollback() && optAutoOptions.getOption(DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue()).isSwitchEnabled();
        }
        catch (OPatchAutoException e) {
            switchSession = false;
        }
        _logger.info("switchSession: " + switchSession);
        return switchSession;
    }

    public static boolean isOOPSwitchbackSession(OPatchAutoOptions optAutoOptions) {
        boolean switchBackSession = false;
        try {
            switchBackSession = optAutoOptions.getCommand().isRollback() && (optAutoOptions.getOption(DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue()).isSwitchEnabled() || optAutoOptions.getOption(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue()).isSwitchEnabled());
        }
        catch (OPatchAutoException e) {
            switchBackSession = false;
        }
        _logger.info("switchBackSession: " + switchBackSession);
        return switchBackSession;
    }

    public static boolean isSingleOOPPatchingSession(OPatchAutoOptions optAutoOptions) {
        boolean isSingleSession = false;
        try {
            isSingleSession = optAutoOptions.getCommand().isApply() && optAutoOptions.getOption(DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue()).isSwitchEnabled();
        }
        catch (OPatchAutoException e) {
            isSingleSession = false;
        }
        _logger.info("isSingleSession: " + isSingleSession);
        return isSingleSession;
    }

    public static boolean isSingleOOPRollbackPatchingSession(OPatchAutoOptions optAutoOptions) {
        boolean isSingleSession = false;
        try {
            isSingleSession = optAutoOptions.getCommand().isRollback() && optAutoOptions.getOption(DBProductParameterConstants.OUT_OF_PLACE_KEY.getValue()).isSwitchEnabled();
        }
        catch (OPatchAutoException e) {
            isSingleSession = false;
        }
        _logger.info("isSingleSession: " + isSingleSession);
        return isSingleSession;
    }

    public static void updateOOPIncomingPatches(OPatchAutoOptions optAutoOptions, String orig_home, ArrayList<OPatchPatchInfo> patchSuccessList) {
        if (DBPatchingHelper.isSingleOOPPatchingSession(optAutoOptions) || DBPatchingHelper.isOOPPreparePatchingSession(optAutoOptions)) {
            OOPSessionInfoHandler instance = OOPSessionInfoHandler.getInstance();
            String home = instance.getCloneHomePath(orig_home);
            _logger.info("Updating the incoming patches in OOP session info for home " + home);
            OOPSessionInfo oopSessionInfo = instance.getOOPSessionInfo();
            if (oopSessionInfo.getIncomingPatchesOnNodes() == null) {
                OracleHomePatchLevel ohpl = new OracleHomePatchLevel();
                ohpl.addOracleHomePatchLevel(home, patchSuccessList);
                oopSessionInfo.setIncomingPatchesOnNodes(ohpl);
            } else {
                oopSessionInfo.getIncomingPatchesOnNodes().addOracleHomePatchLevel(home, patchSuccessList);
            }
        }
    }

    public static String getPatchLocation(OPatchAutoOptions options) throws OPatchAutoException {
        OPatchAutoOption option = options.getOption("patch.location");
        String patchLoc = option.hasValue() ? option.getValue() : options.getOption("patch.base.directory").getValue();
        return patchLoc;
    }

    public static String getWalletLocation(OPatchAutoOptions options) {
        String walletLoc = "";
        try {
            OPatchAutoOption option = options.getOption("wallet");
            if (option.hasValue()) {
                walletLoc = option.getValue();
            }
        }
        catch (OPatchAutoException e) {
            _logger.info("Wallet location not provided or it could not be found.");
        }
        return walletLoc;
    }

    public static String getDrainTimeout(OPatchAutoOptions options) {
        String drainTimeout = "300";
        try {
            OPatchAutoOption option = options.getOption("drain.timeout");
            if (option.hasValue()) {
                drainTimeout = option.getValue();
            }
        }
        catch (OPatchAutoException e) {
            _logger.info("Drain Timeout not provided or it could not be found.");
        }
        return drainTimeout;
    }

    public static boolean isStandByDatabase(String dbname, OPatchAutoOptions options, String actOn) throws OPatchAutoException {
        boolean isStandByDatabase = false;
        Boolean isSidbOnly = Boolean.parseBoolean(options.getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue());
        SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
        if (isSidbOnly.booleanValue() || actOn.equalsIgnoreCase("SIDatabase")) {
            for (SIDatabase siDatabase : systemInstance.getTargetsOfType(SIDatabase.class)) {
                if (!dbname.equalsIgnoreCase(siDatabase.getDatabaseName()) || !siDatabase.getStandby()) continue;
                isStandByDatabase = true;
            }
        } else {
            for (RACDatabase racDatabase : systemInstance.getTargetsOfType(RACDatabase.class)) {
                if (!dbname.equalsIgnoreCase(racDatabase.getDatabaseName()) || !racDatabase.getStandby()) continue;
                isStandByDatabase = true;
            }
        }
        _logger.info("Is " + dbname + " standby database : " + isStandByDatabase);
        return isStandByDatabase;
    }

    public static Credential getOwnerOrCurrentUserCred(PatchTarget target, CredentialManager credentialMgr) {
        String host = target.getHost().getHost();
        String owner = target.getHome().getOwner();
        String currentUser = System.getProperty("user.name");
        return DBPatchingHelper.getOwnerOrCurrentUserCred(host, owner, currentUser, credentialMgr);
    }

    public static Credential getOwnerOrCurrentUserCred(String host, String owner, CredentialManager credentialMgr) {
        String currentUser = System.getProperty("user.name");
        return DBPatchingHelper.getOwnerOrCurrentUserCred(host, owner, currentUser, credentialMgr);
    }

    public static Credential getOwnerOrCurrentUserCred(String host, String owner, String currentUser, CredentialManager credentialMgr) {
        Credential credential = null;
        if (credentialMgr == null) {
            return null;
        }
        if (null != currentUser && "root".equals(currentUser)) {
            return null;
        }
        try {
            if (null != owner && !"root".equals(owner)) {
                credential = credentialMgr.getCredential(host, null, owner);
            }
            if (credential == null) {
                credential = credentialMgr.getCredential(host, null, currentUser);
            }
        }
        catch (OPatchAutoException e) {
            _logger.severe("No credential available for host " + host);
        }
        return credential;
    }

    public static GISystemCall.ExecReturn process(String command, String username, PatchTarget target, CredentialManager credentialMgr, Map<String, String> envVarList) {
        GISystemCall.ExecReturn er = null;
        String host = target.getHost().getHost();
        String currentUser = System.getProperty("user.name");
        if (credentialMgr == null) {
            byte[] password = null;
            er = GISystemCall.process(command, username, password, envVarList);
        } else {
            Credential cred = DBPatchingHelper.getOwnerOrCurrentUserCred(host, username, currentUser, credentialMgr);
            er = GISystemCall.process(command, username, cred, envVarList);
        }
        return er;
    }

    public static String getStepOwner(ExecutionStep step) {
        String owner = "";
        owner = step.getStepProperties() != null ? (!"root".equals(step.getUser().getValue()) ? step.getUser().getValue() : "root") : step.getUser().getValue();
        return owner;
    }

    public static String getHomeOwner(String oracleHome) throws OPatchAutoException {
        String homeOwner = FileUtility.checkFileOwner((File)new File(oracleHome, "oraInst.loc"));
        return homeOwner;
    }

    public static boolean compareFilePath(String src, String dest) {
        _logger.info("src: " + src);
        _logger.info("dest: " + dest);
        return FileUtils.getFile((String)src).equals(FileUtils.getFile((String)dest));
    }

    public static String getHostNameWithoutDomain(String hostName) {
        _logger.info("requestedHostName: " + hostName);
        if (hostName.indexOf(".") != -1) {
            hostName = hostName.substring(0, hostName.indexOf("."));
        }
        _logger.info("formattedHostName: " + hostName.toLowerCase());
        return hostName.toLowerCase();
    }

    public static String getLocalHost() {
        return OPatchAutoHelper.getOPatchAutoHost().toLowerCase();
    }

    public static boolean skipDeployInitSession(OPatchAutoOptions options, Goal goal) {
        boolean skipAction = false;
        try {
            OPatchAutoOption deployOnlyOption = options.getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue());
            if (Boolean.valueOf(deployOnlyOption.getValue()).booleanValue() && goal.equals(InitPhase.Goal.init)) {
                skipAction = true;
            }
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        return skipAction;
    }

    public static String[] fetchPreInitiatedNodes(String homePath, String[] clusterNodes, String crshome, String walletLoc, char[] walletPwd) {
        return OUIDriver.fetchRemoteNodeData((String)homePath, (String[])clusterNodes, (String)crshome, (String)"check", (String)walletLoc, (char[])walletPwd);
    }

    public static String[] deleteRemoteStateFiles(String homePath, String[] clusterNodes, String crshome, String walletLoc, char[] walletPwd) {
        return OUIDriver.fetchRemoteNodeData((String)homePath, (String[])clusterNodes, (String)crshome, (String)"delete", (String)walletLoc, (char[])walletPwd);
    }

    public static void deleteZeroByteFilesAndEmptyDirectories(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            System.out.println("Directory does not exist: " + directoryPath);
            return;
        }
        if (!directory.isDirectory()) {
            System.out.println("Path is not a directory: " + directoryPath);
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    DBPatchingHelper.deleteZeroByteFilesAndEmptyDirectories(file.getAbsolutePath());
                    continue;
                }
                if (file.length() != 0L || !DBPatchingHelper.shouldDeleteFile(file)) continue;
                System.out.println("Deleting zero-byte file: " + file.getAbsolutePath());
                file.delete();
            }
            if (directory.listFiles().length == 0) {
                System.out.println("Deleting empty directory: " + directory.getAbsolutePath());
                directory.delete();
            }
        }
    }

    private static boolean shouldDeleteFile(File file) {
        String fileName = file.getName();
        if (fileName.startsWith("crsSessionInit_")) {
            return false;
        }
        return fileName.endsWith(".lck") || fileName.equals("null.tmp") || fileName.equals("ApplyInstructions.txt") || fileName.equals("RollbackInstructions.txt") || fileName.equals("log.txt");
    }

    public static HostData checkCRSStatusOnAllNodes(String homePath, String[] clusterNodes, String crshome, String walletLoc, char[] walletPwd) {
        return OUIDriver.fetchRemoteHostData((String)homePath, (String[])clusterNodes, (String)crshome, (String)"crs_status", (String)walletLoc, (char[])walletPwd);
    }

    public static boolean isRHPServerRunning() {
        boolean isRunning = false;
        try {
            GridHomeFactory ghFact = GridHomeFactory.getInstance();
            isRunning = ghFact.getGridHomeServer().isRunning();
            _logger.info("RHP server running : " + isRunning);
        }
        catch (NotExistsException e) {
            _logger.info("RHP server is not configured/running");
        }
        catch (SoftwareModuleException e) {
            e.printStackTrace();
        }
        return isRunning;
    }

    public static boolean isRHPClientRunning() {
        boolean isRunning = false;
        try {
            GridHomeFactory ghFact = GridHomeFactory.getInstance();
            isRunning = ghFact.getGridHomeClient().isRunning();
            _logger.info("RHP client running : " + isRunning);
        }
        catch (NotExistsException e) {
            _logger.info("RHP client is not configured/running");
        }
        catch (SoftwareModuleException e) {
            e.printStackTrace();
        }
        return isRunning;
    }

    public static boolean isRHPServerInstanceUp(String nodename) {
        boolean isRunning = false;
        try {
            GridHomeFactory ghFact = GridHomeFactory.getInstance();
            List ghsNodes = ghFact.getGridHomeServer().crsResource().fetchRunningNodes();
            if (ghsNodes.size() > 0 && ((Node)ghsNodes.get(0)).getName().equals(nodename)) {
                isRunning = true;
            }
            _logger.info("RHP server running : " + isRunning);
        }
        catch (NotExistsException e) {
            _logger.info("RHP server is not configured/running");
        }
        catch (SoftwareModuleException e) {
            e.printStackTrace();
        }
        catch (CRSException e) {
            e.printStackTrace();
        }
        catch (NodeException e) {
            e.printStackTrace();
        }
        return isRunning;
    }

    public static boolean isRHPClientInstanceUp(String nodename) {
        boolean isRunning = false;
        try {
            GridHomeFactory ghFact = GridHomeFactory.getInstance();
            List ghcNodes = ghFact.getGridHomeClient().crsResource().fetchRunningNodes();
            if (ghcNodes.size() > 0 && ((Node)ghcNodes.get(0)).getName().equals(nodename)) {
                isRunning = true;
            }
            _logger.info("RHP client running : " + isRunning);
        }
        catch (NotExistsException e) {
            _logger.info("RHP client is not configured/running");
        }
        catch (SoftwareModuleException e) {
            e.printStackTrace();
        }
        catch (CRSException e) {
            e.printStackTrace();
        }
        catch (NodeException e) {
            e.printStackTrace();
        }
        return isRunning;
    }

    public static boolean isQOSMServerRunning() {
        boolean isRunning = false;
        try {
            OC4JFactory oc4jFac = OC4JFactory.getInstance();
            isRunning = oc4jFac.getOC4J(true).isRunning();
            _logger.info("QOSM server running : " + isRunning);
        }
        catch (NotExistsException e) {
            _logger.info("QOSM server is not configured/running");
        }
        catch (SoftwareModuleException e) {
            e.printStackTrace();
        }
        return isRunning;
    }

    public static String getGIMRHomePath() {
        try {
            String version = PatchPlanner.getInstance().getPrimaryPatchVersion();
            if (version == null || Integer.parseInt(version.substring(0, 2)) < 20 || Integer.parseInt(version.substring(0, 2)) > 22) {
                _logger.info("GIMR home will not be detected for versions less than 20 and versions 23c and above.");
                return null;
            }
            String crsHome = null;
            String gimrHome = null;
            ArrayList homes = OUIDriver.getHomesList();
            for (Object home : homes) {
                String[] homeInfo = (String[])home;
                String homePath = homeInfo[0];
                if (!"IS_CRS_HOME".equals(homeInfo[1])) continue;
                crsHome = homePath;
                _logger.log(Level.INFO, "crs home detected at " + crsHome);
            }
            if (crsHome != null) {
                _logger.log(Level.INFO, "SRVCTL utility home path " + crsHome);
                SRVCTLUtil util = new SRVCTLUtil(crsHome);
                gimrHome = util.getMgmtDBHome();
                _logger.log(Level.INFO, "GIMR configuration detected at " + gimrHome);
            }
            return gimrHome;
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "GIMR configuration not detected");
            return null;
        }
    }

    public static boolean isRemoteHost(Host host) {
        boolean isRemoteHost = false;
        String localHostName = null;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
            if (localHostName != null && localHostName.indexOf(".") != -1) {
                localHostName = localHostName.substring(0, localHostName.indexOf("."));
            }
        }
        catch (IOException e) {
            _logger.info("Unable to detect local host information due to " + e.getMessage());
        }
        _logger.info("Local Hostname from InetAddress: " + localHostName);
        if (null != localHostName && !host.getHostName().equalsIgnoreCase(localHostName)) {
            _logger.info("Node identified as Remote: " + host.getHostName());
            isRemoteHost = true;
        }
        return isRemoteHost;
    }

    public static OOPSessionCookie.OOPOperationType getOperationType(OPatchAutoOptions options) {
        OOPSessionCookie.OOPOperationType operationType = null;
        operationType = DBPatchingHelper.isSingleOOPPatchingSession(options) ? OOPSessionCookie.OOPOperationType.APPLY : (DBPatchingHelper.isOOPPreparePatchingSession(options) ? OOPSessionCookie.OOPOperationType.PREPARE : (DBPatchingHelper.isOOPSwitchPatchingSession(options) && options.getCommand().isApply() ? OOPSessionCookie.OOPOperationType.SWITCH : OOPSessionCookie.OOPOperationType.ROLLBACK));
        _logger.info("operationType: " + operationType.name());
        return operationType;
    }

    public static void updateSessionDataWithGIStatus(OPatchAutoOptions options) {
        RemoteNodes remoteObj;
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<Host> hostModelList = configGraph.getTargets(Host.class);
        ArrayList remoteNodes = new ArrayList();
        ArrayList<String> runningHosts = new ArrayList<String>();
        boolean isLocalCRSUp = false;
        String crsHome = SessionData.getInstance().getCrsHome();
        String localhost = "";
        for (Host host : hostModelList) {
            if (!DBPatchingHelper.isRemoteHost(host)) {
                localhost = host.getHostName();
                continue;
            }
            remoteNodes.add(host.getHostName());
        }
        _logger.info("Checking the CRS status across the entire cluster");
        String walletLoc = DBPatchingHelper.getWalletLocation(options);
        char[] walletPwd = null;
        HostData hostData = DBPatchingHelper.checkCRSStatusOnAllNodes(crsHome, remoteNodes.toArray(new String[0]), crsHome, walletLoc, walletPwd);
        isLocalCRSUp = hostData.isLocalCRSUp();
        if (isLocalCRSUp) {
            runningHosts.add(localhost);
        } else {
            _logger.info("CRS is NOT running on the local node: " + localhost);
        }
        Map remoteNodesStatus = hostData.getRemoteNodesStatus();
        if (null != remoteNodes && remoteNodes.size() > 0) {
            for (String clusterNode : remoteNodes) {
                if (!remoteNodesStatus.containsKey(clusterNode)) {
                    _logger.info("Note: CRS status not available in the status map for the node " + clusterNode);
                    continue;
                }
                if (((ClusterInformationLoader.ClusterStatus)remoteNodesStatus.get(clusterNode)).ordinal() == ClusterInformationLoader.ClusterStatus.CRS_STATUS_UNKNOWN.ordinal()) {
                    _logger.info("Note: Unable to check CRS status on remote node " + clusterNode);
                    continue;
                }
                if (((ClusterInformationLoader.ClusterStatus)remoteNodesStatus.get(clusterNode)).ordinal() == ClusterInformationLoader.ClusterStatus.CRS_RUNNING.ordinal()) {
                    _logger.info("CRS is running on the remote node: " + clusterNode);
                    runningHosts.add(clusterNode);
                    continue;
                }
                if (((ClusterInformationLoader.ClusterStatus)remoteNodesStatus.get(clusterNode)).ordinal() != ClusterInformationLoader.ClusterStatus.CRS_NOT_RUNNING.ordinal()) continue;
                _logger.info("CRS is NOT running on the remote node: " + clusterNode);
            }
        }
        ClusterInformationLoader.CrsType crsType = ClusterInformationLoader.getInstance().getCRSType();
        if (remoteNodes.size() < 1 && !isLocalCRSUp && crsType.equals((Object)ClusterInformationLoader.CrsType.CRS) && (remoteObj = RemoteNodes.getSerializedInstance((String)crsHome)) != null) {
            remoteNodes = remoteObj.getRemoteNodes();
        }
        SessionData.getInstance().setRemoteList(remoteNodes);
        SessionData.getInstance().setLocalCRSStatus(isLocalCRSUp);
        SessionData.getInstance().setRunningHosts(runningHosts);
    }

    public static boolean isCRSPatchingSkipped(Set<PatchTarget> patchTargets, boolean isRHPPatching) {
        boolean isCRSPatchingSkipped = false;
        for (PatchTarget target : patchTargets) {
            if (!target.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) || !PatchingSessionInfoStore.getInstance().skipPatchTarget(target) && !isRHPPatching) continue;
            isCRSPatchingSkipped = true;
            break;
        }
        _logger.info("CRS patching skipped isCRSPatchingSkipped : " + isCRSPatchingSkipped);
        return isCRSPatchingSkipped;
    }

    public static boolean hasCRSPatching(Set<PatchTarget> patchTargets) {
        boolean hasCRSPatching = false;
        for (PatchTarget target : patchTargets) {
            if (!target.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) continue;
            hasCRSPatching = true;
            break;
        }
        return hasCRSPatching;
    }

    public static boolean isMultiNodeEnv(Set<PatchTarget> patchTargets) {
        boolean multi_node = false;
        for (PatchTarget target : patchTargets) {
            if (!target.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) && !target.getType().equals(DBProductTypes.PRODUCT_TYPE_RAC.getValue()) && !target.getType().equals(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue())) continue;
            multi_node = true;
            break;
        }
        _logger.info("Identified as multi-node environment for the selected topology : " + multi_node);
        return multi_node;
    }

    public static boolean createLocalDirectory(String dirPath, String fileOwner, String perms) {
        Credential credential;
        if (new File(dirPath).exists()) {
            return true;
        }
        String mkdirCmd = "mkdir -p -m " + perms + " " + dirPath;
        GISystemCall.ExecReturn er = GISystemCall.process(mkdirCmd, fileOwner, credential = null);
        if (!er.isOK()) {
            _logger.log(Level.WARNING, er.getErrorMessage());
        }
        return er.isOK();
    }

    public static void createActiveLock(boolean outofplace) {
        try {
            String opatchAutoHome = OPatchAutoHelper.getOPatchAutoHome();
            String host = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
            String owner = DBPatchingHelper.getHomeOwner(opatchAutoHome);
            String filename = outofplace ? "active_oop.lock" : "active_ip.lock";
            String opatchauto_storage = DBPatchingHelper.getOPatchAutoStorage(opatchAutoHome, host);
            String active_lock = opatchauto_storage + File.separator + filename;
            Credential credential = null;
            if (!outofplace && !DBPatchingHelper.createLocalDirectory(opatchauto_storage, owner, "750")) {
                _logger.warning("Unable to create active_ip lock");
                return;
            }
            DBPatchingUtil.createNewFile(active_lock, owner, credential);
            byte[] pwd = null;
            File lock = new File(active_lock);
            IOUtils.chmodFile(lock, "640", pwd);
        }
        catch (OPatchAutoException e) {
            _logger.info("Unable to create active lock");
        }
    }

    public static void deleteLocalActiveLock(String baseHome, String localhost, boolean oop) {
        String filename = oop ? "active_oop.lock" : "active_ip.lock";
        File active_lock = new File(DBPatchingHelper.getOPatchAutoStorage(baseHome, localhost) + File.separator + filename);
        if (active_lock.exists()) {
            _logger.info("Deleting lock " + active_lock.getPath() + " ...");
            boolean status = active_lock.delete();
            if (!status) {
                _logger.info("Unable to delete the above lock file.");
            } else {
                _logger.info("Deleted the above lock file.");
            }
        } else {
            _logger.info(active_lock.getPath() + " does not exist.");
        }
    }

    public static void deleteRemoteActiveLocks(HashMap<String, String> parallel_sessions, String localhost, boolean oop) {
        String filename = oop ? "active_oop.lock" : "active_ip.lock";
        for (String remote_host : parallel_sessions.keySet()) {
            if (localhost.equalsIgnoreCase(remote_host)) continue;
            String home = parallel_sessions.get(remote_host);
            try {
                String owner = DBPatchingHelper.getHomeOwner(home);
                String file = DBPatchingHelper.getOPatchAutoStorage(home, remote_host) + File.separator + filename;
                DBPatchingHelper.deleteRemoteFile(remote_host, owner, file);
            }
            catch (OPatchAutoException e) {
                _logger.info("Unable to delete remote lock");
            }
        }
    }

    public static String getOPatchAutoStorage(String home, String host) {
        String oop_storage = home + File.separator + ".opatchauto_storage" + File.separator + host;
        return oop_storage;
    }

    public static boolean appendLineToLocalFile(String owner, String file, String line) {
        Credential cred = null;
        String command = "echo " + line + " >> " + file;
        GISystemCall.ExecReturn ret = GISystemCall.process(command, owner, cred);
        if (ret.isOK()) {
            _logger.info("Entered " + line + " into file " + file + " on localhost");
            return true;
        }
        return false;
    }

    public static String readFirstLineFromLocalFile(String owner, String file) {
        Credential cred = null;
        String command = "head -n 1 " + file;
        GISystemCall.ExecReturn ret = GISystemCall.process(command, owner, cred);
        if (ret.isOK()) {
            String line = ret.getNormalMessage().trim();
            _logger.info("First line from " + file + " is : " + line);
            return line;
        }
        return "";
    }

    public static String readFirstLineFromRemoteFile(String remote_host, String owner, String file) {
        Credential cred = null;
        String command = "ssh " + owner + "@" + remote_host + " \"head -n 1 " + file + " \"";
        GISystemCall.ExecReturn ret = GISystemCall.process(command, owner, cred);
        if (ret.isOK()) {
            String line = ret.getNormalMessage().trim();
            _logger.info("First line from " + file + " on remote host " + remote_host + " is : " + line);
            return line;
        }
        return "";
    }

    public static boolean createFileOnRemote(String remote_host, String owner, String file) {
        Credential cred = null;
        String remote_command = "ssh " + owner + "@" + remote_host + " \"touch " + file + " \"";
        GISystemCall.ExecReturn ret = GISystemCall.process(remote_command, owner, cred);
        if (ret.isOK()) {
            _logger.info("File " + file + " created on host " + remote_host);
            return true;
        }
        return false;
    }

    public static boolean appendLineToFileOnRemote(String remote_host, String owner, String file, String line) {
        Credential cred = null;
        String remote_command = "ssh " + owner + "@" + remote_host + " \"echo " + line + " >> " + file + " \"";
        GISystemCall.ExecReturn ret = GISystemCall.process(remote_command, owner, cred);
        if (ret.isOK()) {
            _logger.info("Entered " + line + " into remote file " + file + " on " + remote_host);
            return true;
        }
        return false;
    }

    public static boolean remoteFileExists(String remote_host, String owner, String file) {
        Credential cred = null;
        String remote_command = "ssh " + owner + "@" + remote_host + " \"ls " + file + " \"";
        GISystemCall.ExecReturn ret = GISystemCall.process(remote_command, owner, cred);
        if (ret.isOK()) {
            _logger.info("File " + file + " found on host " + remote_host);
            return true;
        }
        return false;
    }

    public static boolean deleteRemoteFile(String remote_host, String owner, String file) {
        Credential cred = null;
        String remote_command = "ssh " + owner + "@" + remote_host + " \"rm -f " + file + " \"";
        GISystemCall.ExecReturn ret = GISystemCall.process(remote_command, owner, cred);
        if (ret.isOK()) {
            _logger.info("Deleted " + file + " on host " + remote_host);
            return true;
        }
        return false;
    }

    public static boolean copyRemoteFileToLocal(String remote_host, String owner, String source, String dest) {
        Credential cred = null;
        String remote_command = "scp " + owner + "@" + remote_host + ":" + source + " " + dest;
        GISystemCall.ExecReturn ret = GISystemCall.process(remote_command, owner, cred);
        if (ret.isOK()) {
            _logger.info("Copied " + source + " from " + remote_host + " to " + dest);
            return true;
        }
        return false;
    }

    public static void copyLatestPatchScripts(String patchId, String BASE_PATH) throws Exception {
        String PATCH_STORAGE_DIR = ".patch_storage";
        String TARGET_ROOT = "opatchautocfg/db/dbtmp";
        Path storagePath = Paths.get(BASE_PATH, PATCH_STORAGE_DIR);
        SimpleDateFormat sdf = new SimpleDateFormat("MMM_dd_yyyy_HH_mm_ss", Locale.ENGLISH);
        File latestDir = null;
        Date latestDate = null;
        File storageDir = storagePath.toFile();
        if (storageDir.exists() && storageDir.isDirectory()) {
            File[] dirs = storageDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            for (int i = 0; i < dirs.length; ++i) {
                String[] parts;
                File dir = dirs[i];
                String dirName = dir.getName();
                if (!dirName.startsWith(patchId + "_") || (parts = dirName.split(patchId + "_")).length != 2) continue;
                String timestamp = parts[1];
                try {
                    Date date = sdf.parse(timestamp);
                    if (latestDate != null && !date.after(latestDate)) continue;
                    latestDate = date;
                    latestDir = dir;
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (latestDir != null) {
            Path sourcePre = latestDir.toPath().resolve("original_patch/custom/scripts/prepatch.sh");
            Path sourcePost = latestDir.toPath().resolve("original_patch/custom/scripts/postpatch.sh");
            Path targetDir = Paths.get(BASE_PATH, TARGET_ROOT, patchId, "custom/scripts");
            if (Files.exists(sourcePre, new LinkOption[0]) || Files.exists(sourcePost, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            if (Files.exists(sourcePre, new LinkOption[0])) {
                Files.copy(sourcePre, targetDir.resolve("prepatch.sh"), StandardCopyOption.REPLACE_EXISTING);
                _logger.info("Copied prepatch.sh for patch ID " + patchId);
            }
            if (Files.exists(sourcePost, new LinkOption[0])) {
                Files.copy(sourcePost, targetDir.resolve("postpatch.sh"), StandardCopyOption.REPLACE_EXISTING);
                _logger.info("Copied postpatch.sh for patch ID " + patchId);
            }
        }
    }

    public static boolean hasRHPPatching(Set<PatchTarget> patchTargets, PatchSession session) {
        boolean hasRHPPatching = false;
        for (PatchTarget target : patchTargets) {
            if (!target.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) continue;
            String home_loc = target.getHome().getLocation();
            if (SessionData.getInstance().getAnalyzedPatchList(home_loc) == null || SessionData.getInstance().getAnalyzedPatchList(home_loc).isEmpty()) continue;
            hasRHPPatching = DBPatchingHelper.isRHPPatchingSession(target.getHome().getLocation(), session, SessionData.getInstance().getAnalyzedPatchList(target.getHome().getLocation()));
            break;
        }
        return hasRHPPatching;
    }

    public static boolean isFirstNodeGIPatching() {
        return SessionData.getInstance().getInitiatedHosts() == null || SessionData.getInstance().getInitiatedHosts().length < 1;
    }

    public static HashMap<String, String> getIPParallelSessionInfo(Set<PatchTarget> patchTargetList, String localhost, String baseHome) {
        HashMap<String, String> parallel_sessions = new HashMap<String, String>();
        parallel_sessions.put(localhost, baseHome);
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<Host> dbModelHostList = configGraph.getTargets(Host.class);
        block0: for (Host host : dbModelHostList) {
            String remote_host = host.getHostName();
            if (localhost.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(remote_host))) continue;
            for (PatchTarget target : patchTargetList) {
                String home = target.getHome().getLocation();
                if (!DBPatchingHelper.isIPSessionActive(remote_host, home)) continue;
                parallel_sessions.put(remote_host, home);
                continue block0;
            }
        }
        _logger.info("Active sessions in progress on the following hosts : " + parallel_sessions.keySet());
        return parallel_sessions;
    }

    private static boolean isIPSessionActive(String remote_host, String home) {
        String owner = FileUtility.checkFileOwner((File)new File(home, "oraInst.loc"));
        String file = DBPatchingHelper.getOPatchAutoStorage(home, remote_host) + File.separator + "active_ip.lock";
        return DBPatchingHelper.remoteFileExists(remote_host, owner, file);
    }

    public static void updateRuntimePatchMap(Set<PatchTarget> patchTargetList, String localhost) {
        for (PatchTarget patchTarget : patchTargetList) {
            HashMap<String, String> hostPatchData = new HashMap<String, String>();
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            List<Host> hostList = configGraph.getTargets(Host.class);
            Object cred = null;
            List<RACDatabase> racDBs = configGraph.getTargets(RACDatabase.class);
            HashSet<String> hosts = new HashSet<String>();
            ArrayList<ExecutionCommand> commandList = new ArrayList<ExecutionCommand>();
            String home = patchTarget.getHome(true).getLocation();
            String ohOwner = FileUtility.checkFileOwner((File)new File(home, "oraInst.loc"));
            if (patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) {
                for (Host host : hostList) {
                    if (!DBPatchingHelper.isRemoteHost(host)) continue;
                    String hostname = host.getHostName();
                    StringBuilder remoteCommand = new StringBuilder();
                    remoteCommand.append("ssh " + ohOwner + "@" + hostname + " \"");
                    remoteCommand.append(home);
                    remoteCommand.append(File.separator + "OPatch" + File.separator + "opatch lspatches");
                    remoteCommand.append(" -oh ").append(home);
                    remoteCommand.append("\"");
                    _logger.info("remote command: " + remoteCommand.toString());
                    ExecutionCommand ec = new ExecutionCommand(hostname, remoteCommand.toString());
                    commandList.add(ec);
                }
            } else {
                for (RACDatabase racDB : racDBs) {
                    _logger.info("racDB.getOracleHome(): " + racDB.getOracleHome());
                    _logger.info("racDB.getDatabaseName(): " + racDB.getDatabaseName());
                    if (!DBPatchingHelper.compareFilePath(racDB.getOracleHome(), patchTarget.getHome(true).getLocation())) continue;
                    List instances = racDB.getDbInstances();
                    for (RACDBInstance inst : instances) {
                        String hostname = inst.getHost().getHostName();
                        if (patchTarget.getHost().getHost().equals(hostname) || hosts.contains(hostname)) continue;
                        StringBuilder remoteCommand = new StringBuilder();
                        remoteCommand.append("ssh " + ohOwner + "@" + hostname + " \"");
                        remoteCommand.append(home);
                        remoteCommand.append(File.separator + "OPatch" + File.separator + "opatch lspatches");
                        remoteCommand.append(" -oh ").append(home);
                        remoteCommand.append("\"");
                        _logger.info("remote command: " + remoteCommand.toString());
                        ExecutionCommand ec = new ExecutionCommand(hostname, remoteCommand.toString());
                        commandList.add(ec);
                        hosts.add(hostname);
                    }
                }
            }
            ParallelExecution pe = new ParallelExecution(commandList, ohOwner);
            pe.execute();
            for (CommandExecutionThread cet : pe.getResults()) {
                GISystemCall.ExecReturn er = cet.er;
                int exit_code = er.getReturnCode();
                _logger.info("Lspatches exit code is " + exit_code);
                if (exit_code == 0) {
                    String patchList = DBPatchingHelper.extractPatchIDs(cet.er.getNormalMessage().trim());
                    _logger.info("PatchList on home " + home + " of host " + cet.host + " : " + patchList);
                    hostPatchData.put(cet.host, patchList);
                    continue;
                }
                _logger.log(Level.INFO, "\nCOMMAND EXECUTION FAILURE :\n" + er.getNormalMessage() + "\nERROR:\n" + er.getErrorMessage());
            }
            SessionData.getInstance().addToHomePatchDataMap(patchTarget.getHome(true).getLocation(), hostPatchData);
        }
    }

    public static String extractPatchIDs(String output) {
        String patchIDList = null;
        if (output != null && !output.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String[] lines = output.split("\\r?\\n");
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].indexOf(";") == -1 || !Character.isDigit(lines[i].charAt(0))) continue;
                sb.append(lines[i].substring(0, lines[i].indexOf(";"))).append(",");
            }
            if (sb.toString().endsWith(",")) {
                patchIDList = sb.toString().substring(0, sb.toString().length() - 1);
            }
            return patchIDList;
        }
        return null;
    }

    public static enum NodeOfPatching {
        FIRST,
        MIDDLE,
        LAST;

    }
}

