/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.AbstractTopologyBuilder;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb.SDBOptionsAuthorizer;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb.SDBSysInstComposer;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler.DataGuardAssembler;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler.ShardGroupAssembler;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler.ShardSpaceAssembler;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator.CRSHomeFormulator;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator.HASHomeFormulator;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator.RACHomeFormulator;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator.SIDBHomeFormulator;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.DataGuard;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardGroup;
import dbmodel.db_crs.ShardSpace;
import dbmodel.db_crs.ShardedDatabase;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class SDBTopologyBuilder
extends AbstractTopologyBuilder {
    private boolean isShardedDatabase = false;
    private List<String> dataGuardOptions = null;
    private List<String> shardGroupOptions = null;
    private List<String> shardSpaceOptions = null;
    private String parentid = null;
    private List<DataGuard> dataGuards = null;
    private List<ShardGroup> shardGroups = null;
    private List<ShardSpace> shardSpaces = null;
    private List<String> oggTargetList = null;
    private SystemInstance systemInstance = null;
    private Map<String, HostImpl> currentHostMap = new HashMap<String, HostImpl>();
    private Map<String, String> targetMap = new HashMap<String, String>();

    public SDBTopologyBuilder(OPatchAutoCommand command, OPatchAutoOptions options) {
        super(command, options);
    }

    @Override
    public void createSystemInstance() throws OPatchAutoException {
        OPatchAutoOption topologyFileOption = this.options.getOption("topology");
        this.isShardedDatabase = Boolean.parseBoolean(this.options.getOption(DBProductParameterConstants.SDB.getValue()).getValue());
        if (this.options.getOption(DBProductParameterConstants.DG.getValue()) != null) {
            this.dataGuardOptions = PatchActionUtil.convertStringToList(this.options.getOption(DBProductParameterConstants.DG.getValue()).getValue());
        }
        if (this.options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()) != null) {
            this.shardGroupOptions = PatchActionUtil.convertStringToList(this.options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue());
        }
        if (this.options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()) != null) {
            this.shardSpaceOptions = PatchActionUtil.convertStringToList(this.options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue());
        }
        if (this.options.getOption(DBProductParameterConstants.PARENTID.getValue()) != null) {
            this.parentid = this.options.getOption(DBProductParameterConstants.PARENTID.getValue()).getValue();
        }
        File systemInstanceFile = null;
        this.logger.finer("command.isResumed() : " + this.command.isResumed());
        if (this.command.isResumed()) {
            File file = this.readSystemInstanceXML();
            if (file.exists()) {
                try {
                    systemInstanceFile = file;
                    SystemInstance topologySystemInstance = new SystemInstance();
                    topologySystemInstance = topologySystemInstance.readFile(systemInstanceFile);
                    PatchPlanner.getInstance().setSystemInstance(topologySystemInstance);
                }
                catch (FileNotFoundException e) {
                    this.logger.log(Level.WARNING, "File not found : " + file.getAbsolutePath() + "   " + e.getMessage());
                    throw new OPatchAutoException(Integer.toString(72035), new Object[]{245 + e.getMessage()});
                }
            } else {
                this.logger.log(Level.WARNING, "File not found " + file.getAbsolutePath());
                throw new OPatchAutoException(Integer.toString(72035), 245);
            }
            this.logger.finer("System instance file is : " + systemInstanceFile);
        } else {
            if (this.isShardedDatabase) {
                try {
                    File configFile = this.createSystemInstanceXML();
                    SDBSysInstComposer sdbSysInstComposer = new SDBSysInstComposer(this.options, configFile);
                    sdbSysInstComposer.createShardedSystemInstance();
                }
                catch (OPatchAutoException ex) {
                    throw new OPatchAutoException(ex.getMessage(), new Object[0]);
                }
            }
            if (this.dataGuardOptions != null || this.shardGroupOptions != null || this.shardSpaceOptions != null) {
                File file;
                if (topologyFileOption != null && topologyFileOption.getValue() != null) {
                    file = new File(topologyFileOption.getValue());
                    if (!file.exists()) {
                        throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72097), (Object[])new Object[]{file.getAbsolutePath()}), new Object[0]);
                    }
                } else {
                    throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72098), (Object[])new Object[0]), new Object[0]);
                }
                systemInstanceFile = file;
                SystemInstance topologySystemInstance = new SystemInstance();
                if (systemInstanceFile.exists()) {
                    try {
                        topologySystemInstance = topologySystemInstance.readFile(systemInstanceFile);
                        PatchPlanner.getInstance().setSystemInstance(topologySystemInstance);
                        ShardedDatabase shardedDatabase = (ShardedDatabase)topologySystemInstance.getTargetsOfType(ShardedDatabase.class).get(0);
                        List shardspaces = shardedDatabase.getShardSpaces();
                        if (this.dataGuardOptions != null) {
                            this.dataGuards = new ArrayList<DataGuard>();
                            if (null != shardspaces) {
                                for (ShardSpace shardSpace : shardspaces) {
                                    this.dataGuards.addAll(shardSpace.getDataGuards());
                                }
                            }
                        } else if (this.shardGroupOptions != null) {
                            this.shardGroups = new ArrayList<ShardGroup>();
                            if (null != shardspaces) {
                                for (ShardSpace shardSpace : shardspaces) {
                                    this.shardGroups.addAll(shardSpace.getShardGroups());
                                }
                            }
                        } else if (this.shardSpaceOptions != null) {
                            this.shardSpaces = new ArrayList<ShardSpace>();
                            this.shardSpaces.addAll(shardspaces);
                        }
                    }
                    catch (Exception e) {
                        this.logger.throwing("Detailed Execption while creating SystemInstance : ", e.getMessage(), e);
                        this.logger.log(Level.SEVERE, e.getMessage());
                        throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)e.getMessage(), (Object[])new Object[]{72063}), new Object[0]);
                    }
                }
                this.logger.finer("System instance file is : " + systemInstanceFile);
            }
        }
    }

    @Override
    public List<ValidationResult> validate(SystemInstance systemInstance, ConfigGraph configGraph) {
        return new ArrayList<ValidationResult>();
    }

    @Override
    public void buildTopology(CredentialManager credentialManager) throws OPatchAutoException {
        ArrayList<Host> hostList;
        this.systemInstance = PatchPlanner.getInstance().getSystemInstance();
        List<Object> failedValidations = new ArrayList();
        if (this.isShardedDatabase) {
            failedValidations = new SDBOptionsAuthorizer().validate(this.systemInstance, this.options);
        }
        if (failedValidations.isEmpty()) {
            this.logger.log(Level.FINE, "Topology creation started...");
            this.credentialManager = credentialManager;
            hostList = new ArrayList<Host>();
            ArrayList<AbstractBaseTarget> dbShardingTargets = new ArrayList<AbstractBaseTarget>();
            ArrayList<AbstractBaseTarget> hasShardingTargets = new ArrayList<AbstractBaseTarget>();
            List racDatabases = this.systemInstance.getTargetsOfType(RACDatabase.class);
            List siDatabases = this.systemInstance.getTargetsOfType(SIDatabase.class);
            List cRSClusters = this.systemInstance.getTargetsOfType(CRSCluster.class);
            List hases = this.systemInstance.getTargetsOfType(HAS.class);
            dbShardingTargets.addAll(siDatabases);
            dbShardingTargets.addAll(racDatabases);
            hasShardingTargets.addAll(hases);
            hasShardingTargets.addAll(cRSClusters);
            boolean isOgg = PatchActionUtil.isOgg(this.systemInstance);
            String shardingType = PatchActionUtil.getShardingType(this.systemInstance);
            this.oggTargetList = new ArrayList<String>();
            this.collectTopology(hostList, dbShardingTargets, isOgg, shardingType, false);
            if (null != hasShardingTargets && !hasShardingTargets.isEmpty()) {
                this.collectTopology(hostList, hasShardingTargets, isOgg, shardingType, true);
            }
            if (hostList == null || hostList.size() == 0) {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"68036", (Object[])new Object[0]), new Object[0]);
            }
        } else {
            int errorCode = ((ValidationResult)failedValidations.get(0)).getFailureReason().getErrorCode();
            String arguments = "";
            if (null != ((ValidationResult)failedValidations.get(0)).getPayload()) {
                arguments = (String)((ValidationResult)failedValidations.get(0)).getPayload();
            }
            for (int i = 1; i < failedValidations.size(); ++i) {
                int other_failures = ((ValidationResult)failedValidations.get(i)).getFailureReason().getErrorCode();
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(other_failures), (Object[])new Object[0]));
            }
            throw new OPatchAutoException("\n" + OPatchAutoHelper.getPublishedMessage((String)Integer.toString(errorCode), (Object[])new Object[]{arguments}), new Object[0]);
        }
        this.logger.finer("hostList " + hostList.size());
        this.topology = this.getTopology(hostList);
        this.logger.finer("topology " + this.topology);
    }

    private void collectTopology(List<Host> hostList, List<AbstractBaseTarget> shardingTargets, boolean isOgg, String shardingType, boolean isHas) throws OPatchAutoException {
        if (this.shardGroupOptions != null) {
            for (String shardGroupOption : this.shardGroupOptions) {
                this.logger.finer("Collecting " + (isHas ? "GI/HAS" : "database") + " targets of shardGroupOption : " + shardGroupOption);
                this.identifyAndCollectTargets(hostList, isOgg, isHas, shardingType, shardingTargets, shardGroupOption, null, null);
            }
        } else if (this.shardSpaceOptions != null) {
            for (String shardSpaceOption : this.shardSpaceOptions) {
                this.logger.finer("Collecting " + (isHas ? "GI/HAS" : "database") + " targets of shardSpaceOption : " + shardSpaceOption);
                if (isOgg) {
                    this.identifyAndCollectTargets(hostList, isOgg, isHas, shardingType, shardingTargets, null, shardSpaceOption, null);
                    continue;
                }
                if (this.dataGuards == null) {
                    this.dataGuards = this.systemInstance.getTargetsOfType(DataGuard.class);
                }
                for (DataGuard dataguard : this.dataGuards) {
                    String primDbName = null;
                    String primShardSpcName = null;
                    if (dataguard.getPrimary() instanceof SIDatabase) {
                        SIDatabase sidbPrimary = (SIDatabase)dataguard.getPrimary();
                        primDbName = sidbPrimary.getName();
                        primShardSpcName = sidbPrimary.getShardProperty().getShardSpaceName();
                    } else if (dataguard.getPrimary() instanceof RACDatabase) {
                        RACDatabase racdbPrimary = (RACDatabase)dataguard.getPrimary();
                        primDbName = racdbPrimary.getName();
                        primShardSpcName = racdbPrimary.getShardProperty().getShardSpaceName();
                    }
                    this.logger.finer("Comparing primShardSpcName : " + primShardSpcName + " and shardSpaceOption : " + shardSpaceOption);
                    if (StringUtil.isNullOrEmpty((String)primShardSpcName) || !primShardSpcName.equalsIgnoreCase(shardSpaceOption)) continue;
                    this.identifyAndCollectTargets(hostList, isOgg, isHas, shardingType, shardingTargets, null, null, primDbName);
                }
            }
        } else if (this.dataGuardOptions != null) {
            for (String dataGuardOption : this.dataGuardOptions) {
                this.logger.finer("Collecting " + (isHas ? "GI/HAS" : "database") + " targets of dataGuardOption : " + dataGuardOption);
                this.identifyAndCollectTargets(hostList, isOgg, isHas, shardingType, shardingTargets, null, null, dataGuardOption);
            }
        } else {
            this.logger.finer("Collecting all " + (isHas ? "GI/HAS" : "database") + " targets.");
            this.identifyAndCollectTargets(hostList, isOgg, isHas, shardingType, shardingTargets, null, null, null);
        }
    }

    private void identifyAndCollectTargets(List<Host> hostList, boolean isOgg, boolean isHas, String shardingType, List<AbstractBaseTarget> shardingTargets, String shardGroupOption, String shardSpaceOption, String dataGuardOption) throws OPatchAutoException {
        for (AbstractBaseTarget shardingTarget : shardingTargets) {
            if (!this.isShardNeeded(shardingTarget, isOgg, shardingType, shardGroupOption, shardSpaceOption, dataGuardOption)) continue;
            if (this.isTargetsComplete(isHas, shardGroupOption, shardSpaceOption, dataGuardOption, shardingTarget)) break;
            dbmodel.common.Host hostModel = this.getHost(shardingTarget.getHostName());
            if (hostModel == null) {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"68149", (Object[])new Object[]{shardingTarget.getHostName()}), new Object[0]);
            }
            this.logger.fine("hostModel created for : " + hostModel.getHostName());
            HostImpl host = null;
            if (this.currentHostMap.size() != 0 && this.currentHostMap.keySet().contains(hostModel.getHostName())) {
                host = this.createHost(shardingTarget, this.currentHostMap.get(hostModel.getHostName()), true, isOgg, shardingType);
                continue;
            }
            host = this.createHost(shardingTarget, new HostImpl(), false, isOgg, shardingType);
            this.currentHostMap.put(hostModel.getHostName(), host);
            hostList.add((Host)host);
        }
    }

    private boolean isTargetsComplete(boolean isHas, String shardGroupOption, String shardSpaceOption, String dataGuardOption, AbstractBaseTarget abt) {
        boolean isTargetsComplete = false;
        String option = null;
        if (this.isShardedDatabase && StringUtil.isNullOrEmpty((String)this.parentid) && !isHas) {
            if (shardGroupOption != null) {
                option = shardGroupOption;
            } else if (dataGuardOption != null) {
                option = dataGuardOption;
            } else if (shardSpaceOption != null) {
                option = shardSpaceOption;
            } else {
                String shardSpace = null;
                String shardGroup = null;
                if (abt instanceof SIDatabase) {
                    SIDatabase sidb = (SIDatabase)abt;
                    shardSpace = sidb.getShardProperty().getShardSpaceName();
                    shardGroup = sidb.getShardProperty().getShardGroupName();
                } else if (abt instanceof RACDatabase) {
                    RACDatabase racdb = (RACDatabase)abt;
                    shardSpace = racdb.getShardProperty().getShardSpaceName();
                    shardGroup = racdb.getShardProperty().getShardGroupName();
                }
                option = PatchActionUtil.isOgg(this.systemInstance) ? (PatchActionUtil.getShardingType(this.systemInstance).equalsIgnoreCase("user-defined") ? shardSpace : shardGroup) : abt.getName();
            }
            if (this.targetMap.containsKey(option)) {
                isTargetsComplete = true;
            } else {
                this.targetMap.put(option, abt.getName());
            }
        }
        this.logger.finest("Is targets collection complete : " + isTargetsComplete);
        return isTargetsComplete;
    }

    @Override
    protected String getSystemInstanceFileName() throws OPatchAutoException {
        return "opatch_sdb_config.xml";
    }

    private boolean isShardNeeded(AbstractBaseTarget shard, boolean isOgg, String shardingType, String shardGroupOption, String shardSpaceOption, String dataGuardOption) {
        this.logger.finer("Verifying shard " + shard.getName());
        SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
        if (this.isShardedDatabase) {
            if (!StringUtil.isNullOrEmpty((String)dataGuardOption)) {
                DataGuardAssembler dgAssembler = new DataGuardAssembler(this.dataGuards, this.parentid);
                return dgAssembler.isShardRequired(shard, systemInstance, dataGuardOption);
            }
            if (!StringUtil.isNullOrEmpty((String)shardGroupOption)) {
                ShardGroupAssembler shdGrpAssembler = new ShardGroupAssembler(this.shardGroups);
                return shdGrpAssembler.isShardRequired(shard, systemInstance, shardGroupOption);
            }
            if (!StringUtil.isNullOrEmpty((String)shardSpaceOption)) {
                if (!isOgg) {
                    DataGuardAssembler dgAssembler = new DataGuardAssembler(this.dataGuards, this.parentid);
                    return dgAssembler.isShardRequired(shard, systemInstance, dataGuardOption);
                }
                ShardSpaceAssembler shdSpcAssembler = new ShardSpaceAssembler(this.shardSpaces);
                return shdSpcAssembler.isShardRequired(shard, systemInstance, shardSpaceOption);
            }
            if (shard instanceof RACDatabase) {
                RACDatabase racDatabase = (RACDatabase)shard;
                return this.isShardRequired(isOgg, shardingType, racDatabase.getShardProperty().getShardGroupName(), racDatabase.getShardProperty().getShardSpaceName(), racDatabase.getPrimary());
            }
            if (shard instanceof SIDatabase) {
                SIDatabase siDatabase = (SIDatabase)shard;
                return this.isShardRequired(isOgg, shardingType, siDatabase.getShardProperty().getShardGroupName(), siDatabase.getShardProperty().getShardSpaceName(), siDatabase.getPrimary());
            }
            if (shard instanceof CRSCluster || shard instanceof HAS) {
                return true;
            }
        } else {
            if (shard instanceof CRSCluster || shard instanceof HAS) {
                return false;
            }
            if (!StringUtil.isNullOrEmpty((String)dataGuardOption)) {
                DataGuardAssembler dgAssembler = new DataGuardAssembler(this.dataGuards, this.parentid);
                return dgAssembler.isShardRequired(shard, systemInstance, dataGuardOption);
            }
            if (!StringUtil.isNullOrEmpty((String)shardGroupOption)) {
                ShardGroupAssembler shdGrpAssembler = new ShardGroupAssembler(this.shardGroups);
                return shdGrpAssembler.isShardRequired(shard, systemInstance, shardGroupOption);
            }
            if (!StringUtil.isNullOrEmpty((String)shardSpaceOption)) {
                ShardSpaceAssembler shdSpcAssembler = new ShardSpaceAssembler(this.shardSpaces);
                return shdSpcAssembler.isShardRequired(shard, systemInstance, shardSpaceOption);
            }
        }
        this.logger.finer("Shard " + shard.getName() + " is not added to to patch target");
        return false;
    }

    private boolean isShardRequired(boolean isOgg, String shardingType, String shgGrpName, String shdSpcName, boolean isPrimary) {
        if (isOgg) {
            if (shardingType.equalsIgnoreCase("user-defined")) {
                if (!this.oggTargetList.contains(shdSpcName)) {
                    this.oggTargetList.add(shdSpcName);
                    return true;
                }
            } else if (!this.oggTargetList.contains(shgGrpName)) {
                this.oggTargetList.add(shgGrpName);
                return true;
            }
        } else {
            return isPrimary;
        }
        return false;
    }

    public HostImpl createHost(AbstractBaseTarget shard, HostImpl host, boolean addHomeToHost, boolean isOgg, String shardingType) throws OPatchAutoException {
        Credential credential;
        OracleHome oracleHome = new OracleHome();
        DBHomeImpl targetHome = new DBHomeImpl();
        host.setHost(shard.getHostName());
        if (this.credentialManager != null) {
            credential = this.credentialManager.getCredential(host.getHost(), null, shard.getOwner());
            if (null == credential) {
                credential = this.credentialManager.getCredential(host.getHost());
            }
            host.setCredential(credential);
        }
        if (shard instanceof SIDatabase) {
            SIDBHomeFormulator SIDBHostFormulator = new SIDBHomeFormulator(this.isShardedDatabase, this.shardGroupOptions, this.shardSpaceOptions);
            SIDatabase siDatabase = (SIDatabase)shard;
            oracleHome = siDatabase.getRuns_from();
            targetHome = SIDBHostFormulator.createHome(shard, host, isOgg, shardingType, oracleHome);
        } else if (shard instanceof RACDatabase) {
            RACHomeFormulator racHostFormulator = new RACHomeFormulator(this.isShardedDatabase, this.shardGroupOptions, this.shardSpaceOptions);
            RACDatabase racDatabase = (RACDatabase)shard;
            if (!racDatabase.getDbInstances().isEmpty()) {
                oracleHome = ((RACDBInstance)racDatabase.getDbInstances().get(0)).getRuns_from();
            }
            targetHome = racHostFormulator.createHome(shard, host, isOgg, shardingType, oracleHome);
        } else if (shard instanceof CRSCluster) {
            CRSHomeFormulator crsHostFormulator = new CRSHomeFormulator();
            CRSCluster crsCluster = (CRSCluster)shard;
            oracleHome = ((HAS)crsCluster.getHAS().get(0)).getRuns_from();
            targetHome = crsHostFormulator.createHome(shard, host, isOgg, shardingType, oracleHome);
        } else if (shard instanceof HAS) {
            HASHomeFormulator hasHostFormulator = new HASHomeFormulator();
            HAS has = (HAS)shard;
            oracleHome = has.getRuns_from();
            targetHome = hasHostFormulator.createHome(shard, host, isOgg, shardingType, oracleHome);
        }
        if (this.credentialManager != null) {
            credential = this.credentialManager.getCredential(host.getHost(), null, targetHome.getOwner());
            targetHome.setCredential(credential);
        }
        host.setPatchLocation(targetHome.getLocation() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB);
        host.addHome((Home)targetHome);
        return host;
    }

    @Override
    protected File createSystemInstanceXML() throws OPatchAutoException {
        File file = new File(System.getProperty("ORACLE_HOME"), DBCommonPatchingConstants.OPATCHAUTO_DB_SCRIPT);
        String ohOwner = OUIDriver.checkFileOwner((File)file);
        String path = this.getSystemInstanceFilePath();
        DBPatchingUtil.mkdirs(path, ohOwner, null);
        String filePath = path + File.separator + this.getSystemInstanceFileName();
        DBPatchingUtil.createNewFile(filePath, ohOwner, null);
        File configXML = new File(filePath);
        return configXML;
    }

    public dbmodel.common.Host getHost(String hostname) {
        List hostModelList = this.systemInstance.getTargetsOfType(dbmodel.common.Host.class);
        for (dbmodel.common.Host hostModel : hostModelList) {
            this.logger.fine("Comparing hosts: " + hostModel.getName() + " and " + hostname);
            if (!hostModel.getName().equals(hostname)) continue;
            return hostModel;
        }
        return null;
    }

    public void pseudoInit(boolean isShardedDatabase, SystemInstance systemInstance, List<String> shardGroupOptions, List<String> shardSpaceOptions, CredentialManager credentialManager) {
        this.isShardedDatabase = isShardedDatabase;
        this.systemInstance = systemInstance;
        this.shardGroupOptions = shardGroupOptions;
        this.shardSpaceOptions = shardSpaceOptions;
        this.credentialManager = credentialManager;
    }
}

