/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.GILogger;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.database.Database;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.util.NotExistsException;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;
import oracle.opatch.PrereqSession;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.InstalledComponent;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;

public class Crs {
    private static String gridHome = "";
    private static ClusterwareInfo info = new ClusterwareInfo();
    private static Crs crsInstance = null;
    private static CrsType type = CrsType.NONE;
    private static HashMap<File, CrsType> homeMap = new HashMap();
    private IIPMReadServices readServices = null;
    static Logger logger = Logger.getLogger(Crs.class.getName());

    private Crs(IIPMReadServices rs) {
        this.readServices = rs;
    }

    public static synchronized Crs getInstance(String runningOracleHome) {
        return Crs.getInstance(runningOracleHome, "");
    }

    public static synchronized Crs getInstance(String runningOracleHome, String invPtr) throws UnsupportedOperationException {
        String ctrInvLoc;
        StringBuffer buff = new StringBuffer("Crs::getInstance() running from Oracle Home \"");
        buff.append(runningOracleHome);
        buff.append("\".");
        logger.info("crsInstance: " + crsInstance);
        if (crsInstance != null) {
            return crsInstance;
        }
        String invPtrLoc = PatchPlanner.getInstance().getOPlanEnv().getInvPtrLocation();
        boolean badInvPtrFlag = true;
        if (invPtrLoc != null && !invPtrLoc.equals("") && !(ctrInvLoc = PatchPlanner.getInstance().getOPlanEnv().getCentralInvLoc()).equals("n/a")) {
            badInvPtrFlag = false;
            System.setProperty("oracle.installer.custom_inventory", ctrInvLoc);
        }
        if (badInvPtrFlag) {
            throw new RuntimeException("Oralce Home's central inventory pointer location \"" + invPtrLoc + "\" is not valid.");
        }
        String ouiLoc = runningOracleHome + File.separator + "oui";
        File ouiPath = new File(ouiLoc);
        if (!ouiPath.exists()) {
            throw new UnsupportedOperationException("The Oracle Home opatch runs from is not an OUI based home.");
        }
        try {
            type = Crs.getCrsType(runningOracleHome);
            logger.info("type: " + (Object)((Object)type));
        }
        catch (Exception e) {
            logger.info("exception:: " + e.getMessage());
            GILogger.printStackTrace(e);
            throw new RuntimeException("Failed to detect Grid Infrastructure.  " + e.getMessage());
        }
        IIPMReadServices rs = null;
        if (type != CrsType.NONE) {
            try {
                rs = PrereqSession.getReadServices((String)gridHome);
            }
            catch (Throwable t) {
                GILogger.printStackTrace(t);
                throw new RuntimeException("Failed to load home inventory for \"" + gridHome + "\"", t);
            }
        }
        crsInstance = new Crs(rs);
        return crsInstance;
    }

    public boolean isGridEnv() {
        return type != CrsType.NONE;
    }

    public CrsType getCrsType() {
        return type;
    }

    public String getGridHome() {
        return gridHome;
    }

    private static CrsType getCrsType(String runningOracleHome) throws InstallException {
        CrsType crstype;
        block11: {
            StringBuffer buff = new StringBuffer("Crs::getCrsType() called");
            String ouiLoc = runningOracleHome + File.separator + "oui";
            crstype = CrsType.NONE;
            String olrLoc = DBPatchingUtil.getOLRLocation();
            try {
                IIPMReadServices readServices = PrereqSession.getReadServices((String)runningOracleHome);
                if (ComdevHelper.isWindows() || new File(olrLoc).exists()) {
                    if (info.isCRSConfigured(runningOracleHome)) {
                        crstype = CrsType.CRS;
                        gridHome = info.getCRSHome(new Version());
                        homeMap.put(new File(gridHome), crstype);
                    } else if (info.isHAConfigured(runningOracleHome)) {
                        crstype = CrsType.SIHA;
                        gridHome = info.getHAHome(ouiLoc);
                        homeMap.put(new File(gridHome), crstype);
                    }
                }
                if (crstype == CrsType.CRS || crstype == CrsType.SIHA) break block11;
                try {
                    if (!readServices.isInventoryLoaded()) {
                        buff = new StringBuffer("Crs::getCrsType() could not load inventory");
                        throw new NullPointerException(buff.toString());
                    }
                    String gridHomeLoc = readServices.findGridHomeLocation();
                    if (gridHomeLoc != null) {
                        gridHome = gridHomeLoc;
                        crstype = CrsType.SOFTWARE_INSTALLATION_ONLY;
                        homeMap.put(new File(gridHome), crstype);
                    }
                }
                catch (NullPointerException e) {
                    buff = new StringBuffer("GIPatching cannot load inventory from the given Oracle Home.\n");
                    buff.append("Possible causes are:\n");
                    buff.append("    Oracle Home dir. path does not exist in Central Inventory\n");
                    buff.append("    Oracle Home is a symbolic link\n");
                    buff.append("    Oracle Home inventory is corrupted");
                    throw new RuntimeException(buff.toString());
                }
                catch (Throwable e) {
                    GILogger.printStackTrace(e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            catch (Throwable e) {
                GILogger.printStackTrace(e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return crstype;
    }

    public CrsType getCrsTypeOfHome(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("Crs::getCrsTypeOfHome() called");
        File ghome = new File(oracleHomePath);
        if (homeMap.get(ghome) != null) {
            buff = new StringBuffer("CrsType is in homeMap. It is ");
            buff.append((Object)homeMap.get(ghome));
            return homeMap.get(ghome);
        }
        if (!this.readServices.isInventoryLoaded()) {
            throw new RuntimeException("Home inventory is not loaded.");
        }
        CrsType type = CrsType.NONE;
        if (Crs.isGridHome(oracleHomePath)) {
            type = CrsType.SOFTWARE_INSTALLATION_ONLY;
        }
        return type;
    }

    public static boolean isGridHome(String oracleHomePath) {
        String crsctlCmd = oracleHomePath + File.separator + DBCommonPatchingConstants.CRSCTL_COMMAND;
        crsctlCmd = ComdevHelper.isWindows() ? crsctlCmd + ".exe" : crsctlCmd + ".bin";
        File crsctl = new File(crsctlCmd);
        return crsctl.exists();
    }

    public String getCrsVersion() throws IllegalAccessException {
        if (type == CrsType.NONE) {
            throw new IllegalAccessException("No CRS Enviroment detected on current system.");
        }
        String version = "12.1.0.0.0";
        try {
            if (type == CrsType.CRS) {
                version = info.getCRSReleaseVersionString(gridHome);
            } else if (type == CrsType.SIHA) {
                version = info.getSIHAReleaseVersionString(gridHome);
            } else {
                InstalledComponent[] topComps = this.readServices.getTopLevelInstalledComponents();
                if (topComps.length < 1) {
                    throw new RuntimeException("No top-level component detected in current Oracle Home.");
                }
                version = topComps[0].getVersion();
            }
        }
        catch (Exception e) {
            GILogger.printStackTrace(e);
        }
        return version;
    }

    public String getLocalNode() {
        String local = "";
        try {
            local = this.readServices.getLocalNode();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch the local node name by OUI.");
        }
        if (local == null || local.equals("")) {
            try {
                InetAddress ia = InetAddress.getLocalHost();
                local = ia.getHostName().trim();
            }
            catch (UnknownHostException e) {
                GILogger.printStackTrace(e);
                throw new RuntimeException("Failed to detect local node name.");
            }
            int dotPos = local.indexOf(46);
            if (dotPos != -1) {
                local = local.substring(0, dotPos);
            }
        }
        return local;
    }

    public String[] getClusterNodeList(String oracleHomePath) {
        String localNode;
        String[] nodes;
        StringBuffer buff;
        block14: {
            buff = new StringBuffer("Crs::getClusterNodeList() called");
            nodes = new String[]{};
            try {
                if (type != CrsType.CRS || !this.isStackRunning()) {
                    return nodes;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            localNode = "";
            try {
                HashMap nodeMap = info.getClusterNodeActiveRoles(gridHome);
                nodes = new String[nodeMap.keySet().size()];
                nodeMap.keySet().toArray(nodes);
                localNode = Cluster.getLocalNode();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to retrieve the clusterware nodes.");
            }
            try {
                if (new File(oracleHomePath).equals(new File(gridHome))) break block14;
                CommonFactory cf = CommonFactory.getInstance();
                oracle.cluster.common.Cluster cluster = cf.getCluster();
                List databases = null;
                try {
                    databases = cluster.fetchDatabases();
                }
                catch (NotExistsException notExistsException) {
                    // empty catch block
                }
                HashSet<String> filterNodes = new HashSet<String>();
                for (int i = 0; i < nodes.length; ++i) {
                    if (!OiipgClusterOps.fileExistsOnNode((String)nodes[i], (String)oracleHomePath)) continue;
                    filterNodes.add(nodes[i]);
                }
                nodes = new String[filterNodes.size()];
                filterNodes.toArray(nodes);
                if (databases == null) break block14;
                for (Database sdb : databases) {
                    if (!new File(sdb.getOracleHome()).equals(new File(oracleHomePath))) continue;
                    if (!sdb.isClusterDatabase()) {
                        nodes = new String[]{};
                    }
                    break;
                }
            }
            catch (ManageableEntityException e) {
                throw new RuntimeException("Failed to handle configured databases.", e);
            }
            catch (OiipgRemoteOpsException e) {
                throw new RuntimeException("Failed to detect if Oracle Home exists in specific node or not.", e);
            }
        }
        NodeComparator nc = new NodeComparator();
        buff = new StringBuffer("Local node is \"" + localNode + "\"");
        nc.setLocalNode(localNode.toLowerCase());
        buff = new StringBuffer("Detected nodes as below: \n");
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = nodes[i].toLowerCase();
            buff.append(nodes[i] + " ");
        }
        Arrays.sort(nodes, nc);
        return nodes;
    }

    public boolean isStackRunning() throws IllegalAccessException {
        boolean isStackRunning = false;
        switch (type) {
            case NONE: {
                throw new IllegalAccessException("No CRS Enviroment detected on current system.");
            }
            case CRS: 
            case SIHA: {
                isStackRunning = this.isClusterwareRunning(null);
                break;
            }
        }
        return isStackRunning;
    }

    public boolean isClusterwareRunning(String nodeName) throws IllegalAccessException {
        String localNode;
        boolean isRunning = false;
        if (type != CrsType.CRS && type != CrsType.SIHA) {
            throw new IllegalAccessException("There is no clusterware env detected on current platform.");
        }
        boolean isRoot = false;
        try {
            isRoot = OsysUtility.isRootAccess();
        }
        catch (Exception e1) {
            GILogger.printStackTrace(e1);
            throw new RuntimeException("Failed to check if user is root user.", e1);
        }
        if (nodeName != null && !nodeName.equalsIgnoreCase(localNode = this.getLocalNode()) && isRoot) {
            return DBPatchingUtil.isClusterwareUp(gridHome, nodeName);
        }
        String crsVerStr = this.getCrsVersion();
        Version crsV = null;
        try {
            crsV = Version.getVersion((String)crsVerStr);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to get cluster version.", e);
        }
        try {
            isRunning = nodeName != null && !nodeName.equals("") ? (type == CrsType.CRS ? info.isCRSRunning(gridHome, nodeName, crsV) : info.isHARunning(gridHome, nodeName)) : (type == CrsType.CRS ? info.isCRSRunning(gridHome, crsV) : info.isHARunning(gridHome));
        }
        catch (InstallException installException) {
            // empty catch block
        }
        return isRunning;
    }

    class NodeComparator
    implements Comparator<String> {
        String localNode = "";

        NodeComparator() {
        }

        @Override
        public int compare(String node1, String node2) {
            if (node1.equalsIgnoreCase(this.localNode)) {
                return -1;
            }
            if (node2.equalsIgnoreCase(this.localNode)) {
                return 1;
            }
            return node1.compareTo(node2);
        }

        protected void setLocalNode(String localNode) {
            this.localNode = localNode;
        }
    }

    public static enum CrsType {
        NONE,
        CRS,
        SIHA,
        SOFTWARE_INSTALLATION_ONLY;

    }
}

