/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product;

import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.SkipTargetCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import dbmodel.BaseClass;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.PatchBundle;
import dbmodel.patchmodel.PatchPackage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.sysman.oii.oiii.OiiiVersion;

public class DBPatchVersionSelection {
    private Logger logger = Logger.getLogger(DBPatchVersionSelection.class.getName());
    private static final String DB_TWELVE_TWO = "12.2.0.0.0";
    boolean higherOplanVersion = false;
    private static ArrayList<String> supportedVersions = new ArrayList();

    public String getPrimaryPatchVersion() {
        this.logger.config("Searching for automations for the patches");
        String version = this.getConfigRootVersion();
        String patchVersion = this.getPatchVersion();
        String oldDBVersion = this.getOldDBVersionIfPatchingOnlyDB(version, patchVersion);
        if (oldDBVersion != null) {
            version = this.formattedVersion(oldDBVersion);
        }
        String primaryVersion = null;
        if (DBPatchingUtil.isVersionEqalOrlater(version, DB_TWELVE_TWO)) {
            primaryVersion = version;
            this.logger.fine("Primary patch version " + primaryVersion + " is equal or greater than " + DB_TWELVE_TWO);
        } else {
            for (String ver : supportedVersions) {
                if (!version.startsWith(ver)) continue;
                primaryVersion = version;
                break;
            }
        }
        this.logger.fine("Primary patch version ::" + primaryVersion);
        return primaryVersion;
    }

    public boolean isEngSysPatch() {
        PatchPackage patch = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
        return patch instanceof EngineeredSystemPatch;
    }

    protected String getConfigRootVersion() {
        AbstractBaseTarget root = PatchPlanner.getInstance().getConfigGraph().getRootVertex();
        assert (root != null && root.getVersion() == null);
        this.logger.info("Found " + root + " with version: " + root.getVersion());
        return root.getVersion();
    }

    private String getOldDBVersionIfPatchingOnlyDB(String rootVersion, String patchVersion) {
        boolean isGIOrSIHAAvailable = false;
        String oldDBVersion = null;
        HashSet<String> setOfOldDBVersion = new HashSet<String>();
        for (BaseClass bc : PatchPlanner.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            SIDatabase sidb;
            RACDatabase racDB;
            if (bc instanceof OracleHome) {
                OracleHome oh = (OracleHome)bc;
                if (oh.getHomeType().equals("crs")) {
                    if (!DBCommandUtils.isGIMarkedForSkip()) {
                        isGIOrSIHAAvailable = true;
                    }
                } else if (oh.getHomeType().equals("siha")) {
                    if (!DBCommandUtils.isSIHAMarkedForSkip()) {
                        isGIOrSIHAAvailable = true;
                    }
                } else if ((oh.getHomeType().equals("rac") || oh.getHomeType().equals("sidb")) && oh.getProperty(SkipTargetCookie.class) == null) {
                    OUIComponent ouiComp = null;
                    List ouiCompList = oh.getTopLevelOUI();
                    if (ouiCompList != null && !ouiCompList.isEmpty()) {
                        ouiComp = (OUIComponent)oh.getTopLevelOUI().get(0);
                    }
                    if (ouiComp != null) {
                        String dbHomeVersion = new OiiiVersion(ouiComp.getVersion()).getVerString();
                        if (!this.formattedVersion(rootVersion).equals(this.formattedVersion(dbHomeVersion))) {
                            setOfOldDBVersion.add(dbHomeVersion);
                        }
                    }
                }
            }
            if (bc instanceof RACDatabase && (racDB = (RACDatabase)bc).getVersion() != null && racDB.getProperty(SkipTargetCookie.class) == null && !this.formattedVersion(rootVersion).equals(this.formattedVersion(racDB.getVersion()))) {
                setOfOldDBVersion.add(racDB.getVersion());
            }
            if (!(bc instanceof SIDatabase) || (sidb = (SIDatabase)bc).getVersion() == null || sidb.getProperty(SkipTargetCookie.class) != null || this.formattedVersion(rootVersion).equals(this.formattedVersion(sidb.getVersion()))) continue;
            setOfOldDBVersion.add(sidb.getVersion());
        }
        if (!isGIOrSIHAAvailable) {
            if (setOfOldDBVersion.size() > 1) {
                if (patchVersion == null) {
                    this.logger.severe("Unable to determine the Patch version. Please execute individual home compatible to the patch version");
                    throw new PatchPlanException("Unable to determine the Patch version. Please execute individual home compatible to the patch version");
                }
                oldDBVersion = this.getDBVersionMatchingPatchVersion(patchVersion, setOfOldDBVersion);
            } else if (setOfOldDBVersion.size() == 1) {
                oldDBVersion = (String)setOfOldDBVersion.toArray()[0];
            }
        }
        return oldDBVersion;
    }

    private String getDBVersionMatchingPatchVersion(String patchVersion, Set<String> setOfDBVersion) {
        String version = null;
        String[] listOfVersion = new String[setOfDBVersion.size()];
        setOfDBVersion.toArray(listOfVersion);
        for (String ver : listOfVersion) {
            if (!this.formattedVersion(patchVersion).equals(this.formattedVersion(ver))) continue;
            version = ver;
        }
        return version;
    }

    private String getPatchVersion() {
        String version = null;
        PatchPackage patch = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
        if (patch instanceof EngineeredSystemPatch) {
            List subPatches = ((EngineeredSystemPatch)patch).getSubPatches();
            for (GenericPatch subPatch : subPatches) {
                if (subPatch.getVersion() == null) continue;
                version = subPatch.getVersion();
                break;
            }
        } else if (patch instanceof PatchBundle) {
            List subPatches = ((PatchBundle)patch).getSubPatches();
            for (GenericPatch subPatch : subPatches) {
                if (subPatch.getVersion() == null) continue;
                version = subPatch.getVersion();
                break;
            }
        } else {
            version = patch.getVersion();
        }
        return version;
    }

    private String formattedVersion(String version) {
        String formattedVersion = version;
        if (formattedVersion.split("\\.").length == 5) {
            int index = version.lastIndexOf(".");
            formattedVersion = version.substring(0, index);
        }
        return formattedVersion;
    }

    static {
        supportedVersions.add("26.1");
        supportedVersions.add("26.0");
        supportedVersions.add("23.0");
        supportedVersions.add("23.1");
        supportedVersions.add("23.2");
        supportedVersions.add("23.3");
        supportedVersions.add("23.4");
        supportedVersions.add("23.5");
        supportedVersions.add("23.6");
        supportedVersions.add("21.0");
        supportedVersions.add("21.1");
        supportedVersions.add("21.2");
        supportedVersions.add("20.0");
        supportedVersions.add("20.1");
        supportedVersions.add("20.2");
        supportedVersions.add("20.3");
        supportedVersions.add("19.0");
        supportedVersions.add("19.1");
        supportedVersions.add("18.0");
        supportedVersions.add("18.1");
        supportedVersions.add("12.2");
        supportedVersions.add("12.1.0.2");
        supportedVersions.add("12.1.0.1");
        supportedVersions.add("11.2.0.4");
        supportedVersions.add("11.2.0.3");
        supportedVersions.add("11.2.0.2");
    }
}

