/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.LifecycleAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class OracleHomeLifecycle
extends Command {
    protected String type = DBCommandActionType.start.toString();
    protected Strategy s = Strategy.MANUAL;
    List<String> processed = new ArrayList<String>();

    public OracleHomeLifecycle(ActionType automationAction, String type, Strategy s) {
        super(automationAction);
        this.type = type;
        this.s = s;
    }

    private static String getUUID(OracleHome oh, Host host, String sessionid) {
        boolean clone = false;
        if (oh.getOriginalOracleHome() != null) {
            oh = oh.getOriginalOracleHome();
            clone = true;
        }
        String str = oh.getUniqueId().replace(':', '_');
        if (clone) {
            str = str + "_clone";
        }
        if (host != null) {
            str = str + "_" + host.getHostName();
        }
        if (sessionid != null) {
            str = str + "_" + sessionid;
        }
        return str;
    }

    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getTarget(OracleHome.class);
        ArrayList<Host> hostList = new ArrayList<Host>();
        if (this.automationAction.getType().equals(DBCommandActionType.stopOnAllHost.toString()) || this.automationAction.getType().equals(DBCommandActionType.startOnAllHost.toString())) {
            hostList.addAll(this.getHostList(oh));
        } else {
            Host host = context.getTarget(Host.class);
            hostList.add(host);
        }
        ArrayList<String> cmds = new ArrayList<String>();
        Logger.getLogger(OracleHomeLifecycle.class.getName()).info("type: " + this.type);
        List<String> tempCmds = null;
        for (Host host : hostList) {
            tempCmds = this.getCommandForHost(oh, host);
            if (tempCmds == null || tempCmds.isEmpty()) continue;
            cmds.addAll(tempCmds);
        }
        return cmds;
    }

    private List<String> getCommandForHost(OracleHome oh, Host host) {
        ArrayList<String> cmds = new ArrayList<String>();
        String sessionid = SessionData.getInstance().getSessionID();
        String uuid = OracleHomeLifecycle.getUUID(oh, host, sessionid);
        String staFileLoc = HelperUtility.detectOraBaseConfig((String)oh.getPath()) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "statfile" + File.separator + host.getName();
        File statefile = new File(staFileLoc, uuid + ".stat");
        File backupFile = new File(staFileLoc, uuid + ".stat.bak");
        if (this.type.equalsIgnoreCase(DBCommandActionType.stop.toString())) {
            cmds.add("mkdir -p " + staFileLoc);
        }
        String cmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl " + this.type + " home -o " + oh.getPath();
        if (PatchPlanner.getInstance().getConfigGraph().getRootVertex() instanceof CRSCluster) {
            cmd = cmd + " -n " + host.getHostName();
        }
        if (this.type.equalsIgnoreCase(DBCommandActionType.stop.toString())) {
            cmd = cmd + " -f";
            if (oh.getHomeType().equals("rac")) {
                String version = DBCommandUtils.getRACDBVersionForCurrentHome(oh);
                if (version != null) {
                    cmd = version.startsWith("11") ? cmd + " -t TRANSACTIONAL" : cmd + " -stopoption TRANSACTIONAL";
                } else {
                    Logger.getLogger(OracleHomeLifecycle.class.getName()).info("Unable to get the DB version, so not performing stop DB home in transactional mode");
                }
            }
        }
        cmd = cmd + " -s " + statefile.getAbsolutePath();
        cmds.add(cmd);
        if (this.type.equalsIgnoreCase(DBCommandActionType.start.toString())) {
            if (statefile.exists()) {
                cmds.add("rm -rf " + statefile);
            }
            if (backupFile.exists()) {
                cmds.add("rm -rf " + backupFile);
            }
        }
        return cmds;
    }

    public ExecutionStep getExecutionStep(CommandContext context) {
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep(this.automationAction, context, null);
        List<String> commandList = this.getShellCommands(context);
        for (String cmd : commandList) {
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        }
        return executionStep;
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        List<? extends AbstractBaseTarget> ohs = actsOnlyOnTargets;
        for (OracleHome oracleHome : ohs) {
            CommandContext context = contextPopulator.populateContext(g, (AbstractBaseTarget)oracleHome, this.getHost());
            if (!CommandUtils.shouldShutdownRACInstance(this.getPatchingPhase(), oracleHome.getPath())) continue;
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
                OracleHome oh = context.getFirstTarget(OracleHome.class);
                if (oh.getOriginalOracleHome() != null && oh.getOriginalOracleHome().getPath().equals(oh.getPath())) continue;
            }
            ExecutionStep step = this.getExecutionStep(context);
            if (this.s.equals((Object)Strategy.DCLI)) {
                step.setHost(g.getLocalHost());
            }
            steps.add(step);
        }
        return steps;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        return g.getTargets(OracleHome.class, this.automationAction.getStripe());
    }

    private Set<Host> getHostList(OracleHome oh) {
        HashSet<Host> hostList = new HashSet<Host>();
        ConfigGraph graph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> targets = graph.getTargets(OracleHome.class, this.automationAction.getStripe());
        for (OracleHome home : targets) {
            if (!home.getPath().equals(oh.getPath())) continue;
            hostList.addAll(home.getHosts());
        }
        return hostList;
    }

    public static class Builder
    implements CommandBuilder<OracleHomeLifecycle> {
        @Override
        public OracleHomeLifecycle getCommand(ActionType a, Strategy s) {
            if (!(a instanceof LifecycleAction) || a.getActsOn() == null || !a.getActsOn().equals("OracleHome")) {
                return null;
            }
            String type = a.getType();
            if (type.equals(DBCommandActionType.stopOnAllHost.toString())) {
                type = DBCommandActionType.stop.toString();
            } else if (type.equals(DBCommandActionType.startOnAllHost.toString())) {
                type = DBCommandActionType.start.toString();
            }
            OracleHomeLifecycle com = new OracleHomeLifecycle(a, type, s);
            return com;
        }
    }
}

