/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.GenericShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.patchmodel.GenericPatch;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Command;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class PatchRACDBHomeCommand
extends GenericShellCommand {
    private List<String> preScript;
    private List<String> postScript;

    public PatchRACDBHomeCommand(CommandAction automationAction) {
        super(automationAction);
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            List commandList = ((CommandAction)this.getAutomationAction()).getCommand();
            String scriptName = ((Command)commandList.get(0)).getSource().getValue();
            if (scriptName.equalsIgnoreCase("prepatch.sh")) {
                this.preScript = this.createPrePostScript(g, abstractBaseTarget, "prepatch.sh");
                continue;
            }
            if (!scriptName.equalsIgnoreCase("postpatch.sh")) continue;
            this.postScript = this.createPrePostScript(g, abstractBaseTarget, "postpatch.sh");
        }
        steps = super.generateExecutionSteps(g, actsOnlyOnTargets);
        return steps;
    }

    private List<String> createPrePostScript(ConfigGraph g, AbstractBaseTarget t, String fileName) {
        ArrayList<String> filePath = new ArrayList<String>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        CommandContext context = contextPopulator.populateContext(g, t, this.getHost());
        if (this.automationAction.isActsOnClone()) {
            contextPopulator.fixCloneContext(context);
        }
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        boolean isRollbackPatchID = SessionData.getInstance().isRollbackPatchID();
        if (isRollbackPatchID) {
            for (OPatchPatchInfo patchInfo : SessionData.getInstance().getAnalyzedPatchList(oh.getPath())) {
                try {
                    DBPatchingHelper.copyLatestPatchScripts(patchInfo.getPatchID(), oh.getPath());
                }
                catch (Exception e) {
                    Logger.getLogger(PatchRACDBHomeCommand.class.getName()).info("Unable to copy the prepatch and postpatch scripts to tmp location");
                }
                String patchLocation = oh.getPath() + "/opatchautocfg/db/dbtmp" + File.separator + patchInfo.getPatchID();
                Logger.getLogger(PatchRACDBHomeCommand.class.getName()).info("PatchRoot: " + patchLocation);
                String path = patchLocation + File.separator + "custom" + File.separator + "scripts" + File.separator + fileName;
                File f = new File(path);
                if (!f.exists() || f.isDirectory()) continue;
                Logger.getLogger(PatchRACDBHomeCommand.class.getName()).info("path: " + path);
                filePath.add(path);
            }
        } else {
            List<GenericPatch> patches = this.getPatches(oh);
            String mainPatchLoc = PatchPlanner.getInstance().getOPlanEnv().getBundlePatchloc().getAbsolutePath();
            for (OPatchPatchInfo patchInfo : SessionData.getInstance().getAnalyzedPatchList(oh.getPath())) {
                for (GenericPatch patch : patches) {
                    if (!patchInfo.getPatchID().equals(patch.getPatchID())) continue;
                    Logger.getLogger(PatchRACDBHomeCommand.class.getName()).info("PatchRoot: " + patch.getPatchLocation());
                    String path = patch.getPatchLocation() + File.separator + "custom" + File.separator + "scripts" + File.separator + fileName;
                    File f = new File(path);
                    if (!f.exists() || f.isDirectory()) continue;
                    Logger.getLogger(PatchRACDBHomeCommand.class.getName()).info("path: " + path);
                    String patchLoc = patch.getPatchLocation();
                    patchLoc = DBCommandUtils.getTemPatchLocForRemoteNode(mainPatchLoc, patchLoc);
                    path = patchLoc + File.separator + "custom" + File.separator + "scripts" + File.separator + fileName;
                    filePath.add(path);
                }
            }
        }
        return filePath;
    }

    private List<GenericPatch> getPatches(OracleHome oh) {
        List<GenericPatch> patchList = !PatchPlanner.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.valueOf(oh.getHomeType()).toString()) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        List<GenericPatch> patches = CommandUtils.sortPatchesById(patchList);
        return patches;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        StringBuilder cmd;
        ArrayList<String> cmds = new ArrayList<String>();
        if (this.preScript != null) {
            for (String pre : this.preScript) {
                cmd = this.getPrePostScriptCommand(context, pre);
                Logger.getLogger(PatchRACDBHomeCommand.class.getName()).info("cmd: " + cmd.toString());
                cmds.add(cmd.toString());
            }
        }
        if (this.postScript != null) {
            for (String post : this.postScript) {
                cmd = this.getPrePostScriptCommand(context, post);
                Logger.getLogger(PatchRACDBHomeCommand.class.getName()).info("cmd: " + cmd.toString());
                cmds.add(cmd.toString());
            }
        }
        return cmds;
    }

    private StringBuilder getPrePostScriptCommand(CommandContext context, String scriptPath) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<OracleHome> clones = PatchPlanner.getInstance().getMakeCloneHome().getHomeClone(oh);
        String clonePath = null;
        for (OracleHome clone : clones) {
            clonePath = clone.getPath();
            while (clonePath.lastIndexOf("/") == clonePath.length() - 1) {
                clonePath = clonePath.substring(0, clonePath.length() - 1);
            }
        }
        StringBuilder cmd = new StringBuilder(scriptPath);
        cmd.append(" ");
        cmd.append("-dbhome");
        cmd.append(" ");
        if (SessionData.getInstance().isOOPPatchingSession()) {
            cmd.append(clonePath);
        } else {
            cmd.append(oh.getPath());
        }
        return cmd;
    }

    public static class Builder
    implements CommandBuilder<SimpleShellCommand> {
        @Override
        public PatchRACDBHomeCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.PatchRACDBHome.toString())) {
                return null;
            }
            PatchRACDBHomeCommand com = new PatchRACDBHomeCommand((CommandAction)a);
            return com;
        }
    }
}

