/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.GenericShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Command;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class PrePostScriptCommand
extends GenericShellCommand {
    private Logger logger = Logger.getLogger(PrePostScriptCommand.class.getName());

    public PrePostScriptCommand(CommandAction automationAction) {
        super(automationAction);
    }

    protected String findScript(String script, CommandContext context) {
        List<PatchBundle> bps = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getBundlePatches();
        if (bps.size() == 0) {
            throw new PatchPlanInternalException("oplan needs at least one bundle");
        }
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<GenericPatch> patches = !PatchPlanner.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString()) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        String mainPatchLoc = PatchPlanner.getInstance().getOPlanEnv().getBundlePatchloc().getAbsolutePath();
        for (OPatchPatchInfo patchInfo : SessionData.getInstance().getAnalyzedPatchList(oh.getPath())) {
            for (GenericPatch patch : patches) {
                if (!patchInfo.getPatchID().equals(patch.getPatchID()) || !(patch instanceof OPatchSingleton) && !(patch instanceof CompositePatch) || !patch.getPatchLocation().contains("custom/server")) continue;
                String patchLoc = patch.getPatchLocation();
                patchLoc = DBCommandUtils.getTemPatchLocForRemoteNode(mainPatchLoc, patchLoc);
                String fileSeparator = CommandUtils.getFileSeparator(oh);
                return patchLoc + fileSeparator + "custom" + fileSeparator + "scripts" + fileSeparator + script;
            }
        }
        CRSCluster crs = (CRSCluster)PatchPlanner.getInstance().getSystemInstance().getTargetsOfType(CRSCluster.class).get(0);
        String version = crs.getVersion();
        if (DBPatchingUtil.isDBVersionTweleveOrLater(version)) {
            throw new PatchPlanInternalException("This step is not supported for 12c. Please remove it from the automation.xmls in the patch and try again.");
        }
        throw new PatchPlanInternalException("Can't find custom/scripts dir in patches.");
    }

    @Override
    public boolean isCommandApplicableForPatchesInContext() {
        List<EngineeredSystemPatch> eps;
        PatchPackagesBag bag = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag();
        List<PatchBundle> bps = bag.getBundlePatches();
        if (bps.size() == 0 && ((eps = bag.getEngineeredSystemPatches()) == null || eps.size() == 0)) {
            this.logger.fine("There are no bundle patches or engineered system patches in the context. Hence, " + this.getClass().getName() + " will not return any steps.");
            return false;
        }
        return true;
    }

    protected String getSource(Command c, CommandContext context) {
        return this.findScript(c.getSource().getValue().trim(), context);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        for (Command c : this.automationCommands) {
            StringBuilder str = new StringBuilder();
            str.append(this.getSource(c, context));
            for (String arg : c.getParameter()) {
                str.append(" ").append(arg.trim());
            }
            cmds.add(this.replaceParams(str.toString(), context));
        }
        return cmds;
    }

    public static class Builder
    implements CommandBuilder<PrePostScriptCommand> {
        private Logger logger = Logger.getLogger(PrePostScriptCommand.class.getName());

        @Override
        public PrePostScriptCommand getCommand(ActionType a, Strategy s) {
            this.logger.log(Level.FINEST, "In construct");
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.PrePostScript.toString())) {
                return null;
            }
            return new PrePostScriptCommand((CommandAction)a);
        }
    }
}

