/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.cookies.CRSMakeCloneHome;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class RelinkBinaryRacOn
extends SimpleShellCommand {
    public RelinkBinaryRacOn(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        CRSMakeCloneHome makeCloneHome = (CRSMakeCloneHome)PatchPlanner.getInstance().getMakeCloneHome();
        List<OracleHome> clones = makeCloneHome.getHomeClone(oh);
        String scriptFile = HelperUtility.detectOraBaseHome((String)oh.getPath()) + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "relinkbinaryonrac";
        int count = 1;
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        String strMake = "";
        strMake = DBPatchingUtil.isVersionEqalOrlater(primarypatchVersion, "19.0.0.0.0") && SessionData.getInstance().isExtremePerf() ? " make -f ins_rdbms.mk rac_on ipc_rds edition_extremeperf opc_on cloud_on uniaud_on ioracle" : " make -f ins_rdbms.mk rac_on ioracle";
        String tmpScriptFilePath = null;
        for (OracleHome clone : clones) {
            tmpScriptFilePath = scriptFile + count + ".sh";
            cmds.add("echo '#!/bin/sh' > " + tmpScriptFilePath);
            cmds.add("echo 'cd " + clone.getPath() + "/rdbms/lib; ORACLE_HOME=" + clone.getPath() + strMake + "' >> " + tmpScriptFilePath);
            cmds.add("echo 'exit 0;' >> " + tmpScriptFilePath);
            cmds.add("chmod +x " + tmpScriptFilePath);
            cmds.add(tmpScriptFilePath);
            cmds.add("rm -rf " + tmpScriptFilePath);
            ++count;
        }
        return cmds;
    }

    public static class Builder
    implements CommandBuilder<RelinkBinaryRacOn> {
        @Override
        public RelinkBinaryRacOn getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.RelinkBinaryRacOn.toString())) {
                return null;
            }
            return new RelinkBinaryRacOn(a);
        }
    }
}

