/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.patchmodel.GenericPatch;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class SQLPatchUpgradeModeCommand
extends Command {
    private static String sqlUpgradeDirectory = null;
    CommandAction automationAction;
    Logger logger = Logger.getLogger(SQLPatchUpgradeModeCommand.class.getName());

    public SQLPatchUpgradeModeCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep executionStep;
            CommandContext context = contextPopulator.populateContext(g, abstractBaseTarget, this.getHost());
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if (null == (executionStep = this.getExecutionStep(context))) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    private ExecutionStep getExecutionStep(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        ArrayList<GenericPatch> patches = new ArrayList<GenericPatch>();
        patches.addAll(PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString())));
        patches.addAll(PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.toString())));
        if (DBCommandUtils.shouldExecuteSqlCommand(db, patches, (ActionType)this.automationAction)) {
            if (DBCommandUtils.isPhysicalStandbyDatabase(db)) {
                context = DBCommandUtils.resetContextForStandbyDB(db);
                oh = context.getFirstTarget(OracleHome.class);
                db = context.getPrimaryTarget();
            }
            ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, context, null);
            if (this.automationAction.isActsOnClone() && DBCommandUtils.isRemoteDB(db)) {
                this.logger.info("Current step is running on remote db " + db.getDisplayName() + ". Set acts_on_clone property to null");
                executionStep.getAutomationAction().setActsOnClone(null);
            }
            ArrayList<String> cmds = new ArrayList<String>();
            String OracleSid = this.getOracleSIDForActiveInstance(executionStep, db);
            boolean isSQLPatchUpgradeMode = false;
            boolean isPrereqPhase = this.getPatchingPhase().getPhaseType().equals((Object)PhaseType.PRE_REQ);
            List<String> tempCmds = null;
            isSQLPatchUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
            if (isSQLPatchUpgradeMode && (db instanceof RACDatabase || db instanceof SIDatabase)) {
                if (isPrereqPhase && isSQLPatchUpgradeMode) {
                    return null;
                }
                String actionType = this.automationAction.getType();
                sqlUpgradeDirectory = oh.getPath() + File.separator + "cfgtoollogs" + File.separator + "opatchautodb" + File.separator + "sqlupgrade_" + OracleSid;
                if (!new File(sqlUpgradeDirectory).exists()) {
                    cmds.add("mkdir -p " + sqlUpgradeDirectory);
                }
                String sqlPlusCmd = "cd " + oh.getPath() + "; ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + OracleSid + " ./bin/sqlplus / as sysdba @";
                if (DBCommandActionType.SqlPatchDisableCluster.name().equals(actionType)) {
                    tempCmds = this.generateSqlPatchClusterDisableCommand(sqlPlusCmd);
                } else if (DBCommandActionType.SqlPatchStartupUpgradeMode.name().equals(actionType)) {
                    tempCmds = this.generateDBStartupInUpgradeModeCommand(sqlPlusCmd);
                } else if (DBCommandActionType.SqlPatchEnableCluster.name().equals(actionType)) {
                    tempCmds = this.generateSqlPatchClusterEnableCommand(sqlPlusCmd);
                }
            } else {
                return null;
            }
            if (tempCmds != null && !tempCmds.isEmpty()) {
                cmds.addAll(tempCmds);
            }
            for (String s : cmds) {
                executionStep.getCommand().add(new ExecutionStep.Command(s));
            }
            return executionStep;
        }
        return null;
    }

    private List<String> generateSqlPatchClusterDisableCommand(String sqlPlusCmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        String dataPatchfileForSetClusterFalse = sqlUpgradeDirectory + File.separator + "dataPatchfileForSetClusterFalse.sql";
        cmds.add("echo 'alter system set cluster_database=false scope=spfile;' > " + dataPatchfileForSetClusterFalse);
        cmds.add("echo 'quit' >> " + dataPatchfileForSetClusterFalse);
        cmds.add(sqlPlusCmd + dataPatchfileForSetClusterFalse);
        return cmds;
    }

    private List<String> generateSqlPatchClusterEnableCommand(String sqlPlusCmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        String dataPatchfileForSetClusterTrue = sqlUpgradeDirectory + File.separator + "dataPatchfileForSetClusterTrue.sql";
        cmds.add("echo 'alter system set cluster_database=true scope=spfile;' > " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'shutdown' >> " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'quit' >> " + dataPatchfileForSetClusterTrue);
        cmds.add(sqlPlusCmd + dataPatchfileForSetClusterTrue);
        cmds.add("rm -rf " + sqlUpgradeDirectory);
        return cmds;
    }

    private List<String> generateDBStartupInUpgradeModeCommand(String sqlPlusCmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        String dataPatchfileForStartupUpgrade = sqlUpgradeDirectory + File.separator + "dataPatchfileForStartupUpgrade.sql";
        cmds.add("echo 'startup upgrade' > " + dataPatchfileForStartupUpgrade);
        cmds.add("echo 'quit' >> " + dataPatchfileForStartupUpgrade);
        cmds.add(sqlPlusCmd + dataPatchfileForStartupUpgrade);
        return cmds;
    }

    private String getOracleSIDForActiveInstance(ExecutionStep executionStep, AbstractBaseTarget primaryTarget) {
        if (primaryTarget instanceof RACDBInstance) {
            RACDBInstance instance = (RACDBInstance)primaryTarget;
            return instance.getInstanceName();
        }
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)primaryTarget;
            ExecutionMode exeMode = PatchPlanner.getInstance().getOPlanEnv().getExecutionMode();
            if (ExecutionMode.OPATCH.toString().equalsIgnoreCase(exeMode.toString())) {
                return DBCommandUtils.getOracleSID(executionStep, primaryTarget);
            }
            for (RACDBInstance rdbi : racDB.getDbInstances()) {
                if (null != rdbi.getIsRunning()) {
                    if (!"yes".equals(rdbi.getIsRunning())) continue;
                    executionStep.setHost(rdbi.getHost());
                    return rdbi.getInstanceName();
                }
                return DBCommandUtils.getOracleSID(executionStep, primaryTarget);
            }
            throw new PatchPlanException("There is no RAC DB Instance running on" + executionStep.getHost().getHostName());
        }
        if (primaryTarget instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)primaryTarget;
            if (sidb.getAvailability().equals("yes")) {
                return sidb.getInstanceName();
            }
            if (null != sidb.getShardProperty() && null != sidb.getShardProperty().getIsDatabaseUp() && sidb.getShardProperty().getIsDatabaseUp().equalsIgnoreCase("Y")) {
                return sidb.getInstanceName();
            }
            throw new PatchPlanException("There is no sidb Instance running on" + executionStep.getHost().getHostName());
        }
        throw new PatchPlanException("Can not get OracleSID from " + primaryTarget.getClass().getName());
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder<SQLPatchUpgradeModeCommand> {
        @Override
        public SQLPatchUpgradeModeCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.SqlPatchDisableCluster.toString()) && !a.getType().equals(DBCommandActionType.SqlPatchStartupUpgradeMode.toString()) && !a.getType().equals(DBCommandActionType.SqlPatchEnableCluster.toString())) {
                return null;
            }
            return new SQLPatchUpgradeModeCommand((CommandAction)a);
        }
    }
}

