/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.Patchmd;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.VariableResolver;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.cookies.CRSMakeCloneHome;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.OPatchSingleton;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.ApplySqlAction;
import oracle.opatch.system.db.automation.jaxb.SqlCommandType;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class SqlCommand
extends Command {
    private static String applyType = "apply";
    private static String rollbackType = "rollback";
    private static String switchbackType = "switchback";
    private static String restoreType = "restore";
    private static String streamsType = "Streams";
    private static String startDGBrokerType = "startDGBroker";
    Logger logger = Logger.getLogger(SqlCommand.class.getName());
    ApplySqlAction sqlAutomationAction;
    boolean firstSqlCommand = true;

    public SqlCommand(ApplySqlAction automationAction) {
        super((ActionType)automationAction);
        this.sqlAutomationAction = automationAction;
    }

    public ExecutionStep getExecutionStep(CommandContext context) {
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        this.firstSqlCommand = true;
        if (applyType.equalsIgnoreCase(this.sqlAutomationAction.getType()) || rollbackType.equalsIgnoreCase(this.sqlAutomationAction.getType()) || switchbackType.equalsIgnoreCase(this.sqlAutomationAction.getType()) || restoreType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
            List<GenericPatch> patches = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString()));
            boolean isPatchmdExist = false;
            if (DBCommandUtils.shouldExecuteSqlCommand(primaryTarget, patches, (ActionType)this.sqlAutomationAction)) {
                if (DBCommandUtils.isPhysicalStandbyDatabase(primaryTarget)) {
                    context = DBCommandUtils.resetContextForStandbyDB(primaryTarget);
                }
                ExecutionStep executionStep = !this.IsStandaloneExecutionMode() ? CommandUtils.getBasicExecutionStep((ActionType)this.sqlAutomationAction, context, null) : this.getSqlPlusStep(context);
                if (this.automationAction.isActsOnClone() && DBCommandUtils.isRemoteDB(context.getPrimaryTarget())) {
                    this.logger.info("Current step is running on remote db " + context.getPrimaryTarget().getDisplayName() + ". Set acts_on_clone property to null");
                    executionStep.getAutomationAction().setActsOnClone(null);
                }
                for (GenericPatch patch : patches) {
                    if (!(patch instanceof OPatchSingleton) && !(patch instanceof CompositePatch)) continue;
                    String patchmdXMLContent = null;
                    if (patch instanceof OPatchSingleton) {
                        OPatchSingleton opatchPatch = (OPatchSingleton)patch;
                        patchmdXMLContent = opatchPatch.getPatchMDxml();
                    } else {
                        CompositePatch comPatch = (CompositePatch)patch;
                        patchmdXMLContent = comPatch.getPatchMDxml();
                    }
                    if (patchmdXMLContent == null || patchmdXMLContent.length() <= 0) continue;
                    isPatchmdExist = true;
                    try {
                        ExecutionStep.Command exeStepCmd;
                        Patchmd patchmd = new Patchmd(patchmdXMLContent);
                        String sqlcmd = null;
                        if (applyType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                            sqlcmd = this.buildSqlCmd(patchmd.getApplySQLPlusCommand());
                        } else if (rollbackType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                            sqlcmd = this.buildSqlCmd(patchmd.getRollbackSQLPlusCommand());
                        } else if (switchbackType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                            sqlcmd = this.buildSwitchbackCmd(context, patchmd.getRollbackSQLPlusCommand());
                        } else if (restoreType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                            sqlcmd = this.buildRestoreCmd(context, patchmd.getApplySQLPlusCommand());
                        }
                        if (!this.IsStandaloneExecutionMode()) {
                            exeStepCmd = new ExecutionStep.Command(this.wrapSqlSteps(executionStep, sqlcmd, context));
                            executionStep.getCommand().add(exeStepCmd);
                            continue;
                        }
                        exeStepCmd = new ExecutionStep.Command(sqlcmd, ExecutionStep.Command.CommandType.SQL);
                        executionStep.getCommand().add(exeStepCmd);
                    }
                    catch (Patchmd.PatchmdParsingException e) {
                        this.logger.log(Level.WARNING, "PatchmdParsingException occurred in SqlCommand.getExecutionStep()", e);
                    }
                }
                if (!this.IsStandaloneExecutionMode()) {
                    executionStep.getCommand().add(new ExecutionStep.Command(this.wrapSqlSteps(executionStep, "EXIT;", context)));
                    executionStep.getCommand().add(new ExecutionStep.Command(this.getSqlPlusStep(executionStep, context, isPatchmdExist)));
                    if (executionStep.getCommand().size() <= 2) {
                        return null;
                    }
                } else if (executionStep.getCommand().size() < 2) {
                    return null;
                }
                return executionStep;
            }
        } else {
            ExecutionStep executionStep = null;
            if (startDGBrokerType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                if (!DBCommandUtils.isDataGuardConfig(primaryTarget) || !DBCommandUtils.isUsingBroker(primaryTarget)) {
                    return executionStep;
                }
                if (DBCommandUtils.isPhysicalStandbyDatabase(primaryTarget)) {
                    context = DBCommandUtils.resetContextForStandbyDB(primaryTarget);
                }
            }
            if (!this.IsStandaloneExecutionMode()) {
                executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.sqlAutomationAction, context, null);
                executionStep.getCommand().addAll(this.getWrapSqlCommand(executionStep, context));
                executionStep.getCommand().add(new ExecutionStep.Command(this.wrapSqlSteps(executionStep, "EXIT;", context)));
                executionStep.getCommand().add(new ExecutionStep.Command(this.getSqlPlusStep(executionStep, context, true)));
            } else {
                executionStep = this.getSqlPlusStep(context);
                executionStep.getCommand().addAll(this.getSqlCommand(context));
            }
            return executionStep;
        }
        return null;
    }

    private String wrapSqlSteps(String cmd, String tmpSqlFile) {
        String wrapedStep;
        if (this.firstSqlCommand) {
            wrapedStep = "echo \"" + cmd + "\" > " + tmpSqlFile;
            this.firstSqlCommand = false;
        } else {
            wrapedStep = "echo \"" + cmd + "\" >> " + tmpSqlFile;
        }
        return wrapedStep;
    }

    private String wrapSqlSteps(ExecutionStep step, String cmd, CommandContext context) {
        String tmpSqlFile = this.getTmpSqlFile(step, context);
        if (cmd.contains("${Uppercase_ORACLE_SID}")) {
            cmd = cmd.replaceAll("\\$\\{Uppercase_ORACLE_SID\\}", this.getOracleSID(context).toUpperCase());
        }
        return this.wrapSqlSteps(cmd, tmpSqlFile);
    }

    private String getTmpSqlFile(ExecutionStep step, CommandContext context) {
        String oracleSID = DBCommandUtils.getOracleSID(step, context.getPrimaryTarget());
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        String ohName = oh.getName() == null ? "" : oh.getName().replace(" ", "");
        String user = oh.getOwner();
        String tmpSqlFile = "/tmp/" + ohName + "_" + user + "_" + oracleSID + ".sql";
        return tmpSqlFile;
    }

    private boolean IsStandaloneExecutionMode() {
        return ExecutionMode.STANDALONE.equals((Object)PatchPlanner.getInstance().getOPlanEnv().getExecutionMode());
    }

    private String getSqlPlusStep(ExecutionStep executionStep, CommandContext context, boolean flag) {
        String cmd = this.getSqlPlusStepCommand(executionStep, context);
        if (!this.IsStandaloneExecutionMode() && flag) {
            String tmpSqlFile = this.getTmpSqlFile(executionStep, context);
            cmd = cmd + " @" + tmpSqlFile;
        }
        return cmd;
    }

    private ExecutionStep getSqlPlusStep(CommandContext context) {
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.sqlAutomationAction, context, null);
        String cmd = this.getSqlPlusStepCommand(executionStep, context);
        executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        return executionStep;
    }

    private String getSqlPlusStepCommand(ExecutionStep executionStep, CommandContext context) {
        String cmd = null;
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        String scriptLocationRoot = this.getScriptLocationRoot(context);
        String oracleHomePath = this.getOracleHomePath(context);
        String OracleSid = DBCommandUtils.getOracleSID(executionStep, primaryTarget);
        if (!(primaryTarget instanceof SIDatabase || primaryTarget instanceof RACDatabase || primaryTarget instanceof RACDBInstance)) {
            throw new PatchPlanException("SqlCommand action can act only on RACDatabase, SIDatabase, but found: " + primaryTarget.getClass().getName());
        }
        cmd = "cd " + scriptLocationRoot + " ; ORACLE_HOME=" + oracleHomePath + " ORACLE_SID=" + OracleSid + " " + oh.getPath() + "/bin/sqlplus / as " + this.sqlAutomationAction.getConnectAs();
        return cmd;
    }

    private List<ExecutionStep.Command> getSqlCommand(CommandContext context) {
        ArrayList<ExecutionStep.Command> cmdList = new ArrayList<ExecutionStep.Command>();
        for (oracle.opatch.system.db.automation.jaxb.SqlCommand sc : this.sqlAutomationAction.getSqlCommand()) {
            String rep_sqlcmd = VariableResolver.replaceContextProperties(sc.getCommand().trim(), context);
            ExecutionStep.Command sqlcmd = new ExecutionStep.Command(rep_sqlcmd, ExecutionStep.Command.CommandType.SQL);
            if (sc.getErrorHandling() != null) {
                sqlcmd.setErrorMessage(sc.getErrorHandling().getFatalError());
            }
            cmdList.add(sqlcmd);
        }
        return cmdList;
    }

    private List<ExecutionStep.Command> getWrapSqlCommand(ExecutionStep step, CommandContext context) {
        ArrayList<ExecutionStep.Command> cmdList = new ArrayList<ExecutionStep.Command>();
        String tmpSqlFile = this.getTmpSqlFile(step, context);
        for (oracle.opatch.system.db.automation.jaxb.SqlCommand sc : this.sqlAutomationAction.getSqlCommand()) {
            String rep_sqlcmd = VariableResolver.replaceContextProperties(sc.getCommand().trim(), context);
            if (rep_sqlcmd.contains("&{Uppercase_ORACLE_SID}")) {
                rep_sqlcmd = rep_sqlcmd.replaceAll("\\$\\{Uppercase_ORACLE_SID\\}", this.getOracleSID(context).toUpperCase());
            }
            if (rep_sqlcmd.contains("\n")) {
                rep_sqlcmd = rep_sqlcmd.replaceAll("\n", " ");
                rep_sqlcmd = rep_sqlcmd.replaceAll("[ ]+", " ");
            }
            ExecutionStep.Command sqlcmd = new ExecutionStep.Command(this.wrapSqlSteps(rep_sqlcmd, tmpSqlFile));
            if (sc.getErrorHandling() != null) {
                sqlcmd.setErrorMessage(sc.getErrorHandling().getFatalError());
            }
            cmdList.add(sqlcmd);
        }
        return cmdList;
    }

    private String getOracleHomePath(CommandContext context) {
        if (switchbackType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
            SqlCommandType type = null;
            for (oracle.opatch.system.db.automation.jaxb.SqlCommand cmd : this.sqlAutomationAction.getSqlCommand()) {
                SqlCommandType cmdType = cmd.getType();
                if (type == null) {
                    type = cmdType;
                    continue;
                }
                if (cmdType.equals((Object)type)) continue;
                throw new IllegalArgumentException("Invalid automation xml: SQL command types under one apply-sql-action must all either be (INLINE_SOURCE and SCRIPT_IN_ORACLE_HOME) or (SCRIPT_IN_CLONED_ORACLE_HOME). Found both one of each variety in this case.");
            }
            if (SqlCommandType.SCRIPT_IN_CLONED_ORACLE_HOME.equals(type)) {
                String clonePath = this.getClonePath(context);
                return clonePath;
            }
            return context.getFirstTarget(OracleHome.class).getPath();
        }
        return context.getFirstTarget(OracleHome.class).getPath();
    }

    private String getScriptLocationRoot(CommandContext context) {
        SqlCommandType type = null;
        for (oracle.opatch.system.db.automation.jaxb.SqlCommand cmd : this.sqlAutomationAction.getSqlCommand()) {
            SqlCommandType tmp = cmd.getType();
            if (tmp.equals((Object)SqlCommandType.INLINE_SOURCE)) {
                tmp = SqlCommandType.SCRIPT_IN_ORACLE_HOME;
            }
            if (type == null) {
                type = tmp;
                continue;
            }
            if (tmp.equals((Object)type)) continue;
            throw new IllegalArgumentException("Invalid automation xml: SQL command types under one apply-sql-action must all either be (INLINE_SOURCE and SCRIPT_IN_ORACLE_HOME) or (SCRIPT_IN_CLONED_ORACLE_HOME). Found both one of each variety in this case.");
        }
        if (DBCommandUtils.isRemoteDB(context.getPrimaryTarget())) {
            type = SqlCommandType.SCRIPT_IN_ORACLE_HOME;
        }
        if (SqlCommandType.SCRIPT_IN_CLONED_ORACLE_HOME.equals((Object)type)) {
            String clonePath = this.getClonePath(context);
            return clonePath;
        }
        return context.getFirstTarget(OracleHome.class).getPath();
    }

    private String getOracleSID(CommandContext context) {
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)primaryTarget;
            return racDB.getDatabaseName();
        }
        if (primaryTarget instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)primaryTarget;
            return siDB.getDatabaseName();
        }
        throw new PatchPlanException("SqlCommand action can act only on RACDatabase, SIDatabase, but found: " + primaryTarget.getClass().getName());
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep executionStep;
            RACDBInstance dbInst;
            CommandContext context = contextPopulator.populateContext(g, abstractBaseTarget, this.getHost());
            if ((!CommandUtils.isSkipTargetCookieSet(this, abstractBaseTarget) || !this.sqlAutomationAction.getType().equals(DBCommandActionType.savePDBState.toString()) && !this.sqlAutomationAction.getType().equals(DBCommandActionType.discardPDBState.toString())) && this.sqlAutomationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if (abstractBaseTarget instanceof RACDBInstance && "racone".equals((dbInst = (RACDBInstance)abstractBaseTarget).getDbRAC().getDatabaseType()) && "no".equals(dbInst.getIsRunning()) || (executionStep = this.getExecutionStep(context)) == null) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    private String buildSqlCmd(String sqlScript) {
        if (sqlScript == null) {
            this.logger.log(Level.WARNING, "SqlCommand.buildSqlCmd(): Sql command is empty.");
            return "";
        }
        return sqlScript.replaceFirst("\\$ORACLE_HOME\\/", "@");
    }

    private String buildSwitchbackCmd(CommandContext context, String sqlScript) {
        String patchType = null;
        if (sqlScript.contains("catexa")) {
            patchType = "EXA";
        } else if (sqlScript.contains("catpsu")) {
            patchType = "PSU";
        } else if (sqlScript.contains("catcpu")) {
            patchType = "CPU";
        }
        String repSqlcmd = null;
        for (oracle.opatch.system.db.automation.jaxb.SqlCommand sc : this.sqlAutomationAction.getSqlCommand()) {
            String sqlcmd = sc.getCommand().trim();
            repSqlcmd = VariableResolver.replaceContextProperties(sqlcmd.replaceFirst("\\$\\{PATCH_TYPE\\}", patchType), context);
        }
        return repSqlcmd;
    }

    private String buildRestoreCmd(CommandContext context, String sqlScript) {
        if (sqlScript == null) {
            this.logger.log(Level.WARNING, "SqlCommand.buildSqlCmd(): Sql command is empty.");
            return "";
        }
        String clonePath = this.getClonePath(context);
        return sqlScript.replaceFirst("\\$ORACLE_HOME", "@" + clonePath);
    }

    private String getClonePath(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        String clonePath = null;
        if (db instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)db;
            clonePath = ((CRSMakeCloneHome)PatchPlanner.getInstance().getMakeCloneHome()).getClonePathforRAC(racDB, oh);
        } else if (db instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)db;
            clonePath = ((CRSMakeCloneHome)PatchPlanner.getInstance().getMakeCloneHome()).getClonePathforSIDB(siDB, oh);
        }
        return clonePath;
    }

    @Override
    public boolean shouldIncludeStepInExecutionMode(ExecutionMode exeMode) {
        return !ExecutionMode.OPATCH.equals((Object)exeMode) || !streamsType.equalsIgnoreCase(this.sqlAutomationAction.getType());
    }

    public static class Builder
    implements CommandBuilder<SqlCommand> {
        @Override
        public SqlCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof ApplySqlAction)) {
                return null;
            }
            return new SqlCommand((ApplySqlAction)a);
        }
    }
}

