/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class StopStartDbConsole
extends Command {
    private final DBCommandActionType type;
    private final Strategy strat;

    public StopStartDbConsole(ActionType automationAction, DBCommandActionType type, Strategy strat) {
        super(automationAction);
        assert (DBCommandActionType.StartDbConsole.equals((Object)type) || DBCommandActionType.StopDbConsole.equals((Object)type));
        this.type = type;
        this.strat = strat;
    }

    private String getCommandForHost(String dbName, OracleHome oh) {
        String cmd = "if [ -d $(echo " + oh.getPath() + "/oc4j/j2ee/OC4J_DBConsole_" + ((Host)oh.getHosts().get(0)).getHostName() + "*_" + dbName + ") -a -d $(echo " + oh.getPath() + "/" + ((Host)oh.getHosts().get(0)).getHostName() + "*_" + dbName + ") ]; then  " + oh.getPath() + "/bin/emctl " + (DBCommandActionType.StartDbConsole.equals((Object)this.type) ? "start" : "stop") + " dbconsole; else echo 'dbconsole not configured, hence skipping this step.'; fi";
        return cmd;
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        List<? extends AbstractBaseTarget> ohs = actsOnlyOnTargets;
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (OracleHome oracleHome : ohs) {
            CommandContext context = contextPopulator.populateContext(g, (AbstractBaseTarget)oracleHome, this.getHost());
            contextPopulator.fixCloneContext(context);
            OracleHome oh = context.getFirstTarget(OracleHome.class);
            if (!CommandUtils.shouldShutdownRACInstance(this.getPatchingPhase(), oh.getPath())) continue;
            if (Strategy.DCLI.equals((Object)this.strat)) {
                return this.generateDCLIExecutionSteps(g, actsOnlyOnTargets);
            }
            return this.generateNormalExecutionSteps(g, actsOnlyOnTargets);
        }
        return Collections.emptyList();
    }

    protected List<ExecutionStep> generateNormalExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            if (!this.isValidTarget(abstractBaseTarget)) {
                throw new PatchPlanException("StopStartDbConsole action can act only on RACDBInstance, but found: " + abstractBaseTarget.getClass().getName());
            }
            CommandContext cc = this.getCommandContext(abstractBaseTarget, g);
            ExecutionStep es = CommandUtils.getBasicExecutionStep(this.automationAction, cc, null);
            OracleHome oh = cc.getFirstTarget(OracleHome.class);
            ArrayList<String> cmds = new ArrayList<String>();
            String DB_LOG = oh.getPath() + File.separator + "cfgtoollogs" + File.separator + "opatchautodb";
            String fileLoc = DB_LOG + File.separator + "dbconsole_exe";
            cmds.add("mkdir -p -m 775 " + DB_LOG);
            cmds.add("echo '#!/bin/bash' > " + fileLoc);
            String dbconsoleCmd = this.getCommandForTarget(abstractBaseTarget, cc, es);
            cmds.add("echo '" + dbconsoleCmd + "' >> " + fileLoc);
            cmds.add("echo 'RESULT=$?' >>" + fileLoc);
            cmds.add("echo 'exit $RESULT' >>" + fileLoc);
            cmds.add("chmod +x " + fileLoc);
            cmds.add("ORACLE_UNQNAME=" + this.getDBName(abstractBaseTarget) + " " + fileLoc);
            cmds.add("rm -rf " + fileLoc);
            for (String cmd : cmds) {
                es.getCommand().add(new ExecutionStep.Command(cmd));
            }
            steps.add(es);
        }
        return steps;
    }

    private String getDBName(AbstractBaseTarget abt) {
        if (abt instanceof RACDBInstance) {
            RACDBInstance racDB = (RACDBInstance)abt;
            return racDB.getDbRAC().getDatabaseName();
        }
        if (abt instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)abt;
            return siDB.getDatabaseName();
        }
        throw new PatchPlanException("StopStartDbConsole action can act only on RACDBInstance and SIDatabase, but found: " + abt.getClass().getName());
    }

    private boolean isValidTarget(AbstractBaseTarget abt) {
        return abt instanceof RACDBInstance || abt instanceof SIDatabase;
    }

    protected List<ExecutionStep> generateDCLIExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        HashMap<AbstractBaseTarget, ExecutionStep> db2step = new HashMap<AbstractBaseTarget, ExecutionStep>();
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep es;
            if (!this.isValidTarget(abstractBaseTarget)) {
                throw new PatchPlanException("StopStartDbConsole action can act only on RACDBInstance, but found: " + abstractBaseTarget.getClass().getName());
            }
            CommandContext cc = this.getCommandContext(abstractBaseTarget, g);
            AbstractBaseTarget mapObj = abstractBaseTarget;
            if (abstractBaseTarget instanceof RACDBInstance) {
                RACDBInstance inst = (RACDBInstance)abstractBaseTarget;
                mapObj = inst.getDbRAC();
            }
            ExecutionStep executionStep = es = (es = (ExecutionStep)db2step.get(mapObj)) != null ? es : CommandUtils.getBasicExecutionStep(this.automationAction, cc, null);
            if (!steps.contains(es)) {
                steps.add(es);
            }
            String cmd = this.getCommandForTarget(abstractBaseTarget, cc, es);
            es.getCommand().add(new ExecutionStep.Command(cmd));
            if (db2step.get(mapObj) != null) continue;
            db2step.put(mapObj, es);
        }
        return steps;
    }

    private CommandContext getCommandContext(AbstractBaseTarget abt, ConfigGraph g) {
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        CommandContext cc = contextPopulator.populateContext(g, abt, this.getHost());
        if (this.automationAction.isActsOnClone()) {
            contextPopulator.fixCloneContext(cc);
        }
        return cc;
    }

    private String getCommandForTarget(AbstractBaseTarget abt, CommandContext cc, ExecutionStep es) {
        String dbName = this.getDBName(abt);
        String cmd = this.getCommandForHost(dbName, cc.getFirstTarget(OracleHome.class));
        if (Strategy.DCLI.equals((Object)this.strat)) {
            cmd = CommandUtils.dcliPrefix(cmd, cc.getTargets(Host.class), es.getUser().getValue());
        }
        return cmd;
    }

    @Override
    protected boolean includeTargetByVersion(ConfigGraph configGraph, AbstractBaseTarget abstractBaseTarget, ExecutionMode executionMode) {
        return true;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && (a.getType().equals(DBCommandActionType.StartDbConsole.toString()) || a.getType().equals(DBCommandActionType.StopDbConsole.toString()))) {
                return new StopStartDbConsole(a, DBCommandActionType.valueOf(a.getType()), s);
            }
            return null;
        }
    }
}

