/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class StopStartSidbOnly
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(StopStartSidbOnly.class.getName());
    CommandAction automationAction;

    public StopStartSidbOnly(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> executionSteps = new ArrayList();
        executionSteps = super.generateExecutionSteps(configGraph, actsOnlyOnTargets);
        return executionSteps;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        String sidbOnlyOperationFile;
        this.logger.log(Level.FINE, "Generating stopstartsidbOnly command.");
        OracleHome oh = context.getTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        this.logger.log(Level.FINE, "context hostname " + db.getHostName());
        String sid = SessionData.getInstance().getSID();
        SystemInstance instance = PatchPlanner.getInstance().getConfigGraph().getSystemInstance();
        String dbName = "";
        String instName = "";
        for (BaseClass b : instance.getEntities()) {
            if (!(b instanceof SIDatabase)) continue;
            SIDatabase sidb = (SIDatabase)b;
            this.logger.log(Level.FINE, "sidb.getHost().getHostName() " + sidb.getHost().getHostName());
            this.logger.log(Level.FINE, "sidb.getRuns_from().getPath() " + sidb.getRuns_from().getPath());
            if (!db.getHostName().equalsIgnoreCase(sidb.getHost().getHostName()) || !db.getHostName().equals(sidb.getRuns_from().getPath())) continue;
            dbName = sidb.getDatabaseName();
            instName = sidb.getInstanceName();
            this.logger.log(Level.FINE, "SIDB database name: " + dbName);
            this.logger.log(Level.FINE, "SIDB instance name: " + dbName);
        }
        String dbTmp = oh.getPath() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP;
        ArrayList<String> cmds = new ArrayList<String>();
        if (this.automationAction.getType().equals(DBCommandActionType.StopSIDBOnly.toString())) {
            sidbOnlyOperationFile = dbTmp + "stop_" + sid + ".sql";
            cmds.add("rm -f " + sidbOnlyOperationFile);
            cmds.add("echo 'alter pluggable database all save state;' > " + sidbOnlyOperationFile);
            cmds.add("echo 'shutdown immediate;' >> " + sidbOnlyOperationFile);
        } else {
            sidbOnlyOperationFile = dbTmp + "start_" + sid + ".sql";
            cmds.add("rm -f " + sidbOnlyOperationFile);
            cmds.add("echo 'startup' > " + sidbOnlyOperationFile);
        }
        cmds.add("echo 'quit' >> " + sidbOnlyOperationFile);
        String sqlPlusCmd = "cd " + oh.getPath() + "; ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + sid + " ./bin/sqlplus / as sysdba @";
        sqlPlusCmd = "/bin/sh -c '" + sqlPlusCmd + sidbOnlyOperationFile + "'";
        cmds.add(sqlPlusCmd);
        return cmds;
    }

    public static class Builder
    implements CommandBuilder<StopStartSidbOnly> {
        @Override
        public StopStartSidbOnly getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && (a.getType().equals(DBCommandActionType.StopSIDBOnly.toString()) || a.getType().equals(DBCommandActionType.StartSIDBOnly.toString()))) {
                return new StopStartSidbOnly((CommandAction)a);
            }
            return null;
        }
    }
}

