/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.crs;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.driver.crs.AbstractCrsProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.crs.util.CRSutil;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.ASMCluster;
import dbmodel.db_crs.ASMInstance;
import dbmodel.db_crs.DBService;
import dbmodel.db_crs.DBServiceNode;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.PDB;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.cmdtools.SRVCTLUtil;
import oracle.cluster.common.Cluster;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.Service;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nodeapps.NodeException;

public class CrsProductDriver
extends AbstractCrsProductDriver {
    Logger logger = Logger.getLogger(CrsProductDriver.class.getName());
    ArrayList<File> dbHomes = new ArrayList();
    private boolean isAdminPolicyDBMixedSetup = false;
    private Map<String, String> dbForSkipping = new HashMap<String, String>();
    private Map<String, String> dbForPatching = new HashMap<String, String>();
    private List<String> lowerVersionSkippedDBHomeList = null;
    private Map<String, Integer> databasePerHome = new HashMap<String, Integer>();
    private List<OracleHome> inActiveHomeList;
    private String gimr_home_path = "";

    private CrsProductDriver() {
    }

    public static final CrsProductDriver getCrsProductDriverForRootAccess() {
        CrsProductDriver driver = new CrsProductDriver();
        return driver;
    }

    public static final CrsProductDriver getCrsProductDriverForNonRootAccess(String walletLoc, char[] walletCharPwd) {
        CrsProductDriver driver = new CrsProductDriver();
        driver.walletLoc = walletLoc;
        driver.walletCharPwd = walletCharPwd;
        return driver;
    }

    public SystemInstance buildSystemInstance(List<String> oracleHomes) throws ProductDriverException {
        CRSutil.setupLogs();
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "constructConfigGraphForSepecifiedHomes");
        if (oracleHomes == null || oracleHomes.size() < 1) {
            throw new ProductDriverException("Invalid oracle home targets", ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        this.ti = new SystemInstance();
        boolean giHomeSpecified = false;
        boolean sfwOnlySpecified = false;
        File gridHome = new File(this.detectCrsHome());
        ArrayList<File> softwareOnlyGridHomes = new ArrayList<File>();
        for (String home : oracleHomes) {
            File homef = new File(home);
            this.userSpecifiedHomes.add(homef);
            if (this.crsSftwareInsOnly.contains(homef)) {
                this.logger.log(Level.INFO, "Software-only grid home is specified.");
                sfwOnlySpecified = true;
                softwareOnlyGridHomes.add(homef);
                continue;
            }
            if (gridHome.equals(homef)) {
                this.logger.log(Level.INFO, "Configured grid home is specified.");
                giHomeSpecified = true;
                continue;
            }
            this.dbHomes.add(homef);
        }
        this.crsSftwareInsOnly = softwareOnlyGridHomes;
        boolean stackRunning = this.isStackRunning();
        Cluster cluster = null;
        String clusterName = "";
        if (this.crsType == AbstractCrsProductDriver.CrsType.CRS || this.crsType == AbstractCrsProductDriver.CrsType.SOFTWARE_ONLY) {
            if (stackRunning) {
                cluster = this.getSrvmCluster();
                clusterName = cluster.getName();
            } else {
                Properties prop = this.getConfigProperties();
                clusterName = prop.getProperty("CLUSTER_NAME", "");
            }
            if (!giHomeSpecified) {
                clusterName = "";
            }
            this.crsCluster = this.makeClusterObj(clusterName);
            if (CrsProductDriver.isExadata()) {
                this.crsCluster.setHWtype("EXADATA");
            } else {
                this.crsCluster.setHWtype("NON-EXADATA");
            }
            this.getLocalInfo();
            this.crsCluster.setVersion(this.getCrsVersion(stackRunning));
            this.makeNodes();
            this.addHostToLocalInfo();
        } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
            this.siha = this.makeSIHAObj();
            this.getLocalInfo();
            this.siha.setVersion(this.getCrsVersion(stackRunning));
            this.makeNodesForSIHA();
            this.addHostToLocalInfo();
        }
        this.getLocalInfo();
        this.addHostToLocalInfo();
        if (giHomeSpecified || sfwOnlySpecified) {
            this.makeCrsHomes();
            if (giHomeSpecified && stackRunning) {
                if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                    this.makeCrsDaemons();
                    this.makeASM();
                } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                    this.makeASMForSIHA();
                    this.makeSIHAHome();
                }
            }
        }
        if (stackRunning) {
            String crsHomePath;
            if (giHomeSpecified) {
                if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                    if (DBPatchingUtil.isVersionEqalOrlater(this.crsCluster.getVersion(), "20.0.0.0.0") && !DBPatchingUtil.isVersionEqalOrlater(this.crsCluster.getVersion(), "23.0.0.0.0")) {
                        try {
                            crsHomePath = this.detectCrsHome();
                            this.logger.log(Level.INFO, "crs cluster home " + crsHomePath);
                            SRVCTLUtil util = new SRVCTLUtil(crsHomePath);
                            String gimrHome = util.getMgmtDBHome();
                            this.logger.log(Level.INFO, "GIMR home path " + gimrHome);
                            if (null != gimrHome && gimrHome.length() > 0 && this.dbHomes.size() > 0) {
                                ArrayList<File> gimr = new ArrayList<File>();
                                File gimrDir = new File(gimrHome);
                                if (!gimrDir.getCanonicalPath().equals(crsHomePath)) {
                                    for (File home : this.dbHomes) {
                                        if (gimrDir.compareTo(home) != 0) continue;
                                        gimr.add(gimrDir);
                                        this.makeDBHomes(gimr);
                                        this.logger.log(Level.INFO, "Creating GIMR home from " + gimrHome);
                                        this.gimr_home_path = gimrHome;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(Level.INFO, "Unable to identify any GIMR home");
                        }
                    }
                    this.makeDBs(cluster);
                } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                    this.makeDBsForSIHA();
                }
            } else if (this.dbHomes.size() > 0) {
                this.makeDBHomes(this.dbHomes);
                if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                    if (DBPatchingUtil.isVersionEqalOrlater(this.crsCluster.getVersion(), "20.0.0.0.0") && !DBPatchingUtil.isVersionEqalOrlater(this.crsCluster.getVersion(), "23.0.0.0.0")) {
                        try {
                            File gimrDir;
                            crsHomePath = this.detectCrsHome();
                            this.logger.log(Level.INFO, "crs cluster home " + crsHomePath);
                            SRVCTLUtil util = new SRVCTLUtil(crsHomePath);
                            String gimrHome = util.getMgmtDBHome();
                            this.logger.log(Level.INFO, "GIMR home path " + gimrHome);
                            if (null != gimrHome && gimrHome.length() > 0 && this.dbHomes.size() > 0 && !(gimrDir = new File(gimrHome)).getCanonicalPath().equals(crsHomePath)) {
                                for (File home : this.dbHomes) {
                                    if (gimrDir.compareTo(home) != 0) continue;
                                    this.logger.log(Level.INFO, "Creating GIMR home from " + gimrHome);
                                    this.gimr_home_path = gimrHome;
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(Level.INFO, "Unable to identify any GIMR home");
                        }
                    }
                    this.makeDBs(cluster);
                } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                    this.makeDBsForSIHA();
                }
            }
        } else {
            this.makeDBHomes(this.dbHomes);
        }
        this.setHomeIds();
        this.cleanUpInactiveHomes(oracleHomes);
        return this.ti;
    }

    private void checkCRSSIHA() {
        block5: {
            File gridHome = new File(this.detectCrsHome());
            ClusterwareInfo crsInfo = new ClusterwareInfo();
            try {
                if (crsInfo.isCRSConfigured(gridHome.getAbsolutePath())) {
                    this.crsType = AbstractCrsProductDriver.CrsType.CRS;
                    break block5;
                }
                if (crsInfo.isHAConfigured(gridHome.getAbsolutePath())) {
                    this.crsType = AbstractCrsProductDriver.CrsType.SIHA;
                    break block5;
                }
                if (this.crsSftwareInsOnly.size() > 0) {
                    this.crsType = AbstractCrsProductDriver.CrsType.SOFTWARE_ONLY;
                    break block5;
                }
                throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            catch (InstallException e) {
                this.logger.log(Level.INFO, e.getMessage());
            }
        }
    }

    private boolean isCRSHASRunning() {
        boolean isRunning = false;
        File gridHome = new File(this.detectCrsHome());
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                isRunning = crsInfo.isCRSRunning(gridHome.getAbsolutePath());
            } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                isRunning = crsInfo.isHARunning(gridHome.getAbsolutePath());
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, e.getMessage());
        }
        this.logger.log(Level.INFO, "isRunning: " + isRunning);
        return isRunning;
    }

    public boolean isSIHA() {
        return this.crsType == AbstractCrsProductDriver.CrsType.SIHA;
    }

    @Override
    boolean isStackRunning() {
        boolean running = false;
        String crsHomePath = this.detectCrsHome();
        File gridHome = new File(crsHomePath);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (crsInfo.isCRSConfigured(crsHomePath)) {
                this.crsType = AbstractCrsProductDriver.CrsType.CRS;
            } else if (crsInfo.isHAConfigured(crsHomePath)) {
                this.crsType = AbstractCrsProductDriver.CrsType.SIHA;
            } else if (this.crsSftwareInsOnly.size() > 0) {
                this.crsType = AbstractCrsProductDriver.CrsType.SOFTWARE_ONLY;
            } else {
                throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            this.logger.log(Level.INFO, "crsType: " + (Object)((Object)this.crsType));
            if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                running = crsInfo.isCRSRunning(gridHome.getAbsolutePath());
            } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                running = crsInfo.isHARunning(gridHome.getAbsolutePath());
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, e.getMessage());
        }
        this.logger.log(Level.INFO, "running: " + running);
        return running;
    }

    protected HAS makeSIHAObj() {
        HAS has = new HAS();
        this.defaultValues((AbstractBaseTarget)has);
        has.setDBInstance(new ArrayList());
        has.setInstanceASM(new ArrayList());
        this.ti.getEntities().add(has);
        this.ti.setTop((AbstractBaseTarget)has);
        return has;
    }

    protected void buildSIHASystemInstance() throws ProductDriverException {
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "buildSIHASystemInstance");
        this.ti = new SystemInstance();
        this.siha = this.makeSIHAObj();
        this.getLocalInfo();
        this.siha.setVersion(this.getCrsVersion(this.isStackRunning()));
        this.makeNodesForSIHA();
        this.addHostToLocalInfo();
        this.makeCrsHomes();
        if (this.isCRSHASRunning()) {
            this.makeASMForSIHA();
        }
        this.makeDBsForSIHA();
        this.makeSIHAHome();
        this.setHomeIds();
    }

    private void makeSIHAHome() {
        if (this.gihomes.get(this.siha.getHost()) != null) {
            ((OracleHome)this.gihomes.get(this.siha.getHost())).getInstalledSWComponents().add(this.siha);
            OracleHome home = (OracleHome)this.gihomes.get(this.siha.getHost());
            home.setHomeType("siha");
            this.siha.setRuns_from(home);
        }
    }

    protected void buildCRSSystemInstance() throws ProductDriverException {
        Cluster cluster = null;
        String clusterName = null;
        cluster = this.getSrvmCluster();
        clusterName = cluster.getName();
        this.crsCluster = this.makeClusterObj(clusterName);
        this.getLocalInfo();
        this.crsCluster.setVersion(this.getCrsVersion(this.isStackRunning()));
        if (CrsProductDriver.isExadata()) {
            this.crsCluster.setHWtype("EXADATA");
        } else {
            this.crsCluster.setHWtype("NON-EXADATA");
        }
        this.makeNodes();
        this.addHostToLocalInfo();
        this.makeCrsHomes();
        if (this.isCRSHASRunning()) {
            this.makeASM();
        }
        this.makeDBs(cluster);
        if (DBPatchingUtil.isVersionEqalOrlater(this.crsCluster.getVersion(), "20.0.0.0.0") && !DBPatchingUtil.isVersionEqalOrlater(this.crsCluster.getVersion(), "23.0.0.0.0")) {
            try {
                this.logger.log(Level.INFO, "crs cluster version " + this.crsCluster.getVersion());
                String crsHomePath = this.detectCrsHome();
                this.logger.log(Level.INFO, "crs cluster home " + crsHomePath);
                SRVCTLUtil util = new SRVCTLUtil(crsHomePath);
                String gimrHome = util.getMgmtDBHome();
                this.logger.log(Level.INFO, "GIMR home path " + gimrHome);
                if (null != gimrHome && gimrHome.length() > 0) {
                    ArrayList<File> gimr = new ArrayList<File>();
                    File gimrDir = new File(gimrHome);
                    if (!gimrDir.getCanonicalPath().equals(crsHomePath)) {
                        gimr.add(new File(gimrHome));
                        this.makeDBHomes(gimr);
                        this.logger.log(Level.INFO, "Creating GIMR home from " + gimrHome);
                        this.gimr_home_path = gimrHome;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.makeCrsDaemons();
        this.setHomeIds();
        this.checkDBUnpresentOnLocalNode(cluster);
        this.cleanUpInactiveHomes(null);
    }

    public SystemInstance buildSystemInstance() throws ProductDriverException {
        CRSutil.setupLogs();
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "buildSystemInstance");
        this.ti = new SystemInstance();
        this.checkCRSSIHA();
        if (this.isSIHA()) {
            this.buildSIHASystemInstance();
        } else {
            this.buildCRSSystemInstance();
        }
        for (BaseClass b : this.ti.getEntities()) {
            this.logger.log(Level.INFO, b.getLeafClassName() + " object:" + b.getId());
        }
        this.logger.exiting(((Object)((Object)this)).getClass().getName(), "buildSystemInstance");
        return this.ti;
    }

    Cluster getSrvmCluster() {
        try {
            CommonFactory cf = CommonFactory.getInstance();
            return cf.getCluster();
        }
        catch (ClusterException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (ManageableEntityException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public void checkDBUnpresentOnLocalNode(Cluster cluster) {
        boolean existed = false;
        try {
            for (Database sdb : cluster.fetchDatabases()) {
                OracleHome localHome = this.getLocalInfo().getHome(sdb.getOracleHome());
                if (localHome != null) continue;
                if (!existed) {
                    Reporting.report((String)"Following home(s) will not be included as part of current opatchauto session as they do not run from the current host.");
                    existed = true;
                }
                Reporting.report((String)("\tDatabase Name: " + sdb.getDBName()));
                Reporting.report((String)("\tOracle Home: " + sdb.getOracleHome()));
                Reporting.report((String)"\tHost: ");
                for (DatabaseInstance inst : sdb.configuredInstances()) {
                    Reporting.report((String)(" " + inst.node().getHostName()));
                }
            }
            if (existed) {
                Reporting.report((String)"\nTo complete the patching process for the above databases, execute it on host where the databases are running.");
            }
        }
        catch (ClusterException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            return;
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (InstanceException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    private String getCrsVersion(boolean stackRunning) {
        this.logger.entering(CrsProductDriver.class.getName(), "getCrsVersion");
        if (!stackRunning) {
            this.logger.log(Level.INFO, "CRS stack is down. Now getting crs version by OUI.");
            this.haVersion = this.getCrsVersion();
            return this.haVersion;
        }
        File ohpath = new File(this.detectCrsHome());
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            this.haVersion = this.crsType != AbstractCrsProductDriver.CrsType.CRS ? crsInfo.getSIHAReleaseVersionString(ohpath.getAbsolutePath()) : crsInfo.getCRSActiveVersionString(ohpath.getAbsolutePath());
            return this.haVersion;
        }
        catch (NoSuchExecutableException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoSuchCRSHomeException e) {
            throw new ProductDriverException("OracleHome Path given does not exist", (Throwable)e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (ClusterInfoException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (InstallException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    private static File getTargetHome() {
        String oh = System.getenv("ORACLE_HOME");
        if (oh == null) {
            StringBuffer msg = new StringBuffer(" ORACLE_HOME environment variable is not set.");
            throw new ProductDriverException(msg.toString());
        }
        File f = new File(oh);
        if (!f.exists()) {
            StringBuffer msg = new StringBuffer("OracleHome:");
            msg.append(f.getAbsolutePath());
            msg.append(" doesn't exist.");
            throw new ProductDriverException(msg.toString());
        }
        return f;
    }

    public void makeASM() {
        try {
            this.logger.info("oracle.installer.library_loc set    to " + System.getProperty("oracle.installer.library_loc"));
            ASMFactory factory = ASMFactory.getInstance();
            ASM srvmAsm = factory.getASM();
            ASMCluster asmCluster = new ASMCluster();
            asmCluster.setASMinstances(this.makeASMInstances(srvmAsm));
            asmCluster.setName(srvmAsm.getName());
            this.defaultValues((AbstractBaseTarget)asmCluster);
            this.crsCluster.setASMCluster(asmCluster);
            this.ti.getEntities().add(asmCluster);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            this.logger.log(Level.WARNING, "ASM not found ", e);
        }
        catch (AlreadyStoppedException e) {
            this.logger.log(Level.INFO, "Unable to detect ASM information", e);
        }
    }

    public void makeASMForSIHA() {
        try {
            ASMFactory factory = ASMFactory.getInstance();
            ASM srvmAsm = factory.getASM();
            this.siha.setInstanceASM(this.makeASMInstances(srvmAsm));
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            this.logger.log(Level.WARNING, "ASM not found ", e);
        }
        catch (AlreadyStoppedException e) {
            this.logger.log(Level.INFO, "Unable to detect ASM information", e);
        }
    }

    private List<ASMInstance> makeASMInstances(ASM srvmAsm) throws AlreadyStoppedException {
        try {
            int i;
            List srvmAsmInstances = srvmAsm.instances();
            ArrayList<ASMInstance> asmInstances = new ArrayList<ASMInstance>();
            for (i = 0; i < srvmAsmInstances.size(); ++i) {
                if (((oracle.cluster.asm.ASMInstance)srvmAsmInstances.get(i)).node().getName() == null || ((oracle.cluster.asm.ASMInstance)srvmAsmInstances.get(i)).node().getName().length() == 0) continue;
                asmInstances.add(new ASMInstance());
                ((ASMInstance)asmInstances.get(i)).setName(((oracle.cluster.asm.ASMInstance)srvmAsmInstances.get(i)).getName());
                this.defaultValues((AbstractBaseTarget)asmInstances.get(i));
                String nodeName = ((oracle.cluster.asm.ASMInstance)srvmAsmInstances.get(i)).node().getName();
                Host host = this.findHostByName(nodeName);
                ((OracleHome)this.gihomes.get(host)).getInstalledSWComponents().add(asmInstances.get(i));
                ((ASMInstance)asmInstances.get(i)).setRuns_from((OracleHome)this.gihomes.get(host));
            }
            for (i = 0; i < asmInstances.size(); ++i) {
                this.ti.getEntities().add(asmInstances.get(i));
            }
            return asmInstances;
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public void makeDBsForSIHA() {
        try {
            DatabaseFactory fact = DatabaseFactory.getInstance();
            Map dbInfos = fact.getDatabaseInfos();
            Set dbuniqnames = dbInfos.keySet();
            for (String dbname : dbuniqnames) {
                SIDatabase sidb;
                Database sdb;
                this.logger.info("dbname: " + dbname);
                List list = (List)dbInfos.get(dbname);
                this.logger.info("list: " + list);
                if (list == null || list.size() <= 1) continue;
                Version version = (Version)list.get(1);
                this.logger.info("version: " + version);
                try {
                    sdb = fact.getDatabase(dbname, version);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    this.logger.info("exception message: " + message);
                    if (message.indexOf("PRCD-1027") != -1 || message.indexOf("PRCD-1229") != -1) {
                        if (this.lowerVersionSkippedDBHomeList == null) {
                            this.lowerVersionSkippedDBHomeList = new ArrayList<String>();
                        }
                        this.lowerVersionSkippedDBHomeList.add((String)list.get(0));
                        continue;
                    }
                    throw e;
                }
                if (this.userSpecifiedHomes.size() > 0 && !this.dbHomes.contains(new File(sdb.getOracleHome()))) continue;
                this.updateDBPerHome(sdb);
                OracleHome localHome = this.getLocalInfo().getHome(sdb.getOracleHome());
                if (localHome == null || (sidb = this.makeSIDatabase(sdb)) == null) continue;
                this.siha.getDBInstance().add(sidb);
            }
        }
        catch (NotExistsException e) {
            this.logger.log(Level.WARNING, "Unable to detect any databases in SIHA", e);
            System.out.println("Warning: Unable to detect any databases in SIHA.");
            return;
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (Exception e) {
            if (e instanceof ProductDriverException) {
                throw e;
            }
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public void makeDBs(Cluster cluster) {
        try {
            String path;
            List<Database> dbList = new ArrayList();
            try {
                dbList = cluster.fetchDatabases();
                this.logger.info("dbList.size: " + dbList.size());
            }
            catch (Exception e) {
                String message = e.getMessage();
                this.logger.info("exception message: " + message);
                if (message.indexOf("PRCD-1027") != -1 || message.indexOf("PRCD-1229") != -1) {
                    ClusterwareInfo info = new ClusterwareInfo();
                    List dbuniqnames = info.getHAManagedDatabases(this.detectCrsHome());
                    DatabaseFactory fact = DatabaseFactory.getInstance();
                    block11: for (Iterator dbname : dbuniqnames) {
                        try {
                            dbList.add(fact.getDatabase((String)((Object)dbname)));
                        }
                        catch (Exception e1) {
                            String msg = e1.getMessage();
                            this.logger.info("exception msg: " + msg);
                            if (msg.indexOf("PRCD-1027") != -1 || message.indexOf("PRCD-1229") != -1) {
                                Map dbInfo = fact.getDatabaseInfos();
                                Set keySet = dbInfo.keySet();
                                for (String s : keySet) {
                                    this.logger.info("keySet: " + s);
                                    if (!s.equalsIgnoreCase((String)((Object)dbname))) continue;
                                    List list = (List)dbInfo.get(s);
                                    this.logger.info("list: " + list);
                                    if (list == null || list.size() <= 0) continue block11;
                                    if (this.lowerVersionSkippedDBHomeList == null) {
                                        this.lowerVersionSkippedDBHomeList = new ArrayList<String>();
                                    }
                                    this.lowerVersionSkippedDBHomeList.add((String)list.get(0));
                                    continue block11;
                                }
                                continue;
                            }
                            throw e1;
                        }
                    }
                }
                throw e;
            }
            boolean isAdminDB = false;
            boolean isPolicyDB = false;
            for (Database sdb : dbList) {
                if (this.userSpecifiedHomes.size() > 0 && !this.dbHomes.contains(new File(sdb.getOracleHome()))) continue;
                if (this.isAdminManagedDB(sdb)) {
                    isAdminDB = true;
                } else {
                    isPolicyDB = true;
                }
                if (isAdminDB && isPolicyDB && !this.isAdminPolicyDBMixedSetup) {
                    this.isAdminPolicyDBMixedSetup = true;
                }
                this.updateDBPerHome(sdb);
            }
            this.logger.info("isAdminPolicyDBMixedSetup: " + this.isAdminPolicyDBMixedSetup);
            for (Database sdb : dbList) {
                OracleHome localHome;
                if (this.userSpecifiedHomes.size() > 0 && !this.dbHomes.contains(new File(sdb.getOracleHome())) || (localHome = this.getLocalInfo().getHome(sdb.getOracleHome())) == null) continue;
                if (sdb.isClusterDatabase()) {
                    this.logger.info("Detected as RAC");
                    this.makeRACDatabase(sdb);
                    continue;
                }
                this.logger.info("Detected as SIDB");
                SIDatabase sidb = this.makeSIDatabase(sdb);
                if (sidb == null) continue;
                this.crsCluster.getDbSI().add(sidb);
            }
            ArrayList<String> racInstancesFromHome = new ArrayList<String>();
            ArrayList<String> SIDBsFromHome = new ArrayList<String>();
            String localhost = this.localInfo.getLocalHost().getName();
            HashMap remoteRACMap = new HashMap();
            for (Host h : this.ti.getTargetsOfType(Host.class)) {
                remoteRACMap.put(h.getName(), new ArrayList());
            }
            for (RACDatabase rdb : this.crsCluster.getDbRAC()) {
                this.logger.info("Checking RAC instances for " + rdb.getDatabaseName());
                path = rdb.getOracleHome();
                for (RACDBInstance dbinst : rdb.getDbInstances()) {
                    String host = dbinst.getHost().getName();
                    this.logger.info("Home " + dbinst.getRuns_from().getPath() + " contains RAC instance " + dbinst.getInstanceName() + " on node " + host);
                    if (dbinst.getHost().getName().equals(localhost)) {
                        if (racInstancesFromHome.contains(path)) continue;
                        racInstancesFromHome.add(path);
                        continue;
                    }
                    if (((ArrayList)remoteRACMap.get(host)).contains(path)) continue;
                    ((ArrayList)remoteRACMap.get(host)).add(path);
                }
            }
            this.logger.info("Remote RAC map : " + remoteRACMap.toString());
            for (SIDatabase sidb : this.crsCluster.getDbSI()) {
                this.logger.info("checking SIDB " + sidb.getName() + " instance " + sidb.getInstanceName());
                path = sidb.getOracleHome();
                if (!sidb.getHost().getName().equals(localhost)) continue;
                this.logger.info("Home " + sidb.getRuns_from().getPath() + " contains SIDB " + sidb.getName());
                if (SIDBsFromHome.contains(path)) continue;
                SIDBsFromHome.add(path);
            }
            for (OracleHome oh : this.homes) {
                this.logger.info("Checking homeType for home " + oh.getPath() + " on host " + this.localInfo.getLocalHost().getName());
                if (!((Host)oh.getHosts().get(0)).getName().equals(localhost) || !SIDBsFromHome.contains(oh.getPath()) || racInstancesFromHome.contains(oh.getPath())) continue;
                oh.setHomeType("sidb");
                this.logger.info("Changing home type of " + oh.getPath() + " to SIDB on host " + ((Host)oh.getHosts().get(0)).getName());
            }
            ArrayList<OracleHome> sidbRemote = new ArrayList<OracleHome>();
            for (SIDatabase sidb : this.crsCluster.getDbSI()) {
                OracleHome ohSIDB = sidb.getRuns_from();
                String tmpHost = sidb.getHost().getName();
                this.logger.info("SIDB " + sidb.getName() + " from home " + ohSIDB.getPath() + " runs from host " + tmpHost);
                this.logger.info("First host of home is " + ((Host)ohSIDB.getHosts().get(0)).getName());
                if (tmpHost.equals(localhost) || ((ArrayList)remoteRACMap.get(tmpHost)).contains(ohSIDB.getPath())) continue;
                this.logger.info("Removing SIDB " + sidb.getName() + " and its home on host " + sidb.getHost().getName() + " from the system instance.");
                this.ti.getEntities().remove(sidb);
                sidbRemote.add(ohSIDB);
            }
            try {
                for (OracleHome oh : sidbRemote) {
                    this.ti.getEntities().remove(oh);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (OracleHome oh : this.ti.getTargetsOfType(OracleHome.class)) {
                String tmpHost = ((Host)oh.getHosts().get(0)).getName();
                String path2 = oh.getPath();
                if (tmpHost.equals(localhost) || ((ArrayList)remoteRACMap.get(tmpHost)).contains(path2) || this.detectCrsHome().equals(path2) || this.gimr_home_path.equals(path2)) continue;
                this.logger.info("Removing software-only home " + path2 + " on host " + tmpHost + " from the system instance.");
                this.ti.getEntities().remove(oh);
            }
        }
        catch (NotExistsException e) {
            this.logger.log(Level.WARNING, "Unable to detect any databases in this cluster", e);
            return;
        }
        catch (ClusterException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (Exception e) {
            if (e instanceof ProductDriverException) {
                throw (ProductDriverException)e;
            }
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    private void updateDBPerHome(Database sdb) throws DatabaseException {
        String ohPath = sdb.getOracleHome();
        if (this.databasePerHome.containsKey(ohPath)) {
            int count = this.databasePerHome.get(ohPath);
            this.databasePerHome.put(ohPath, ++count);
        } else {
            this.databasePerHome.put(ohPath, 1);
        }
    }

    public RACDatabase makeRACDatabase(Database sdb) throws Exception {
        try {
            RACDatabase db = new RACDatabase();
            if (DatabaseType.RAC == sdb.databaseType()) {
                db.setDatabaseType("rac");
            } else if (DatabaseType.RACOneNode == sdb.databaseType()) {
                db.setDatabaseType("racone");
            }
            db.setName(this.stripPrefixSuffix(sdb.getName(), "ora.", ".db"));
            this.defaultValues((AbstractBaseTarget)db);
            db.setDatabaseName(sdb.getUserAssignedName());
            db.setOracleHome(sdb.getOracleHome());
            db.setVersion(sdb.version().toString());
            db.setDbInstances(new ArrayList());
            try {
                db.setSpFileLoc(sdb.getSPFile());
            }
            catch (Exception e) {
                this.logger.warning("SPFile not found " + e.getMessage());
            }
            this.logger.info("SPFile: " + db.getSpFileLoc());
            if (this.isStandByDatabase(sdb)) {
                db.setStandby(true);
            }
            this.makeDBInstances(sdb, db);
            if (db.getDbInstances().size() < 1 && this.databasePerHome.containsKey(sdb.getOracleHome()) && this.databasePerHome.get(sdb.getOracleHome()) > 1) {
                this.logger.log(Level.INFO, "Database home " + sdb.getOracleHome() + " has multiple database configured, so ignoring the RAC DB " + sdb.getUserAssignedName() + " which doesn't have instances as binary patching can be done using the other configured RAC database");
                return null;
            }
            db.setPDB(this.findPDB(sdb));
            this.setPDBWithRACDatabase(db);
            db.setServices(this.makeServices(sdb));
            this.ti.getEntities().add(db);
            this.crsCluster.getDbRAC().add(db);
            return db;
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoVersionAvailableException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (Exception e) {
            if (e.getMessage().equalsIgnoreCase("ADMIN_POLICY_MIXED_DB")) {
                this.logger.log(Level.INFO, "Unable to detect information for database " + sdb.getUserAssignedName());
                return null;
            }
            throw e;
        }
    }

    private void cleanUpInactiveHomes(List<String> selectedHomes) throws ProductDriverException {
        if (this.inActiveHomeList != null) {
            ArrayList<OracleHome> clearedOracleHomeList = new ArrayList<OracleHome>();
            boolean isCurrentHomeSoftwareOnly = false;
            String currentHome = System.getProperty("OPatch.ORACLE_HOME");
            for (OracleHome oh : this.inActiveHomeList) {
                this.logger.info("Trying to clean inactive instance home:" + oh.getPath() + ", host:" + ((Host)oh.getHosts().get(0)).getHostName());
                String localHost = this.extractHostName(OsysUtility.getHostname());
                String hostName = ((Host)oh.getHosts().get(0)).getHostName();
                try {
                    List<RACDatabase> dbList = this.findAdminDBConfigured(oh);
                    List<RACDBInstance> instanceList = this.findInstanceList(dbList, hostName);
                    if (currentHome != null && DBPatchingHelper.compareFilePath(currentHome, oh.getPath()) && localHost.equalsIgnoreCase(hostName) && instanceList.isEmpty()) {
                        isCurrentHomeSoftwareOnly = true;
                    }
                    if (isCurrentHomeSoftwareOnly && selectedHomes != null && selectedHomes.size() > 1) {
                        throw new ProductDriverException("As current home is software only home, other homes can't be patched along with it.", ProductDriverException.Type.SoftwareOnlyHomeConfiguration);
                    }
                    if (localHost.equalsIgnoreCase(hostName) && isCurrentHomeSoftwareOnly) {
                        this.logger.info("Cleaning information of home in other node as curren home is software only home");
                        if (!instanceList.isEmpty()) continue;
                        for (RACDatabase racDB : dbList) {
                            this.logger.info("Cleaning RAC Database:" + racDB.getDatabaseName());
                            this.ti.getEntities().remove(racDB);
                        }
                        List<OracleHome> homeList = this.findOracleHomeLocatedInOtherHost(oh.getPath(), hostName);
                        for (OracleHome homeToClean : homeList) {
                            this.logger.info("Cleaning home:" + homeToClean.getPath() + ", Host:" + ((Host)homeToClean.getHosts().get(0)).getHostName());
                            this.ti.getEntities().remove(homeToClean);
                        }
                        continue;
                    }
                    this.logger.info("Cleaning information of software only homes");
                    if (!instanceList.isEmpty()) continue;
                    this.logger.info("Cleaning home:" + oh.getPath() + ", Host:" + ((Host)oh.getHosts().get(0)).getHostName());
                    this.ti.getEntities().remove(oh);
                    clearedOracleHomeList.add(oh);
                }
                catch (OPatchAutoException e) {
                    this.logger.info("Cleaning of homes not required as " + e.getMessage());
                }
            }
            if (!clearedOracleHomeList.isEmpty()) {
                Reporting.report((String)"Following home(s) will not be included as part of current opatchauto session as it's software only RAC home:");
                for (OracleHome home : clearedOracleHomeList) {
                    Reporting.report((String)("Home path:" + home.getPath() + ", Host:" + ((Host)home.getHosts().get(0)).getHostName()));
                }
                Reporting.report((String)"\n");
            }
        }
    }

    private List<OracleHome> findOracleHomeLocatedInOtherHost(String homePath, String nodeName) {
        ArrayList<OracleHome> homeList = new ArrayList<OracleHome>();
        for (BaseClass b : this.ti.getEntities()) {
            OracleHome oh;
            if (!(b instanceof OracleHome) || !DBPatchingHelper.compareFilePath((oh = (OracleHome)b).getPath(), homePath) || ((Host)oh.getHosts().get(0)).getHostName().equals(nodeName)) continue;
            homeList.add(oh);
        }
        return homeList;
    }

    private List<RACDatabase> findAdminDBConfigured(OracleHome oh) throws OPatchAutoException {
        ArrayList<RACDatabase> racDBList = new ArrayList<RACDatabase>();
        for (BaseClass b : this.ti.getEntities()) {
            RACDatabase racDB;
            if (!(b instanceof RACDatabase) || !(racDB = (RACDatabase)b).getOracleHome().equals(oh.getPath())) continue;
            if (racDB.getType().equals("adminManaged")) {
                racDBList.add(racDB);
                continue;
            }
            if (!racDB.getType().equals("policyManaged")) continue;
            throw new OPatchAutoException("No admin managed DB found", new Object[0]);
        }
        return racDBList;
    }

    private List<RACDBInstance> findInstanceList(List<RACDatabase> dbList, String nodeName) {
        ArrayList<RACDBInstance> instanceList = new ArrayList<RACDBInstance>();
        for (RACDatabase racDB : dbList) {
            List dbInstances = racDB.getDbInstances();
            for (RACDBInstance instance : dbInstances) {
                if (!instance.getHost().getHostName().equals(nodeName)) continue;
                instanceList.add(instance);
            }
        }
        return instanceList;
    }

    private boolean isStandByDatabase(Database sdb) throws DatabaseException {
        DBRole dbRole = sdb.getDBRole();
        this.logger.info("DB Role :: " + dbRole);
        boolean isStandby = false;
        if (null != dbRole && (dbRole.equals((Object)DBRole.LOGICAL_STANDBY) || dbRole.equals((Object)DBRole.PHYSICAL_STANDBY) || dbRole.equals((Object)DBRole.SNAPSHOT_STANDBY))) {
            isStandby = true;
        }
        return isStandby;
    }

    public void setPDBWithRACDatabase(RACDatabase db) {
        List pdbList = db.getPDB();
        for (PDB pdb : pdbList) {
            pdb.setRACDatabase(db);
        }
    }

    public void setPDBWithSIDatabase(SIDatabase db) {
        List pdbList = db.getPDB();
        for (PDB pdb : pdbList) {
            pdb.setSIDatabase(db);
        }
    }

    public List<PDB> findPDB(Database sdb) {
        ArrayList<PDB> pdbList = new ArrayList<PDB>();
        HashMap<String, PDB> pdbMap = new HashMap<String, PDB>();
        try {
            List services = sdb.services();
            for (Service serv : services) {
                String pdbName;
                Method getPDBMethod = serv.getClass().getMethod("getPDB", new Class[0]);
                Object obj = getPDBMethod.invoke((Object)serv, new Object[0]);
                if (!(obj instanceof String) || (pdbName = (String)obj) == null || pdbName.length() <= 0 || pdbMap.containsKey(pdbName)) continue;
                PDB pdb = new PDB();
                this.logger.log(Level.INFO, "Found PDB " + pdbName);
                pdb.setName(pdbName);
                pdbList.add(pdb);
                pdbMap.put(pdbName, pdb);
                this.ti.getEntities().add(pdb);
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.config("Method not found" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (DatabaseException e) {
            throw new ProductDriverException("Exception when get the pdb service:\t" + e.getMessage());
        }
        return pdbList;
    }

    private List<DBService> makeServices(Database sdb) {
        ArrayList<DBService> dbServices = new ArrayList<DBService>();
        try {
            for (Service service : sdb.services()) {
                DBService dbService = new DBService();
                dbService.setName(service.getUserAssignedName());
                dbService.setIsRunning(service.isRunning());
                if (this.isAdminManagedDB(sdb)) {
                    dbService.setAdministrationType("adminManagedDB");
                } else {
                    dbService.setAdministrationType("policyManagedDB");
                }
                ArrayList<DBServiceNode> configuredNodes = new ArrayList<DBServiceNode>();
                for (DatabaseInstance databaseInstance : service.getProviderInstances()) {
                    if (!(null != service.getServerGroup() & null != service.getServerGroup().servers())) continue;
                    for (Server server : service.getServerGroup().servers()) {
                        if (!server.node().getName().equalsIgnoreCase(databaseInstance.node().getName())) continue;
                        DBServiceNode node = new DBServiceNode();
                        node.setDatabaseName(databaseInstance.getName());
                        node.setDatabaseInstance(databaseInstance.getUserAssignedName());
                        node.setHostName(databaseInstance.node().getName());
                        node.setIsRunning(service.isRunning(databaseInstance.node()));
                        configuredNodes.add(node);
                    }
                }
                dbService.setConfiguredNodes(configuredNodes);
                dbServices.add(dbService);
            }
            return dbServices;
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (ServerGroupException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (NodeException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (ServerException e) {
            throw new ProductDriverException(e.getMessage());
        }
    }

    public void makeDBInstances(Database sdb, RACDatabase rdb) throws Exception {
        try {
            RACDBInstance dbInst;
            List candServer;
            List dbis = sdb.instances();
            boolean isAdminManaged = this.isAdminManagedDB(sdb);
            this.logger.info("isAdminManaged: " + isAdminManaged);
            if (isAdminManaged) {
                rdb.setType("adminManaged");
                candServer = ((ServerGroup)sdb.serverGroups().get(0)).configuredServers();
            } else {
                rdb.setType("policyManaged");
                candServer = ((ServerGroup)sdb.serverGroups().get(0)).servers();
            }
            this.logger.info("No of candidate Server: " + candServer.size());
            ArrayList<Node> candidateNodes = new ArrayList<Node>(candServer.size());
            for (Server server : candServer) {
                this.logger.info("server: " + server);
                try {
                    candidateNodes.add(server.node());
                }
                catch (ServerException e) {
                    this.logger.warning("ServerException: " + e.getMessage());
                }
            }
            String dbConfigType = isAdminManaged ? "adminManagedDB" : "policyManagedDB";
            this.logger.info("dbConfigType: " + dbConfigType);
            if (dbis.size() == 0) {
                this.logger.log(Level.WARNING, "Warning: There are no RAC Database Instances running for " + sdb);
                if (this.isAdminPolicyDBMixedSetup) {
                    this.dbForSkipping.put(sdb.getUserAssignedName(), dbConfigType);
                    throw new Exception("ADMIN_POLICY_MIXED_DB");
                }
            }
            this.dbForPatching.put(sdb.getUserAssignedName(), dbConfigType);
            this.logger.log(Level.INFO, "There are " + dbis.size() + " RAC database insatnces running for database: " + sdb);
            for (DatabaseInstance inst : dbis) {
                try {
                    Method isPQ = inst.getClass().getMethod("isPQInstance", new Class[0]);
                    if (((Boolean)isPQ.invoke((Object)inst, new Object[0])).booleanValue()) {
                        this.logger.info("the instance " + inst.getName() + " : " + inst.getUserAssignedName() + " runs on leaf node that belongs to PQ pools ");
                    } else {
                        this.logger.info("the instance " + inst.getName() + " : " + inst.getUserAssignedName() + " runs on hub node that belongs to server pools ");
                    }
                }
                catch (NoSuchMethodException e) {
                    System.out.println();
                }
                catch (IllegalAccessException e) {
                    System.out.println();
                }
                catch (InvocationTargetException e) {
                    System.out.println();
                }
                dbInst = new RACDBInstance();
                dbInst.setName(inst.getUserAssignedName());
                dbInst.setInstanceName(inst.getUserAssignedName());
                this.defaultValues((AbstractBaseTarget)dbInst);
                dbInst.setDbRAC(rdb);
                dbInst.setVersion(sdb.version().toString());
                Node node = inst.node();
                this.updateCandidateNode(node, candidateNodes);
                this.logger.info("updated candidateNode: " + candidateNodes.isEmpty());
                String nodename = node.getName();
                dbInst.setHost(this.findHostByName(nodename));
                if (inst.isRunning()) {
                    dbInst.setIsRunning("yes");
                } else {
                    dbInst.setIsRunning("no");
                }
                String ohPath = sdb.getOracleHome(node);
                OracleHome oh = this.findOrMakeHome(nodename, ohPath);
                oh.setHomeType("rac");
                oh.getInstalledSWComponents().add(dbInst);
                dbInst.setRuns_from(oh);
                this.logger.info("Found DB Instance " + dbInst.getInstanceName() + " running on " + nodename + " from " + ohPath);
                rdb.getDbInstances().add(dbInst);
                this.ti.getEntities().add(dbInst);
            }
            if (!candidateNodes.isEmpty() && sdb.databaseType() == DatabaseType.RACOneNode) {
                this.logger.info("Database type is shown as RACOne");
                for (Node node : candidateNodes) {
                    dbInst = new RACDBInstance();
                    dbInst.setName("InactiveRACOne");
                    dbInst.setInstanceName("InactiveRACOne");
                    this.defaultValues((AbstractBaseTarget)dbInst);
                    dbInst.setDbRAC(rdb);
                    dbInst.setVersion(sdb.version().toString());
                    String nodename = node.getName();
                    dbInst.setHost(this.findHostByName(nodename));
                    dbInst.setIsRunning("no");
                    String ohPath = sdb.getOracleHome(node);
                    OracleHome oh = this.findOrMakeHome(nodename, ohPath);
                    oh.setHomeType("rac");
                    oh.getInstalledSWComponents().add(dbInst);
                    dbInst.setRuns_from(oh);
                    this.logger.info("Found RACOne candidate home on " + nodename + " from " + ohPath);
                    rdb.getDbInstances().add(dbInst);
                    this.ti.getEntities().add(dbInst);
                }
            }
            this.makeDBHomeWithNoInstance(sdb, rdb, dbis);
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (InstanceException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoVersionAvailableException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (ServerGroupException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    private void makeDBHomeWithNoInstance(Database sdb, RACDatabase rdb, List<DatabaseInstance> dbis) throws NodeException, NoVersionAvailableException, SoftwareModuleException {
        ArrayList<String> inactiveInstances = new ArrayList<String>();
        String oracleHomePath = sdb.getOracleHome();
        this.logger.info("Make DBHome with no Instance for home " + oracleHomePath + " with version " + this.haVersion);
        String[] databaseNodes = this.fetchNodeNames(oracleHomePath);
        for (int i = 0; i < databaseNodes.length; ++i) {
            boolean isPresent = false;
            for (DatabaseInstance inst : dbis) {
                Node instNode = inst.node();
                if (!databaseNodes[i].equalsIgnoreCase(instNode.getName())) continue;
                isPresent = true;
            }
            if (isPresent) continue;
            inactiveInstances.add(databaseNodes[i]);
        }
        if (!inactiveInstances.isEmpty()) {
            this.inActiveHomeList = new ArrayList<OracleHome>();
            for (String node : inactiveInstances) {
                OracleHome oh = this.findOrMakeHome(node, oracleHomePath);
                if (!this.inActiveHomeList.contains(oh)) {
                    this.inActiveHomeList.add(oh);
                }
                oh.setHomeType("rac");
                this.logger.info("Created RAC instance candidate home on " + node + " from " + oracleHomePath);
            }
        }
    }

    private boolean isAdminManagedDB(Database sdb) throws ServerGroupException {
        boolean isAdminManaged = false;
        List serverGrp = sdb.serverGroups();
        if (serverGrp.size() == 1 && !((ServerGroup)serverGrp.get(0)).isServerPool()) {
            isAdminManaged = true;
        }
        this.logger.info("isAdminManaged: " + isAdminManaged);
        return isAdminManaged;
    }

    private void updateCandidateNode(Node instanceNode, List<Node> candidateNodes) {
        for (Node node : candidateNodes) {
            try {
                if (!instanceNode.getName().equals(node.getName())) continue;
                this.logger.info("Removing Node: " + node.getName());
                candidateNodes.remove(node);
                break;
            }
            catch (NodeException e) {
                this.logger.warning("NodeException: " + e.getMessage());
            }
        }
    }

    public void makeSIDBInstances(Database sdb, SIDatabase sidb) {
        try {
            List dbis = sdb.instances();
            this.logger.info("There are " + dbis.size() + " SI database instances running for database: " + sdb);
            for (DatabaseInstance inst : dbis) {
                try {
                    Method isPQ = inst.getClass().getMethod("isPQInstance", new Class[0]);
                    if (((Boolean)isPQ.invoke((Object)inst, new Object[0])).booleanValue()) {
                        this.logger.info("the instance " + inst.getName() + " : " + inst.getUserAssignedName() + " runs on leaf node that belongs to PQ pools ");
                    } else {
                        this.logger.info("the instance " + inst.getName() + " : " + inst.getUserAssignedName() + " runs on hub node that belongs to server pools ");
                    }
                }
                catch (NoSuchMethodException e) {
                    System.out.println();
                }
                catch (IllegalAccessException e) {
                    System.out.println();
                }
                catch (InvocationTargetException e) {
                    System.out.println();
                }
                sidb.setInstanceName(inst.getUserAssignedName());
                if (inst.isRunning()) {
                    sidb.setAvailability("yes");
                    continue;
                }
                sidb.setAvailability("no");
            }
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public SIDatabase makeSIDatabase(Database sdb) {
        try {
            List nodes;
            SIDatabase db = new SIDatabase();
            db.setName(this.stripPrefixSuffix(sdb.getName(), "ora.", ".db"));
            this.defaultValues((AbstractBaseTarget)db);
            db.setPDB(this.findPDB(sdb));
            this.setPDBWithSIDatabase(db);
            db.setOracleHome(sdb.getOracleHome());
            db.setDatabaseName(sdb.getUserAssignedName());
            db.setVersion(sdb.version().toString());
            try {
                db.setSpFileLoc(sdb.getSPFile());
            }
            catch (Exception e) {
                this.logger.warning("SPFile not found " + e.getMessage());
            }
            if (!StringUtil.isNullOrEmpty((String)db.getSpFileLoc(), (boolean)true)) {
                this.logger.info("SPFile: " + db.getSpFileLoc());
            }
            if ((nodes = sdb.nodes()).size() != 1) {
                throw new ProductDriverException("Non-cluster database " + db.getName() + " has " + String.valueOf(nodes.size()) + " nodes", ProductDriverException.Type.InvalidConfiguration);
            }
            Node node = (Node)nodes.get(0);
            String nodename = node.getName();
            db.setHost(this.findHostByName(nodename));
            String ohPath = sdb.getOracleHome(node);
            OracleHome oh = this.findOrMakeHome(nodename, ohPath);
            if (oh.getHomeType() == null || !oh.getHomeType().equals("rac")) {
                oh.setHomeType("sidb");
            }
            oh.getInstalledSWComponents().add(db);
            db.setRuns_from(oh);
            if (this.isStandByDatabase(sdb)) {
                db.setStandby(true);
            }
            this.makeSIDBInstances(sdb, db);
            if (sdb.instances().size() < 1 && this.databasePerHome.containsKey(sdb.getOracleHome()) && this.databasePerHome.get(sdb.getOracleHome()) > 1) {
                this.logger.log(Level.INFO, "Database home " + sdb.getOracleHome() + " has multiple database configured, so ignoring the Single instance DB " + sdb.getUserAssignedName() + " which doesn't have instances as binary patching can be done using the other configured Single instance database");
                return null;
            }
            this.ti.getEntities().add(db);
            return db;
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoVersionAvailableException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
    }

    public Map<String, String> getDBForSkipping() {
        return this.dbForSkipping;
    }

    public Map<String, String> getDBForPatching() {
        return this.dbForPatching;
    }

    String stripPrefixSuffix(String name, String prefix, String suffix) {
        if (name.startsWith(prefix) && name.endsWith(suffix)) {
            return name.substring(prefix.length(), name.length() - suffix.length());
        }
        return name;
    }

    public static boolean isExadata() {
        Logger logger = Logger.getLogger(CrsProductDriver.class.getName());
        logger.info("Checking for Exadata. Looking for /opt/oracle.cellos/ORACLE_CELL_OS_IS_SETUP file.");
        File imageinfo = new File("/opt/oracle.cellos/ORACLE_CELL_OS_IS_SETUP");
        if (imageinfo.exists()) {
            logger.info("Found Exadata!");
            return true;
        }
        logger.info("This is not an Exadata environment");
        return false;
    }

    public static boolean isExadata_skgxpinfo() {
        Logger logger = Logger.getLogger(CrsProductDriver.class.getName());
        logger.entering(CrsProductDriver.class.getName(), "isExadata");
        try {
            File ohpath = CrsProductDriver.getTargetHome();
            File skgxpinfo = new File(ohpath, File.separator + "bin" + File.separator + "skgxpinfo");
            if (!skgxpinfo.isFile()) {
                logger.info("Non-Exadata environment: skgxpinfo command does not exists at " + skgxpinfo.getPath());
                return false;
            }
            Process p = Runtime.getRuntime().exec(new String[]{skgxpinfo.getPath()});
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String s = b.readLine();
            b.close();
            logger.info("skgxpinfo returned: " + s);
            if (s != null && s.equalsIgnoreCase("rds")) {
                logger.info("Found Exadata env");
                logger.entering(CrsProductDriver.class.getName(), "isExadata");
                return true;
            }
            logger.info("Found non-Exadata env");
            logger.exiting(CrsProductDriver.class.getName(), "isExadata");
            return false;
        }
        catch (IOException e) {
            throw new ProductDriverException(e.getMessage(), (Throwable)e, ProductDriverException.Type.Unknown);
        }
    }
}

