/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.crs.util;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.LogInfo;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanEnv;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanUserException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.helper.util.HelperUtility;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.BaseSWComponent;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.ASMCluster;
import dbmodel.db_crs.ASMInstance;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.DB;
import dbmodel.db_crs.DBInstance;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.OracleListener;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class CRSutil {
    private static Logger logger = Logger.getLogger(CRSutil.class.getName());
    public static boolean printAttributes = false;

    public static void setupLogs() {
        Logger rootLogger = Logger.getLogger("");
        if (rootLogger.getHandlers().length >= 1 && rootLogger.getHandlers()[0] instanceof ConsoleHandler) {
            rootLogger.getHandlers()[0].setLevel(Level.OFF);
        }
        Logger driverLogger = Logger.getLogger("com.oracle.glcm.patch.auto.db.product.driver");
        Logger modelLogger = Logger.getLogger("dbmodel");
        driverLogger.setLevel(Level.ALL);
        modelLogger.setLevel(Level.ALL);
        try {
            PatchPlanEnv env = PatchPlanner.getInstance().getOPlanEnv();
            String logDir = env.getProperty("logDir") != null && env.getProperty("logDir").length() > 0 ? env.getProperty("logDir") : (System.getenv("ORACLE_HOME") != null && System.getenv("ORACLE_HOME").length() > 0 ? HelperUtility.detectOraBaseHome((String)env.getProperty("OracleHome")) + File.separator + "cfgtoollogs" + File.separator + "opatchautodb" : System.getProperty("java.io.tmpdir") + File.separator + "opatchautodb");
            File oplanDir = new File(logDir);
            if (!oplanDir.exists()) {
                oplanDir.mkdirs();
            }
            IOUtils.chmodTo775(oplanDir, null);
            File src = new File(PatchPlanner.getInstance().getOPlanEnv().getOracleHome(), "oraInst.loc");
            IOUtils.copyOwnerGroup(src, oplanDir);
            logDir = logDir + File.separator + "driver";
            File logFolder = new File(logDir);
            if (!logFolder.exists()) {
                logFolder.mkdirs();
            }
            IOUtils.chmodTo775(logFolder, null);
            IOUtils.copyOwnerGroup(src, logFolder);
            if (CRSutil.checkAndRemoveLogHandles(driverLogger, modelLogger)) {
                LogInfo logInfo = new LogInfo(logFolder);
                File logFile = logInfo.getLogFile().getAbsoluteFile();
                FileHandler fh = new FileHandler(logFile.getAbsolutePath());
                fh.setFormatter(new SimpleFormatter());
                fh.setLevel(Level.ALL);
                driverLogger.addHandler(fh);
                modelLogger.addHandler(fh);
            }
            CRSutil.enableSRVMTrace(logDir);
        }
        catch (Exception e) {
            throw new PatchPlanUserException(e, "UNABLE_TO_CREATE_LOGS", e.getMessage());
        }
    }

    private static void enableSRVMTrace(String logDir) {
        String logFileName = logDir + File.separator + "srvmtrace_" + OPatchAutoHelper.getCurrentDateTimeStamp((String)"yyyy-MM-dd_hh-mm-ssa") + ".log";
        DBPatchingUtil.enableSRVMTrace(logFileName);
    }

    private static boolean checkAndRemoveLogHandles(Logger driverLogger, Logger modelLogger) {
        boolean haveRemovedHandle = false;
        if (driverLogger.getHandlers().length == 0 || modelLogger.getHandlers().length == 0) {
            CRSutil.removeLogHandles(driverLogger);
            CRSutil.removeLogHandles(modelLogger);
            haveRemovedHandle = true;
        }
        return haveRemovedHandle;
    }

    private static void removeLogHandles(Logger logger) {
        Handler[] handles = logger.getHandlers();
        for (int i = 0; i < handles.length; ++i) {
            logger.removeHandler(handles[i]);
        }
    }

    public static void print(List<BaseClass> all) {
        for (BaseClass obj : all) {
            CRSutil.print(obj);
        }
    }

    public static void print(BaseClass obj) {
        logger.finer(" ****************** ");
        if (obj instanceof DB) {
            CRSutil.printDB((DB)obj);
        } else if (obj instanceof OracleHome) {
            logger.finer(obj.toString());
            logger.finer(((OracleHome)obj).getOracleBaseLocation());
        } else if (obj instanceof CRSCluster) {
            CRSutil.printCRSUp((CRSCluster)obj);
            CRSutil.printCRSDown((CRSCluster)obj);
        } else if (obj instanceof ASMCluster) {
            logger.finer(obj.toString());
            List instances = ((ASMCluster)obj).getASMinstances();
            if (instances == null) {
                return;
            }
            for (ASMInstance instance : instances) {
                logger.finer(instance.toString());
            }
        } else if (obj instanceof RACDatabase) {
            logger.finer(obj.toString());
            List instances = ((RACDatabase)obj).getDbInstances();
            if (instances == null) {
                return;
            }
            for (RACDBInstance instance : instances) {
                logger.finer(instance.toString());
                logger.finer("HAS is managing this RAC instance is " + instance.getCRS());
                OracleHome home = instance.getRuns_from();
                logger.finer(" OracleHome attribute=" + instance.getOracleHome() + " home=" + home + " path=" + (home == null ? "" : home.getPath()));
            }
        } else {
            logger.finer(obj.toString());
        }
    }

    public static void printCRS(SystemInstance sys) {
        logger.finer(" ****************** ");
        CRSCluster crs = null;
        for (BaseClass obj : sys.getEntities()) {
            if (!(obj instanceof CRSCluster)) continue;
            crs = (CRSCluster)obj;
            CRSutil.print(obj);
        }
        if (crs == null) {
            logger.finer(" Failed to find CRS !!!!!");
        }
        logger.finer(" ****************** ");
    }

    public static void printCRSUp(CRSCluster crs) {
        logger.finer(" ********UP********** ");
        if (crs == null) {
            return;
        }
        List nodes = crs.getNodes();
        boolean noNodes = nodes == null || nodes.size() == 0;
        logger.finer("\n CRS " + crs.toString() + "  " + crs.getHWtype() + " cluster name=" + crs.getClusterName() + (noNodes ? " There is no nodes!" : " has " + nodes.size() + " nodes."));
        if (printAttributes) {
            logger.finer(" CRS attributes:" + crs.getAttributes().toString());
        }
        OracleHome giHome = crs.getGIHome();
        if (printAttributes) {
            logger.finer(" GIhome attributes:" + giHome.getAttributes().toString());
        }
        if (noNodes) {
            return;
        }
        for (Host host : nodes) {
            List comps = host.getSWComponents();
            logger.finer("    The " + host.toString() + " host name=" + host.getHostName() + " dbmMember=" + host.getDbmMember());
            if (printAttributes) {
                logger.finer("      attributes:" + host.getAttributes().toString());
            }
            logger.finer("     is hosting " + (comps == null || comps.isEmpty() ? " nothing!" : ":"));
            if (comps == null) continue;
            for (BaseSWComponent comp : comps) {
                DBInstance db;
                OracleHome home = comp.getRuns_from();
                logger.finer("      " + comp.toString() + (comp instanceof DBInstance ? "instance name=" + ((DBInstance)comp).getInstanceName() : "") + (comp instanceof HAS ? "node name=" + ((HAS)comp).getNodeName() : "") + (home == null ? "\n        OracleHome assoc is not set!" : "\n            runs from " + home.toString() + " owner=" + home.getOwner() + " homeName(OUI)=" + home.getHomeName() + " path=" + home.getPath() + " inventoryLocation=" + home.getInventoryLocation()));
                if (printAttributes) {
                    logger.finer("        attributes:" + comp.getAttributes().toString());
                }
                if (home != null && printAttributes) {
                    logger.finer("       home attributes:" + home.getAttributes().toString());
                }
                if (comp instanceof HAS) {
                    HAS has = (HAS)comp;
                    if (has.getCluster() != null && has.getCluster().getGUID() != crs.getGUID()) {
                        logger.finer("         HAS belongs to a different CRS " + has.getCluster().getGUID());
                    }
                    if (has.getInstanceASM() != null && has.getInstanceASM().size() != 0) {
                        logger.finer("      " + has.getInstanceASM().toString());
                        ASMCluster asmCluster = ((ASMInstance)has.getInstanceASM().get(0)).getASMcluster();
                        if (asmCluster != null) {
                            logger.finer("         " + asmCluster.toString());
                        }
                    }
                    if (has.getListeners() != null && has.getListeners().size() != 0) {
                        logger.finer(has.getListeners().toString());
                    }
                    if (has.getDBInstance() != null && has.getDBInstance().size() != 0) {
                        RACDatabase rac;
                        logger.finer("            manages " + has.getDBInstance().toString());
                        if (has.getDBInstance() instanceof RACDBInstance && (rac = ((RACDBInstance)has.getDBInstance()).getDbRAC()) != null) {
                            logger.finer("            " + rac.toString());
                        }
                    }
                }
                if (comp instanceof RACDBInstance) {
                    logger.finer("            is managed by HAS " + ((RACDBInstance)comp).getCRS());
                    RACDatabase rac = ((RACDBInstance)comp).getDbRAC();
                    if (rac != null) {
                        logger.finer("            belongs to " + rac.toString());
                    } else {
                        logger.finer("            RACInstance to RAC is not set ");
                    }
                }
                if (comp instanceof ASMInstance) {
                    ASMCluster asm = ((ASMInstance)comp).getASMcluster();
                    if (asm != null) {
                        logger.finer("            belongs to " + asm.toString());
                    } else {
                        logger.finer("            ASMInstance to ASM is not set ");
                    }
                }
                if (!(comp instanceof OracleListener) || (db = ((OracleListener)comp).getDbInstances()) == null) continue;
                logger.finer("         " + db.toString());
            }
        }
        logger.finer(" ****************** ");
    }

    public static void printCRSDown(CRSCluster crs) {
        logger.finer(" ********DOWN********** ");
        if (crs == null) {
            return;
        }
        if (crs.getHAS() == null || crs.getHAS().size() == 0) {
            logger.finer("#CRS " + crs.toString() + "\n does NOT have any active nodes:");
        } else {
            logger.finer("CRS " + crs.toString() + "  " + crs.getHWtype() + "\n consists of the following nodes:");
            for (Host host : crs.getNodes()) {
                logger.finer("       " + host.toString());
                if (!printAttributes) continue;
                logger.finer("       attributes:" + host.getAttributes().toString());
            }
            logger.finer(" active nodes:");
            for (HAS has : crs.getHAS()) {
                CRSutil.printHas(has);
            }
        }
        CRSutil.printASMCluster(crs.getASMCluster(), crs.getName());
        List racs = crs.getDbRAC();
        if (racs == null || racs.isEmpty()) {
            logger.finer("CRS " + crs.getName() + " does NOT have any RAC DB ");
        } else {
            for (RACDatabase rac : racs) {
                logger.finer("  manages RAC database \n       " + rac.toString() + "\n       wich consists of the following RAC instances:");
                for (RACDBInstance racInst : rac.getDbInstances()) {
                    CRSutil.printRACDBInstance(racInst);
                }
            }
        }
        List dbs = crs.getDbSI();
        if (dbs == null || dbs.isEmpty()) {
            logger.finer("\nCRS " + crs.getName() + " does NOT have any SI DB ");
        } else {
            for (SIDatabase db : dbs) {
                CRSutil.printSIDababase(db);
            }
        }
        logger.finer(" ****************** ");
    }

    public static void printSIDababase(SIDatabase db) {
        logger.finer("  manages SI database \n       " + db.toString());
        logger.finer("         home=" + db.getRuns_from() + " host=" + db.getHost());
    }

    public static void printRACDBInstance(RACDBInstance racInst) {
        logger.finer("          " + racInst.toString());
        logger.finer("             home=" + racInst.getRuns_from() + " host=" + racInst.getHost());
        if (printAttributes) {
            logger.finer("           attributes:" + racInst.getAttributes().toString());
        }
    }

    public static void printASMCluster(ASMCluster asm, String crsName) {
        if (asm == null) {
            logger.finer("CRS " + crsName + " does NOT have any ASM cluster !!!");
        } else {
            logger.finer(" manages ASM cluster \n       " + asm.toString() + "\n wich consists of the following ASM instances:");
            if (printAttributes) {
                logger.finer("       attributes:" + asm.getAttributes().toString());
            }
            for (ASMInstance instASM : asm.getASMinstances()) {
                logger.finer("            " + instASM.toString());
                logger.finer("               home=" + instASM.getRuns_from() + " host=" + instASM.getHost());
                if (!printAttributes) continue;
                logger.finer("               attributes:" + instASM.getAttributes().toString());
            }
        }
    }

    public static void printHas(HAS has) {
        logger.finer("       " + has.toString());
        if (printAttributes) {
            logger.finer("       attributes:" + has.getAttributes().toString());
        }
        logger.finer("            home=" + has.getRuns_from() + " host=" + has.getHost());
        if (has.getDBInstance() != null) {
            for (DBInstance inst : has.getDBInstance()) {
                logger.finer("        " + inst.toString());
            }
        }
        if (has.getListeners() != null) {
            for (DBInstance inst : has.getListeners()) {
                logger.finer("        " + inst.toString());
            }
        }
        if (has.getInstanceASM() != null) {
            for (DBInstance inst : has.getInstanceASM()) {
                logger.finer("        " + inst.toString());
            }
        }
        if (has.getACFS() != null) {
            for (DBInstance inst : has.getACFS()) {
                logger.finer("        " + inst.toString());
            }
        }
    }

    public static void printOH(List<OracleHome> ohs) {
        if (ohs == null || ohs.isEmpty()) {
            logger.finer("      There is no Oracle Homes ");
            return;
        }
        for (OracleHome oh : ohs) {
            logger.finer("     " + oh.toString() + " type=" + oh.getHomeType() + " inventoryLocation=" + oh.getInventoryLocation() + "\n                           centralInvPtr=" + oh.getCentralInvPtr() + " OracleBaseLocation=" + oh.getOracleBaseLocation());
        }
    }

    public static void printDB(DB db) {
        RACDatabase rac = db.getRAC();
        SIDatabase sidb = db.getSI();
        logger.finer("\nDB system " + db.toString() + "\n contains:\n " + (null == rac ? " no RAC " : rac.toString()) + "\n" + (null == sidb ? " no SIDB" : sidb.toString()));
        logger.finer("Primary is " + db.getPrimary() + (null == db.getPrimary() ? "" : db.getPrimary().toString()) + "\nSecondary is " + (null == db.getSecondary() ? "" : db.getSecondary().toString()));
        if (rac != null) {
            if (rac.getDbInstances() == null) {
                return;
            }
            logger.finer(rac.toString() + "RAC instances:");
            for (RACDBInstance instDB : rac.getDbInstances()) {
                logger.finer(instDB.toString());
            }
        }
    }
}

