/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Receiver;
import com.oracle.cie.common.util.reporting.ReceiverType;
import com.oracle.cie.common.util.reporting.ReceiverTypes;
import com.oracle.cie.common.util.reporting.Receiving;
import com.oracle.cie.common.util.reporting.Recipient;
import com.oracle.cie.common.util.reporting.RecipientAdapter;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.integration.controller.RemoteContentTransferHandler;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SDBProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SystemInstBuilder;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.ASMCluster;
import dbmodel.db_crs.ASMInstance;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardedDatabase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class CRSHASSystemInstBuilder
extends SDBProductDriver
implements SystemInstBuilder {
    public CRSHASSystemInstBuilder(CredentialManager credentialManager, SystemInstance ti) {
        this.credentialManager = credentialManager;
        this.ti = ti;
    }

    @Override
    public SystemInstance createSystemInstance() throws ProductDriverException {
        ShardedDatabase sdb = (ShardedDatabase)this.ti.getTop();
        ArrayList<String> hostNames = new ArrayList<String>();
        boolean hostFound = false;
        List shards = this.ti.getTargetsOfType(AbstractBaseTarget.class);
        for (AbstractBaseTarget shard : shards) {
            HostImpl hostImpl = null;
            hostFound = false;
            String shardDbtype = "";
            String hostname = null;
            String oracleHome = null;
            String owner = null;
            if (shard instanceof SIDatabase) {
                SIDatabase sidb = (SIDatabase)shard;
                hostname = sidb.getHost().getHostName();
                oracleHome = sidb.getOracleHome();
                owner = sidb.getOwner();
                shardDbtype = sidb.getShardProperty().getDbType();
                if (shardDbtype.equalsIgnoreCase("ADMIN_RAC") || shardDbtype.equalsIgnoreCase("POLICY_RAC") || shardDbtype.equalsIgnoreCase("SIHA")) {
                    this.logger.fine("Creating hostimpl for the sidb : '" + sidb.getDatabaseName() + "' on host '" + hostname + "' on home '" + oracleHome + "'");
                    hostImpl = PatchActionUtil.createHostImpl(this.credentialManager, hostname, oracleHome, owner);
                }
            } else {
                if (!(shard instanceof RACDatabase)) continue;
                RACDatabase racdb = (RACDatabase)shard;
                hostname = racdb.getHostName();
                oracleHome = racdb.getOracleHome();
                owner = racdb.getOwner();
                shardDbtype = racdb.getShardProperty().getDbType();
                this.logger.fine("Creating hostimpl for the rac db : '" + racdb.getDatabaseName() + "' on host '" + hostname + "' on home '" + oracleHome + "'");
                hostImpl = PatchActionUtil.createHostImpl(this.credentialManager, hostname, oracleHome, owner);
            }
            if (StringUtil.isNullOrEmpty((String)shardDbtype) || !shardDbtype.equalsIgnoreCase("ADMIN_RAC") && !shardDbtype.equalsIgnoreCase("POLICY_RAC") && !shardDbtype.equalsIgnoreCase("SIHA")) continue;
            if (hostNames.contains(hostname)) {
                hostFound = true;
            }
            this.logger.fine("Is host found in the list of hostnames " + hostNames + " :" + hostFound);
            if (!this.isRemoteDataCollectReq(shard)) continue;
            String currentHostName = hostImpl.getHost();
            String xmlFileName = "opatch_remote_" + currentHostName + "_config.xml";
            this.findRemoteHostDetails(oracleHome, hostImpl, xmlFileName, owner);
            AbstractBaseTarget abt = null;
            try {
                abt = this.postExecute(OPatchAutoHelper.getOPatchAutoHome(), xmlFileName, currentHostName);
            }
            catch (OPatchAutoException e) {
                this.logger.throwing("Exception while trying to get the localhome : ", e.getMessage(), e);
                throw new ProductDriverException("Exception while trying to get the localhome : \n" + (Object)((Object)e));
            }
            if (abt instanceof CRSCluster) {
                CRSCluster crs = (CRSCluster)abt;
                for (Host node : crs.getNodes()) {
                    hostNames.add(node.getHostName());
                }
                sdb.getCrs().add(crs);
                if (hostFound) continue;
                this.logger.fine("Adding the CRSCluster instance to ti " + crs.getName());
                this.ti.getEntities().add(crs);
                continue;
            }
            if (!(abt instanceof HAS)) continue;
            HAS has = (HAS)abt;
            hostNames.add(has.getHost().getHostName());
            sdb.getHas().add(has);
            this.logger.fine("Adding the HAS instance to ti " + has.getName());
            this.ti.getEntities().add(has);
        }
        return this.ti;
    }

    private boolean isRemoteDataCollectReq(AbstractBaseTarget shard) {
        boolean isRequired = true;
        if (shard instanceof RACDatabase) {
            List racdbs = this.ti.getTargetsOfType(RACDatabase.class);
            for (RACDatabase racdb : racdbs) {
                String hostName = shard.getHostName();
                String dbHostName = racdb.getHostName();
                if (!shard.getName().equalsIgnoreCase(racdb.getName()) || !hostName.equalsIgnoreCase(dbHostName) || racdb.getDbInstances() == null) continue;
                isRequired = false;
            }
        }
        return isRequired;
    }

    private void findRemoteHostDetails(String oracleHome, HostImpl hostImpl, String xmlFileName, String owner) throws ProductDriverException {
        String localXmlPath;
        Credential credential = DBPatchingHelper.getOwnerOrCurrentUserCred(hostImpl.getHost(), owner, hostImpl.getUsername(), this.credentialManager);
        RemoteConnectionHandler handler = PatchActionUtil.getHandler(hostImpl);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Obtained remote connection handler [" + handler.getClass() + "] for host " + hostImpl);
        }
        try {
            localXmlPath = this.createLocalXmlFilePath(OPatchAutoHelper.getOPatchAutoHome(), xmlFileName);
        }
        catch (OPatchAutoException e2) {
            this.logger.throwing("Exception while trying to get the localhome : ", e2.getMessage(), e2);
            throw new ProductDriverException("Exception while trying to get the localhome : \n" + (Object)((Object)e2));
        }
        if (oracleHome.endsWith("/")) {
            oracleHome = oracleHome.substring(0, oracleHome.length() - 1);
        }
        String giHome = "";
        String giOwner = "";
        String hasCommand = this.getRemoteCommandForHAS(oracleHome, hostImpl);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            handler.exec(hasCommand, (OutputStream)outputStream);
            String output = outputStream.toString();
            if (!StringUtil.isNullOrEmpty((String)output) && output.contains("CRSHOME:")) {
                giHome = output.substring(8);
            }
            this.logger.info("GI Home path on " + hostImpl.getHost() + " : " + giHome);
            giOwner = RemoteContentTransferHandler.getInstance().findRemoteHomeOwner(giHome, giHome + File.separator + DBCommonPatchingConstants.OPATCHAUTO_SCRIPT, handler);
            this.logger.info("GI Home owner on " + hostImpl.getHost() + " : " + giOwner);
            if (StringUtil.isNullOrEmpty((String)giHome)) {
                String message = OPatchAutoHelper.getLocalizedString((String)"SDBProdutDriver.gihome.path.collect.failure", (Object[])new Object[]{hostImpl.getHost()});
                Reporting.report((String)message);
                throw new ProductDriverException(message);
            }
            if (StringUtil.isNullOrEmpty((String)giOwner)) {
                String message = OPatchAutoHelper.getLocalizedString((String)"SDBProdutDriver.gihome.owner.collect.failure", (Object[])new Object[]{giHome, hostImpl.getHost()});
                Reporting.report((String)message);
                throw new ProductDriverException(message);
            }
        }
        catch (RemoteConnectionException e1) {
            this.logger.throwing("Exception while putting the container into handler : ", e1.getMessage(), e1);
            throw new ProductDriverException("Exception while putting the container into handler : \n" + (Object)((Object)e1));
        }
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        try {
            pipedOutputStream = new PipedOutputStream(pipedInputStream);
        }
        catch (IOException e1) {
            this.logger.throwing("Exception : ", e1.getMessage(), e1);
            throw new ProductDriverException("Exception : \n" + e1);
        }
        Receiver receiver = null;
        try {
            receiver = Receiving.addReceiver((ReceiverType)ReceiverTypes.jackson, (InputStream)pipedInputStream, (String)OPatchAutoHelper.OPATCHAUTO_REMOTE_MESSAGE_INDICATOR);
            receiver.setKeepStreamOpen(false);
            receiver.addRecipient((Recipient)new RecipientAdapter(){

                public void received(Message message) {
                    message.setMessage("< Message > : " + message.getMessage());
                    Reporting.report((Message)message);
                }
            });
        }
        catch (ReportingException e1) {
            this.logger.throwing("Exception in reciever : ", e1.getMessage(), e1);
            throw new ProductDriverException("Exception in reciever : \n" + (Object)((Object)e1));
        }
        HostImpl giHostImpl = PatchActionUtil.createHostImpl(this.credentialManager, hostImpl.getHost(), giHome, giOwner);
        String opatchAutoTmp = giHome + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB;
        String opatchAutoTmpInst = giHome + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE;
        String opatchAutoTmpWallet = giHome + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB + "wallet" + File.separator;
        String remoteXmlPath = opatchAutoTmpInst + xmlFileName;
        String sysInstCommand = this.getRemoteCommandForSysInst(giHome, giHostImpl, opatchAutoTmpWallet);
        RemoteConnectionHandler giHandler = PatchActionUtil.getHandler(giHostImpl);
        ByteArrayOutputStream junkOutputStream = new ByteArrayOutputStream();
        receiver.setJunkOutputStream((OutputStream)junkOutputStream);
        try {
            RemoteContentTransferHandler.getInstance().mkDirOnRemoteHost(opatchAutoTmp, giHandler, RemoteContentTransferHandler.DeleteStatus.NONE, giOwner, credential);
            RemoteContentTransferHandler.getInstance().mkDirOnRemoteHost(opatchAutoTmpInst, giHandler, RemoteContentTransferHandler.DeleteStatus.NONE, giOwner, credential);
            RemoteContentTransferHandler.getInstance().transferFileToRemoteHost(opatchAutoTmpWallet, this.credentialManager.getWalletLocation(), giHandler, RemoteContentTransferHandler.DeleteStatus.DELETE_ON_EXIT);
            giHandler.exec(sysInstCommand, (OutputStream)pipedOutputStream);
        }
        catch (RemoteConnectionException e) {
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"SDBProdutDriver.remote.execution.failure", (Object[])new Object[]{hostImpl.getHost(), oracleHome, junkOutputStream.toString()}));
            throw new ProductDriverException("68141 : " + (Object)((Object)e) + " : " + hostImpl.getHost());
        }
        finally {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.throwing("Exception in sleep : ", e.getMessage(), e);
                throw new ProductDriverException("Exception in sleep : \n" + e);
            }
            Receiving.stop((Receiver)receiver);
            try {
                receiver.getReceiverThread().join();
            }
            catch (InterruptedException e) {
                this.logger.throwing("Exception in join : ", e.getMessage(), e);
                throw new ProductDriverException("Exception in join  : \n" + e);
            }
        }
        try {
            junkOutputStream.flush();
            junkOutputStream.close();
        }
        catch (IOException e) {
            this.logger.throwing("Exception while closing junk output stream : ", e.getMessage(), e);
            throw new ProductDriverException("Exception while closing junk output stream : \n" + e);
        }
        this.logger.info("Output:\n****BEGIN\t REMOTE HOST ACTION OUTPUT****\n" + junkOutputStream.toString() + "\n****END REMOTE HOST ACTION OUTPUT****");
        if (junkOutputStream != null && junkOutputStream.toString() != null) {
            String message = null;
            if (junkOutputStream.toString().indexOf("PRKH-3003") != -1 || junkOutputStream.toString().indexOf("PRKH-1010") != -1 || junkOutputStream.toString().indexOf("PRCT-1011") != -1 || junkOutputStream.toString().indexOf("PRCI-1117") != -1) {
                message = OPatchAutoHelper.getLocalizedString((String)"SDBProdutDriver.communicate.failure", (Object[])new Object[]{hostImpl.getHost()});
            } else if (junkOutputStream.toString().indexOf("Failed to collect grid details") != -1) {
                message = OPatchAutoHelper.getLocalizedString((String)"SDBProdutDriver.details.collection.failure", (Object[])new Object[]{hostImpl.getHost()});
            } else if (junkOutputStream.toString().indexOf("Successfully detected grid features") == -1) {
                message = OPatchAutoHelper.getLocalizedString((String)"SDBProdutDriver.remote.execution.failure", (Object[])new Object[]{hostImpl.getHost(), oracleHome, junkOutputStream.toString()});
            }
            if (!StringUtil.isNullOrEmpty((String)message)) {
                Reporting.report((String)message);
                throw new ProductDriverException(message);
            }
        }
        try {
            if (handler.exists(remoteXmlPath)) {
                handler.get(remoteXmlPath, new File(localXmlPath));
            } else {
                this.logger.warning("Remote system instance xml file does not exist : " + remoteXmlPath);
            }
        }
        catch (RemoteConnectionException e) {
            this.logger.throwing("Exception while getting remote xml path : ", e.getMessage(), e);
            throw new ProductDriverException("Exception while getting remote xml path : \n" + (Object)((Object)e));
        }
        try {
            if (handler.exists(remoteXmlPath)) {
                handler.delete(remoteXmlPath);
            } else {
                this.logger.warning("Remote system instance xml file does not exist : " + remoteXmlPath);
            }
        }
        catch (RemoteConnectionException e) {
            this.logger.throwing("Exception while deleting remote xml path : ", e.getMessage(), e);
        }
    }

    private String createLocalXmlFilePath(String oracleHome, String fileName) throws ProductDriverException {
        String owner;
        String filePath = oracleHome + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE;
        boolean isOk = DBPatchingUtil.mkdirs(filePath, owner = OUIDriver.checkFileOwner((File)new File(oracleHome, DBCommonPatchingConstants.OPATCHAUTO_DB_SCRIPT)), null);
        if (!isOk) {
            throw new ProductDriverException(owner + " is unable to create the dir : " + filePath);
        }
        return filePath + File.separator + fileName;
    }

    private AbstractBaseTarget postExecute(String oracleHome, String xmlFileName, String currentHostName) throws ProductDriverException {
        String filePath = oracleHome + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE + xmlFileName;
        this.logger.fine("filePath : " + filePath);
        SystemInstance sysInst = new SystemInstance();
        try {
            sysInst = sysInst.readFile(new File(filePath));
        }
        catch (FileNotFoundException e) {
            this.logger.throwing("File not found : ", e.getMessage(), e);
            throw new ProductDriverException("File not found : " + filePath + " \n" + e);
        }
        this.logger.fine("System instance from the remote host : \n" + sysInst.toString());
        for (BaseClass abt : sysInst.getEntities()) {
            if (abt instanceof CRSCluster) {
                this.logger.fine("Getting the CRSCluster instance  " + ((CRSCluster)abt).getName() + " from host " + currentHostName);
                CRSCluster cluster = (CRSCluster)abt;
                cluster.setHostName(currentHostName);
                OracleHome oracleHomeObj = ((HAS)cluster.getHAS().get(0)).getRuns_from();
                oracleHomeObj.setHostName(currentHostName);
                cluster.setOracleHome(oracleHomeObj.getPath());
                cluster.setOwner(oracleHomeObj.getOwner());
                this.ti.getEntities().add(oracleHomeObj);
                this.getRacInstances((AbstractBaseTarget)cluster);
                for (Host host : cluster.getNodes()) {
                    if (!currentHostName.equalsIgnoreCase(host.getHostName())) continue;
                    ArrayList<OracleHome> oracleHomes = new ArrayList<OracleHome>();
                    oracleHomes.add(oracleHomeObj);
                    host.setOracleHomes(oracleHomes);
                    this.ti.getEntities().add(host);
                }
                for (Object o : oracleHomeObj.getTopLevelOUI()) {
                    this.ti.getEntities().add(o);
                }
                ASMCluster asmCluster = cluster.getASMCluster();
                if (asmCluster != null) {
                    for (ASMInstance asmInstance : asmCluster.getASMinstances()) {
                        this.ti.getEntities().add(asmInstance);
                    }
                }
                return cluster;
            }
            if (!(abt instanceof HAS)) continue;
            this.logger.fine("Getting the HAS instance  " + ((HAS)abt).getName() + " from host " + currentHostName);
            HAS has = (HAS)abt;
            has.setHostName(currentHostName);
            OracleHome oracleHomeObj = has.getRuns_from();
            oracleHomeObj.setHostName(currentHostName);
            has.setOracleHome(oracleHomeObj.getPath());
            has.setOwner(oracleHomeObj.getOwner());
            this.ti.getEntities().add(oracleHomeObj);
            ArrayList<OracleHome> oracleHomes = new ArrayList<OracleHome>();
            oracleHomes.add(oracleHomeObj);
            has.getHost().setOracleHomes(oracleHomes);
            this.ti.getEntities().add(has.getHost());
            for (OUIComponent o : oracleHomeObj.getTopLevelOUI()) {
                this.ti.getEntities().add(o);
            }
            List instanceASM = has.getInstanceASM();
            if (instanceASM != null) {
                for (ASMInstance asmInstance : instanceASM) {
                    this.ti.getEntities().add(asmInstance);
                }
            }
            return has;
        }
        return null;
    }

    private void getRacInstances(AbstractBaseTarget abt) {
        if (abt instanceof CRSCluster) {
            this.logger.fine("Getting the RACDatabase instances from CRS " + ((CRSCluster)abt).getName());
            CRSCluster crs = (CRSCluster)abt;
            List racdbsFrmCluster = crs.getDbRAC();
            List racdbs = this.ti.getTargetsOfType(RACDatabase.class);
            for (RACDatabase racDatabase : racdbsFrmCluster) {
                for (RACDatabase racdb : racdbs) {
                    this.logger.fine("Checking if the rac db names matches " + racDatabase.getDatabaseName() + " and " + racdb.getDatabaseName());
                    if (!racDatabase.getDatabaseName().equalsIgnoreCase(racdb.getDatabaseName())) continue;
                    racdb.setDbInstances(racDatabase.getDbInstances());
                    for (RACDBInstance racdbInst : racDatabase.getDbInstances()) {
                        this.ti.getEntities().add(racdbInst);
                    }
                }
            }
        }
    }

    private String getRemoteCommandForHAS(String oracleHome, HostImpl hostImpl) {
        String command = this.getPerlPath(oracleHome) + " " + oracleHome + File.separator + "OPatch" + File.separator + "auto" + File.separator + "database" + File.separator + "bin" + File.separator + "detecthas.pl " + this.createArgumentsForRemoteScript(oracleHome) + " -FINDHAS ";
        this.logger.info("command for identifying crs home : " + PatchActionUtil.replacePwdFrmCmd(command));
        return command;
    }

    private String getRemoteCommandForSysInst(String oracleHome, HostImpl hostImpl, String walletLoc) {
        String command = this.getPerlPath(oracleHome) + " " + oracleHome + File.separator + "OPatch" + File.separator + "auto" + File.separator + "database" + File.separator + "bin" + File.separator + "detecthas.pl " + this.createArgumentsForRemoteScript(oracleHome) + " -walletloc " + walletLoc + " -hostname " + hostImpl.getHost();
        this.logger.info("command for retrieving system instance: " + PatchActionUtil.replacePwdFrmCmd(command));
        return command;
    }

    private String getPerlPath(String oracleHome) {
        return oracleHome + File.separator + "perl" + File.separator + "bin" + File.separator + "perl";
    }

    private String createArgumentsForRemoteScript(String ohPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(" -oh ");
        sb.append(ohPath);
        return sb.toString();
    }
}

