/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.executor;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GIEnv;
import com.oracle.glcm.patch.auto.db.product.executor.ReaderThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.sysman.oii.oiix.OiixFileOps;

public class GISystemCall {
    private static final Logger _log = Logger.getLogger(DBPatchingUtil.class.getName());
    private static String suCommandPath = null;
    static Thread mainThread = Thread.currentThread();

    public static int runTimeExecution(String systemCommand) {
        int status = -1;
        try {
            Runtime runTime = Runtime.getRuntime();
            Process process = runTime.exec(systemCommand);
            return process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            status = -1;
            return status;
        }
    }

    public static void checkSuCommand() {
        if (suCommandPath != null) {
            return;
        }
        if (new File(DBCommonPatchingConstants.BIN_PATH + File.separator + "su").exists()) {
            suCommandPath = DBCommonPatchingConstants.BIN_PATH + File.separator + "su";
        } else if (new File(DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "su").exists()) {
            suCommandPath = DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "su";
        } else {
            int ret = GISystemCall.runTimeExecution("which su");
            if (ret == 0) {
                suCommandPath = "su";
            } else {
                RuntimeException re = new RuntimeException("'su' command could not be found in system path environment, command execution will be failed.");
                throw re;
            }
        }
    }

    public static ExecReturn process(String command, byte[] password) {
        return GISystemCall.process(command, null, password);
    }

    public static ExecReturn process(String command, String owner, Credential credential) {
        return GISystemCall.process(command, owner, credential, null);
    }

    public static ExecReturn process(String command, String owner, Credential credential, Map<String, String> envVarList) {
        ExecReturn er = new ExecReturn(new String[]{command});
        byte[] password = null;
        boolean useSudo = true;
        if (credential == null) {
            return GISystemCall.process(command, owner, password, envVarList);
        }
        char[] pass = null;
        try {
            pass = credential.getPassword();
        }
        catch (OPatchAutoException e) {
            pass = null;
        }
        if (pass != null) {
            password = new String(pass).getBytes();
        }
        if (owner == null) {
            owner = "root";
        }
        useSudo = !owner.equalsIgnoreCase(credential.getUsername());
        er = GISystemCall.process(command, owner, password, envVarList, useSudo);
        return er;
    }

    public static ExecReturn process(String command, String username, byte[] password) {
        return GISystemCall.process(command, username, password, null);
    }

    public static ExecReturn process(String command, String username, byte[] password, Map<String, String> envVarList) {
        return GISystemCall.process(command, username, password, envVarList, true);
    }

    public static ExecReturn process(String command, String username, byte[] password, Map<String, String> envVarList, boolean useSudo) {
        ExecReturn ret = null;
        String ohValue = "";
        try {
            ohValue = PatchPlanner.getInstance().getOPlanEnv().getOracleHome();
        }
        catch (Exception e) {
            ohValue = "";
        }
        if (ohValue != null && !ohValue.equals("")) {
            OUIDriver.setEnv((String)"oracleHome", (String)ohValue);
        }
        if (command == null) {
            String[] tmp = new String[]{"Null Command given by caller"};
            ret = new ExecReturn(tmp);
            ret.setErrorMessage("");
            ret.setNormalMessage("");
            ret.setReturnCode(0);
            return ret;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        String osname = GIEnv.getOsName();
        String currentUser = System.getProperty("user.name");
        if (username == null) {
            username = "root";
        }
        if (currentUser.equalsIgnoreCase("root")) {
            boolean runAsRoot;
            if (suCommandPath == null) {
                GISystemCall.checkSuCommand();
            }
            if (!(runAsRoot = username.equalsIgnoreCase("root"))) {
                cmds.add(suCommandPath);
                cmds.add(username);
                if (!osname.equalsIgnoreCase("SunOS") && !osname.equalsIgnoreCase("HP-UX")) {
                    cmds.add("-m");
                } else if (osname.equalsIgnoreCase("HP-UX")) {
                    cmds.add("+m");
                }
                cmds.add("-c");
                cmds.add(command);
            } else {
                String[] parts = (command = command.trim()).split("\\s+", 0);
                if (parts[0].trim().endsWith("bash")) {
                    for (String part : parts) {
                        cmds.add(part);
                    }
                } else {
                    String bashCommand = GISystemCall.getBashCmd(command);
                    cmds.add(bashCommand);
                    if (!osname.equalsIgnoreCase("SunOS") && !osname.equalsIgnoreCase("HP-UX")) {
                        cmds.add("-m");
                    } else if (osname.equalsIgnoreCase("HP-UX")) {
                        cmds.add("+m");
                    }
                    cmds.add("-c");
                    cmds.add(command);
                }
            }
        } else if (currentUser.equalsIgnoreCase(username)) {
            String bashCommand = GISystemCall.getBashCmd(command);
            cmds.add(bashCommand);
            if (!osname.equalsIgnoreCase("SunOS") && !osname.equalsIgnoreCase("HP-UX")) {
                cmds.add("-m");
            } else if (osname.equalsIgnoreCase("HP-UX")) {
                cmds.add("+m");
            }
            cmds.add("-c");
            cmds.add(command);
        } else {
            if (password == null) {
                String[] tmp = new String[]{command};
                ret = new ExecReturn(tmp);
                ret.setErrorMessage("Invalid password given by caller");
                ret.setNormalMessage("");
                ret.setReturnCode(41);
                return ret;
            }
            cmds.add(GISystemCall.getBashCmd(command));
            if (!osname.equalsIgnoreCase("SunOS") && !osname.equalsIgnoreCase("HP-UX")) {
                cmds.add("-m");
            } else if (osname.equalsIgnoreCase("HP-UX")) {
                cmds.add("+m");
            }
            cmds.add("-c");
            if (useSudo) {
                String formattedCommand = "echo '" + new String(password) + "' | " + GISystemCall.getSudoCmd(command) + GISystemCall.getSudoPreserveEnv(osname) + " -S -u " + username + " " + command;
                cmds.add(formattedCommand);
            } else {
                cmds.add(PatchActionUtil.getExpectFormattedSuCmd());
                cmds.add(username);
                cmds.add(command);
                cmds.add(new String(password));
            }
        }
        String logMsg = ((Object)cmds).toString();
        if (password != null) {
            logMsg = logMsg.replace(new String(password), "*******");
        }
        _log.info("System Call command is: " + logMsg);
        ret = GISystemCall.execute(cmds, envVarList);
        if (ret.getReturnCode() != 0 && GISystemCall.isRetryRequired(osname, ret)) {
            cmds.remove("+m");
            ret = GISystemCall.execute(cmds, envVarList);
        }
        return ret;
    }

    private static boolean isRetryRequired(String osName, ExecReturn ret) {
        boolean isRetry = false;
        String errorMsg = ret.getErrorMessage();
        if (osName.equalsIgnoreCase("HP-UX") && !StringUtil.isNullOrEmpty((String)errorMsg, (boolean)true) && errorMsg.contains("+m")) {
            isRetry = true;
        }
        _log.info("Is retry required=" + isRetry);
        return isRetry;
    }

    private static String getSudoPreserveEnv(String osname) {
        String preserveEnv = "";
        if (osname.equalsIgnoreCase("AIX")) {
            preserveEnv = " -E";
        }
        return preserveEnv;
    }

    private static ExecReturn execute(List<String> cmds, Map<String, String> envVariable) {
        ExecReturn ret = new ExecReturn(cmds.toArray(new String[cmds.size()]));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        if (envVariable != null && !envVariable.isEmpty()) {
            Map<String, String> currentEnv = pb.environment();
            Set<String> envKeyList = envVariable.keySet();
            for (String key : envKeyList) {
                currentEnv.put(key, envVariable.get(key));
            }
        }
        int retValue = -1;
        try {
            Process process = pb.start();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream, "ErrorStream");
            ReaderThread rinput = new ReaderThread(inputStream, "InputStream");
            rinput.start();
            rerror.start();
            retValue = process.waitFor();
            try {
                rerror.join();
                rinput.join();
                ret.setNormalMessage(rinput.outputString);
                String errorMsg = rerror.outputString;
                errorMsg = GISystemCall.trimErrorMessages(errorMsg);
                ret.setErrorMessage(errorMsg);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ret.setReturnCode(retValue);
        }
        catch (Throwable t) {
            ret.setErrorMessage(t.getMessage());
            ret.setNormalMessage(t.getMessage());
            ret.setReturnCode(-1);
        }
        if (!StringUtil.isNullOrEmpty((String)ret.getErrorMessage(), (boolean)true)) {
            _log.info("Error message:" + ret.getErrorMessage());
        }
        _log.info("Output message:" + ret.getNormalMessage());
        _log.info("Return code: " + ret.getReturnCode());
        return ret;
    }

    private static String trimErrorMessages(String errorMsg) {
        String[] lines;
        if (StringUtil.isNullOrEmpty((String)errorMsg, (boolean)true)) {
            return "";
        }
        String message = "";
        for (String line : lines = errorMsg.split(System.lineSeparator())) {
            if (line.indexOf("Inappropriate ioctl for device") != -1 || line.indexOf("no job control in this shell") != -1) continue;
            message = message + line + System.lineSeparator();
        }
        return message;
    }

    public static boolean createNewFile(String filePath) throws RuntimeException {
        File newFile = new File(filePath);
        String parentDirName = newFile.getParent();
        File parentFile = new File(parentDirName);
        if (!newFile.exists()) {
            try {
                boolean ok;
                if (!parentFile.exists() && !(ok = parentFile.mkdirs())) {
                    StringBuffer buff = new StringBuffer("GISystemCall::createNewFile(String) cannot mkdirs on ");
                    buff.append(parentFile.getPath());
                    _log.log(Level.WARNING, buff.toString());
                    throw new RuntimeException(buff.toString());
                }
                newFile.createNewFile();
                return true;
            }
            catch (Exception e) {
                StringBuffer buff = new StringBuffer("GISystemCall::createNewFile(String) failed to create file  ");
                buff.append(filePath);
                _log.log(Level.WARNING, buff.toString());
                throw new RuntimeException(buff.toString());
            }
        }
        return false;
    }

    public static boolean chownRecurse(String dir, String owner, String group) {
        if (ComdevHelper.isWindows()) {
            return true;
        }
        File top = new File(dir);
        try {
            OiixFileOps.chown((String)dir, (String)owner, (String)group);
        }
        catch (IOException e) {
            return false;
        }
        if (top.isFile()) {
            return true;
        }
        File[] subFiles = top.listFiles();
        for (int i = 0; i < subFiles.length; ++i) {
            GISystemCall.chownRecurse(subFiles[i].getAbsolutePath(), owner, group);
        }
        return true;
    }

    public static String formatSHCommand(String command, boolean formatCommandparams) {
        StringBuilder shCmd = new StringBuilder();
        shCmd.append(GISystemCall.getSHCmd(command));
        shCmd.append(" -c '");
        if (formatCommandparams) {
            shCmd.append(GISystemCall.formatCommand(command));
        } else {
            shCmd.append(command.replaceAll("'", "\""));
        }
        shCmd.append("'");
        return shCmd.toString();
    }

    private static String formatCommand(String command) {
        if (!command.startsWith("echo \"")) {
            if (command.contains("\"")) {
                command = command.replace("\"", "\\\"");
            }
            if (command.contains("`")) {
                command = command.replace("`", "\\`");
            }
            if (command.contains("$")) {
                command = command.replace("$", "\\$");
            }
            if (command.contains("!")) {
                command = command.replace("!", "\\!");
            }
            command = command.replace("'", "\"");
        } else if (command.contains("'")) {
            command = command.replace("'", "'\\''");
        }
        return command;
    }

    public static String getSHCmd(String command) {
        String sh = "";
        if (new File(DBCommonPatchingConstants.BIN_PATH + File.separator + "sh").exists()) {
            sh = DBCommonPatchingConstants.BIN_PATH + File.separator + "sh";
        } else if (new File(DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "sh").exists()) {
            sh = DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "sh";
        } else {
            int ret = GISystemCall.runTimeExecution("which sh");
            if (ret == 0) {
                sh = "sh";
            } else {
                RuntimeException re = new RuntimeException("opatchauto wasn't able to run the command \"" + command + "\" because 'bash' command could not be found on the current platform.");
                throw re;
            }
        }
        return sh;
    }

    public static String getSudoCmd(String command) {
        String sudo = "";
        if (new File(DBCommonPatchingConstants.BIN_PATH + File.separator + "sudo").exists()) {
            sudo = DBCommonPatchingConstants.BIN_PATH + File.separator + "sudo";
        } else if (new File(DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "sudo").exists()) {
            sudo = DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "sudo";
        } else if (new File(DBCommonPatchingConstants.USR_LOCAL_BIN_PATH + File.separator + "sudo").exists()) {
            sudo = DBCommonPatchingConstants.USR_LOCAL_BIN_PATH + File.separator + "sudo";
        } else {
            int ret = GISystemCall.runTimeExecution("which sudo");
            if (ret == 0) {
                sudo = "sudo";
            } else {
                RuntimeException re = new RuntimeException("opatchauto wasn't able to run the command \"" + command + "\" because 'sudo' command could not be found on the current platform.");
                throw re;
            }
        }
        _log.info("Sudo path::" + sudo);
        return sudo;
    }

    public static String getBashCmd(String command) {
        String bashCommand = "";
        if (new File(DBCommonPatchingConstants.BIN_PATH + File.separator + "bash").exists()) {
            bashCommand = DBCommonPatchingConstants.BIN_PATH + File.separator + "bash";
        } else if (new File(DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "bash").exists()) {
            bashCommand = DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "bash";
        } else {
            int ret = GISystemCall.runTimeExecution("which bash");
            if (ret == 0) {
                bashCommand = "bash";
            } else {
                RuntimeException re = new RuntimeException("opatchauto wasn't able to run the command \"" + command + "\" because 'bash' command could not be found on the current platform.");
                throw re;
            }
        }
        return bashCommand;
    }

    public static class ExecReturn {
        String[] systemCommand;
        String errorMessage;
        String normalMessage;
        int retCode;
        boolean ok;

        public ExecReturn(String[] cmd) {
            this.systemCommand = cmd;
            this.errorMessage = "";
            this.normalMessage = "";
            this.retCode = 0;
            this.ok = true;
        }

        public String getCommand() {
            if (this.systemCommand != null) {
                StringBuffer cmd = new StringBuffer();
                for (int i = 0; i < this.systemCommand.length; ++i) {
                    cmd.append(this.systemCommand[i]);
                    cmd.append("\n");
                }
                return cmd.toString();
            }
            return "Command not intialized";
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getNormalMessage() {
            return this.normalMessage;
        }

        public int getReturnCode() {
            return this.retCode;
        }

        public boolean isOK() {
            return this.ok;
        }

        protected void setErrorMessage(String msg) {
            this.errorMessage = msg;
        }

        protected void setNormalMessage(String msg) {
            this.normalMessage = msg;
        }

        protected void setReturnCode(int c) {
            this.retCode = c;
            this.ok = this.retCode == 0;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("[GISystemCall.ExecReturn: ");
            buff.append("systemCommand= (");
            if (this.systemCommand == null) {
                buff.append("null");
            } else {
                for (int i = 0; i < this.systemCommand.length; ++i) {
                    String cmd = this.systemCommand[i];
                    if (cmd == null) continue;
                    buff.append("\"");
                    buff.append(cmd);
                    buff.append("\"");
                    if (i == this.systemCommand.length - 1) continue;
                    buff.append(", ");
                }
                buff.append(")");
            }
            buff.append(", errMsg= ");
            buff.append(this.errorMessage);
            buff.append(", normalMsg= ");
            buff.append(this.normalMessage);
            buff.append(", return code= ");
            buff.append(this.retCode);
            buff.append(", exec. ok= ");
            buff.append(this.ok);
            buff.append("]");
            return buff.toString();
        }
    }
}

