/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.helper.remote.exec.model.OPeration;
import com.oracle.helper.remote.exec.model.Request;
import com.oracle.helper.remote.exec.model.TransferOPeration;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;

public class OOPSessionCookieTransferHandler {
    static final Logger logger = Logger.getLogger(OOPSessionCookieTransferHandler.class.getName());

    public void distributeLocal(OOPSessionCookie cookie, Credential credential) throws OPatchAutoException {
        Map<String, List<String>> ownerHomeMap = this.getHomeOwnerMap(cookie.getOperationType());
        this.handleLocalTransfer(OOPSessionInfoHandler.getInstance().getOOPSessionInfo(), ownerHomeMap, cookie.getOperationType(), credential);
    }

    public void distributeRemote(OOPSessionCookie cookie, Credential credential) throws OPatchAutoException {
        Set<Map.Entry<String, OOPSessionInfo>> oopsEntries = cookie.getOOPSessionInfoList();
        Map<String, List<String>> ownerHomeMap = this.getHomeOwnerMap(cookie.getOperationType());
        this.handleRemoteTranfer(oopsEntries, ownerHomeMap, cookie.getOperationType(), credential);
    }

    public void distributeSystemInfo(OOPSessionCookie cookie, Credential credential) throws OPatchAutoException {
        OOPSessionInfoHandler instance = OOPSessionInfoHandler.getInstance();
        if (!cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.SWITCH) && instance.isFirstNode(DBPatchingHelper.getLocalHost())) {
            Map<String, List<String>> ownerHomeMap = this.getHomeOwnerMap(cookie.getOperationType());
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            List<Host> hostList = configGraph.getTargets(Host.class);
            for (Host host : hostList) {
                this.pushNonrollingFile(ownerHomeMap, credential, host.getHostName());
            }
        }
    }

    private void handleLocalTransfer(OOPSessionInfo oopSessionInfo, Map<String, List<String>> ownerHomeMap, OOPSessionCookie.OOPOperationType oopOperationType, Credential credential) throws OPatchAutoException {
        Iterator<String> ownerItr = ownerHomeMap.keySet().iterator();
        String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        String src = OPatchAutoHelper.getOPatchAutoHome() + sessionInfoFile;
        logger.info("Copying file : " + src + " to other homes.");
        while (ownerItr.hasNext()) {
            String owner = ownerItr.next();
            List<String> homes = ownerHomeMap.get(owner);
            for (String home : homes) {
                boolean isCloneHome;
                logger.info("Data transfer for home : " + home);
                if (!DBPatchingHelper.compareFilePath(home, OPatchAutoHelper.getOPatchAutoHome())) {
                    this.copySessionInfo(src, owner, home, credential);
                }
                if (!(isCloneHome = OOPSessionInfoHandler.getInstance().getCloneHomePath(home) == null)) continue;
                this.copySwitchbackSessionFile(oopOperationType, src, owner, home, credential);
            }
        }
    }

    private void copySessionInfo(String src, String owner, String home, Credential credential) throws OPatchAutoException {
        File oraInstLocFile = new File(home, "oraInst.loc");
        if (oraInstLocFile.exists()) {
            StringBuffer buff = new StringBuffer(home);
            buff.append(File.separator);
            buff.append(".opatchauto_storage");
            buff.append(File.separator);
            DBPatchingHelper.createPatchDirectory(home, buff.toString(), credential, "750");
            buff.append(DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
            DBPatchingHelper.createPatchDirectory(home, buff.toString(), credential, "750");
            String cmd = "cp -rf " + src + " " + buff.toString();
            logger.info("Copying session info . Command : " + cmd);
            GISystemCall.process(cmd, owner, credential);
            logger.info("Changing file owner for folder : " + buff.toString());
            DBPatchingHelper.changeOwner(home, credential, new File(buff.toString()));
        }
    }

    private void copySwitchbackSessionFile(OOPSessionCookie.OOPOperationType oopOperationType, String src, String owner, String cloneHomePath, Credential credential) throws OPatchAutoException {
        if (oopOperationType.equals((Object)OOPSessionCookie.OOPOperationType.SWITCH) || oopOperationType.equals((Object)OOPSessionCookie.OOPOperationType.APPLY)) {
            String sbSessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
            sbSessionInfoFile = sbSessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
            String switchbackFileHomePath = cloneHomePath + sbSessionInfoFile;
            String cmd = "cp -rf " + src + " " + switchbackFileHomePath;
            logger.info("Copying switchback session info . Command : " + cmd);
            GISystemCall.process(cmd, owner, credential);
            logger.info("Changing file owner for folder : " + switchbackFileHomePath);
            File switchbackFile = new File(switchbackFileHomePath);
            if (switchbackFile.exists()) {
                DBPatchingHelper.changeOwner(cloneHomePath, credential, switchbackFile);
            }
        }
    }

    private void handleRemoteTranfer(Set<Map.Entry<String, OOPSessionInfo>> oopsEntries, Map<String, List<String>> ownerHomeMap, OOPSessionCookie.OOPOperationType oopOperationType, Credential credential) throws OPatchAutoException {
        OOPSessionInfoHandler instance = OOPSessionInfoHandler.getInstance();
        if (instance.isSessionCompletedOnAllNode()) {
            for (Map.Entry<String, OOPSessionInfo> entry : oopsEntries) {
                String host = entry.getKey();
                this.pushSessionInfo(ownerHomeMap, oopOperationType, credential, host);
            }
        }
    }

    private void pushSessionInfo(Map<String, List<String>> ownerHomeMap, OOPSessionCookie.OOPOperationType oopOperationType, Credential credential, String host) throws OPatchAutoException {
        if (!host.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) {
            Request request = null;
            Iterator<String> ownerItr = ownerHomeMap.keySet().iterator();
            while (ownerItr.hasNext()) {
                request = new Request(host);
                String owner = ownerItr.next();
                List<String> homes = ownerHomeMap.get(owner);
                for (String home : homes) {
                    boolean isCloneHome;
                    OOPSessionInfoHandler instance = OOPSessionInfoHandler.getInstance();
                    String cloneHomePath = null;
                    boolean bl = isCloneHome = instance.getCloneHomePath(home) == null;
                    if ((oopOperationType.equals((Object)OOPSessionCookie.OOPOperationType.SWITCH) || oopOperationType.equals((Object)OOPSessionCookie.OOPOperationType.APPLY)) && isCloneHome) {
                        cloneHomePath = home;
                    }
                    this.fillCopyOperation(home, request, cloneHomePath);
                }
                this.executeRequest(credential, host, request, owner, homes);
            }
        }
    }

    private void pushNonrollingFile(Map<String, List<String>> ownerHomeMap, Credential credential, String host) throws OPatchAutoException {
        if (!host.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) {
            Request request = null;
            Iterator<String> ownerItr = ownerHomeMap.keySet().iterator();
            while (ownerItr.hasNext()) {
                request = new Request(host);
                String owner = ownerItr.next();
                List<String> homes = ownerHomeMap.get(owner);
                for (String home : homes) {
                    OOPSessionInfoHandler instance = OOPSessionInfoHandler.getInstance();
                    boolean isCloneHome = instance.getCloneHomePath(home) == null;
                    if (isCloneHome) continue;
                    String srcPath = OOPSessionInfoHandler.getInstance().getOOPSessionInfo().getSystemInstanceFilePath();
                    TransferOPeration op = new TransferOPeration(home + DBCommonPatchingConstants.OOP_NONROLLING_TOPOLOGY_FILE_PATH, srcPath, OPeration.OPerationType.TRANSFER);
                    request.addOperation((OPeration)op);
                }
                this.executeRequest(credential, host, request, owner, homes);
            }
        }
    }

    private void executeRequest(Credential credential, String host, Request request, String owner, List<String> homes) throws OPatchAutoException {
        String objLoc = homes.get(0) + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "request_" + host + ".ser";
        String responseObjLoc = homes.get(0) + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "response_" + host + ".ser";
        OOPSessionInfoHelper.serializeFile(objLoc, request, owner, credential);
        GISystemCall.ExecReturn er = GISystemCall.process(OOPSessionCookieTransferHandler.getRemoteCommand(homes.get(0), objLoc, responseObjLoc), owner, credential);
        logger.info("Execution result for cookie distribution: " + er.isOK());
        new File(responseObjLoc).delete();
        new File(objLoc).delete();
    }

    private Map<String, List<String>> getHomeOwnerMap(OOPSessionCookie.OOPOperationType oopOperationType) {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> ohList = configGraph.getTargets(OracleHome.class);
        HashMap<String, List<String>> homeOwnerMap = new HashMap<String, List<String>>();
        String version = PatchPlanner.getInstance().getPrimaryPatchVersion();
        for (OracleHome oh : ohList) {
            if (!DBPatchingUtil.canIncludeTargetByVersion(configGraph, (AbstractBaseTarget)oh, version)) continue;
            String homeOwner = oh.getOwner();
            if (homeOwnerMap.containsKey(homeOwner)) {
                String value = FileUtils.getFile((String)oh.getPath()).getPath();
                if (((List)homeOwnerMap.get(homeOwner)).contains(value)) continue;
                ((List)homeOwnerMap.get(homeOwner)).add(value);
                ((List)homeOwnerMap.get(homeOwner)).add(OOPSessionInfoHandler.getInstance().getCloneHomePath(oh.getPath()));
                continue;
            }
            ArrayList<String> homeList = new ArrayList<String>();
            homeList.add(FileUtils.getFile((String)oh.getPath()).getPath());
            homeList.add(OOPSessionInfoHandler.getInstance().getCloneHomePath(oh.getPath()));
            homeOwnerMap.put(homeOwner, homeList);
        }
        return homeOwnerMap;
    }

    private void fillCopyOperation(String location, Request request, String cloneHomePath) {
        String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        String localsessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        String remotesessionInfoFile = sessionInfoFile.replace("$HOST_NAME", request.getHost());
        String localCookie = location + localsessionInfoFile;
        String remoteCookie = location + remotesessionInfoFile;
        TransferOPeration op = new TransferOPeration(remoteCookie, localCookie, OPeration.OPerationType.TRANSFER);
        request.addOperation((OPeration)op);
        logger.info("Transfer is triggered from source: " + localCookie + " to destination: " + remoteCookie + " on " + request.getHost());
        if (cloneHomePath != null) {
            String sbSessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
            sbSessionInfoFile = sbSessionInfoFile.replace("$HOST_NAME", request.getHost());
            String remoteSwitchbackCookie = cloneHomePath + sbSessionInfoFile;
            op = new TransferOPeration(remoteSwitchbackCookie, localCookie, OPeration.OPerationType.TRANSFER);
            request.addOperation((OPeration)op);
            logger.info("Transfer is triggered from source: " + localCookie + " to destination: " + remoteSwitchbackCookie + " on " + request.getHost());
        }
    }

    private static String getRemoteCommand(String homePath, String objLoc, String responseLoc) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(homePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append((CharSequence)perlPath);
        remoteCommand.append(homePath);
        remoteCommand.append(ProductDriverConstants.OPATCHAUTO_BIN);
        remoteCommand.append("RemoteHostExecutor.pl ");
        remoteCommand.append(" -OBJECTLOC=").append(objLoc);
        remoteCommand.append(" -RESPONSEOBJECTLOC=").append(responseLoc);
        remoteCommand.append(" -JVM_HANDLER=com.oracle.helper.remote.exec.RemoteRequestHandler ");
        logger.info("remote command: " + remoteCommand.toString());
        return remoteCommand.toString();
    }
}

