/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;

public class OOPSessionInfoHelper {
    private static final Logger logger = Logger.getLogger(OOPSessionInfoHelper.class.getName());

    public static void serializeFile(String filePath, Object obj, String owner, Credential credential) throws OPatchAutoException {
        OOPSessionInfoHelper.createFile(filePath, owner, credential);
        FileOutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = new FileOutputStream(filePath);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(obj);
        }
        catch (IOException e) {
            throw new OPatchAutoException((Throwable)e);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException((Throwable)e);
            }
        }
    }

    private static void createFile(String filePath, String owner, Credential credential) throws OPatchAutoException {
        if (new File(filePath).exists()) {
            return;
        }
        File hostDirectory = new File(filePath).getParentFile();
        if (!hostDirectory.exists()) {
            File patchStorageDirectory = hostDirectory.getParentFile();
            DBPatchingHelper.createPatchDirectory(patchStorageDirectory.getParent(), patchStorageDirectory.getAbsolutePath(), credential, "750");
            DBPatchingHelper.createPatchDirectory(patchStorageDirectory.getParent(), hostDirectory.getAbsolutePath(), credential, "750");
        }
        DBPatchingUtil.createNewFile(filePath, owner, credential);
    }

    public static OOPHomeInfo.HomeOperationType getHomeOperationType(OOPSessionCookie.OOPOperationType operationType) {
        OOPHomeInfo.HomeOperationType type = null;
        switch (operationType) {
            case PREPARE: {
                type = OOPHomeInfo.HomeOperationType.PREPARE;
                break;
            }
            case SWITCH: {
                type = OOPHomeInfo.HomeOperationType.SWITCH;
                break;
            }
            case APPLY: {
                type = OOPHomeInfo.HomeOperationType.APPLY;
                break;
            }
            case ROLLBACK: {
                type = OOPHomeInfo.HomeOperationType.ROLLBACK;
                break;
            }
        }
        return type;
    }

    public static boolean isFirstRollbackNode(String requestedHome) {
        logger.info("Identifying rollback stage for home " + requestedHome + " ...");
        if (!OOPSessionInfoHandler.getInstance().getCurrentOperationType().equals((Object)OOPSessionCookie.OOPOperationType.ROLLBACK)) {
            logger.info("Curent session is not a rollback session");
            return false;
        }
        List<Host> hostList = OOPSessionInfoHelper.getHostListForRequestedHome(requestedHome);
        if (!hostList.isEmpty()) {
            for (Host host : hostList) {
                String hostName = host.getHostName();
                logger.info("hostName: " + hostName);
                if (hostName.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) continue;
                OOPSessionInfo oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo(hostName);
                if (oopSessionInfo != null) {
                    List<OOPHomeInfo> homeInfoList = oopSessionInfo.getHomeInfoList();
                    for (OOPHomeInfo homeInfo : homeInfoList) {
                        logger.info("homeInfo.getOriginalHome(): " + homeInfo.getOriginalHome());
                        if (!DBPatchingHelper.compareFilePath(requestedHome, homeInfo.getOriginalHome())) continue;
                        logger.info("homeInfo.isSessionCompleted(): " + homeInfo.isSessionCompleted());
                        if ((homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.SWITCH) || homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.APPLY)) && homeInfo.isSessionCompleted()) continue;
                        logger.info("Operation on host " + hostName + " is " + (Object)((Object)homeInfo.getHomeOperationType()));
                        return false;
                    }
                    continue;
                }
                logger.info("Session Info not found for the remote host " + hostName);
            }
        }
        logger.info("This is the first rollback node.");
        return true;
    }

    public static boolean canExecuteDBSteps(PatchTarget patchTarget, boolean isRemotePatching) {
        boolean canExecuteAction = true;
        if (isRemotePatching) {
            try {
                if (patchTarget.isRemote()) {
                    canExecuteAction = false;
                }
            }
            catch (OPatchAutoException e) {
                canExecuteAction = false;
            }
            logger.info("canExecuteAction: " + canExecuteAction);
            return canExecuteAction;
        }
        String requestedHome = patchTarget.getHome(true).getLocation();
        boolean is_shared_rac = patchTarget.getHome(true).isSharedHome();
        boolean no_crs = OOPSessionInfoHelper.no_crs(requestedHome);
        List<Host> hostList = OOPSessionInfoHelper.getHostListForRequestedHome(requestedHome);
        if (!hostList.isEmpty()) {
            canExecuteAction = is_shared_rac && no_crs ? OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget) : SessionData.getInstance().isSelectedFinalHost();
        }
        logger.info("canExecuteAction: " + canExecuteAction);
        return canExecuteAction;
    }

    public static boolean no_crs(String requestedHome) {
        logger.info("requestedHome for checking no crs : " + requestedHome);
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> ohList = configGraph.getTargets(OracleHome.class);
        for (OracleHome oh : ohList) {
            if (!oh.getHomeType().equals("crs") && !oh.getHomeType().equals("siha")) continue;
            return false;
        }
        return true;
    }

    public static String getRemoteCommand(String homePath, String objLoc, String responseLoc) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(homePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append((CharSequence)perlPath);
        remoteCommand.append(homePath);
        remoteCommand.append(ProductDriverConstants.OPATCHAUTO_BIN);
        remoteCommand.append("RemoteHostExecutor.pl ");
        remoteCommand.append(" -OBJECTLOC=").append(objLoc);
        remoteCommand.append(" -RESPONSEOBJECTLOC=").append(responseLoc);
        remoteCommand.append(" -JVM_HANDLER=com.oracle.helper.remote.exec.RemoteRequestHandler ");
        logger.info("remote command: " + remoteCommand.toString());
        return remoteCommand.toString();
    }

    public static List<Host> getHostListForRequestedHome(String requestedHome) {
        logger.info("requestedHome: " + requestedHome);
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<Host> hostList = new ArrayList<Host>();
        ArrayList<String> identifiedHosts = new ArrayList<String>();
        List<OracleHome> ohList = configGraph.getTargets(OracleHome.class);
        for (OracleHome oh : ohList) {
            if (!DBPatchingHelper.compareFilePath(requestedHome, oh.getPath()) || !oh.getHomeType().equals("crs") && !oh.getHomeType().equals("siha")) continue;
            hostList.addAll(configGraph.getTargets(Host.class));
            break;
        }
        if (hostList.isEmpty()) {
            List<RACDatabase> racDBs = configGraph.getTargets(RACDatabase.class);
            for (RACDatabase racDB : racDBs) {
                Database sdb;
                String dbname = racDB.getDatabaseName();
                logger.info("oh: " + racDB.getOracleHome());
                if (!DBPatchingHelper.compareFilePath(requestedHome, racDB.getOracleHome())) continue;
                try {
                    DatabaseFactory fact = DatabaseFactory.getInstance();
                    try {
                        sdb = fact.getDatabase(dbname);
                        logger.info("hostlist as per srvctl  API is:" + sdb.nodes());
                    }
                    catch (Exception e) {
                        logger.info("exception in sdb");
                    }
                }
                catch (Exception e) {
                    logger.info("exception in gettingg db fact");
                }
                List instances = racDB.getDbInstances();
                for (RACDBInstance instance : instances) {
                    if (OOPSessionInfoHelper.hostSelected(instance.getHost(), identifiedHosts)) continue;
                    hostList.add(instance.getHost());
                    identifiedHosts.add(instance.getHost().getHostName());
                }
                try {
                    DatabaseFactory fact = DatabaseFactory.getInstance();
                    try {
                        sdb = fact.getDatabase(dbname);
                        if (hostList.size() != 1 || OOPSessionInfoHelper.isAdminManagedDB(sdb)) continue;
                        logger.info("Selecting all hosts from ConfigGraph");
                        hostList.removeAll(hostList);
                        hostList.addAll(configGraph.getTargets(Host.class));
                    }
                    catch (Exception e) {
                        logger.info("Exception in sdb");
                    }
                }
                catch (Exception e) {
                    logger.info("Exception in gettingg db fact");
                }
            }
        }
        if (hostList.isEmpty()) {
            List<SIDatabase> sidbs = configGraph.getTargets(SIDatabase.class);
            for (SIDatabase sidb : sidbs) {
                logger.info("oh: " + sidb.getOracleHome());
                if (!DBPatchingHelper.compareFilePath(requestedHome, sidb.getOracleHome())) continue;
                hostList.add(sidb.getHost());
                break;
            }
        }
        if (hostList.isEmpty()) {
            try {
                String gimrHome = DBPatchingHelper.getGIMRHomePath();
                if (null != gimrHome && gimrHome.length() > 0) {
                    logger.info("gimrHome: " + gimrHome);
                    hostList.addAll(configGraph.getTargets(Host.class));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        logger.info("Host list size: " + hostList.size());
        return hostList;
    }

    private static boolean hostSelected(Host host, ArrayList<String> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (String fromList : list) {
            if (!host.getHostName().equalsIgnoreCase(fromList)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClonePathExists(List<String> requestedHomeList, OOPSessionCookie cookie) throws OPatchAutoException {
        Map.Entry<String, OOPSessionInfo> oopSessionInfoEntry = cookie.getOOPSessionInfoList().iterator().next();
        OOPSessionInfo oopSessionInfo = oopSessionInfoEntry.getValue();
        for (OOPHomeInfo oopHomeInfo : oopSessionInfo.getHomeInfoList()) {
            if (!requestedHomeList.contains(FileUtils.getFile((String)oopHomeInfo.getCloneHome()).getPath()) || !new File(oopHomeInfo.getCloneHome()).exists()) continue;
            throw new OPatchAutoException(Integer.toString(72124), new Object[]{cookie.getOperationType().name().toLowerCase(), oopHomeInfo.getCloneHome()});
        }
        return true;
    }

    private static boolean isAdminManagedDB(Database sdb) throws ServerGroupException {
        boolean isAdminManaged = false;
        List serverGrp = sdb.serverGroups();
        if (serverGrp.size() == 1 && !((ServerGroup)serverGrp.get(0)).isServerPool()) {
            isAdminManaged = true;
        }
        logger.info("isAdminManaged: " + isAdminManaged);
        return isAdminManaged;
    }

    public static HashMap<String, String> identifyParallelSessions(OOPSessionInfo osi) {
        HashMap<String, String> parallel_sessions = new HashMap<String, String>();
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<Host> dbModelHostList = configGraph.getTargets(Host.class);
        String localhost = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
        block2: for (Host host : dbModelHostList) {
            String remote_host = host.getHostName();
            if (!DBPatchingHelper.getHostNameWithoutDomain(localhost).equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(remote_host))) {
                for (OOPHomeInfo home_info : osi.getHomeInfoList()) {
                    String home = home_info.getOriginalHome();
                    if (!OOPSessionInfoHelper.isSessionActive(remote_host, home)) continue;
                    parallel_sessions.put(remote_host, home);
                    continue block2;
                }
                continue;
            }
            try {
                String localhome = OPatchAutoHelper.getOPatchAutoHome();
                parallel_sessions.put(localhost, localhome);
            }
            catch (OPatchAutoException e) {
                logger.info("Failed to add local node to active session list");
            }
        }
        logger.info("Active sessions in progress on the following hosts : " + parallel_sessions.keySet());
        return parallel_sessions;
    }

    private static boolean isSessionActive(String remote_host, String home) {
        String owner = FileUtility.checkFileOwner((File)new File(home, "oraInst.loc"));
        String file = DBPatchingHelper.getOPatchAutoStorage(home, remote_host) + File.separator + "active_oop.lock";
        return DBPatchingHelper.remoteFileExists(remote_host, owner, file);
    }

    public static boolean isSessionCompletedOnAllNodesAtRuntime() {
        try {
            String ref_home = OPatchAutoHelper.getOPatchAutoHome();
            List<Host> hostList = OOPSessionInfoHelper.getHostListForRequestedHome(ref_home);
            String localhost = DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost());
            OOPSessionInfoHandler instance = OOPSessionInfoHandler.getInstance();
            OOPSessionCookie.OOPOperationType oper = instance.getCurrentOperationType();
            logger.info("Home map will be compared for home " + ref_home);
            for (Host host : hostList) {
                String remote_host = DBPatchingHelper.getHostNameWithoutDomain(host.getHostName());
                if (localhost.equalsIgnoreCase(remote_host)) continue;
                if (OOPSessionInfoHelper.isSessionCompletedOnRemoteNode(remote_host, localhost, ref_home, oper)) {
                    logger.info("OOP Session already completed on host " + remote_host);
                    continue;
                }
                logger.info("OOP Session NOT completed on host " + remote_host);
                return false;
            }
            logger.info("OOP Session already completed on ALL hosts.");
            return true;
        }
        catch (Exception e) {
            logger.info("Hit an Exception while trying to read remote cookies : \n" + e.getMessage());
            return false;
        }
    }

    public static boolean isSessionCompletedOnRemoteNode(String remote_host, String localhost, String home, OOPSessionCookie.OOPOperationType oper) {
        String owner = FileUtility.checkFileOwner((File)new File(home, "oraInst.loc"));
        String remote_cookie = DBPatchingHelper.getOPatchAutoStorage(home, remote_host) + File.separator + "oopsessioninfo.ser";
        String local_copy = DBPatchingHelper.getOPatchAutoStorage(home, localhost) + File.separator + remote_host + "_oopsessioninfo.ser";
        if (DBPatchingHelper.remoteFileExists(remote_host, owner, remote_cookie)) {
            DBPatchingHelper.copyRemoteFileToLocal(remote_host, owner, remote_cookie, local_copy);
            try {
                OOPSessionInfo rosi;
                OOPSessionCookie rc = OOPSessionInfoHandler.getInstance().getOOPSessionCookie(new File(local_copy));
                if (rc.getOperationType() != null && oper.equals((Object)rc.getOperationType())) {
                    logger.info("Same operation identified on remote node " + remote_host);
                    rosi = rc.getOOPSessionInfo(remote_host);
                    if (rosi == null) {
                        logger.info("OOP session info not found on remote node " + remote_host);
                        return false;
                    }
                    if (rosi.getHomeInfoList() == null) {
                        logger.info("HomeInfo list not available on this host");
                        return false;
                    }
                    String clone_path = OOPSessionInfoHandler.getInstance().getCloneHomePath(home);
                    logger.info("Matching original and cloned home on remote node.");
                    boolean matches = false;
                    for (OOPHomeInfo rohi : rosi.getHomeInfoList()) {
                        String path = rohi.getOriginalHome();
                        String clone = rohi.getCloneHome();
                        if (path == null || !home.equals(path) || !clone_path.equals(clone)) continue;
                        logger.info("Original and clone home paths match on remote node.");
                        matches = true;
                        break;
                    }
                    if (!matches) {
                        logger.info("Original/Clone home does not match on remote node.");
                        return false;
                    }
                    for (OOPHomeInfo rohi : rosi.getHomeInfoList()) {
                        if (rohi.isSessionCompleted()) continue;
                        logger.info("Session not completed for home " + rohi.getOriginalHome());
                        return false;
                    }
                } else {
                    logger.info("OOP operation does not match on host " + remote_host);
                    return false;
                }
                OOPSessionInfoHandler.getInstance().updateRemoteSessionInfo(rosi);
            }
            catch (OPatchAutoException e) {
                logger.info("Unable to read cookie " + local_copy + "\n " + e.getMessage());
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static void deleteLocalCopyOfRemoteCookies() {
        try {
            String ref_home = OPatchAutoHelper.getOPatchAutoHome();
            List<Host> hostList = OOPSessionInfoHelper.getHostListForRequestedHome(ref_home);
            String localhost = DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost());
            for (Host host : hostList) {
                String remote_cookie;
                File rc;
                String remote_host = DBPatchingHelper.getHostNameWithoutDomain(host.getHostName());
                if (localhost.equalsIgnoreCase(remote_host) || !(rc = new File(remote_cookie = DBPatchingHelper.getOPatchAutoStorage(ref_home, localhost) + File.separator + remote_host + "_oopsessioninfo.ser")).exists()) continue;
                rc.delete();
                logger.info("Deleted file " + remote_cookie);
            }
        }
        catch (OPatchAutoException e) {
            logger.info("Failed to delete local copy of cookie " + e.getMessage());
        }
    }

    public static void registerWithStationHost(String localhost, String station_host, String home) {
        String owner = FileUtility.checkFileOwner((File)new File(home, "oraInst.loc"));
        String file = DBPatchingHelper.getOPatchAutoStorage(home, station_host) + File.separator + "transfer.lock";
        if (localhost.equals(station_host)) {
            Credential credential = null;
            DBPatchingUtil.createNewFile(file, owner, credential);
        } else {
            DBPatchingHelper.createFileOnRemote(station_host, owner, file);
        }
        if (localhost.equals(station_host)) {
            DBPatchingHelper.appendLineToLocalFile(owner, file, localhost);
        } else {
            DBPatchingHelper.appendLineToFileOnRemote(station_host, owner, file, localhost);
        }
    }

    public static void deleteTransferLock(String localhost, String station_host, String station_home) {
        String owner = FileUtility.checkFileOwner((File)new File(station_home, "oraInst.loc"));
        String file = DBPatchingHelper.getOPatchAutoStorage(station_home, station_host) + File.separator + "transfer.lock";
        if (localhost.equals(station_host)) {
            File tl = new File(file);
            tl.delete();
        } else {
            DBPatchingHelper.deleteRemoteFile(station_host, owner, file);
        }
    }

    public static String getSelectedHost(String localhost, String station_host, String home) {
        String owner = FileUtility.checkFileOwner((File)new File(home, "oraInst.loc"));
        String file = DBPatchingHelper.getOPatchAutoStorage(home, station_host) + File.separator + "transfer.lock";
        if (localhost.equals(station_host)) {
            return DBPatchingHelper.readFirstLineFromLocalFile(owner, file);
        }
        return DBPatchingHelper.readFirstLineFromRemoteFile(station_host, owner, file);
    }
}

