/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.helper.remote.exec.model.OPeration;
import com.oracle.helper.remote.exec.model.Request;
import com.oracle.helper.remote.exec.model.TransferOPeration;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;

public abstract class CommonSessionCookieCreator {
    protected OOPSessionCookie cookie;
    protected List<String> requestedHomeList;
    protected Credential credential;
    static final Logger logger = Logger.getLogger(CommonSessionCookieCreator.class.getName());

    protected abstract void validateAndMerge(boolean var1) throws OPatchAutoException;

    public void merge(OOPSessionCookie cookie, List<String> requestedHomeList, Credential credential, boolean isRemotePatching, boolean nonrolling) throws OPatchAutoException {
        this.cookie = cookie;
        this.requestedHomeList = requestedHomeList;
        this.credential = credential;
        this.validateAndMerge(isRemotePatching);
        this.verifyPatchingMode(nonrolling);
    }

    public OOPSessionCookie create(List<String> requestedHomeList, Credential credential, boolean isRemotePatching, boolean nonrolling) throws OPatchAutoException {
        this.requestedHomeList = requestedHomeList;
        this.credential = credential;
        this.validateAndMerge(isRemotePatching);
        this.verifyPatchingMode(nonrolling);
        return this.cookie;
    }

    private static String getRemoteCommand(String homePath, String objLoc, String responseLoc) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(homePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append((CharSequence)perlPath);
        remoteCommand.append(homePath);
        remoteCommand.append(ProductDriverConstants.OPATCHAUTO_BIN);
        remoteCommand.append("RemoteHostExecutor.pl ");
        remoteCommand.append(" -OBJECTLOC=").append(objLoc);
        remoteCommand.append(" -RESPONSEOBJECTLOC=").append(responseLoc);
        remoteCommand.append(" -JVM_HANDLER=com.oracle.helper.remote.exec.RemoteRequestHandler ");
        logger.info("remote command: " + remoteCommand.toString());
        return remoteCommand.toString();
    }

    protected void cleanSessionData(OOPSessionCookie cookie) {
        Set<Map.Entry<String, OOPSessionInfo>> oopSessionInfoEntrySet = cookie.getOOPSessionInfoList();
        String host = DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost());
        for (Map.Entry<String, OOPSessionInfo> entry : oopSessionInfoEntrySet) {
            String key = DBPatchingHelper.getHostNameWithoutDomain(entry.getKey());
            if (host.equalsIgnoreCase(key)) continue;
            cookie.removeSessionInfo(key);
        }
    }

    protected Map<String, List<OOPSessionCookie>> getRemoteNodeCookies(List<String> requestedHomeList) throws OPatchAutoException {
        ConcurrentHashMap<String, List<OOPSessionCookie>> remoteCookieMap = new ConcurrentHashMap<String, List<OOPSessionCookie>>();
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<Host> dbModelHostList = configGraph.getTargets(Host.class);
        for (Host host : dbModelHostList) {
            String hostName = host.getHostName();
            if (hostName.equalsIgnoreCase(DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost()))) {
                logger.info("Skipping the query from local host");
                continue;
            }
            ArrayList<OOPSessionCookie> remoteCookieList = new ArrayList<OOPSessionCookie>();
            logger.info("Creating request param for host: " + hostName);
            Request request = new Request(hostName);
            int homeCount = 1;
            for (String home : requestedHomeList) {
                String tmpOOPSessionCookie = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "oopsessioninfo_" + hostName + "_Home" + homeCount + ".ser";
                ++homeCount;
                String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
                sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", hostName);
                String remoteOOPSessionCookie = home + sessionInfoFile;
                this.fillCopyOperation(remoteOOPSessionCookie, tmpOOPSessionCookie, request);
            }
            String objLoc = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "request_" + hostName + ".ser";
            String responseObjLoc = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "response_" + hostName + ".ser";
            OOPSessionInfoHelper.serializeFile(objLoc, request, DBPatchingHelper.getHomeOwner(OPatchAutoHelper.getOPatchAutoHome()), this.credential);
            byte[] password = null;
            GISystemCall.ExecReturn er = GISystemCall.process(CommonSessionCookieCreator.getRemoteCommand(OPatchAutoHelper.getOPatchAutoHome(), objLoc, responseObjLoc), DBPatchingHelper.getHomeOwner(OPatchAutoHelper.getOPatchAutoHome()), password);
            logger.info("Execution result: " + er.isOK());
            File responseFile = new File(responseObjLoc);
            if (er.isOK() && responseFile.exists()) {
                for (OPeration op : request.getOperations()) {
                    TransferOPeration transferOp = (TransferOPeration)op;
                    logger.info("transferOp" + transferOp.getStatus().name());
                    logger.info("transferOp.getDest(): " + transferOp.getDest());
                    File tmpCookieFile = new File(transferOp.getDest());
                    logger.info("tmpCookieFile.exists(): " + tmpCookieFile.exists());
                    if (!tmpCookieFile.exists()) continue;
                    OOPSessionCookie tmpCookie = OOPSessionInfoHandler.getInstance().getOOPSessionCookie(tmpCookieFile);
                    tmpCookieFile.delete();
                    logger.info("tmpCookie.isSessionCompleted(): " + tmpCookie.isSessionCompleted());
                    if (tmpCookie.isSessionCompleted()) continue;
                    remoteCookieList.add(tmpCookie);
                }
                if (!remoteCookieList.isEmpty()) {
                    remoteCookieMap.put(hostName, remoteCookieList);
                }
                responseFile.delete();
                new File(objLoc).delete();
                continue;
            }
            throw new OPatchAutoException(Integer.toString(72158), new Object[]{hostName});
        }
        return remoteCookieMap;
    }

    private void fillCopyOperation(String remoteOOPSessionCookie, String tmpOOPSessionCookie, Request request) {
        TransferOPeration op = new TransferOPeration(remoteOOPSessionCookie, tmpOOPSessionCookie, OPeration.OPerationType.COPY);
        logger.info("Copy is triggered from source: " + remoteOOPSessionCookie + " to destination: " + tmpOOPSessionCookie);
        request.addOperation((OPeration)op);
    }

    private void verifyPatchingMode(boolean isNonrolling) throws OPatchAutoException {
        boolean failed = false;
        String localhost = DBPatchingHelper.getHostNameWithoutDomain(DBPatchingHelper.getLocalHost());
        logger.info("Verifying Patching modes on local node " + localhost + " and remote node cookies\n");
        Map<String, List<OOPSessionCookie>> remoteCookies = this.getRemoteNodeCookies(this.requestedHomeList);
        Set<String> remoteHostList = remoteCookies.keySet();
        logger.info("Verifying against " + remoteHostList.size() + " remote node cookies\n");
        for (String remoteHost : remoteHostList) {
            List<OOPSessionCookie> cookieList = remoteCookies.get(remoteHost);
            for (OOPSessionCookie remoteCookie : cookieList) {
                logger.info("Patching mode on host " + remoteHost + " is nonrolling : " + remoteCookie.isNonRolling() + "\n");
                if (isNonrolling && !remoteCookie.isNonRolling()) {
                    failed = true;
                    logger.info("Patching mode on local node and remote node " + remoteHost + "are different.");
                }
                if (isNonrolling || !remoteCookie.isNonRolling()) continue;
                failed = true;
                logger.info("Patching mode on local node and remote node " + remoteHost + "are different.");
            }
        }
        if (failed) {
            throw new OPatchAutoException(Integer.toString(72173), new Object[0]);
        }
    }
}

