/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.validators.CommonSessionCookieCreator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SwitchSessionCookieCreator
extends CommonSessionCookieCreator {
    static final Logger logger = Logger.getLogger(SwitchSessionCookieCreator.class.getName());

    @Override
    protected void validateAndMerge(boolean isRemotePatching) throws OPatchAutoException {
        this.validateLocalSession(this.requestedHomeList);
        this.validateRemoteSessionsAndMerge(this.requestedHomeList, isRemotePatching);
    }

    private void validateLocalSession(List<String> requestedHomeList) throws OPatchAutoException {
        ArrayList<String> localCookieFiles = new ArrayList<String>();
        for (String homePath : requestedHomeList) {
            String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
            sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
            localCookieFiles.add(homePath + sessionInfoFile);
        }
        for (String localCookie : localCookieFiles) {
            File cookieFile = new File(localCookie);
            if (cookieFile.exists()) {
                logger.info("Found local cookie file: " + localCookie);
                OOPSessionCookie cookie = OOPSessionInfoHandler.getInstance().getOOPSessionCookie(cookieFile);
                this.verifyCookieInfo(cookie, requestedHomeList, DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
                continue;
            }
            throw new OPatchAutoException(Integer.toString(72118), new Object[0]);
        }
    }

    private OOPSessionCookie validateRemoteSessionsAndMerge(List<String> requestedHomeList, boolean isRemotePatching) throws OPatchAutoException {
        Map<String, List<OOPSessionCookie>> remoteCookies = this.getRemoteNodeCookies(requestedHomeList);
        Set<String> remoteHostList = remoteCookies.keySet();
        for (String remoteHost : remoteHostList) {
            List<OOPSessionCookie> cookieList = remoteCookies.get(remoteHost);
            for (OOPSessionCookie remoteCookie : cookieList) {
                this.verifyRemoteCookieInfo(remoteCookie, requestedHomeList, remoteHost);
            }
            if (isRemotePatching || cookieList.isEmpty()) continue;
            OOPSessionCookie tempCookie = cookieList.get(0);
            if (this.cookie == null) {
                this.cookie = tempCookie;
                continue;
            }
            this.cookie.addSessionInfo(remoteHost, tempCookie.getOOPSessionInfo(remoteHost));
        }
        return this.cookie;
    }

    private void verifyCookieInfo(OOPSessionCookie cookie, List<String> requestedHomeList, String host) throws OPatchAutoException {
        ArrayList<String> previousSessionHomeList = new ArrayList<String>();
        logger.info("isSessionCompleted(): " + cookie.isSessionCompleted());
        logger.info("operationType: " + cookie.getOperationType().name());
        if (cookie.isSessionCompleted() && cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.PREPARE)) {
            OOPSessionInfo sessioninfo = cookie.getOOPSessionInfo(host);
            List<OOPHomeInfo> homeInfoList = sessioninfo.getHomeInfoList();
            for (OOPHomeInfo homeInfo : homeInfoList) {
                previousSessionHomeList.add(FileUtils.getFile((String)homeInfo.getOriginalHome()).getPath());
            }
            if (!previousSessionHomeList.isEmpty()) {
                Collections.sort(previousSessionHomeList);
                Collections.sort(requestedHomeList);
                logger.info("previousSessionHomeList: " + previousSessionHomeList);
                logger.info("requestedHomeList: " + requestedHomeList);
                if (!previousSessionHomeList.equals(requestedHomeList)) {
                    throw new OPatchAutoException(Integer.toString(72119), new Object[]{((Object)previousSessionHomeList).toString()});
                }
            }
        } else {
            throw new OPatchAutoException(Integer.toString(72120), new Object[]{cookie.getOperationType().name().toLowerCase(), host});
        }
    }

    private void verifyRemoteCookieInfo(OOPSessionCookie cookie, List<String> requestedHomeList, String host) throws OPatchAutoException {
        if (cookie.isSessionCompleted() && cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.PREPARE)) {
            return;
        }
        if (!cookie.isSessionCompleted() && cookie.getOperationType().equals((Object)OOPSessionCookie.OOPOperationType.SWITCH)) {
            ArrayList<String> previousSessionHomeList = new ArrayList<String>();
            OOPSessionInfo sessioninfo = cookie.getOOPSessionInfo(host);
            List<OOPHomeInfo> homeInfoList = sessioninfo.getHomeInfoList();
            for (OOPHomeInfo homeInfo : homeInfoList) {
                if (!homeInfo.getHomeOperationType().equals((Object)OOPHomeInfo.HomeOperationType.SWITCH)) continue;
                previousSessionHomeList.add(FileUtils.getFile((String)homeInfo.getOriginalHome()).getPath());
            }
            if (!previousSessionHomeList.isEmpty()) {
                Collections.sort(previousSessionHomeList);
                Collections.sort(requestedHomeList);
                logger.info("previousSessionHomeList: " + previousSessionHomeList);
                logger.info("requestedHomeList: " + requestedHomeList);
                if (!previousSessionHomeList.equals(requestedHomeList)) {
                    throw new OPatchAutoException(Integer.toString(72116), new Object[]{cookie.getOperationType().name().toLowerCase(), host, ((Object)previousSessionHomeList).toString()});
                }
            }
        } else {
            throw new OPatchAutoException(Integer.toString(72117), new Object[]{OOPSessionCookie.OOPOperationType.SWITCH.name().toLowerCase(), host, cookie.getOperationType().name().toLowerCase()});
        }
    }
}

