/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patchlevel;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.patchlevel.MultiHostCommandExecutor;
import com.oracle.glcm.patch.auto.db.product.patchlevel.MultiHostCommandResultListener;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OHPatchLevelRequestParam;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.db.product.patchlevel.PatchLevelReportingListener;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class OracleHomePatchLevelReporter
implements MultiHostCommandResultListener {
    private int resultCount = 0;
    private Map<Host, OracleHomePatchLevel> patchLevelsOnHost = new ConcurrentHashMap<Host, OracleHomePatchLevel>();
    private Map<Host, List<Home>> remoteSharedHomes = new ConcurrentHashMap<Host, List<Home>>();
    private PatchLevelReportingListener reportingListener;
    private List<Thread> commandHandlers = new ArrayList<Thread>();
    private Logger logger = Logger.getLogger(OracleHomePatchLevelReporter.class.getName());

    public void report(List<Host> hosts, PatchLevelReportingListener reportingListener) {
        this.reportingListener = reportingListener;
        for (Host host : hosts) {
            this.prepareCommand(host);
        }
        this.executeCommand();
    }

    private void prepareCommand(Host host) {
        String invPtrLoc = null;
        ConcurrentHashMap<String, OHPatchLevelRequestParam> ownerRequestParamMap = new ConcurrentHashMap<String, OHPatchLevelRequestParam>();
        Iterator homeItr = host.getHomes().iterator();
        String command = null;
        String crsHome = null;
        while (homeItr.hasNext()) {
            Home home = (Home)homeItr.next();
            if (DBPatchingUtil.isCrsHome(home) || DBPatchingUtil.isSIHAHome(home)) {
                invPtrLoc = home.getInvPtrLoc();
                crsHome = home.getLocation();
            }
            if (invPtrLoc == null) {
                invPtrLoc = home.getInvPtrLoc();
            }
            try {
                if (home.isSharedHome() && host.isRemote()) {
                    List<Object> sharedHomes;
                    this.logger.fine("Handling shared home " + home.getLocation() + " for remote node  " + host.getHost());
                    if (this.remoteSharedHomes.containsKey(host)) {
                        sharedHomes = this.remoteSharedHomes.get(host);
                        sharedHomes.add(home);
                        continue;
                    }
                    sharedHomes = new ArrayList<Home>();
                    sharedHomes.add(home);
                    this.remoteSharedHomes.put(host, sharedHomes);
                    continue;
                }
            }
            catch (OPatchAutoException e) {
                this.reportingListener.notifyResult(1, 102, "OPatchAutoException: " + e.getMessage(), this.patchLevelsOnHost);
            }
            String ohOwner = home.getOwner();
            if (ownerRequestParamMap.containsKey(ohOwner)) {
                ((OHPatchLevelRequestParam)ownerRequestParamMap.get(ohOwner)).getOracleHomeLocations().add(home.getLocation());
                continue;
            }
            OHPatchLevelRequestParam param = new OHPatchLevelRequestParam();
            ArrayList<String> homeLoc = new ArrayList<String>();
            homeLoc.add(home.getLocation());
            param.setOracleHomeLocations(homeLoc);
            ownerRequestParamMap.put(ohOwner, param);
        }
        for (String owner : ownerRequestParamMap.keySet()) {
            String dbHome;
            String objectLoc = null;
            String logHome = null;
            logHome = ((OHPatchLevelRequestParam)ownerRequestParamMap.get(owner)).getOracleHomeLocations().contains(crsHome) ? crsHome : (dbHome = ((OHPatchLevelRequestParam)ownerRequestParamMap.get(owner)).getOracleHomeLocations().get(0));
            objectLoc = logHome + File.separator + "cfgtoollogs" + File.separator + "opatchautodb" + File.separator + "homePatchLevel_" + owner + "_" + host.getHost() + ".obj";
            if (objectLoc != null) {
                ((OHPatchLevelRequestParam)ownerRequestParamMap.get(owner)).setResultLocation(objectLoc);
            }
            command = this.prepareCommandForOwner(((OHPatchLevelRequestParam)ownerRequestParamMap.get(owner)).getOracleHomeLocations(), invPtrLoc, ((OHPatchLevelRequestParam)ownerRequestParamMap.get(owner)).getResultLocation());
            this.logger.info("For owner: " + owner + " command: " + command);
            ((OHPatchLevelRequestParam)ownerRequestParamMap.get(owner)).setCommand(command);
        }
        if (ownerRequestParamMap.size() > 0) {
            this.prepareCommandForExecution(host, ownerRequestParamMap);
        }
    }

    private void prepareCommandForExecution(Host host, Map<String, OHPatchLevelRequestParam> ownerRequestParamMap) {
        MultiHostCommandExecutor executor = new MultiHostCommandExecutor(host, this, ownerRequestParamMap);
        Thread t = new Thread(executor);
        this.commandHandlers.add(t);
    }

    private void executeCommand() {
        for (Thread thread : this.commandHandlers) {
            thread.start();
        }
        for (Thread thread : this.commandHandlers) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                this.logger.warning("InterruptedException: " + e.getMessage());
            }
        }
    }

    private String prepareCommandForOwner(List<String> oracleHomeList, String invPtrLoc, String objectLoc) {
        StringBuilder command = new StringBuilder();
        command.append(oracleHomeList.get(0));
        command.append("/perl/bin/perl ");
        command.append(oracleHomeList.get(0));
        command.append(File.separator);
        command.append("OPatch");
        command.append(File.separator);
        command.append("auto");
        command.append(File.separator);
        command.append("database");
        command.append(File.separator);
        command.append("bin");
        command.append(File.separator);
        command.append("PatchLevelReport.pl");
        command.append(" ");
        command.append(this.prepareArguments(oracleHomeList, invPtrLoc, objectLoc));
        return command.toString();
    }

    private String prepareArguments(List<String> oracleHomeList, String invPtrLoc, String objectLoc) {
        StringBuilder sb = new StringBuilder();
        sb.append("-OHLIST=");
        String ohList = "";
        for (String ohPath : oracleHomeList) {
            ohList = ohList + ohPath;
            ohList = ohList + ",";
        }
        if (ohList.endsWith(",")) {
            ohList = ohList.substring(0, ohList.lastIndexOf(","));
        }
        sb.append(ohList);
        sb.append(" ");
        sb.append("-OBJECTLOC=");
        sb.append(objectLoc);
        sb.append(" ");
        sb.append("-INVPTRLOC=");
        sb.append(invPtrLoc);
        return sb.toString();
    }

    @Override
    public void notify(MultiHostCommandResultListener.ResultID id, int messageID, String message, Host host, Object payload) {
        if (id == MultiHostCommandResultListener.ResultID.FAILED) {
            this.logger.info("Failed for host:" + host.getHost() + " due to " + message);
            this.reportingListener.notifyResult(1, messageID, "Failed for host:" + host.getHost() + " due to " + message, this.patchLevelsOnHost);
            this.reportingListener = null;
        } else {
            this.logger.fine("Successfully retrieve data for host " + host.getHost());
            ++this.resultCount;
            if (this.resultCount <= this.commandHandlers.size()) {
                this.patchLevelsOnHost.put(host, (OracleHomePatchLevel)payload);
            }
            if (this.resultCount == this.commandHandlers.size()) {
                this.updateSharedHomePatchLevel(this.patchLevelsOnHost);
                this.reportingListener.notifyResult(0, 0, message, this.patchLevelsOnHost);
            }
        }
    }

    private void updateSharedHomePatchLevel(Map<Host, OracleHomePatchLevel> patchLevelsOnHost) {
        Set<Host> hosts = patchLevelsOnHost.keySet();
        for (Host host : hosts) {
            this.logger.fine("host: " + host.getHost());
            try {
                OracleHomePatchLevel remoteOhPatchLevel;
                Home home;
                Set homeSet;
                Iterator homes;
                if (host.isRemote() || !(homes = (homeSet = host.getHomes()).iterator()).hasNext() || !(home = (Home)homes.next()).isSharedHome()) continue;
                OracleHomePatchLevel patchLevel = patchLevelsOnHost.get(host);
                Map<String, List<OPatchPatchInfo>> ohPatchInfo = patchLevel.getOracleHomePatchLevel();
                List<OPatchPatchInfo> patchInfo = ohPatchInfo.get(home.getLocation());
                Set<Host> remoteHosts = this.remoteSharedHomes.keySet();
                Iterator<Host> remoteHostItr = remoteHosts.iterator();
                if (!remoteHostItr.hasNext()) continue;
                Host remoteHost = remoteHostItr.next();
                if (patchLevelsOnHost.containsKey(remoteHost)) {
                    remoteOhPatchLevel = patchLevelsOnHost.get(remoteHost);
                    remoteOhPatchLevel.addOracleHomePatchLevel(home.getLocation(), patchInfo);
                    continue;
                }
                remoteOhPatchLevel = new OracleHomePatchLevel();
                remoteOhPatchLevel.addOracleHomePatchLevel(home.getLocation(), patchInfo);
                patchLevelsOnHost.put(remoteHost, remoteOhPatchLevel);
            }
            catch (OPatchAutoException e) {
                this.reportingListener.notifyResult(1, 102, "OPatchAutoException: " + e.getMessage(), patchLevelsOnHost);
            }
        }
        this.logger.fine("patchLevelsOnHost: " + patchLevelsOnHost);
    }
}

