/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.summary;

import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.summary.PatchingSummary;
import com.oracle.glcm.patch.auto.db.product.summary.PatchingSummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTargetList;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class DBPatchingSummaryCreator {
    private static final String OPATCH_AUTO_DB_NAMESPACE = "opatchautodb";
    private PatchingSummary dbPatchingSummary;

    public synchronized void storePatchingSummary(int status, SummaryID summaryID, PatchTarget target, String summary) {
        this.dbPatchingSummary.storePatchingSummary(status, summaryID, target, summary);
        this.save(summaryID);
    }

    public synchronized void storePatchingSummary(int status, SummaryID summaryID, List<String> summaryList) {
        for (String value : summaryList) {
            this.dbPatchingSummary.storePatchingSummary(status, summaryID, null, value);
        }
        this.save(summaryID);
    }

    public synchronized void storeConfigSummary(int status, SummaryID summaryID, List<String> summaryList) {
        for (String value : summaryList) {
            this.dbPatchingSummary.storeConfigSummary(status, summaryID, value);
        }
        this.save(summaryID);
    }

    public int getLastActionStatus() {
        return this.dbPatchingSummary.getLastActionStatus();
    }

    private void save(SummaryID summaryID) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PatchingSummary.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            String summaryFileName = this.getSummaryFile(summaryID);
            jaxbMarshaller.marshal((Object)this.dbPatchingSummary, new File(summaryFileName));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private String getSummaryFile(SummaryID summaryID) {
        String summaryFileName = "";
        summaryFileName = summaryID.equals((Object)SummaryID.sdb_patching) || summaryID.equals((Object)SummaryID.sdb_analyze_patching) ? File.separator + "tmp" + File.separator + "sdbpatchingsummary.xml" : (summaryID.equals((Object)SummaryID.shard_patching) ? File.separator + "tmp" + File.separator + "shardpatchingsummary.xml" : SessionData.getConfigDir() + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "patchingsummary.xml");
        return summaryFileName;
    }

    public void initializePatchingSummary(OPatchAutoCommand command, String sessionID) {
        this.initializePatchingSummary(command, sessionID, SummaryID.initialize);
    }

    public void initializePatchingSummary(OPatchAutoCommand command, String sessionID, SummaryID summaryID) {
        String summaryFileName = this.getSummaryFile(summaryID);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PatchingSummary.class});
            Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
            this.dbPatchingSummary = (PatchingSummary)jaxbMarshaller.unmarshal(new File(summaryFileName));
            if (!sessionID.equals(this.dbPatchingSummary.getSessionID())) {
                this.dbPatchingSummary.clear();
                if (new File(summaryFileName).exists()) {
                    new File(summaryFileName).delete();
                }
            }
        }
        catch (JAXBException e) {
            this.dbPatchingSummary = new PatchingSummary();
        }
        if (!new File(summaryFileName).exists()) {
            String crsOwner = OUIDriver.checkFileOwner((File)new File(PatchPlanner.getInstance().getOPlanEnv().getOracleHome(), "oraInst.loc"));
            DBPatchingUtil.createNewFile(summaryFileName, crsOwner, null);
            IOUtils.chmodTo775(new File(summaryFileName), null);
        }
        this.dbPatchingSummary.init(sessionID);
    }

    public void generateSummary(OPatchAutoCommand command) {
        PatchingSummaryGenerator summaryGenerator = new PatchingSummaryGenerator();
        summaryGenerator.generatePatchingSummary(this.dbPatchingSummary, command);
    }

    public Set<SummaryID> getSummaryIDList(String summaryFileName) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PatchingSummary.class});
        Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
        PatchingSummary patchingSummary = (PatchingSummary)jaxbMarshaller.unmarshal(new File(summaryFileName));
        Set<SummaryID> summaryIds = patchingSummary.getTargetSummaryIDList();
        return summaryIds;
    }

    public SummaryTargetList getSummary(String summaryFileName, SummaryID summaryID) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PatchingSummary.class});
        Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
        PatchingSummary patchingSummary = (PatchingSummary)jaxbMarshaller.unmarshal(new File(summaryFileName));
        SummaryTargetList summaryIds = patchingSummary.getTargetSummaryList(summaryID);
        return summaryIds;
    }

    public Set<SummaryID> getGeneralSummaryIDList(String summaryFileName) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PatchingSummary.class});
        Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
        PatchingSummary patchingSummary = (PatchingSummary)jaxbMarshaller.unmarshal(new File(summaryFileName));
        Set<SummaryID> summaryIds = patchingSummary.getGeneralSummaryIDList();
        return summaryIds;
    }

    public List<String> getGeneralSummary(String summaryFileName, SummaryID summaryID) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PatchingSummary.class});
        Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
        PatchingSummary patchingSummary = (PatchingSummary)jaxbMarshaller.unmarshal(new File(summaryFileName));
        List<String> genSummaryLst = patchingSummary.getGeneralSummaryList(summaryID);
        return genSummaryLst;
    }
}

