/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.summary.generator;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.ISummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.Summary;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTarget;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTargetList;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;

public class SDBPatchingActionSummaryGenerator
implements ISummaryGenerator {
    @Override
    public void generateSummary(SummaryID id, Map<SummaryTarget, Summary> summaryTargetList, List<String> summaryList, OPatchAutoCommand command) {
        if (summaryList != null && id == SummaryID.sdb_patching) {
            for (String summary : summaryList) {
                Reporting.report((String)summary);
            }
        }
        DBPatchingSummaryCreator summaryCreator = new DBPatchingSummaryCreator();
        String summaryFileName = File.separator + "tmp" + File.separator + "sdbpatchingsummary.xml";
        int count = this.getSummaryCount(summaryCreator, summaryFileName);
        if (null != summaryTargetList) {
            for (Map.Entry<SummaryTarget, Summary> summaryEntry : summaryTargetList.entrySet()) {
                String summaryDetails = summaryEntry.getValue().getSummaryDetails();
                if (id != SummaryID.sdb_patching || summaryDetails.contains("name :")) continue;
                try {
                    id = SummaryID.sdb_analyze_patching;
                    SummaryTargetList targetList = summaryCreator.getSummary(summaryFileName, id);
                    summaryTargetList = targetList.getSummaryList();
                    count = 1;
                }
                catch (JAXBException jAXBException) {}
                break;
            }
        }
        if (count == 2 && id.equals((Object)SummaryID.sdb_patching) || count == 1 && id.equals((Object)SummaryID.sdb_analyze_patching)) {
            this.displayTargetSummary(id, summaryTargetList);
        }
    }

    private int getSummaryCount(DBPatchingSummaryCreator summaryCreator, String summaryFileName) {
        int count = 0;
        try {
            Set<SummaryID> summaryIDSet = summaryCreator.getSummaryIDList(summaryFileName);
            if (summaryIDSet != null) {
                for (SummaryID summaryId : summaryIDSet) {
                    count = summaryId.equals((Object)SummaryID.sdb_analyze_patching) ? ++count : count;
                    count = summaryId.equals((Object)SummaryID.sdb_patching) ? ++count : count;
                }
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        return count;
    }

    private void displayTargetSummary(SummaryID id, Map<SummaryTarget, Summary> summaryTargetList) {
        TreeMap<Integer, String> summaryMap = new TreeMap<Integer, String>();
        if (summaryTargetList != null && (id == SummaryID.sdb_patching || id == SummaryID.sdb_analyze_patching)) {
            for (Map.Entry<SummaryTarget, Summary> summaryEntry : summaryTargetList.entrySet()) {
                String summaryDetails = summaryEntry.getValue().getSummaryDetails();
                if (summaryDetails.contains("Patching summary for data guard with DR-set number")) {
                    int drsetIndex = summaryDetails.indexOf(":");
                    String drsetStr = summaryDetails.substring(drsetIndex + 2, drsetIndex + 3);
                    int drsetNum = Integer.parseInt(drsetStr);
                    summaryMap.put(drsetNum, summaryDetails);
                    continue;
                }
                Reporting.report((String)(summaryDetails + "\n"));
            }
        }
        if (summaryMap != null && summaryMap.size() > 0) {
            Collection summaryContents = summaryMap.values();
            Iterator itr = summaryContents.iterator();
            while (itr.hasNext()) {
                Reporting.report((String)((String)itr.next() + "\n"));
            }
        }
    }
}

