/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckForNullValuesValidator
implements IValidator {
    private final Logger logger = Logger.getLogger(CheckForNullValuesValidator.class.getName());
    private final Map<AbstractBaseTarget, List<Method>> failedResultMap = new HashMap<AbstractBaseTarget, List<Method>>();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        this.logger.log(Level.FINE, "Ensuring that all the required values specified by the method filter are non null.");
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        List methodValidationFilter = (List)params.get(ValidationParamKey.METHOD_VALIDATION_FILTER.ordinal());
        boolean passed = false;
        passed = this.validate(systemInst, methodValidationFilter);
        ArrayList<AbstractBaseTarget> failed = new ArrayList<AbstractBaseTarget>();
        if (!passed) {
            for (AbstractBaseTarget abt : this.failedResultMap.keySet()) {
                failed.add(abt);
            }
            String message = BundleUtils.getMessage(CheckForNullValuesValidator.class, "VALUE_FOUND_TO_BE_NULL", BundleUtils.makeStringForFailedResultMap(this.failedResultMap));
            StringBuffer str = new StringBuffer();
            str.append("\n    ").append(message);
            if (failed == null || failed.isEmpty()) {
                message = str.toString();
            } else {
                for (BaseClass baseClass : failed) {
                    str.append("\n      " + baseClass);
                }
            }
            this.logger.log(Level.INFO, str.toString());
            Reporting.report((String)str.toString());
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.VALUE_FOUND_TO_BE_NULL, failed));
            return multipleValidationResult;
        }
        String successMessage = "Checks if the all the required values specified by the method filter are non null.";
        this.logger.log(Level.FINE, successMessage);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    public boolean validate(SystemInstance systemInst, List<AbstractBaseTarget> validationObjects) {
        HashMap<Class<? extends AbstractBaseTarget>, List<Method>> validationFilter = new HashMap<Class<? extends AbstractBaseTarget>, List<Method>>();
        for (AbstractBaseTarget entity : validationObjects) {
            validationFilter.put(entity.getClass(), entity.getRequestedGetters());
        }
        return this.validate(systemInst, validationFilter);
    }

    private boolean validate(SystemInstance systemInst, Map<Class<? extends AbstractBaseTarget>, List<Method>> validationFilter) {
        boolean isSuccessful = true;
        for (BaseClass sbc : systemInst.getEntities()) {
            assert (sbc instanceof AbstractBaseTarget);
            AbstractBaseTarget entity = (AbstractBaseTarget)sbc;
            if (validationFilter.get(entity.getClass()) == null || validationFilter.get(entity.getClass()).size() == 0) {
                this.logger.log(Level.INFO, "Method Filter's for " + sbc.getClass() + " don't exist or is empty in the Validation Filter map. This class will be ignored for validation");
                continue;
            }
            ArrayList<Method> failedMethods = new ArrayList<Method>();
            for (Method method : validationFilter.get(entity.getClass())) {
                Object ret = null;
                try {
                    ret = method.invoke((Object)sbc, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    this.logger.severe(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    this.logger.severe(e.getMessage());
                }
                if (ret != null && (!(ret instanceof List) || !((List)ret).isEmpty())) continue;
                isSuccessful = false;
                failedMethods.add(method);
            }
            if (failedMethods.isEmpty()) continue;
            this.failedResultMap.put(entity, failedMethods);
        }
        return isSuccessful;
    }
}

