/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.OracleHomePathValidation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NonRollingOracleHomeValidation
implements IValidator {
    private Logger logger = Logger.getLogger(NonRollingOracleHomeValidation.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.FINE, "Invoking out of place non-rolling validation for number oracle home involved in patching.");
        List oracleHomes = (List)params.get(ValidationParamKey.ORACLE_HOMES.ordinal());
        boolean ohOptionEnabled = (Boolean)params.get(ValidationParamKey.HOME_KEY_OPTION.ordinal());
        boolean isNonRolling = (Boolean)params.get(ValidationParamKey.NONROLLING_OPTION.ordinal());
        boolean isOOPEnabled = (Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal());
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        if (isOOPEnabled && isNonRolling) {
            if (ohOptionEnabled) {
                String operation = (String)params.get(ValidationParamKey.OPERATION.ordinal());
                if (oracleHomes.size() > 1 && !operation.equals("rollback")) {
                    String message = BundleUtils.getMessage(OracleHomePathValidation.class, "OOP_NONROLLING_EXCEEDS_NOOFHOMES", new Object[0]);
                    Reporting.report((String)message);
                    multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.OOP_NONROLLING_EXCEEDS_NOOFHOMES, ""));
                }
            } else {
                String message = BundleUtils.getMessage(OracleHomePathValidation.class, "OOP_NONROLLING_OH_OPT_MISSING", new Object[0]);
                Reporting.report((String)message);
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.OOP_NONROLLING_OH_OPT_MISSING, ""));
            }
        }
        if (multipleValidationResult.getValidationResultList().isEmpty()) {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        }
        return multipleValidationResult;
    }
}

