/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Topology;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class OOPPatchTargetValidator
implements IValidator {
    Logger _logger = Logger.getLogger(OOPPatchTargetValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        ValidationResult result = new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null);
        boolean isOOPEnabled = false;
        if (params.get(ValidationParamKey.OOP_ENABLED.ordinal()) != null) {
            isOOPEnabled = (Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal());
        }
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        boolean isSidbOnlyMode = false;
        if (params.get(ValidationParamKey.SIDB_ONLY.ordinal()) != null) {
            isSidbOnlyMode = (Boolean)params.get(ValidationParamKey.SIDB_ONLY.ordinal());
        }
        if (isOOPEnabled && !isSidbOnlyMode && ClusterInformationLoader.getInstance().getCRSType() == ClusterInformationLoader.CrsType.CRS && OOPSessionInfoHandler.getInstance().isFirstNode(DBPatchingHelper.getLocalHost()) && this.isValidSession(params)) {
            Topology topology;
            ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
            Map<File, Set<Host>> failedList = this.validatePatchTargets(configGraph, topology = (Topology)params.get(ValidationParamKey.TOPOLOGY.ordinal()));
            if (!failedList.isEmpty()) {
                String failedHomeLList = this.findFailedHomeDetails(failedList);
                result = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.OOP_PARTIAL_RAC_SETUP, failedHomeLList);
            }
        } else {
            this._logger.info("OOP patch target validation skipped");
        }
        multipleValidationResult.addValidationResult(result);
        return multipleValidationResult;
    }

    private boolean isValidSession(ValidationParam params) {
        OOPSessionCookie.OOPOperationType type = (OOPSessionCookie.OOPOperationType)((Object)params.get(ValidationParamKey.OOP_OPERATION_TYPE.ordinal()));
        return type == OOPSessionCookie.OOPOperationType.PREPARE || type == OOPSessionCookie.OOPOperationType.APPLY;
    }

    private String findFailedHomeDetails(Map<File, Set<Host>> failedList) {
        StringBuilder failedHomes = new StringBuilder();
        Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OOPPatchTargetValidator.partial.rac.home.message", (Object[])new Object[0]));
        Set<Map.Entry<File, Set<Host>>> hostEntrySet = failedList.entrySet();
        for (Map.Entry<File, Set<Host>> hostEntry : hostEntrySet) {
            failedHomes.append(hostEntry.getKey());
            failedHomes.append(",");
            Set<Host> hostList = hostEntry.getValue();
            Iterator<Host> itr = hostList.iterator();
            StringBuilder hostName = new StringBuilder();
            while (itr.hasNext()) {
                hostName.append(itr.next().getHostName());
                if (!itr.hasNext()) continue;
                hostName.append(",");
            }
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OOPPatchTargetValidator.partial.rac.home.details", (Object[])new Object[]{hostEntry.getKey().getAbsolutePath(), hostName.toString()}));
        }
        failedHomes.deleteCharAt(failedHomes.length() - 1);
        return failedHomes.toString();
    }

    private Map<File, Set<Host>> validatePatchTargets(ConfigGraph configGraph, Topology topology) {
        HashMap<File, Set<Host>> failedValidationList = new HashMap<File, Set<Host>>();
        HashMap homeToHostList = new HashMap();
        Set selectedHomeList = topology.getHomes();
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        HashSet completeHostList = new HashSet();
        for (Home selectedHome : selectedHomeList) {
            for (OracleHome home : oracleHomes) {
                if (!DBPatchingHelper.compareFilePath(selectedHome.getLocation(), home.getPath())) continue;
                List ohHostList = home.getHosts();
                completeHostList.addAll(ohHostList);
                File homePath = new File(selectedHome.getLocation());
                if (homeToHostList.containsKey(homePath)) {
                    ((Set)homeToHostList.get(homePath)).addAll(ohHostList);
                    continue;
                }
                HashSet hosts = new HashSet();
                hosts.addAll(ohHostList);
                homeToHostList.put(homePath, hosts);
            }
        }
        Set hostEntrySet = homeToHostList.entrySet();
        for (Map.Entry hostEntry : hostEntrySet) {
            HashSet tmpList = new HashSet(completeHostList);
            Set selectedHostList = (Set)hostEntry.getValue();
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("Home selected::" + ((File)hostEntry.getKey()).getAbsolutePath());
                for (Host tmp : selectedHostList) {
                    this._logger.fine("Home belongs to host::" + tmp.getHostName());
                }
            }
            tmpList.removeAll(selectedHostList);
            if (tmpList.isEmpty()) continue;
            this._logger.info("Failed for home:" + ((File)hostEntry.getKey()).getAbsolutePath());
            failedValidationList.put((File)hostEntry.getKey(), tmpList);
        }
        return failedValidationList;
    }
}

