/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleHomeTypeValidator
implements IValidator {
    Logger logger = Logger.getLogger(OracleHomeTypeValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Invoking rule to ensure all home type of Oracle Home is recognized by OPlan.");
        String message = null;
        List<String> validHomeType = this.getValidHomeType();
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        List homeList = systemInst.getTargetsOfType(OracleHome.class);
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        if (homeList == null || homeList.isEmpty()) {
            this.logger.log(Level.INFO, "Oracle Home does not exist.");
            message = BundleUtils.getMessage(OracleHomeTypeValidator.class, "NO_HOMES_IN_SYSTEM_INSTANCE", new Object[0]);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_HOMES_IN_SYSTEM_INSTANCE, null));
            return multipleValidationResult;
        }
        for (AbstractBaseTarget abt : homeList) {
            OracleHome home = (OracleHome)abt;
            if (validHomeType.contains(home.getHomeType())) continue;
            message = BundleUtils.getMessage(OracleHomeTypeValidator.class, "INVALID_HOMETYPE", home.getHomeType(), home.getDisplayName());
            Reporting.report((String)message);
            this.logger.log(Level.INFO, message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_HOMETYPE, home));
            return multipleValidationResult;
        }
        this.logger.log(Level.INFO, " All Oracle home Type is valid ");
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private List<String> getValidHomeType() {
        ArrayList<String> validHomeType = new ArrayList<String>();
        validHomeType.add("crs");
        validHomeType.add("rac");
        validHomeType.add("siha");
        validHomeType.add("sidb");
        return validHomeType;
    }
}

