/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class PatchListOOPValidator
implements IValidator {
    Logger logger = Logger.getLogger(PatchListOOPValidator.class.getName());
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Running validation for the consistency of patch list while preparing homes.");
        ClusterInformationLoader.CrsType crsType = ClusterInformationLoader.getInstance().getCRSType();
        this.logger.info("CRS Type is detected to be " + crsType);
        if (crsType.equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY)) {
            this.logger.info("Grid home is a software-only installation");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Patch list validations are not required for a software-only installation."));
            return this.multipleValidationResult;
        }
        PatchTarget patchTarget = (PatchTarget)params.get(ValidationParamKey.PATCH_TARGET.ordinal());
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        List<Host> hostModelList = configGraph.getTargets(Host.class);
        this.logger.info("Size of the host list is : " + hostModelList.size());
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        ArrayList<OracleHome> dbhomes = new ArrayList<OracleHome>();
        String crsHome = null;
        String crsOwner = null;
        boolean isSiha = false;
        for (OracleHome oh : oracleHomes) {
            if (oh.getHomeType().equals("crs")) {
                crsHome = oh.getPath();
                crsOwner = oh.getOwner();
                break;
            }
            if (oh.getHomeType().equals("siha")) {
                crsHome = oh.getPath();
                crsOwner = oh.getOwner();
                isSiha = true;
                break;
            }
            dbhomes.add(oh);
        }
        this.logger.fine("Is SIHA: " + isSiha);
        if (isSiha) {
            this.logger.info("This is a SIHA environment.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Patch List Validation will be skipped on a SIHA environment."));
            return this.multipleValidationResult;
        }
        boolean isOOPEnabled = false;
        if (params.get(ValidationParamKey.OOP_ENABLED.ordinal()) != null) {
            isOOPEnabled = (Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal());
        }
        String home = patchTarget.getHome().getLocation();
        this.logger.info("Validator is being run on home " + home);
        try {
            if (isOOPEnabled) {
                if (OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget)) {
                    this.logger.info("This is the first node of OOP Patching. Hence, the validator will be skipped.\n");
                    return this.multipleValidationResult;
                }
                return this.validatePatchListConsistency(patchTarget, hostModelList);
            }
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "OOP Patch List Validation will be skipped for in-place mode of patching."));
            return this.multipleValidationResult;
        }
        catch (Exception e) {
            this.logger.fine("Error hit : " + e.getMessage());
            this.logger.warning("Tool hit an exception trying to determine the consistency of patch list.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Patch List Validation will be skipped."));
            return this.multipleValidationResult;
        }
    }

    public MultipleValidationResult validatePatchListConsistency(PatchTarget patchTarget, List<Host> hostModelList) {
        String home = patchTarget.getHome().getLocation();
        String host = patchTarget.getHost().getHost();
        this.logger.info("Performing patch list consistency validation for home " + home);
        try {
            OOPSessionInfo localInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
            for (Host remote : hostModelList) {
                String remotehost = remote.getName();
                if (host.equalsIgnoreCase(remotehost)) continue;
                this.logger.info("Checking Patch list on remote node " + remotehost);
                OOPSessionInfo remoteInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo(remotehost);
                if (null == remoteInfo) {
                    this.logger.info("OOP Session info not available for host " + remotehost);
                    continue;
                }
                OracleHomePatchLevel localPatchLevel = localInfo.getIncomingPatchesOnNodes();
                OracleHomePatchLevel remotePatchLevel = remoteInfo.getIncomingPatchesOnNodes();
                if (null == localPatchLevel) {
                    this.logger.info("Local incoming patch list is null.");
                    return this.multipleValidationResult;
                }
                if (null == remotePatchLevel) {
                    this.logger.info("Incoming patch list on remote node " + remotehost + " is null. Hence, ignoring the host.");
                    continue;
                }
                if (localPatchLevel.equals(remotePatchLevel)) {
                    this.logger.info("Incoming patch list is consistent with the list on remote node.");
                    return this.multipleValidationResult;
                }
                this.logger.info("Incoming patch list is NOT consistent with the list on remote node.");
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.PATCH_LIST_INCONSISTENT, null));
            }
            return this.multipleValidationResult;
        }
        catch (Exception e) {
            this.logger.fine("Error hit : " + e.getMessage());
            this.logger.warning("Tool hit an exception trying to determine the consistency of patch list.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Patch List Validation will be skipped."));
            return this.multipleValidationResult;
        }
    }
}

