/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.SkipTargetCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationUtil;
import com.oracle.glcm.patch.auto.db.product.SIPatchingContext;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSObjectValidator;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.PhaseType;

public class RACOneVersionValidator
implements IValidator {
    Logger logger = Logger.getLogger(RACOneVersionValidator.class.getName());
    private String strMinRACversion = null;

    public RACOneVersionValidator(String strMinRACversion) {
        this.strMinRACversion = strMinRACversion;
    }

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Invoking rule to ensure that RACOne version is greater than " + this.strMinRACversion);
        CRSObjectValidator crsObjectValidator = new CRSObjectValidator();
        crsObjectValidator.setClazz(RACOneVersionValidator.class);
        MultipleValidationResult multipleValidationResult = crsObjectValidator.validate(params);
        if (this.getFailureResult(multipleValidationResult)) {
            return multipleValidationResult;
        }
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        CRSCluster crs = (CRSCluster)systemInst.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        list.add(crs);
        List racs = crs.getDbRAC();
        String message = null;
        String formattedMessage = "";
        ArrayList<BaseClass> noInstances = new ArrayList<BaseClass>();
        if (racs != null && !racs.isEmpty()) {
            for (RACDatabase rac : racs) {
                if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) continue;
                this.logger.log(Level.INFO, "There are RAC Databases with no instances associated");
                noInstances.add((BaseClass)rac);
            }
        }
        if (!noInstances.isEmpty()) {
            message = BundleUtils.getMessage(RACOneVersionValidator.class, "NO_RACINSTANCE", BundleUtils.makeStringOutOfList(noInstances));
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_RACINSTANCE, noInstances));
            formattedMessage = ValidationUtil.getFormattedMessage(noInstances, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMessage);
            return multipleValidationResult;
        }
        ArrayList<BaseClass> instMissingVersion = new ArrayList<BaseClass>();
        ArrayList<BaseClass> wrongVersion = new ArrayList<BaseClass>();
        if (racs != null && !racs.isEmpty()) {
            for (RACDatabase rac : racs) {
                if (!"racone".equals(rac.getDatabaseType())) continue;
                String verRAC = null;
                for (RACDBInstance instance : rac.getDbInstances()) {
                    String verInst = instance.getVersion();
                    if (verInst == null) {
                        instMissingVersion.add((BaseClass)instance);
                        continue;
                    }
                    if (verRAC != null) continue;
                    verRAC = verInst;
                }
                if (verRAC == null || verRAC.trim().compareToIgnoreCase(this.strMinRACversion) >= 0) continue;
                if (this.checkIfPatchingOnlyRACone(rac, racs, systemInst)) {
                    this.logger.log(Level.INFO, "Given RACOnes have a version that is not supported for RACOne only patching");
                    wrongVersion.add((BaseClass)rac);
                    continue;
                }
                this.dontPatchIncompatibleRACOneDB(rac, systemInst, configGraph);
            }
        }
        if (!instMissingVersion.isEmpty()) {
            message = BundleUtils.getMessage(RACOneVersionValidator.class, "MISSING_VERSION", BundleUtils.makeStringOutOfList(instMissingVersion));
            formattedMessage = ValidationUtil.getFormattedMessage(instMissingVersion, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMessage);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_VERSION, instMissingVersion));
            return multipleValidationResult;
        }
        if (!wrongVersion.isEmpty()) {
            message = BundleUtils.getMessage(RACOneVersionValidator.class, "RAC_VERSION_NOT_SUPPORTED", BundleUtils.makeStringOutOfList(wrongVersion));
            formattedMessage = ValidationUtil.getFormattedMessage(wrongVersion, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMessage);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_VERSION, wrongVersion));
            return multipleValidationResult;
        }
        this.logger.log(Level.INFO, "All RACs have a version greater than the minimum required version");
        this.logger.log(Level.INFO, "RAC version is greater or equal to " + this.strMinRACversion);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private boolean getFailureResult(MultipleValidationResult multipleValidationResult) {
        for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
            if (validationResult.getStatus() != ValidationResult.ValidationStatus.FAILED || validationResult.getFailureReason().equals(DBValidationFailureReason.MISSING_VERSION)) continue;
            return true;
        }
        return false;
    }

    private void dontPatchIncompatibleRACOneDB(RACDatabase racDB, SystemInstance config, ConfigGraph configGraph) {
        SIPatchingContext context = new SIPatchingContext(config, configGraph, false);
        context.dontTouchRacDatabase(racDB, new PhaseType[0]);
    }

    private boolean checkIfPatchingOnlyRACone(RACDatabase racOne, List<RACDatabase> allDBs, SystemInstance config) {
        boolean checkIfPatchingOnlyRACone = true;
        List crss = config.getTargetsOfType(CRSCluster.class);
        assert (crss.size() == 1);
        if (crss.size() != 1) {
            throw new IllegalStateException("Found none or more than one CRSCluster objects in the systemInstance: " + crss);
        }
        CRSCluster crs = (CRSCluster)crss.get(0);
        this.logger.info("Checking CRSCluster: " + crs);
        if (crs.getProperty(SkipTargetCookie.class) != null) {
            for (HAS has : this.l(crs.getHAS())) {
                this.logger.info("Not going to touch HAS: " + has);
                if (has.getProperty(SkipTargetCookie.class) != null) continue;
                checkIfPatchingOnlyRACone = false;
                break;
            }
            for (RACDatabase rac : allDBs) {
                if (rac == racOne || rac.getProperty(SkipTargetCookie.class) != null) continue;
                checkIfPatchingOnlyRACone = false;
                break;
            }
        } else {
            checkIfPatchingOnlyRACone = false;
        }
        return checkIfPatchingOnlyRACone;
    }

    private <T> List<T> l(List<T> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        return in;
    }
}

