/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RootOwnedFilesValidator
implements IValidator {
    Logger logger = Logger.getLogger(RootOwnedFilesValidator.class.getName());
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Running root owned files validation");
        PatchTarget patchTarget = (PatchTarget)params.get(ValidationParamKey.PATCH_TARGET.ordinal());
        String home = patchTarget.getHome().getLocation();
        this.logger.info("Validator is being run on home " + home);
        String[] files = new String[]{"rdbms/install/rootadd_rdbms.sh"};
        List<String> notOwnedByRoot = this.validateOwnership(files, home);
        if (notOwnedByRoot.isEmpty()) {
            this.logger.info("Validation Passed: Root owned files validation is successful.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Root owned files validation is successful."));
        } else {
            this.logger.info("Validation Failed: The following files are not owned by root:");
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"RootOwnedFilesValidator.execution.failed", (Object[])new Object[0]));
            for (String file : notOwnedByRoot) {
                Reporting.report((String)file);
            }
            Reporting.report((String)"\n");
            ValidationResult validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.ROOT_OWNED_FILE_CHECK_FAILED, "Files are not owned by root");
            this.multipleValidationResult.addValidationResult(validationResult);
        }
        return this.multipleValidationResult;
    }

    private List<String> validateOwnership(String[] filePaths, String home) {
        ArrayList<String> notOwnedByRoot = new ArrayList<String>();
        for (String filePath : filePaths) {
            Path path = Paths.get(home + File.separator + filePath, new String[0]);
            try {
                FileOwnerAttributeView ownerAttributeView = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
                UserPrincipal owner = ownerAttributeView.getOwner();
                if (owner.getName().equalsIgnoreCase("root")) continue;
                notOwnedByRoot.add(home + File.separator + filePath);
            }
            catch (IOException e) {
                this.logger.info("Error checking file ownership for: " + home + File.separator + filePath);
            }
        }
        return notOwnedByRoot;
    }
}

