/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.credential.ValueHolder;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.ShardDBProductTypes;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.utils.remote.IRemoteCommandResult;
import com.oracle.glcm.patch.auto.db.utils.remote.RemoteCommandExecutor;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Topology;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class UserCredentialValidator
implements IValidator,
IRemoteCommandResult {
    private static final int SCRIPT_EXECUTION_FAILED = -1;
    public static final String BIN_PATH = File.separator + "bin";
    public static final String SU_CMD = "su";
    public static final String BASH_CMD = "bash";
    public static final String EXPECT_CMD = "expect";
    public static final String USR_BIN_PATH = File.separator + "usr" + File.separator + "bin";
    private List<Thread> remoteHandlers = new ArrayList<Thread>();
    private boolean isMultiuserSetup = false;
    private boolean hasCRS = false;
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
    private Logger logger = Logger.getLogger(UserCredentialValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        boolean isGenerateStep = (Boolean)params.get(ValidationParamKey.GENERATE_STEP_OPTION.ordinal());
        String currentUser = System.getProperty("user.name");
        Map perlLibMap = (Map)params.get(ValidationParamKey.PERL_LIB_MAP.ordinal());
        if (isGenerateStep || currentUser.equals("root")) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Validation not required"));
            return this.multipleValidationResult;
        }
        Topology topology = (Topology)params.get(ValidationParamKey.TOPOLOGY.ordinal());
        String wallet = (String)params.get(ValidationParamKey.WALLET_LOC.ordinal());
        Set hosts = topology.getHosts();
        for (Host host : hosts) {
            String perlPath = null;
            if (perlLibMap != null) {
                perlPath = (String)perlLibMap.get(host.getHost());
            }
            try {
                if (!this.verifyUserHostCredentials(host, wallet)) {
                    return this.multipleValidationResult;
                }
                if (null == perlPath) {
                    if (null != host.getHomes() && host.getHomes().iterator().hasNext()) {
                        Home home = (Home)host.getHomes().iterator().next();
                        perlPath = home.getLocation();
                    } else {
                        perlPath = OPatchAutoHelper.getOPatchAutoHome();
                    }
                }
                if (host.isRemote()) {
                    this.validateRemoteCredentials(host, perlPath);
                    continue;
                }
                this.validateLocalHostCredentials(host, wallet);
            }
            catch (OPatchAutoException e) {
                this.logger.warning("OPatchAutoException: " + e.getMessage());
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.USER_CREDENTIAL_VALIDATION_FAILED, e.getMessage()));
            }
        }
        for (Thread t : this.remoteHandlers) {
            t.start();
        }
        for (Thread t : this.remoteHandlers) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.logger.warning("InterruptedException: " + e.getMessage());
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.USER_CREDENTIAL_VALIDATION_FAILED, e.getMessage()));
            }
        }
        return this.multipleValidationResult;
    }

    private void validateRemoteCredentials(Host host, String perlPath) {
        this.logger.info("validation for host: " + host.getHost() + " on home " + perlPath);
        if (host.getHomes().size() < 1) {
            this.logger.finest("Not validating remote user credentials");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "No target to verify"));
        } else {
            RemoteCommandExecutor remoteHandler = new RemoteCommandExecutor(this.getRemoteCommand(host, perlPath), host, this);
            Thread t = new Thread(remoteHandler);
            this.remoteHandlers.add(t);
        }
    }

    private String getRemoteCommand(Host host, String home) {
        StringBuilder command = new StringBuilder();
        command.append(home);
        command.append(DBCommonPatchingConstants.OPATCH_AUTO_BIN_DIR);
        command.append("remotevalidation.sh ");
        command.append(this.createArgumentsForRemoteScript(host, home));
        return command.toString();
    }

    private String createArgumentsForRemoteScript(Host host, String perlPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("-PASSWORD=");
        sb.append(new String(host.getPassword()));
        sb.append(" ");
        sb.append("-HAS_CRS=");
        sb.append(this.hasCRS);
        sb.append(" ");
        sb.append("-HOME=");
        sb.append(perlPath);
        return sb.toString();
    }

    private void validateLocalHostCredentials(Host host, String wallet) {
        this.logger.info("validation for host: " + host.getHost());
        if (this.hasCRS) {
            String sudoCommand;
            String bashCommand = this.getBashCmd();
            if (!this.ifValidCommand(bashCommand)) {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.BASH_COMMAND_NOT_FOUND_ON_LOCAL, ""));
            }
            if (!this.ifValidCommand(sudoCommand = this.getSudoCmd())) {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.SUDO_COMMAND_NOT_FOUND_ON_LOCAL, ""));
            }
            if (this.cleanSudoSession(bashCommand, sudoCommand)) {
                this.logger.fine(" Current execution is run as " + System.getProperty("user.name"));
                ArrayList<String> cmds = new ArrayList<String>();
                cmds.add(bashCommand);
                cmds.add("-c");
                cmds.add("echo '" + new String(host.getPassword()) + "' | " + sudoCommand + " -S -u " + "root" + " pwd");
                int retValue = this.execute(cmds);
                if (retValue != 0) {
                    this.logger.info(host.getUsername() + " doesn't have sudo credentials for " + "root");
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.SUDO_CREDENTIAL_CHECK_FAILED_ON_LOCAL, host.getUsername() + " doesn't have sudo credentials for " + "root"));
                }
            } else {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.SUDO_CREDENTIAL_CHECK_FAILED_ON_LOCAL, "command execution failed for sudo -k"));
            }
        }
        this.logger.finest("Is multiuser patching " + this.isMultiuserSetup);
        if (this.isMultiuserSetup && !this.ifValidCommand(this.getExpectCmd())) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.EXPECT_COMMAND_NOT_FOUND_ON_LOCAL, ""));
        }
    }

    private boolean verifyUserHostCredentials(Host host, String wallet) {
        if (host.getPassword() == null || host.getUsername() == null || StringUtil.isNullOrEmpty((String)wallet)) {
            this.logger.info("User credential missing for host ::  " + host.getHost());
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.HOST_CREDENTIAL_MISSING, host.getHost()));
            return false;
        }
        Set homes = host.getHomes();
        HashSet<String> owners = new HashSet<String>();
        block2: for (Home home : homes) {
            owners.add(home.getOwner());
            for (Object productType : home.getProductTypes()) {
                if (!productType.getType().equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue()) && !productType.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) && !productType.getType().equals(ShardDBProductTypes.PRODUCT_TYPE_SIHA_SDB.getValue()) && !productType.getType().equals(ShardDBProductTypes.PRODUCT_TYPE_CRS_SDB.getValue())) continue;
                this.hasCRS = true;
                continue block2;
            }
        }
        if (owners.size() > 1) {
            this.isMultiuserSetup = true;
            Credential credential = null;
            ValueHolder valueHolder = null;
            CredentialManager credentialManager = new CredentialManager();
            try {
                credentialManager.setWallet(new File(wallet), valueHolder);
                for (String owner : owners) {
                    credential = credentialManager.getCredential(host.getHost(), null, owner);
                    if (credential == null && !(credential = credentialManager.getCredential(host.getHost(), null, null)).getUsername().equalsIgnoreCase(owner)) {
                        credential = null;
                    }
                    if (credential != null) continue;
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.USER_CREDENTIAL_MISSING_FOR_HOST, "user " + owner + " for host " + host.getHost()));
                    return false;
                }
            }
            catch (OPatchAutoException e) {
                this.logger.severe("Validation failed due to : " + e.getMessage());
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.USER_CREDENTIAL_VALIDATION_FAILED, e.getMessage()));
                return false;
            }
        }
        return true;
    }

    private boolean cleanSudoSession(String bashCommand, String sudoCommand) {
        boolean ifSuccessfullyExecuted = false;
        if (!bashCommand.equals("") && !sudoCommand.equals("")) {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(bashCommand);
            cmds.add("-c");
            cmds.add(sudoCommand + " -k");
            int retValue = this.execute(cmds);
            if (retValue != 0) {
                this.logger.info("Command execution failed for sudo -k");
                Reporting.report((String)"Command execution failed for sudo -k");
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.SUDO_CREDENTIAL_CHECK_FAILED_ON_LOCAL, "command execution failed for sudo -k"));
            } else {
                ifSuccessfullyExecuted = true;
            }
        }
        return ifSuccessfullyExecuted;
    }

    private String getSudoCmd() {
        String sudo = "";
        if (new File(DBCommonPatchingConstants.BIN_PATH + File.separator + "sudo").exists()) {
            sudo = DBCommonPatchingConstants.BIN_PATH + File.separator + "sudo";
        } else if (new File(DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "sudo").exists()) {
            sudo = DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "sudo";
        } else {
            int ret = GISystemCall.runTimeExecution("which sudo");
            if (ret == 0) {
                sudo = "sudo";
            }
        }
        this.logger.info("Sudo path::" + sudo);
        return sudo;
    }

    private String getBashCmd() {
        String bash = "";
        if (new File(BIN_PATH + File.separator + BASH_CMD).exists()) {
            bash = BIN_PATH + File.separator + BASH_CMD;
        } else if (new File(USR_BIN_PATH + File.separator + BASH_CMD).exists()) {
            bash = USR_BIN_PATH + File.separator + BASH_CMD;
        } else {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("which bash");
            int ret = this.execute(cmds);
            if (ret == 0) {
                bash = BASH_CMD;
            }
        }
        return bash;
    }

    private String getExpectCmd() {
        String expect = "";
        if (new File(BIN_PATH + File.separator + EXPECT_CMD).exists()) {
            expect = BIN_PATH + File.separator + EXPECT_CMD;
        } else if (new File(USR_BIN_PATH + File.separator + EXPECT_CMD).exists()) {
            expect = USR_BIN_PATH + File.separator + EXPECT_CMD;
        } else {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("which expect");
            int ret = this.execute(cmds);
            if (ret == 0) {
                expect = EXPECT_CMD;
            }
        }
        return expect;
    }

    private boolean ifValidCommand(String command) {
        return !StringUtil.isNullOrEmpty((String)command);
    }

    private int execute(ArrayList<String> cmds) {
        ProcessBuilder pb = new ProcessBuilder(cmds);
        int retValue = -1;
        try {
            Process process = pb.start();
            retValue = process.waitFor();
            InputStreamReader rader = new InputStreamReader(process.getErrorStream());
            BufferedReader br = new BufferedReader(rader);
            StringBuffer sb = new StringBuffer();
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            InputStreamReader rader1 = new InputStreamReader(process.getInputStream());
            BufferedReader br1 = new BufferedReader(rader1);
            StringBuffer sb1 = new StringBuffer();
            String line1 = "";
            while ((line1 = br1.readLine()) != null) {
                sb1.append(line1);
                sb1.append("\n");
            }
            this.logger.info("command execution status:: " + sb.toString());
            this.logger.info("command execution status:: " + sb1.toString());
        }
        catch (Throwable t) {
            this.logger.severe("command execution failed due to ," + t.getMessage());
            retValue = -1;
        }
        return retValue;
    }

    @Override
    public void notifyResult(int resultID, String resultMsg, Host host, Home home, Thread executedThread, Object payload) {
        ValidationResult validationResult = null;
        resultMsg = PatchActionUtil.replacePwdFrmCmd(resultMsg);
        if (resultID == 0) {
            validationResult = new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, resultMsg);
            this.logger.info("Validation successfull on " + host.getHost());
        } else if (resultID == 2) {
            validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.REMOTE_CONNECTION_FAILED, resultMsg);
            this.logger.info("Validation failed: " + DBValidationFailureReason.REMOTE_CONNECTION_FAILED.name());
        } else {
            validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.REMOTE_COMMAND_EXECUTION_FAILED, resultMsg);
            this.logger.info("Validation failed: " + DBValidationFailureReason.REMOTE_COMMAND_EXECUTION_FAILED.name());
        }
        this.multipleValidationResult.addValidationResult(validationResult);
    }
}

