/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.utils;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.utils.BootstrapConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class BootstrapUtil {
    private static final Logger _logger = Logger.getLogger(BootstrapUtil.class.getName());

    public static void storePropertiesFile(Properties prop, String fileName, boolean ifAppend) throws OPatchAutoException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName, ifAppend);
            prop.store(out, null);
        }
        catch (IOException e) {
            _logger.warning("Failed to write properties file " + fileName);
            throw new OPatchAutoException(e.getMessage(), 240, (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                    File file = new File(fileName);
                    byte[] pwd = null;
                    IOUtils.chmodFile(file, "640", pwd);
                }
                catch (IOException e) {
                    _logger.warning("Failed to close output stream");
                    throw new OPatchAutoException(e.getMessage(), 240, (Throwable)e);
                }
            }
        }
    }

    public static void storePropertiesFile(Properties prop, String fileName) throws OPatchAutoException {
        BootstrapUtil.storePropertiesFile(prop, fileName, false);
    }

    public static void writeToFile(String path, String outputPath) throws OPatchAutoException {
        File f = new File(outputPath);
        BufferedWriter output = null;
        try {
            f.createNewFile();
            output = new BufferedWriter(new FileWriter(f));
            output.write(path);
        }
        catch (IOException e) {
            _logger.info("Error: IOException: " + e.getMessage());
            throw new OPatchAutoException(e.getMessage(), 234, (Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    _logger.warning("Failed to close writer");
                    throw new OPatchAutoException(e.getMessage(), 240, (Throwable)e);
                }
            }
        }
    }

    public static final Properties loadPropertiesFile(String location) throws OPatchAutoException, IOException {
        Properties prop = new Properties();
        if (new File(location).exists()) {
            try (FileInputStream stream = null;){
                stream = new FileInputStream(location);
                prop.load(stream);
            }
        }
        return prop;
    }

    public static boolean deleteDirRecursively(String path) {
        try {
            File file = new File(path);
            if (!file.isDirectory() || file.listFiles().length == 0) {
                file.delete();
            } else {
                File[] sub_files;
                for (File subfile : sub_files = file.listFiles()) {
                    if (!subfile.isDirectory()) {
                        subfile.delete();
                        continue;
                    }
                    if (BootstrapUtil.deleteDirRecursively(subfile.getPath())) continue;
                    return false;
                }
            }
            file.delete();
        }
        catch (Exception e) {
            _logger.info("Exception during deletion of directory : " + e.getMessage());
            return false;
        }
        return true;
    }

    public static String removeTrailingFileSeperator(String path) {
        String modifiedPath = path;
        if (path.endsWith(File.separator)) {
            modifiedPath = path.substring(0, path.lastIndexOf(File.separator));
        }
        return modifiedPath;
    }

    public static void createPatchWork(String baseLoc, String configDir, String currentUser, Credential credential) throws OPatchAutoException {
        String bootStrapPath = configDir + DBCommonPatchingConstants.CONFIG_DBTMP_DIR + "bootstrap_" + DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
        String patchWorkPath = bootStrapPath + File.separator + "patchwork";
        File boostrapDir = new File(bootStrapPath);
        _logger.info("Creating boostrap dir: " + boostrapDir.getAbsolutePath());
        BootstrapUtil.mkdir(boostrapDir, true);
        File patchWorkDir = new File(patchWorkPath);
        _logger.info("Creating patchwork dir: " + patchWorkDir.getAbsolutePath());
        BootstrapUtil.mkdir(patchWorkDir, false);
        String homeOwner = DBPatchingHelper.getHomeOwner(baseLoc);
        if ("root".equalsIgnoreCase(currentUser) || !currentUser.equals(homeOwner)) {
            _logger.info("Changing permission of bootstrap dir and sub-dir");
            if ("root".equalsIgnoreCase(currentUser)) {
                IOUtils.chmodTo775(boostrapDir, null);
                IOUtils.chmodTo775(patchWorkDir, null);
            } else {
                IOUtils.chmodTo775(boostrapDir, OPatchAutoHelper.toBytes((char[])credential.getPassword()));
                IOUtils.chmodTo775(patchWorkDir, OPatchAutoHelper.toBytes((char[])credential.getPassword()));
            }
            _logger.info("Changing owner of bootstrap dir and sub-dir");
            BootstrapUtil.changeowner(baseLoc, boostrapDir, credential);
            BootstrapUtil.changeowner(baseLoc, patchWorkDir, credential);
        }
    }

    private static void mkdir(File dir, boolean deleteIfExists) throws OPatchAutoException {
        boolean isOk = true;
        if (dir.exists() && deleteIfExists && !(isOk = BootstrapUtil.deleteDirRecursively(dir.getAbsolutePath()))) {
            _logger.warning("Exception while deleting directory : " + dir.getAbsolutePath());
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72144), (Object[])new Object[]{dir.getAbsolutePath()}), new Object[0]);
        }
        if (!dir.exists() && !(isOk = dir.mkdir())) {
            _logger.warning("Exception while creating directory : " + dir.getAbsolutePath());
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72143), (Object[])new Object[]{dir.getAbsolutePath()}), new Object[0]);
        }
    }

    private static void changeowner(String baseLoc, File file, Credential cred) throws OPatchAutoException {
        boolean isOk = DBPatchingHelper.changeOwner(baseLoc, cred, file);
        if (!isOk) {
            _logger.warning("Exception while changing owner of : " + file);
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72142), (Object[])new Object[]{file.getAbsoluteFile()}), new Object[0]);
        }
    }

    public static boolean isPerlPatch() throws OPatchAutoException {
        boolean isPerlPatch = false;
        Properties prop = new Properties();
        try {
            String isPerlPatchValue;
            String bootstrapPropertiesLocation;
            String patchWorkDirectory;
            String patchingInfoLocation = System.getProperty("OPatch.PATCH_INFO_LOCATION");
            if (!StringUtil.isNullOrEmpty((String)patchingInfoLocation) && (prop = BootstrapUtil.loadPropertiesFile(patchingInfoLocation)).containsKey(BootstrapConstants.PATCHWORK_DIR.getValue()) && !StringUtil.isNullOrEmpty((String)(patchWorkDirectory = prop.getProperty(BootstrapConstants.PATCHWORK_DIR.getValue()))) && (prop = BootstrapUtil.loadPropertiesFile(bootstrapPropertiesLocation = patchWorkDirectory + File.separator + BootstrapConstants.BOOTSTRAP_PROPERTIES.getValue())).containsKey(BootstrapConstants.IS_PERL_PATCH.getValue()) && !StringUtil.isNullOrEmpty((String)(isPerlPatchValue = prop.getProperty(BootstrapConstants.IS_PERL_PATCH.getValue()))) && Boolean.valueOf(isPerlPatchValue).booleanValue()) {
                isPerlPatch = true;
            }
        }
        catch (IOException ex) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72154), (Object[])new Object[]{ex.getMessage()}), new Object[0]);
        }
        return isPerlPatch;
    }
}

