/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.utils;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.RemoteContentTransferHandler;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.utils.helper.SDBRemoteFileHandlerHelper;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import dbmodel.SystemInstance;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SDBRemoteFileHandler
implements Runnable {
    private static final Logger _log = Logger.getLogger(SDBRemoteFileHandler.class.getName());
    private Host hostImpl;
    private CredentialManager credentialManager;
    private OPatchAutoOptions options;
    private OPatchAutoCommand command;
    private boolean isDeleteOperation = false;
    private boolean isPushRootSession = false;
    private File localSessionInfoFile = null;
    private Map<String, String> filesToBeDeleted;
    private PatchActionResult _patchActionResult;
    private RemoteConnectionHandler handler = null;

    public SDBRemoteFileHandler(Host hostImpl, CredentialManager credentialManager, OPatchAutoOptions options, OPatchAutoCommand command) {
        this.hostImpl = hostImpl;
        this.credentialManager = credentialManager;
        this.options = options;
        this.command = command;
    }

    public SDBRemoteFileHandler(RemoteConnectionHandler handler, Map<String, String> filesToBeDeleted, boolean isDeleteOperation) {
        this.isDeleteOperation = isDeleteOperation;
        this.filesToBeDeleted = filesToBeDeleted;
        this.handler = handler;
    }

    public SDBRemoteFileHandler(Host hostImpl, CredentialManager credentialManager, boolean isPushRootSession, File localSessionInfoFile) {
        this.isPushRootSession = isPushRootSession;
        this.credentialManager = credentialManager;
        this.hostImpl = hostImpl;
        this.localSessionInfoFile = localSessionInfoFile;
    }

    @Override
    public void run() {
        block34: {
            block33: {
                if (!this.isDeleteOperation) break block33;
                if (this.filesToBeDeleted == null || this.handler == null) break block34;
                for (Map.Entry<String, String> entry : this.filesToBeDeleted.entrySet()) {
                    String fileToBeDeleted = entry.getKey();
                    try {
                        if (!this.handler.exists(fileToBeDeleted)) continue;
                        SDBRemoteFileHandlerHelper sdbRemoteFileHandlerHelper = new SDBRemoteFileHandlerHelper();
                        sdbRemoteFileHandlerHelper.deleteDestinationFile(this.handler, fileToBeDeleted, entry.getValue());
                    }
                    catch (Throwable ex) {
                        OPatchAutoException opatchAutoException = this.createNewOAException(ex);
                        _log.throwing("Detailed Exception while deleting Local And Remote files : ", opatchAutoException.getMessage(), opatchAutoException);
                        this._patchActionResult = new PatchActionResult(ex);
                    }
                }
                break block34;
            }
            if (this.isPushRootSession) {
                SDBRemoteFileHandlerHelper sdbRemoteFileHandlerHelper = new SDBRemoteFileHandlerHelper();
                RemoteContentTransferHandler contentHandler = RemoteContentTransferHandler.getInstance();
                try {
                    for (Home home : this.hostImpl.getHomes()) {
                        if (this.hostImpl.getHost() == null) continue;
                        String owner = home.getOwner();
                        Credential credential = this.credentialManager.getCredential(this.hostImpl.getHost(), null, owner);
                        HostImpl dbHostImpl = PatchActionUtil.createHostImpl(this.credentialManager, this.hostImpl.getHost(), home.getLocation(), owner);
                        RemoteConnectionHandler handler = PatchActionUtil.getHandler(dbHostImpl);
                        if (dbHostImpl.isRemote()) {
                            sdbRemoteFileHandlerHelper.createRemoteFolder(contentHandler, handler, (DBHomeImpl)home, owner, credential);
                            sdbRemoteFileHandlerHelper.persistRootSession(handler, home.getLocation(), contentHandler, this.hostImpl.isRemote(), owner, credential, this.localSessionInfoFile);
                            continue;
                        }
                        sdbRemoteFileHandlerHelper.persistRootSession(null, home.getLocation(), null, this.hostImpl.isRemote(), owner, credential, this.localSessionInfoFile);
                    }
                }
                catch (Exception e) {
                    OPatchAutoException opatchAutoException = this.createNewOAException(e);
                    _log.throwing("Detailed Exception while pushing root session details to remote : ", opatchAutoException.getMessage(), opatchAutoException);
                    this._patchActionResult = new PatchActionResult((Throwable)opatchAutoException);
                }
            } else {
                try {
                    boolean isShardedDatabase = Boolean.parseBoolean(this.options.getOption(DBProductParameterConstants.SDB.getValue()).getValue());
                    String dataGuardName = null;
                    if (this.options.getOption(DBProductParameterConstants.DG.getValue()) != null) {
                        dataGuardName = this.options.getOption(DBProductParameterConstants.DG.getValue()).getValue();
                    }
                    boolean shardOption = false;
                    String shardGroupName = null;
                    String shardSpaceName = null;
                    if (this.options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()) != null) {
                        shardGroupName = this.options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue();
                    }
                    if (this.options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()) != null) {
                        shardSpaceName = this.options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue();
                    }
                    if (!StringUtil.isNullOrEmpty((String)shardGroupName) || !StringUtil.isNullOrEmpty(shardSpaceName)) {
                        shardOption = true;
                    }
                    SDBRemoteFileHandlerHelper sdbFileHandlerHelper = new SDBRemoteFileHandlerHelper();
                    SystemInstance sysInst = PatchPlanner.getInstance().getSystemInstance();
                    boolean isOgg = PatchActionUtil.isOgg(sysInst);
                    RemoteContentTransferHandler contentHandler = null;
                    _log.info("Starting transfer on host  " + this.hostImpl.getHost());
                    if (this.hostImpl.isRemote()) {
                        contentHandler = RemoteContentTransferHandler.getInstance();
                    }
                    for (Home home : this.hostImpl.getHomes()) {
                        DBHomeImpl dbHomeImpl = (DBHomeImpl)home;
                        Credential credential = dbHomeImpl.getCredential();
                        String owner = credential.getUsername();
                        HostImpl host = null;
                        if (this.hostImpl.isRemote()) {
                            host = PatchActionUtil.createHostImpl(this.credentialManager, this.hostImpl.getHost(), dbHomeImpl.getLocation(), owner);
                            String patchLoc = dbHomeImpl.getLocation() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB;
                            host.setPatchLocation(patchLoc);
                            this.handler = PatchActionUtil.getHandler(host);
                        }
                        if (null == host) {
                            host = (HostImpl)this.hostImpl;
                        }
                        _log.finer("Starting transfer on home  " + home.getLocation());
                        String oracleHomeLoc = home.getLocation();
                        if (!oracleHomeLoc.equals(OPatchAutoHelper.getOPatchAutoHome()) || host.isRemote()) {
                            String message = null;
                            message = dbHomeImpl.getTargetType().equalsIgnoreCase("crs") || dbHomeImpl.getTargetType().equalsIgnoreCase("siha") ? this.getLocalizedString("ProductSupport.executing.start.message", host.getHost(), dbHomeImpl.getTargetName()) : (isOgg || shardOption ? (!StringUtil.isNullOrEmpty((String)shardGroupName) ? this.getLocalizedString("ProductSupport.executing.start.shardgroup.message", host.getHost(), dbHomeImpl.getTargetName(), dbHomeImpl.getShardGroupName()) : (!StringUtil.isNullOrEmpty((String)shardSpaceName) ? this.getLocalizedString("ProductSupport.executing.start.shardspace.message", host.getHost(), dbHomeImpl.getTargetName(), dbHomeImpl.getShardSpaceName()) : this.getLocalizedString("ProductSupport.executing.start.generic.message", host.getHost(), dbHomeImpl.getTargetName()))) : this.getLocalizedString("ProductSupport.executing.start.drset.message", host.getHost(), dbHomeImpl.isPrimary() ? " primary " : " standby ", dbHomeImpl.getDrsetNumber()));
                            if (!StringUtil.isNullOrEmpty((String)message)) {
                                if (isShardedDatabase) {
                                    Reporting.report((String)message);
                                } else {
                                    Reporting.report((String)("<sharding>" + message + "</sharding>"));
                                }
                            }
                        }
                        if (host.isRemote()) {
                            sdbFileHandlerHelper.createRemoteFolder(contentHandler, this.handler, dbHomeImpl, owner, credential);
                            if (!this.isPatchIDForRollback()) {
                                sdbFileHandlerHelper.copyPatchZip(this.handler, contentHandler, host, owner);
                                sdbFileHandlerHelper.unzipPatch(this.handler, contentHandler, host, dbHomeImpl, owner, credential);
                            }
                            sdbFileHandlerHelper.writeWallet(this.handler, dbHomeImpl, this.credentialManager, contentHandler, host.isRemote(), owner, credential);
                            sdbFileHandlerHelper.persistSessionID(this.handler, dbHomeImpl, contentHandler, host.isRemote(), owner, credential);
                            if (isShardedDatabase) {
                                sdbFileHandlerHelper.writeSDBInstanceFile(this.handler, dbHomeImpl, contentHandler, this.options, host.isRemote(), owner, credential);
                            }
                            if (!isShardedDatabase && (!StringUtil.isNullOrEmpty((String)dataGuardName) || shardOption) && dbHomeImpl.getTargetType() != null && dbHomeImpl.getTargetType().equalsIgnoreCase("sidb_only")) {
                                sdbFileHandlerHelper.transferSysInstForSIDB(this.handler, dbHomeImpl, contentHandler, host.isRemote(), owner, credential, dbHomeImpl.getTargetName());
                            }
                        } else {
                            boolean isOk = DBPatchingUtil.mkdirs(oracleHomeLoc + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE, owner, credential);
                            if (!isOk) {
                                throw new OPatchAutoException(this.getLocalizedString("Directory.create.fail.message", oracleHomeLoc + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE), new Object[0]);
                            }
                            if (!this.isPatchIDForRollback()) {
                                sdbFileHandlerHelper.unzipPatch(null, null, host, dbHomeImpl, owner, credential);
                            }
                            sdbFileHandlerHelper.writeWallet(null, dbHomeImpl, this.credentialManager, null, host.isRemote(), owner, credential);
                            sdbFileHandlerHelper.persistSessionID(null, dbHomeImpl, null, host.isRemote(), owner, credential);
                            if (isShardedDatabase) {
                                sdbFileHandlerHelper.writeSDBInstanceFile(null, dbHomeImpl, null, this.options, host.isRemote(), owner, credential);
                            }
                            if (!isShardedDatabase && (!StringUtil.isNullOrEmpty((String)dataGuardName) || shardOption) && dbHomeImpl.getTargetType() != null && dbHomeImpl.getTargetType().equalsIgnoreCase("sidb_only")) {
                                sdbFileHandlerHelper.transferSysInstForSIDB(null, dbHomeImpl, null, host.isRemote(), owner, credential, dbHomeImpl.getTargetName());
                            }
                        }
                        if (oracleHomeLoc.equals(OPatchAutoHelper.getOPatchAutoHome()) && !host.isRemote()) continue;
                        String message = null;
                        message = dbHomeImpl.getTargetType().equalsIgnoreCase("crs") || dbHomeImpl.getTargetType().equalsIgnoreCase("siha") ? this.getLocalizedString("ProductSupport.executing.completed.message", host.getHost(), dbHomeImpl.getTargetName()) : (isOgg || shardOption ? (!StringUtil.isNullOrEmpty((String)shardGroupName) ? this.getLocalizedString("ProductSupport.executing.completed.shardgroup.message", host.getHost(), dbHomeImpl.getTargetName(), dbHomeImpl.getShardGroupName()) : (!StringUtil.isNullOrEmpty((String)shardSpaceName) ? this.getLocalizedString("ProductSupport.executing.completed.shardspace.message", host.getHost(), dbHomeImpl.getTargetName(), dbHomeImpl.getShardSpaceName()) : this.getLocalizedString("ProductSupport.executing.completed.generic.message", host.getHost(), dbHomeImpl.getTargetName()))) : this.getLocalizedString("ProductSupport.executing.completed.drset.message", host.getHost(), dbHomeImpl.isPrimary() ? " primary " : " standby ", dbHomeImpl.getDrsetNumber()));
                        if (StringUtil.isNullOrEmpty((String)message)) continue;
                        if (isShardedDatabase) {
                            Reporting.report((String)message);
                            continue;
                        }
                        Reporting.report((String)("<sharding>" + message + "</sharding>"));
                    }
                }
                catch (Exception ex) {
                    OPatchAutoException opatchAutoException = this.createNewOAException(ex);
                    this._patchActionResult = new PatchActionResult((Throwable)opatchAutoException);
                }
            }
        }
    }

    private OPatchAutoException createNewOAException(Throwable ex) {
        String errorMessageWithoutPassword = PatchActionUtil.replacePwdFrmCmd(ex.getMessage());
        OPatchAutoException opatchAutoException = new OPatchAutoException(errorMessageWithoutPassword, new Object[0]);
        opatchAutoException.initCause(ex.getCause());
        opatchAutoException.setStackTrace(ex.getStackTrace());
        return opatchAutoException;
    }

    private String getLocalizedString(String name, Object ... messageFormatting) {
        return OPatchAutoHelper.getLocalizedString((String)name, (Object[])messageFormatting);
    }

    public Map<Host, PatchActionResult> getResults() {
        HashMap<Host, PatchActionResult> results = new HashMap<Host, PatchActionResult>();
        results.put(this.hostImpl, this._patchActionResult);
        return results;
    }

    private boolean isPatchIDForRollback() {
        boolean isPatchID = false;
        try {
            if (this.options != null && this.command != null && this.command.isRollback()) {
                isPatchID = !StringUtil.isNullOrEmpty((String)this.options.getOption("id").getValue());
            }
        }
        catch (OPatchAutoException e) {
            _log.throwing("Detailed Exception while identifying if -id is used for rollback : ", e.getMessage(), e);
        }
        _log.finer("Is patch ID used for rollback::" + isPatchID);
        return isPatchID;
    }
}

