/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.glcm.opatch.common.api.Utility;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteFile;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.JarAction;
import oracle.opatch.JarClassLoader;
import oracle.opatch.MakeAction;
import oracle.opatch.NameValuePair;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.XMLConverter;
import oracle.opatch.ZipUtilities;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchactions.StringSubsAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchlevel.FileVersion;
import oracle.opatch.wrappers.WrapperFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ActionsFileParser
extends DefaultHandler {
    protected LinkedList compList = new LinkedList();
    protected int lineNumber = 1;
    protected double actionNum = 0.0;
    protected JarClassLoader oextJarLoader = null;
    protected String patchFilesLocation = null;
    private Path actionsFile = null;
    private InputStream actionsStream = null;
    private static HashMap pdtDirMap = new HashMap();
    private PatchObject pObject;
    private boolean isDirectory = false;

    private ActionsFileParser(JarClassLoader oextJarLoader, String patchFilesLocation, PatchObject pObject) {
        this.oextJarLoader = oextJarLoader;
        this.patchFilesLocation = patchFilesLocation;
        this.pObject = pObject;
    }

    public ActionsFileParser(Path actionsFile, JarClassLoader oextJarLoader, String patchFilesLocation, PatchObject pObject) {
        this(oextJarLoader, patchFilesLocation, pObject);
        this.actionsFile = actionsFile;
    }

    public ActionsFileParser(InputStream actionsStream, JarClassLoader oextJarLoader, String patchFilesLocation, PatchObject pObject) {
        this(oextJarLoader, patchFilesLocation, pObject);
        this.actionsStream = actionsStream;
    }

    protected LinkedList parseActionsContent() throws RuntimeException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            if (this.actionsFile != null) {
                InputStream inputStream = Files.newInputStream(this.actionsFile, new OpenOption[0]);
                InputStreamReader reader = new InputStreamReader(inputStream);
                InputSource is = new InputSource(reader);
                saxParser.parse(is, (DefaultHandler)this);
            } else if (this.actionsStream != null) {
                saxParser.parse(this.actionsStream, (DefaultHandler)this);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof SymbolFailureException) {
                SymbolFailureException se = new SymbolFailureException("Failed to parse action.xml: " + this.actionsFile.toAbsolutePath().toString() + e2.getMessage());
                se.setStackTrace(e2.getStackTrace());
                throw se;
            }
            StringBuilder errMsgBuff = new StringBuilder(this.actionsFile.toAbsolutePath().toString());
            errMsgBuff.append(" with ").append(e2.getMessage());
            RuntimeException re = new RuntimeException(errMsgBuff.toString());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        return this.compList;
    }

    private String getDefaultCharEncoding() {
        byte[] bArray = new byte[]{119};
        ByteArrayInputStream is = new ByteArrayInputStream(bArray);
        InputStreamReader reader = new InputStreamReader(is);
        return reader.getEncoding();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public boolean isActionElement(String name) throws RuntimeException {
        if (name.equals("copy") || name.equals("jar") || name.equals("archive") || name.equals("make") || name.equals("delete") || name.equals("unzip") || name.equals("delete_from_jar") || name.equals("stringsubs")) {
            return true;
        }
        String className = name + "Action";
        Class<?> actionClass = null;
        try {
            actionClass = Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (actionClass == null) {
                try {
                    String classNamePath = "oracle.opatch.opatchactions." + className;
                    actionClass = Class.forName(classNamePath);
                    return true;
                }
                catch (ClassNotFoundException classNamePath) {
                    // empty catch block
                }
            }
            if (this.oextJarLoader != null && actionClass == null) {
                try {
                    actionClass = this.oextJarLoader.loadClass(className);
                    return true;
                }
                catch (ClassNotFoundException e2) {
                    return false;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("#text")) {
            ++this.lineNumber;
            return;
        }
        if (qName.equals("oneoff_actions")) {
            ++this.lineNumber;
            return;
        }
        if (this.isActionElement(qName)) {
            block196: {
                PatchComponent patchComp = (PatchComponent)this.compList.get(this.compList.size() - 1);
                if (patchComp.isFilter()) {
                    ++this.lineNumber;
                    return;
                }
                if (patchComp.hasSymbol() && OPatchEnv.isSymbolResolveEnabled() && pdtDirMap.get(patchComp) == null) {
                    throw new SAXException("OPatch gets null product directories for symbol " + patchComp.getSymbolName());
                }
                String[] productDirs = (String[])pdtDirMap.get(patchComp);
                ArrayList<String> attributeNames = new ArrayList<String>();
                ArrayList<String> attributeValues = new ArrayList<String>();
                ArrayList<NameValuePair> attributeNameValue = new ArrayList<NameValuePair>();
                int length = attributes.getLength();
                for (int i2 = 0; i2 < length; ++i2) {
                    String name = attributes.getQName(i2);
                    String value = attributes.getValue(i2);
                    NameValuePair nv = new NameValuePair(name, value);
                    attributeNameValue.add(nv);
                }
                StringBuffer rawEntry = new StringBuffer(OPatchEnv.getBufferSize());
                if (!qName.equals("delete") && !qName.equals("unzip")) {
                    rawEntry.append("<");
                    rawEntry.append(qName);
                    rawEntry.append(" ");
                    for (int k2 = 0; k2 < attributeNameValue.size(); ++k2) {
                        String attrName = ((NameValuePair)attributeNameValue.get(k2)).getAttributeName();
                        rawEntry.append(attrName);
                        rawEntry.append("=\"");
                        String value = ((NameValuePair)attributeNameValue.get(k2)).getAttributeValue();
                        String tmp = XMLConverter.getXMLString(value);
                        rawEntry.append(tmp);
                        if (k2 == attributeNameValue.size() - 1) {
                            rawEntry.append("\" />");
                            continue;
                        }
                        rawEntry.append("\" ");
                    }
                }
                String argValue1 = "";
                String argValue2 = "";
                String argValue3 = "";
                String argValue4 = "";
                String argValue5 = "";
                String argValue6 = "";
                String hashValue = "";
                String argValue7 = "";
                String argValue8 = "";
                String argValue9 = "";
                String argValue10 = "";
                String argValue11 = "";
                String aName = qName;
                try {
                    if (aName.equals("copy")) {
                        boolean hasFileVersion = false;
                        for (int k3 = 0; k3 < attributeNameValue.size(); ++k3) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k3);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("update_timestamp")) {
                                argValue4 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_version")) {
                                hasFileVersion = true;
                                argValue5 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("diagnostic_string")) {
                                argValue6 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("retain_permission")) {
                                argValue7 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("mode")) {
                                argValue10 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("app_dir")) {
                                argValue9 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("opatch_binary")) {
                                argValue8 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("backup_in_zip")) {
                                argValue11 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("shaolue")) continue;
                            hashValue = nv.getAttributeValue();
                        }
                        if (argValue4 == null || argValue4.equals("")) {
                            argValue4 = "false";
                        }
                        if (argValue7 == null || argValue7.equals("")) {
                            argValue7 = "true";
                        }
                        if (argValue8 == null || argValue8.isEmpty()) {
                            argValue8 = "false";
                        }
                        if (argValue11 == null || argValue11.isEmpty()) {
                            argValue11 = "false";
                        }
                        String applicationVersion = "";
                        String copyPath = argValue2;
                        if (this.pObject.getApplicationDirs().size() > 0) {
                            Boolean isExist = OPatchEnv.getFirstAppDirMap().get(argValue9);
                            boolean isFirstAppVerDirExist = false;
                            if (isExist == null) {
                                isFirstAppVerDirExist = this.checkFirstAppVerDirExist(argValue9);
                                OPatchEnv.getFirstAppDirMap().put(argValue9, isFirstAppVerDirExist);
                            } else {
                                isFirstAppVerDirExist = isExist;
                            }
                            String string = applicationVersion = isFirstAppVerDirExist ? this.pObject.getApplicationVersion() : "";
                        }
                        if (OPatchEnv.isApplyOrNApplySession() || OPatchEnv.isNApplySDKSession()) {
                            copyPath = copyPath.replace("%APP_DIR%", argValue9).replace("%VERSION%", applicationVersion);
                        } else {
                            applicationVersion = this.pObject.getCurrentAppVerDirs().get(argValue9);
                            if (applicationVersion != null && !"".equals(applicationVersion)) {
                                copyPath = copyPath.replace("%APP_DIR%", argValue9).replace("%VERSION%", applicationVersion);
                            }
                        }
                        if (patchComp.hasSymbol() && OPatchEnv.isSymbolResolveEnabled()) {
                            for (int i3 = 0; i3 < productDirs.length; ++i3) {
                                this.actionNum += 1.0;
                                CopyAction copyAction = new CopyAction(patchComp, argValue1, copyPath.replace("%SYMBOL%", productDirs[i3]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber, Boolean.valueOf(argValue4), argValue5, argValue6, Boolean.valueOf(argValue7), argValue10, hasFileVersion);
                                copyAction.setRawActionEntry(rawEntry.toString());
                                copyAction.setHashValue(hashValue);
                                copyAction.setOrder(this.actionNum);
                                copyAction.setOpatchBinary(Boolean.valueOf(argValue8));
                                copyAction.setBackupZip(Boolean.valueOf(argValue11));
                                String patchSubType = this.pObject.getPatchSubType();
                                if (hasFileVersion && patchSubType.equalsIgnoreCase("upgrade") || !hasFileVersion && patchSubType.equalsIgnoreCase("update")) {
                                    copyAction.setFileVersionObject(new FileVersion(patchComp.getPatchLevel(), patchSubType, copyAction.getFileVersion()));
                                }
                                patchComp.copyList.add(copyAction);
                            }
                        } else {
                            this.actionNum += 1.0;
                            CopyAction copyAction = new CopyAction(patchComp, argValue1, copyPath, argValue3, this.lineNumber, Boolean.valueOf(argValue4), argValue5, argValue6, Boolean.valueOf(argValue7), argValue10, hasFileVersion);
                            copyAction.setRawActionEntry(rawEntry.toString());
                            copyAction.setHashValue(hashValue);
                            copyAction.setOrder(this.actionNum);
                            copyAction.setOpatchBinary(Boolean.valueOf(argValue8));
                            copyAction.setBackupZip(Boolean.valueOf(argValue11));
                            String patchSubType = this.pObject.getPatchSubType();
                            if (hasFileVersion && patchSubType.equalsIgnoreCase("upgrade") || !hasFileVersion && patchSubType.equalsIgnoreCase("update")) {
                                copyAction.setFileVersionObject(new FileVersion(patchComp.getPatchLevel(), patchSubType, copyAction.getFileVersion()));
                            }
                            patchComp.copyList.add(copyAction);
                        }
                        break block196;
                    }
                    if (aName.equals("jar")) {
                        for (int k4 = 0; k4 < attributeNameValue.size(); ++k4) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k4);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("class_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("opatch_binary")) {
                                argValue4 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("backup_in_zip")) {
                                argValue5 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("shaolue")) continue;
                            hashValue = nv.getAttributeValue();
                        }
                        if (argValue4 == null || argValue4.isEmpty()) {
                            argValue4 = "false";
                        }
                        if (argValue5 == null || argValue5.isEmpty()) {
                            argValue5 = "false";
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i4 = 0; i4 < productDirs.length; ++i4) {
                                this.actionNum += 1.0;
                                JarAction jarAction = new JarAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i4]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber);
                                if (patchComp.jarList.contains(jarAction)) {
                                    jarAction.setDuplicate(true);
                                }
                                jarAction.setOPatchBinary(Boolean.valueOf(argValue4));
                                jarAction.setBackupZip(Boolean.valueOf(argValue5));
                                jarAction.setHashValue(hashValue);
                                jarAction.setOrder(this.actionNum);
                                jarAction.setRawActionEntry(rawEntry.toString());
                                patchComp.jarList.add(jarAction);
                            }
                        } else {
                            this.actionNum += 1.0;
                            JarAction jarAction = new JarAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            if (patchComp.jarList.contains(jarAction)) {
                                jarAction.setDuplicate(true);
                            }
                            jarAction.setOPatchBinary(Boolean.valueOf(argValue4));
                            jarAction.setBackupZip(Boolean.valueOf(argValue5));
                            jarAction.setOrder(this.actionNum);
                            jarAction.setHashValue(hashValue);
                            jarAction.setRawActionEntry(rawEntry.toString());
                            patchComp.jarList.add(jarAction);
                        }
                        break block196;
                    }
                    if (aName.equals("delete_from_jar")) {
                        for (int k5 = 0; k5 < attributeNameValue.size(); ++k5) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k5);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("class_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("opatch_binary")) {
                                argValue4 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("backup_in_zip")) {
                                argValue5 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("opt_req")) continue;
                            argValue6 = nv.getAttributeValue();
                        }
                        if (argValue4 == null || argValue4.isEmpty()) {
                            argValue4 = "false";
                        }
                        if (argValue5 == null || argValue5.isEmpty()) {
                            argValue5 = "false";
                        }
                        boolean required = false;
                        if (argValue6 != null && !argValue6.equals("")) {
                            required = argValue6.equalsIgnoreCase("R");
                        }
                        String deletePath = argValue2;
                        if (patchComp.hasSymbol()) {
                            for (int i5 = 0; i5 < productDirs.length; ++i5) {
                                this.actionNum += 1.0;
                                DeleteJarAction deletejarAction = new DeleteJarAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i5]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber, required);
                                if (patchComp.jarList.contains(deletejarAction)) {
                                    deletejarAction.setDuplicate(true);
                                }
                                deletejarAction.setOPatchBinary(Boolean.valueOf(argValue4));
                                deletejarAction.setBackupZip(Boolean.valueOf(argValue5));
                                deletejarAction.setOrder(this.actionNum);
                                deletejarAction.setRawActionEntry(rawEntry.toString());
                                patchComp.deleteJarList.add(deletejarAction);
                            }
                        } else {
                            DeleteJarAction deletejarAction;
                            this.actionNum += 1.0;
                            if (this.pObject.getApplicationDirs().size() != 0) {
                                argValue2 = deletePath;
                            }
                            if (patchComp.jarList.contains(deletejarAction = new DeleteJarAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber, required))) {
                                deletejarAction.setDuplicate(true);
                            }
                            deletejarAction.setOPatchBinary(Boolean.valueOf(argValue4));
                            deletejarAction.setBackupZip(Boolean.valueOf(argValue5));
                            deletejarAction.setOrder(this.actionNum);
                            deletejarAction.setRawActionEntry(rawEntry.toString());
                            patchComp.deleteJarList.add(deletejarAction);
                        }
                        break block196;
                    }
                    if (aName.equals("archive")) {
                        for (int k6 = 0; k6 < attributeNameValue.size(); ++k6) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k6);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("object_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("shaolue")) continue;
                            hashValue = nv.getAttributeValue();
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i6 = 0; i6 < productDirs.length; ++i6) {
                                this.actionNum += 1.0;
                                ArchiveAction archiveAction = new ArchiveAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i6]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber);
                                patchComp.archiveList.add(archiveAction);
                                archiveAction.setRawActionEntry(rawEntry.toString());
                                archiveAction.setHashValue(hashValue);
                                archiveAction.setOrder(this.actionNum);
                            }
                        } else {
                            this.actionNum += 1.0;
                            ArchiveAction archiveAction = new ArchiveAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            patchComp.archiveList.add(archiveAction);
                            archiveAction.setRawActionEntry(rawEntry.toString());
                            archiveAction.setHashValue(hashValue);
                            archiveAction.setOrder(this.actionNum);
                        }
                        break block196;
                    }
                    if (aName.equals("make")) {
                        for (int k7 = 0; k7 < attributeNameValue.size(); ++k7) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k7);
                            if (nv.getAttributeName().equals("make_file")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("make_target")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("change_dir")) continue;
                            argValue1 = nv.getAttributeValue();
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i7 = 0; i7 < productDirs.length; ++i7) {
                                MakeAction makeAction = new MakeAction(patchComp, argValue1.replace("%SYMBOL%", productDirs[i7]), argValue2, argValue3, this.lineNumber);
                                patchComp.makeList.add(makeAction);
                                makeAction.setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            MakeAction makeAction = new MakeAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            patchComp.makeList.add(makeAction);
                            makeAction.setRawActionEntry(rawEntry.toString());
                        }
                        break block196;
                    }
                    if (aName.equals("stringsubs")) {
                        for (int k8 = 0; k8 < attributeNameValue.size(); ++k8) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k8);
                            if (nv.getAttributeName().equals("schema")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("configure")) continue;
                            argValue2 = nv.getAttributeValue();
                        }
                        this.actionNum += 1.0;
                        StringSubsAction stringSubsAction = new StringSubsAction(patchComp, argValue1, argValue2, this.lineNumber);
                        patchComp.stringSubsList.add(stringSubsAction);
                        stringSubsAction.setRawActionEntry(rawEntry.toString());
                        stringSubsAction.setOrder(this.actionNum);
                        break block196;
                    }
                    if (aName.equals("unzip")) {
                        NApplyDataSerializer serializer;
                        boolean hasFileVersion = false;
                        for (int k9 = 0; k9 < attributeNameValue.size(); ++k9) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k9);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_version")) {
                                hasFileVersion = true;
                                argValue4 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("retain_permission")) {
                                argValue5 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("update_timestamp")) continue;
                            argValue6 = nv.getAttributeValue();
                        }
                        if (argValue6 == null || argValue6.equals("")) {
                            argValue6 = "false";
                        }
                        if (argValue5 == null || argValue5.equals("")) {
                            argValue5 = "true";
                        }
                        argValue2 = PatchObjectUtil.getPlatformDependentPath(argValue2);
                        argValue3 = PatchObjectUtil.getPlatformDependentPath(argValue3);
                        String applicationVersion = this.pObject.getApplicationVersion();
                        String dirPath = new String(argValue2);
                        dirPath = dirPath.equals("%ORACLE_HOME%") ? "" : (patchComp.hasSymbol() ? (dirPath.equals("%ORACLE_HOME%" + File.separator + "%SYMBOL%") ? "" : dirPath.replace("%ORACLE_HOME%" + File.separator, "").replace("%SYMBOL%" + File.separator, "")) : dirPath.replace("%ORACLE_HOME%" + File.separator, ""));
                        String folder = Long.toString(System.currentTimeMillis());
                        String parentLoc = OPatchEnv.getTmpUnzipLocation(folder);
                        String fileLoc = "";
                        if (patchComp.hasSymbol()) {
                            parentLoc = parentLoc + File.separator + patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName();
                            fileLoc = this.patchFilesLocation + File.separator + patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3;
                        } else {
                            fileLoc = this.patchFilesLocation + File.separator + argValue3;
                        }
                        parentLoc = PatchObjectUtil.getPlatformDependentPath(parentLoc);
                        String unzipDir = "";
                        unzipDir = dirPath.equals("") ? parentLoc : parentLoc + File.separator + dirPath;
                        String zipFiles = OPatchEnv.getUnzipActionLocation() + File.separator + "zipfiles.txt";
                        Path zipFile = WrapperFactory.getNioServiceWrapper().getPath(zipFiles, new String[0]);
                        String key256 = Utility.getSha256sum((File)WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]).toFile());
                        String key1 = Utility.getSha1sum((File)WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]).toFile());
                        if (patchComp.hasSymbol()) {
                            key1 = key1 + fileLoc.hashCode();
                            key256 = key256 + fileLoc.hashCode();
                        }
                        if (Files.exists(zipFile, new LinkOption[0])) {
                            serializer = new NApplyDataSerializer();
                            Map<String, String> fileContent = serializer.deserializeUnzipActionLoc(zipFiles);
                            if (fileContent.containsKey(key1)) {
                                parentLoc = fileContent.get(key1);
                                parentLoc = PatchObjectUtil.getPlatformDependentPath(parentLoc);
                                unzipDir = dirPath.equals("") ? parentLoc : parentLoc + File.separator + dirPath;
                            } else if (fileContent.containsKey(key256)) {
                                parentLoc = fileContent.get(key256);
                                parentLoc = PatchObjectUtil.getPlatformDependentPath(parentLoc);
                                unzipDir = dirPath.equals("") ? parentLoc : parentLoc + File.separator + dirPath;
                            } else {
                                ZipUtilities.depressFiles(fileLoc, unzipDir);
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put(key256, parentLoc);
                                serializer.serializeUnzipActionLoc(zipFiles, map);
                            }
                        } else {
                            serializer = new NApplyDataSerializer();
                            ZipUtilities.depressFiles(fileLoc, unzipDir);
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put(key256, parentLoc);
                            serializer.serializeUnzipActionLoc(zipFiles, map);
                        }
                        ArrayList<String> fileNameList = this.getFiles(unzipDir, unzipDir + File.separator);
                        StringBuffer unzipRawEntry = null;
                        if (patchComp.hasSymbol() && OPatchEnv.isSymbolResolveEnabled()) {
                            parentLoc = parentLoc.replaceFirst(File.separator + patchComp.getName(), "").replace(File.separator + patchComp.getVersion(), "").replace(File.separator + patchComp.getSymbolName(), "");
                            for (int i8 = 0; i8 < productDirs.length; ++i8) {
                                for (String file : fileNameList) {
                                    void var41_133;
                                    file = PatchObjectUtil.getPlatformDependentPath(file);
                                    String string = "";
                                    if (dirPath.equals("")) {
                                        String string2 = file;
                                    } else {
                                        String string3 = dirPath + File.separator + file;
                                    }
                                    String string4 = new String(file);
                                    String unzipName = new String(file);
                                    String path = new String(argValue2);
                                    int index = string4.lastIndexOf(File.separator);
                                    if (index != -1) {
                                        String string5 = string4.substring(0, index);
                                        unzipName = unzipName.substring(index + 1);
                                        path = path + File.separator + string5;
                                    }
                                    unzipRawEntry = this.getUnzipRawEntry(unzipName, path, (String)var41_133, argValue5, argValue4, argValue6);
                                    this.actionNum += 1.0;
                                    CopyAction unzipAction = new CopyAction(patchComp, unzipName, path.replace("%SYMBOL%", productDirs[i8]).replace("%VERSION%", applicationVersion), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + (String)var41_133, this.lineNumber, argValue4, Boolean.valueOf(argValue5), hasFileVersion, Boolean.valueOf(argValue6), parentLoc, fileLoc, unzipDir, true);
                                    unzipAction.setRawActionEntry(unzipRawEntry.toString());
                                    String patchSubType = this.pObject.getPatchSubType();
                                    if (hasFileVersion && patchSubType.equalsIgnoreCase("upgrade") || !hasFileVersion && patchSubType.equalsIgnoreCase("update")) {
                                        unzipAction.setFileVersionObject(new FileVersion(patchComp.getPatchLevel(), patchSubType, unzipAction.getFileVersion()));
                                    }
                                    patchComp.copyList.add(unzipAction);
                                    unzipAction.setOrder(this.actionNum);
                                }
                            }
                        } else {
                            for (String file : fileNameList) {
                                void var42_145;
                                file = PatchObjectUtil.getPlatformDependentPath(file);
                                String fileName = "";
                                fileName = dirPath.equals("") ? file : dirPath + File.separator + file;
                                String string = new String(file);
                                String string6 = new String(file);
                                int index = string.lastIndexOf(File.separator);
                                String path = new String(argValue2);
                                if (index != -1) {
                                    String string7 = string.substring(0, index);
                                    String string8 = string6.substring(index + 1);
                                    path = path + File.separator + string7;
                                }
                                unzipRawEntry = this.getUnzipRawEntry((String)var42_145, path, fileName, argValue5, argValue4, argValue6);
                                this.actionNum += 1.0;
                                CopyAction unzipAction = new CopyAction(patchComp, (String)var42_145, path.replace("%VERSION%", applicationVersion), fileName, this.lineNumber, argValue4, Boolean.valueOf(argValue5), hasFileVersion, Boolean.valueOf(argValue6), parentLoc, fileLoc, unzipDir, true);
                                String patchSubType = this.pObject.getPatchSubType();
                                if (hasFileVersion && patchSubType.equalsIgnoreCase("upgrade") || !hasFileVersion && patchSubType.equalsIgnoreCase("update")) {
                                    unzipAction.setFileVersionObject(new FileVersion(patchComp.getPatchLevel(), patchSubType, unzipAction.getFileVersion()));
                                }
                                unzipAction.setRawActionEntry(unzipRawEntry.toString());
                                patchComp.copyList.add(unzipAction);
                                unzipAction.setOrder(this.actionNum);
                            }
                        }
                        break block196;
                    }
                    if (aName.equals("delete")) {
                        boolean hasFileVersion = false;
                        boolean rawIsDirectory = false;
                        String passedValue = "";
                        for (int k10 = 0; k10 < attributeNameValue.size(); ++k10) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k10);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("opt_req")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("is_directory")) {
                                argValue5 = nv.getAttributeValue();
                                rawIsDirectory = Boolean.valueOf(argValue5);
                                continue;
                            }
                            if (nv.getAttributeName().equals("is_oneway")) {
                                argValue7 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_version")) {
                                hasFileVersion = true;
                                argValue8 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("backup_in_zip")) {
                                argValue9 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("is_passed")) {
                                passedValue = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("opatch_binary")) {
                                argValue10 = nv.getAttributeName();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("app_dir")) continue;
                            argValue11 = nv.getAttributeValue();
                        }
                        if (passedValue.equals("")) {
                            passedValue = "false";
                        }
                        if (argValue5 == null || argValue5.equals("")) {
                            argValue5 = "false";
                        }
                        if (argValue7 == null || argValue7.equals("")) {
                            argValue7 = "false";
                        }
                        if (argValue9 == null || argValue9.equals("")) {
                            argValue9 = "false";
                        }
                        if (argValue10 == null || argValue10.equals("")) {
                            argValue10 = "false";
                        }
                        boolean required = false;
                        if (argValue3 != null && !argValue3.equals("")) {
                            boolean bl = required = argValue3.equalsIgnoreCase("R");
                        }
                        if (argValue1 != "") {
                            argValue1 = PatchObjectUtil.getPlatformDependentPath(argValue1);
                        }
                        argValue2 = PatchObjectUtil.getPlatformDependentPath(argValue2);
                        boolean isDir = Boolean.valueOf(argValue5);
                        boolean isOneway = Boolean.valueOf(argValue7);
                        boolean backupZip = Boolean.valueOf(argValue9);
                        boolean isPassed = Boolean.valueOf(passedValue);
                        StringBuffer deleteRawEntry = null;
                        ArrayList<Object> fileNameList = new ArrayList();
                        String deletePath = "";
                        String applicationVersion_del = "";
                        deletePath = argValue2;
                        if (this.pObject.getApplicationDirs().size() > 0) {
                            OLogger.printlnOnLog("Delete Action for MSID is triggered. All the delete action related paths will be changed to APP_VERSION_DIR");
                            Boolean isExist = OPatchEnv.getFirstAppDirMap().get(argValue11);
                            boolean isFirstAppVerDirExist = false;
                            if (isExist == null) {
                                isFirstAppVerDirExist = this.checkFirstAppVerDirExist(argValue11);
                                OPatchEnv.getFirstAppDirMap().put(argValue11, isFirstAppVerDirExist);
                            } else {
                                isFirstAppVerDirExist = isExist;
                            }
                            String string = applicationVersion_del = isFirstAppVerDirExist ? this.pObject.getApplicationVersion() : "";
                        }
                        if (OPatchEnv.isApplyOrNApplySession() || OPatchEnv.isNApplySDKSession()) {
                            deletePath = deletePath.replace("%APP_DIR%", argValue11).replace("%VERSION%", applicationVersion_del);
                        } else {
                            applicationVersion_del = this.pObject.getCurrentAppVerDirs().get(argValue11);
                            if (applicationVersion_del != null && !"".equals(applicationVersion_del)) {
                                deletePath = deletePath.replace("%APP_DIR%", argValue11).replace("%VERSION%", applicationVersion_del);
                            }
                        }
                        if (isDir && !isPassed) {
                            String dstDir = OPatchEnv.getOracleHome();
                            if (patchComp.hasSymbol()) {
                                String dirInOH = new String(argValue2);
                                for (int i9 = 0; i9 < productDirs.length; ++i9) {
                                    dirInOH = dirInOH.replace("%ORACLE_HOME%" + File.separator, "").replace("%SYMBOL%", productDirs[i9]);
                                    dstDir = PatchObjectUtil.getPlatformDependentPath(dstDir);
                                    String rootDir = new String(dstDir + File.separator + productDirs[i9]);
                                    dstDir = dstDir + File.separator + dirInOH;
                                    if (!fileNameList.isEmpty() || fileNameList.size() != 0) {
                                        fileNameList.clear();
                                    }
                                    fileNameList = ActionsFileParser.getAllDeleteFiles(dstDir, rootDir + File.separator);
                                    for (DeleteFile deleteFile : fileNameList) {
                                        String fileName = deleteFile.getName();
                                        String middleDir = new String(fileName);
                                        argValue6 = fileName;
                                        int index = argValue6.lastIndexOf(new String(File.separator));
                                        if (index != -1) {
                                            if (!deleteFile.isDir()) {
                                                argValue6 = argValue6.substring(index + 1);
                                                middleDir = middleDir.substring(0, index);
                                                middleDir = "%ORACLE_HOME%" + File.separator + "%SYMBOL%" + File.separator + middleDir;
                                            } else {
                                                argValue6 = "";
                                                middleDir = "%ORACLE_HOME%" + File.separator + "%SYMBOL%" + File.separator + middleDir;
                                            }
                                        } else {
                                            middleDir = "%ORACLE_HOME%" + File.separator + "%SYMBOL%" + File.separator + middleDir;
                                            if (deleteFile.isDir()) {
                                                argValue6 = "";
                                            }
                                        }
                                        isDir = middleDir.equals(argValue2) && argValue6.equals("");
                                        fileName = patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + fileName;
                                        deleteRawEntry = this.getDeleteRawEntry(aName, argValue6, middleDir, isOneway, argValue3, argValue8, isDir, backupZip);
                                        this.actionNum += 1.0;
                                        DeleteAction deleteAction = new DeleteAction(patchComp, argValue6, middleDir.replace("%SYMBOL%", productDirs[i9]), required, fileName, isDir, argValue8, hasFileVersion, isOneway, backupZip, this.lineNumber);
                                        deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                        deleteAction.setOPatchBinary(Boolean.valueOf(argValue10));
                                        deleteAction.setOrder(this.actionNum);
                                        deleteAction.setRawIsDirectory(rawIsDirectory);
                                        patchComp.deleteList.add(deleteAction);
                                    }
                                }
                            } else {
                                String dirInOH = new String(argValue2);
                                if (deletePath != null || deletePath != "") {
                                    dirInOH = new String(deletePath);
                                }
                                dirInOH = dirInOH.replace("%ORACLE_HOME%" + File.separator, "");
                                dstDir = PatchObjectUtil.getPlatformDependentPath(dstDir);
                                String rootDir = new String(dstDir);
                                dstDir = dstDir + File.separator + dirInOH;
                                fileNameList = ActionsFileParser.getAllDeleteFiles(dstDir, rootDir + File.separator);
                                for (DeleteFile deleteFile : fileNameList) {
                                    String string;
                                    argValue6 = string = deleteFile.getName();
                                    String middleDir = new String(string);
                                    int index = argValue6.lastIndexOf(new String(File.separator));
                                    if (index != -1) {
                                        if (deleteFile.isDir()) {
                                            argValue6 = "";
                                            middleDir = "%ORACLE_HOME%" + File.separator + middleDir;
                                        } else {
                                            argValue6 = argValue6.substring(index + 1);
                                            middleDir = middleDir.substring(0, index);
                                            middleDir = "%ORACLE_HOME%" + File.separator + middleDir;
                                        }
                                    } else {
                                        middleDir = "%ORACLE_HOME%" + File.separator + middleDir;
                                        if (deleteFile.isDir()) {
                                            argValue6 = "";
                                        }
                                    }
                                    isDir = middleDir.equals(argValue2) && string.equals(dirInOH);
                                    deleteRawEntry = this.getDeleteRawEntry(aName, argValue6, middleDir, isOneway, argValue3, argValue8, isDir, backupZip);
                                    this.actionNum += 1.0;
                                    DeleteAction deleteAction = new DeleteAction(patchComp, argValue6, middleDir, required, string, isDir, argValue8, hasFileVersion, isOneway, backupZip, this.lineNumber);
                                    deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                    deleteAction.setOPatchBinary(Boolean.valueOf(argValue10));
                                    deleteAction.setOrder(this.actionNum);
                                    deleteAction.setRawIsDirectory(rawIsDirectory);
                                    patchComp.deleteList.add(deleteAction);
                                }
                            }
                        } else {
                            argValue4 = new String(argValue2);
                            if (deletePath != null || deletePath != "") {
                                argValue4 = new String(deletePath);
                            }
                            argValue4 = argValue4.replace("%ORACLE_HOME%" + File.separator, "");
                            if (patchComp.hasSymbol()) {
                                for (int i10 = 0; i10 < productDirs.length; ++i10) {
                                    argValue4 = argValue4.replace("%SYMBOL%" + File.separator, "");
                                    argValue4 = patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue4 + File.separator + argValue1;
                                    deleteRawEntry = this.getDeleteRawEntry(aName, argValue1, argValue2, isOneway, argValue3, argValue8, false, backupZip);
                                    this.actionNum += 1.0;
                                    DeleteAction deleteAction = new DeleteAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i10]), required, argValue4, isDir, argValue8, hasFileVersion, isOneway, backupZip, this.lineNumber);
                                    deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                    deleteAction.setOPatchBinary(Boolean.valueOf(argValue10));
                                    deleteAction.setOrder(this.actionNum);
                                    deleteAction.setRawIsDirectory(rawIsDirectory);
                                    patchComp.deleteList.add(deleteAction);
                                }
                            } else {
                                this.actionNum += 1.0;
                                argValue4 = argValue4 + File.separator + argValue1;
                                if (deletePath != null || deletePath != "") {
                                    argValue2 = deletePath;
                                }
                                deleteRawEntry = this.getDeleteRawEntry(aName, argValue1, argValue2, isOneway, argValue3, argValue8, rawIsDirectory, backupZip);
                                DeleteAction deleteAction = new DeleteAction(patchComp, argValue1, argValue2, required, argValue4, isDir, argValue8, hasFileVersion, isOneway, backupZip, this.lineNumber);
                                deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                deleteAction.setOrder(this.actionNum);
                                deleteAction.setOPatchBinary(Boolean.valueOf(argValue10));
                                deleteAction.setRawIsDirectory(rawIsDirectory);
                                patchComp.deleteList.add(deleteAction);
                            }
                        }
                        break block196;
                    }
                    for (int k11 = 0; k11 < attributeNameValue.size(); ++k11) {
                        NameValuePair nv = (NameValuePair)attributeNameValue.get(k11);
                        attributeNames.add(nv.getAttributeName());
                        attributeValues.add(nv.getAttributeValue());
                    }
                    String className = aName + "Action";
                    Class<?> actionClass = null;
                    boolean externalClass = false;
                    try {
                        actionClass = Class.forName(className);
                    }
                    catch (ClassNotFoundException required) {
                        // empty catch block
                    }
                    if (actionClass == null) {
                        try {
                            String classNamePath = "oracle.opatch.opatchactions." + className;
                            actionClass = Class.forName(classNamePath);
                        }
                        catch (ClassNotFoundException classNamePath) {
                            // empty catch block
                        }
                    }
                    if (this.oextJarLoader != null && actionClass == null) {
                        actionClass = this.oextJarLoader.loadClass(className);
                        externalClass = true;
                    }
                    if (actionClass != null) {
                        Integer lineNumberObject = new Integer(this.lineNumber);
                        Class[] parameterTypes = new Class[]{patchComp.getClass(), attributeNames.getClass(), attributeValues.getClass(), lineNumberObject.getClass()};
                        Object[] parameterArgs = new Object[]{patchComp, attributeNames, attributeValues, lineNumberObject};
                        attributeNames.add("PATCH_FILES_LOCATION_TAG");
                        attributeValues.add(this.patchFilesLocation);
                        Constructor<?> newActionConst = actionClass.getConstructor(parameterTypes);
                        if (patchComp.hasSymbol()) {
                            for (int i11 = 0; i11 < productDirs.length; ++i11) {
                                for (int j2 = 0; j2 < attributeValues.size(); ++j2) {
                                    String value = attributeValues.get(j2).toString();
                                    String name = attributeNames.get(j2).toString();
                                    if (name.equals("file_name") || name.equals("filename") || name.equals("className")) {
                                        attributeValues.set(j2, patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + value);
                                        continue;
                                    }
                                    if (!value.contains("%SYMBOL%")) continue;
                                    attributeValues.set(j2, value.replace("%SYMBOL%", productDirs[i11]));
                                }
                                this.actionNum += 1.0;
                                Object newAction = newActionConst.newInstance(parameterArgs);
                                if (!externalClass) {
                                    patchComp.pluginList.add(newAction);
                                    ((OrderedPatchAction)newAction).setOrder(this.actionNum);
                                } else {
                                    patchComp.externalPluginList.add(newAction);
                                }
                                ((PatchAction)newAction).setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            this.actionNum += 1.0;
                            Object newAction = newActionConst.newInstance(parameterArgs);
                            if (!externalClass) {
                                patchComp.pluginList.add(newAction);
                                ((OrderedPatchAction)newAction).setOrder(this.actionNum);
                            } else {
                                patchComp.externalPluginList.add(newAction);
                            }
                            ((PatchAction)newAction).setRawActionEntry(rawEntry.toString());
                        }
                        break block196;
                    }
                    StringBuffer buff = new StringBuffer("Class not found \"");
                    buff.append(className);
                    buff.append("\"");
                    ClassNotFoundException ce = new ClassNotFoundException(buff.toString());
                    throw ce;
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException(e2);
                    re.setStackTrace(e2.getStackTrace());
                    SAXException se = new SAXException(re);
                    se.setStackTrace(re.getStackTrace());
                    throw se;
                }
            }
            ++this.lineNumber;
        } else {
            if (attributes == null || attributes.getLength() == 0) {
                RuntimeException re = new RuntimeException("OPatch was not able to find any attributes for an expected component in actions file. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            String name = qName;
            String version = attributes.getValue("version");
            String requireStr = attributes.getValue("opt_req");
            String patch_level = attributes.getValue("patch_level");
            if (version == null || version.equals("")) {
                RuntimeException re = new RuntimeException("Version field of the component \"" + qName + "\" in actions file cannot be <null> or empty. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            if (requireStr == null || requireStr.equals("")) {
                RuntimeException re = new RuntimeException("Required/Optional field of the component \"" + qName + "\" in actions file cannot be <null> or empty. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            boolean required = requireStr.equalsIgnoreCase("R");
            String symbol = attributes.getValue("symbol");
            String[] rawPatchComp = new String[2];
            StringBuffer sb = new StringBuffer(OPatchEnv.getBufferSize());
            sb.append("<");
            sb.append(name);
            sb.append(" ");
            sb.append("version");
            sb.append("=\"");
            sb.append(version);
            sb.append("\"");
            sb.append(" ");
            sb.append("opt_req");
            sb.append("=\"");
            sb.append(requireStr);
            sb.append("\"");
            sb.append(" ");
            if (symbol != null && !symbol.equals("")) {
                sb.append("symbol");
                sb.append("=\"");
                sb.append(symbol);
                sb.append("\" ");
            }
            if (patch_level != null && !patch_level.equals("")) {
                sb.append("patch_level");
                sb.append("=\"");
                sb.append(patch_level);
                sb.append("\"");
                sb.append(" ");
            }
            sb.append(">");
            rawPatchComp[0] = sb.toString();
            sb.delete(0, sb.capacity());
            sb.append("</");
            sb.append(name);
            sb.append(">");
            rawPatchComp[1] = sb.toString();
            PatchComponent patchComp = new PatchComponent(name, version, required);
            patchComp.setOptString(requireStr);
            if (patch_level != null && !patch_level.equals("")) {
                patchComp.setPatchLevel(patch_level);
            }
            if (symbol != null && !symbol.equals("") && OPatchEnv.isSymbolResolveEnabled()) {
                try {
                    patchComp.setSymbolName(symbol);
                    if (!pdtDirMap.containsKey(patchComp)) {
                        String oracleHomePath = OPatchEnv.getOracleHome();
                        pdtDirMap.put(patchComp, patchComp.getProductDirectories(oracleHomePath));
                    } else {
                        patchComp.setProductDirectories((String[])pdtDirMap.get(patchComp));
                    }
                }
                catch (SymbolFailureException ex) {
                    patchComp.setSymbolName(null);
                    if (required) {
                        throw ex;
                    }
                    patchComp.setFilter(true);
                }
            }
            patchComp.setRawActionEntry(rawPatchComp);
            this.compList.add(patchComp);
            ++this.lineNumber;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!(qName.equals("#text") || qName.equals("oneoff_actions") || this.isActionElement(qName))) {
            ++this.lineNumber;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
    }

    private ArrayList<String> getFiles(String directory, String rootDir) {
        Path dir = WrapperFactory.getNioServiceWrapper().getPath(directory, new String[0]);
        ArrayList<String> fileNameList = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    fileNameList.addAll(this.getFiles(entry.toString(), rootDir));
                    continue;
                }
                String fileName = entry.toString().replace(rootDir, "");
                fileNameList.add(fileName);
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        if (rootDir.length() - dir.toString().length() != 1) {
            String direc = dir.toString().replace(rootDir, "");
            fileNameList.add(direc);
        }
        return fileNameList;
    }

    private static ArrayList<DeleteFile> getAllDeleteFiles(String directory, String rootDir) {
        Path dir = WrapperFactory.getNioServiceWrapper().getPath(directory, new String[0]);
        ArrayList<DeleteFile> fileNameList = new ArrayList<DeleteFile>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    fileNameList.addAll(ActionsFileParser.getAllDeleteFiles(entry.toString(), rootDir));
                    continue;
                }
                DeleteFile df = new DeleteFile();
                df.setName(entry.toString().replace(rootDir, ""));
                df.setDir(false);
                fileNameList.add(df);
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        if (rootDir.length() - directory.length() != 1) {
            DeleteFile df = new DeleteFile();
            df.setName(directory.replace(rootDir, ""));
            df.setDir(true);
            fileNameList.add(df);
        }
        return fileNameList;
    }

    private StringBuffer getDeleteRawEntry(String aName, String name, String path, boolean isOneway, String isReq, String fileVersion, boolean isDir, boolean backupZip) {
        StringBuffer deleteRawEntry = new StringBuffer(OPatchEnv.getBufferSize());
        deleteRawEntry.append("<");
        deleteRawEntry.append(aName);
        deleteRawEntry.append(" ");
        if (name != "") {
            deleteRawEntry.append("name");
            deleteRawEntry.append("=\"");
            deleteRawEntry.append(name);
            deleteRawEntry.append("\" ");
        }
        if (fileVersion != null && !fileVersion.equals("")) {
            deleteRawEntry.append("file_version");
            deleteRawEntry.append("=\"");
            deleteRawEntry.append(fileVersion);
            deleteRawEntry.append("\" ");
        }
        deleteRawEntry.append("path");
        deleteRawEntry.append("=\"");
        deleteRawEntry.append(path);
        deleteRawEntry.append("\" ");
        deleteRawEntry.append("is_oneway");
        deleteRawEntry.append("=\"");
        deleteRawEntry.append(isOneway);
        deleteRawEntry.append("\" ");
        deleteRawEntry.append("is_directory");
        deleteRawEntry.append("=\"");
        deleteRawEntry.append(isDir);
        deleteRawEntry.append("\" ");
        if (isDir) {
            deleteRawEntry.append("is_passed");
            deleteRawEntry.append("=\"");
            deleteRawEntry.append(true);
            deleteRawEntry.append("\" ");
        }
        if (backupZip) {
            deleteRawEntry.append("backup_in_zip");
            deleteRawEntry.append("=\"");
            deleteRawEntry.append(backupZip);
            deleteRawEntry.append("\" ");
        }
        deleteRawEntry.append("opt_req");
        deleteRawEntry.append("=\"");
        deleteRawEntry.append(isReq);
        deleteRawEntry.append("\" />");
        return deleteRawEntry;
    }

    private StringBuffer getUnzipRawEntry(String name, String path, String fileName, String perm, String fileVersion, String timeStamp) {
        StringBuffer unzipRawEntry = new StringBuffer(OPatchEnv.getBufferSize());
        unzipRawEntry.append("<");
        unzipRawEntry.append("copy ");
        unzipRawEntry.append("name");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(name);
        unzipRawEntry.append("\" ");
        unzipRawEntry.append("path");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(path);
        unzipRawEntry.append("\" ");
        unzipRawEntry.append("file_name");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(fileName);
        unzipRawEntry.append("\" ");
        unzipRawEntry.append("update_timestamp");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(timeStamp);
        unzipRawEntry.append("\" ");
        if (fileVersion != null && !fileVersion.equals("")) {
            unzipRawEntry.append("file_version");
            unzipRawEntry.append("=\"");
            unzipRawEntry.append(fileVersion);
            unzipRawEntry.append("\" ");
        }
        unzipRawEntry.append("retain_permission");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(perm);
        unzipRawEntry.append("\" />");
        return unzipRawEntry;
    }

    private boolean checkFirstAppVerDirExist(String appDir) {
        boolean isSparseCopyType;
        boolean bl = isSparseCopyType = this.pObject.getApplicationDirs().size() > 0;
        if (isSparseCopyType) {
            OLogger.debug("ENTERING METHOD: PatchObject::checkFirstAppVerDirExist()");
            Path appFile = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOracleHome() + File.separator + appDir, new String[0]);
            OLogger.debug("The application location is " + appFile.toAbsolutePath().toString());
            if (Files.exists(appFile, new LinkOption[0])) {
                Path latestPointerFile = OPatchEnv.getLatestFileWtihStartString(OPatchEnv.getOracleHome(), appDir, "latest-ptr-");
                if (latestPointerFile == null || !Files.exists(latestPointerFile, new LinkOption[0])) {
                    OLogger.debug("The latest pointer file doesn't exists.");
                    return false;
                }
                OLogger.debug("The latest pointer file is in " + latestPointerFile.toAbsolutePath().toString());
                String fileName = latestPointerFile.getFileName().toString();
                String firstAppVerDirName = fileName.substring("latest-ptr-".length());
                Path firstAppVerFile = WrapperFactory.getNioServiceWrapper().getPath(appFile.toAbsolutePath().toString() + File.separator + firstAppVerDirName, new String[0]);
                OLogger.debug("The location of the first version directory is " + firstAppVerFile.toAbsolutePath().toString());
                if (Files.exists(firstAppVerFile, new LinkOption[0])) {
                    OLogger.debug("The first application version directory exists.");
                    return true;
                }
                OLogger.debug("The first application version directory doesn't exist.");
                return false;
            }
            OLogger.debug("The application directory doesn't exist.");
            return true;
        }
        return false;
    }
}

