/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import oracle.opatch.JarActionEntity;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.Rollbackable;
import oracle.opatch.opatchlogger.OLogger;

class BackupRollbackForApplyState
extends OPatchState {
    public BackupRollbackForApplyState() {
        super(8, 50, 54, "Back up for rollback", OLogger.INFO, false);
    }

    @Override
    protected String getStateAssociatedMessage(String oracleHome, PatchObject[] patchObject) {
        StringBuffer buff = new StringBuffer("");
        int backUpFileNumber = 0;
        for (int i2 = 0; i2 < patchObject.length; ++i2) {
            backUpFileNumber += this.getBackupRollbackFileNumber(oracleHome, patchObject[i2]);
        }
        buff.append("Back up " + backUpFileNumber + " files for future patch rollback.");
        return buff.toString();
    }

    private int getBackupRollbackFileNumber(String oracleHome, PatchObject patchObject) {
        int backupFileNumber = 0;
        String cookedPatchID = patchObject.getCookedPatchID();
        String patchID = patchObject.getPatchID();
        PatchComponent[] includedPatchComponents = patchObject.getIncludedPatchComponents();
        int nComps = includedPatchComponents.length;
        int nActions = patchObject.getPatchActions().length;
        TreeSet<String> set = new TreeSet<String>();
        ArrayList<Rollbackable> backupList = new ArrayList<Rollbackable>();
        for (int i2 = 0; i2 < nComps; ++i2) {
            PatchComponent pc = includedPatchComponents[i2];
            PatchAction[] includedPatchActions = patchObject.getPatchActionsForComponent(pc);
            Rollbackable ra = null;
            for (int j2 = 0; j2 < includedPatchActions.length; ++j2) {
                String desc;
                String key;
                PatchAction pa = includedPatchActions[j2];
                if (!pa.isAppliedOK() || !(pa instanceof Rollbackable) || set.contains(key = (desc = (ra = (Rollbackable)((Object)pa)).getRollbackableDesc(oracleHome, cookedPatchID)))) continue;
                backupList.add(ra);
                set.add(key);
            }
        }
        HashMap<String, PatchAction> jarActionEntityMap = new HashMap<String, PatchAction>();
        for (int i3 = 0; i3 < backupList.size(); ++i3) {
            Object obj = backupList.get(i3);
            PatchAction po = (PatchAction)obj;
            if (!(po instanceof Rollbackable)) continue;
            try {
                if (po instanceof JarActionEntity) {
                    jarActionEntityMap.put(((JarActionEntity)po).getJarName(), po);
                    continue;
                }
                backupFileNumber += po.getBackupForRollbackFileNumber(oracleHome, cookedPatchID);
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return backupFileNumber += jarActionEntityMap.size();
    }
}

