/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.cas.FailureType;
import oracle.opatch.cas.OPatchCASException;
import oracle.opatch.cas.client.CASClientFactory;
import oracle.opatch.opatchlogger.OLogger;

public class CleanupSession
implements IOPatchSession {
    private boolean hasOUI = false;

    @Override
    public boolean isOUIBased() {
        return this.hasOUI;
    }

    @Override
    public void process(String oracleHome) {
        if (OPatchEnv.isHelp()) {
            if (this.helpPresent()) {
                this.displayHelp();
            }
            return;
        }
        OLogger.println(MessageFormat.format("CleanupSession process on cas_repo \"{0}\"... ", oracleHome));
        String casTagId = OPatchEnv.getCasTagId();
        boolean report = OPatchEnv.isReport();
        boolean pruneSpace = OPatchEnv.isPruneSpace();
        String maxMem = OPatchEnv.getMaxMem();
        try {
            OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
            CASClientFactory.getCASClient().cleanup(casTagId, pruneSpace, maxMem, report);
            if (casTagId != null) {
                OLogger.println(MessageFormat.format("cleanup all the patches after the tag \"{0}\". ", casTagId));
            } else {
                OLogger.println("cleanup all the patches. ");
            }
        }
        catch (OPatchCASException t) {
            if (t.getFailureType() == FailureType.NO_OP_EXCEPTION) {
                return;
            }
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "cleanup_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

