/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import oracle.opatch.OUIReplacer;
import oracle.opatch.opatchlogger.OLogger;

public class DBOperations {
    String dbType = "";
    final String typecrs = "CRS";
    final String typerac = "RAC";
    final String typesidb = "SIDB";
    final String typesihaDB = "SIHADB";
    final String typehas = "HAS";
    final String hasErrorMessage1 = "Parse Error:";
    final String sidbErrMsg = "Unable to retrieve Oracle Clusterware home";
    final String restartMsgErr = "PRKO-2012 : instance object is not supported in Oracle Restart";
    final String notClusterMsgErr = "PRCD-1035 : Database orclsidb is not a cluster database";
    final String nosupport = "UNSUPPORTED";
    final String nofallback = "NOFALLBACK";
    final String TAGMSG = "[FUSER FALLBACK] ";
    public static boolean restartCmdError = false;
    public static boolean restartDBStatus = false;
    public static String dbName = "";
    public static String restartDBID = "";
    ArrayList<String> patchingHomeMatchedInstances = new ArrayList();
    public ArrayList<String> serviceRunningList = new ArrayList();
    public static boolean outputExists = false;
    String[] supportedDBTypes = new String[]{"SIDB", "RAC", "CRS", "HAS"};
    Path srvctlLoc;
    Path crsctlLoc;
    public static String errorMsg = "ERROR";
    public String envVarOH = "ORACLE_HOME";
    private String[] dbInstances;

    public String cmdToExecute(String cmd) {
        StringBuilder op = new StringBuilder();
        outputExists = false;
        errorMsg = "";
        try {
            String line;
            Process pr = Runtime.getRuntime().exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = br.readLine()) != null) {
                op.append(line + "\n");
            }
            int exitCode = pr.waitFor();
            if (exitCode == 0) {
                outputExists = true;
                return op.toString();
            }
        }
        catch (IOException | InterruptedException e2) {
            e2.printStackTrace();
        }
        errorMsg = op.toString();
        return errorMsg;
    }

    private boolean getRestartOutput(String srvctlLoc, String cmd, String dbNameLocal) {
        String op = this.cmdToExecute(cmd);
        String[] opMulti = op.trim().split(System.lineSeparator());
        if (!outputExists) {
            for (int i2 = opMulti.length - 1; i2 >= 0; --i2) {
                if (!opMulti[i2].trim().contains("PRKO-2012 : instance object is not supported in Oracle Restart") && !opMulti[i2].trim().contains("PRCD-1035 : Database orclsidb is not a cluster database")) continue;
                OLogger.printlnOnLog("[FUSER FALLBACK] DB is in restart mode and switching to database command : " + opMulti[i2]);
                StringBuffer cmdToRun = new StringBuffer();
                cmdToRun.append(srvctlLoc);
                cmdToRun.append(" status database -db ");
                cmdToRun.append(dbNameLocal);
                OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
                op = "";
                restartCmdError = true;
                op = this.cmdToExecute(cmdToRun.toString());
                if (!op.trim().contains("is running")) break;
                restartDBStatus = true;
                restartDBID = dbNameLocal;
                return true;
            }
        }
        return false;
    }

    public String getDBType(String oh) throws RuntimeException {
        HashSet<String> removeDup = new HashSet<String>();
        removeDup.addAll(this.patchingHomeMatchedInstances);
        this.patchingHomeMatchedInstances.clear();
        this.patchingHomeMatchedInstances.addAll(removeDup);
        OUIReplacer.setEnv("ORACLE_HOME", oh);
        this.srvctlLoc = Paths.get(oh, File.separator, "bin", File.separator, "srvctl");
        this.crsctlLoc = Paths.get(oh, File.separator, "bin", File.separator, "crsctl");
        String op = "";
        if (Files.exists(this.crsctlLoc, new LinkOption[0])) {
            StringBuffer cmdToRun = new StringBuffer("");
            cmdToRun.append(this.crsctlLoc);
            cmdToRun.append(" check crs");
            OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
            op = this.cmdToExecute(cmdToRun.toString());
            String[] opMulti = op.trim().split(System.lineSeparator());
            for (int i2 = opMulti.length - 1; i2 >= 0; --i2) {
                if (!opMulti[i2].equalsIgnoreCase("Parse Error:")) continue;
                return "HAS";
            }
            return "CRS";
        }
        if (Files.exists(this.srvctlLoc, new LinkOption[0])) {
            StringBuffer cmdToRun = new StringBuffer("");
            cmdToRun.append(this.srvctlLoc);
            cmdToRun.append(" config database -home ");
            OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
            op = this.cmdToExecute(cmdToRun.toString());
            if (outputExists) {
                String[] op1 = this.cmdToExecute(cmdToRun.toString()).split("\n");
                String dbNameLocal = "";
                for (int i3 = 0; i3 < op1.length; ++i3) {
                    String[] getDBHome = op1[i3].split("\\s+");
                    String homePath = getDBHome[1].trim();
                    String instanceName = getDBHome[0].trim();
                    if (!oh.equalsIgnoreCase(homePath)) continue;
                    OLogger.printlnOnLog("[FUSER FALLBACK] Patching Oracle Home: " + oh);
                    OLogger.printlnOnLog("[FUSER FALLBACK] DB Home path from command: " + homePath);
                    cmdToRun = new StringBuffer("");
                    cmdToRun.append(this.srvctlLoc);
                    cmdToRun.append(" status instance -db ");
                    cmdToRun.append(instanceName);
                    cmdToRun.append(" -node ");
                    cmdToRun.append(this.getHostname());
                    OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
                    boolean restartHome = this.getRestartOutput(this.srvctlLoc.toString(), cmdToRun.toString(), instanceName);
                    if (restartCmdError) {
                        this.setDBName(instanceName);
                        return "SIHADB";
                    }
                    op = this.cmdToExecute(cmdToRun.toString());
                    if (!outputExists) {
                        this.setDBName(instanceName);
                        return "SIDB";
                    }
                    this.patchingHomeMatchedInstances.add(instanceName);
                }
                dbName = this.patchingHomeMatchedInstances.toString();
                OLogger.printlnOnLog("[FUSER FALLBACK] DB unique name is : " + dbName);
                return "RAC";
            }
            if (!outputExists && errorMsg.contains("Unable to retrieve Oracle Clusterware home")) {
                return "SIDB";
            }
            return "UNSUPPORTED";
        }
        OLogger.printlnOnLog("[FUSER FALLBACK] Both crsctl and srvctl are not present in home and no fallback.");
        return "UNSUPPORTED";
    }

    public void setDBName(String name) {
        if (name != "" || name != null) {
            dbName = name;
        }
    }

    public String getDBName(String oh) throws IOException {
        dbName = "";
        String type = this.getDBType(oh);
        if (type.equalsIgnoreCase("RAC")) {
            if (dbName != null || dbName != "") {
                return dbName;
            }
            OLogger.printlnOnLog("[FUSER FALLBACK] WARNING: Unable to get DB Name");
            return "UNSUPPORTED";
        }
        if (type.equalsIgnoreCase("SIDB")) {
            String sidbID = this.tnsParser(oh).toString();
            if (sidbID != null || sidbID != "") {
                return sidbID;
            }
            OLogger.printlnOnLog("[FUSER FALLBACK] WARNING : Unable to get SIDB Name");
            return "UNSUPPORTED";
        }
        if (type.equalsIgnoreCase("CRS")) {
            return "asm";
        }
        if (type.equalsIgnoreCase("HAS")) {
            return "HAS";
        }
        return "UNSUPPORTED";
    }

    public String tnsParser(String oh) throws IOException {
        Path filePath = Paths.get(oh, File.separator, "network", File.separator, "admin", File.separator, "tnsnames.ora");
        ArrayList<String> allSIDBIDs = new ArrayList<String>();
        File file = new File(String.valueOf(filePath.toFile()));
        String strDBID = "";
        OLogger.printlnOnLog("[FUSER FALLBACK] Reading tnsnames.ora : " + file.toString());
        if (!file.exists()) {
            return "NOFALLBACK";
        }
        try (Scanner scanTns = new Scanner(new File(String.valueOf(file)));){
            while (scanTns.hasNext()) {
                String str = scanTns.nextLine();
                if (!str.contains("SERVICE_NAME")) continue;
                strDBID = str.replaceAll(".*=", "");
                strDBID = strDBID.replaceAll("\\)", "");
                strDBID = strDBID.replaceAll("\\s", "");
                if ((strDBID = strDBID.replaceAll("\\..*", "")) != null || strDBID != "") {
                    allSIDBIDs.add(strDBID);
                    continue;
                }
                OLogger.printlnOnLog("[FUSER FALLBACK] Error: Unable to get SIDB from tnsnames.ora.");
            }
        }
        OLogger.printlnOnLog("[FUSER FALLBACK] SIDB that is congiured in tnsnames.ora : " + strDBID);
        return strDBID;
    }

    public String[] dbInstances(String oh) throws IOException {
        String type = this.getDBType(oh);
        String op = "";
        OLogger.printlnOnLog("[FUSER FALLBACK] get dbInstances() ");
        StringBuffer cmdToRun = new StringBuffer("");
        if (type.equalsIgnoreCase("RAC")) {
            String dbNameLocal = this.getDBName(oh);
            this.srvctlLoc = Paths.get(oh, File.separator, "bin", File.separator, "srvctl");
            cmdToRun = new StringBuffer();
            cmdToRun.append(this.srvctlLoc);
            cmdToRun.append(" config database -db ");
            if (dbNameLocal == null || dbNameLocal == "") {
                OLogger.printlnOnLog("[FUSER FALLBACK] No service configured for the home : " + oh);
                return new String[]{""};
            }
            cmdToRun.append(dbNameLocal);
            OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
            op = this.cmdToExecute(cmdToRun.toString());
            if (outputExists) {
                String[] cmdOPInstances;
                OLogger.printlnOnLog("[FUSER FALLBACK] Command Output : \n" + op);
                for (String str : cmdOPInstances = op.split(System.lineSeparator())) {
                    if (!str.contains("Database instances")) continue;
                    str = str.replaceAll(".*: ", "");
                    OLogger.printlnOnLog("str : " + str);
                    String[] dbInstances = new String[str.split(",").length];
                    dbInstances = str.split(",");
                    return dbInstances;
                }
            } else {
                OLogger.printlnOnLog("[FUSER FALLBACK] WARNING : Unable to get DB instances as the srvctl command does not return.Please make sure that services are properly shut down");
                return new String[]{""};
            }
        }
        OLogger.printlnOnLog("[FUSER FALLBACK] The current home does not have instances as type is : " + type);
        return new String[]{""};
    }

    public String getHostname() {
        String nodeName = this.cmdToExecute("hostname");
        return nodeName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dbServiceIsRunning(String oh) throws IOException {
        StringBuffer cmdToRun = new StringBuffer("");
        String type = this.getDBType(oh);
        OLogger.printlnOnLog("[FUSER FALLBACK] Check dbServiceIsRunning or not for type : " + type);
        if (type.equalsIgnoreCase("SIHADB")) {
            if (!restartCmdError) return false;
            if (!restartDBStatus) return false;
            OLogger.printlnOnLog("[FUSER FALLBACK] service that is running from OH  : " + restartDBID);
            OLogger.printlnOnLog("[FUSER FALLBACK] Kindly shutdown the services for the given OH : " + oh);
            return true;
        }
        if (type.equalsIgnoreCase("RAC")) {
            HashSet<String> removeDup = new HashSet<String>();
            removeDup.addAll(this.patchingHomeMatchedInstances);
            this.patchingHomeMatchedInstances.clear();
            this.patchingHomeMatchedInstances.addAll(removeDup);
            boolean racStatus = false;
            if (this.patchingHomeMatchedInstances.size() <= 0) {
                OLogger.printlnOnLog("[FUSER FALLBACK] No service has been configured for the given OH : " + oh);
                return false;
            }
            Iterator<String> iterator = this.patchingHomeMatchedInstances.iterator();
            while (iterator.hasNext()) {
                String dbInst;
                String dbNameLocal = dbInst = iterator.next();
                OLogger.printlnOnLog("[FUSER FALLBACK] Check for Instance  : " + dbInst);
                this.srvctlLoc = Paths.get(oh, File.separator, "bin", File.separator, "srvctl");
                cmdToRun = new StringBuffer();
                cmdToRun.append(this.srvctlLoc);
                cmdToRun.append(" status instance -db ");
                if (dbNameLocal == null || dbNameLocal == "") {
                    OLogger.printlnOnLog("[FUSER FALLBACK] DBName is null and no DB service is being run from OH");
                    return false;
                }
                cmdToRun.append(dbNameLocal);
                cmdToRun.append(" -node ");
                cmdToRun.append(this.getHostname());
                this.getRestartOutput(this.srvctlLoc.toString(), cmdToRun.toString(), dbNameLocal);
                OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
                String op = this.cmdToExecute(cmdToRun.toString());
                String[] opMulti = op.trim().split(System.lineSeparator());
                if (outputExists) {
                    OLogger.printlnOnLog("[FUSER FALLBACK] Command output : " + op);
                    if (op.contains("is running")) {
                        System.out.println("WARNING : OH Service is running.  Please shutdown the services of OH");
                        System.out.println("Service that is running : \n" + op);
                        this.serviceRunningList.add(dbInst);
                        racStatus = true;
                        continue;
                    }
                    OLogger.printlnOnLog("[FUSER FALLBACK] No service is being run from OH for instance : " + dbInst);
                    continue;
                }
                OLogger.printlnOnLog("[FUSER FALLBACK] WARNING: Unable to check the DB Status");
            }
            return racStatus;
        }
        if (type.equalsIgnoreCase("SIDB")) {
            OLogger.printlnOnLog("[FUSER FALLBACK] Type of the home is : " + type);
            String dbID = this.getDBName(oh);
            cmdToRun = new StringBuffer();
            cmdToRun.append("ps -ef");
            if (dbID.equalsIgnoreCase("NOFALLBACK")) {
                OLogger.printlnOnLog("[FUSER FALLBACK] NO fallback mechanism as there is an error while parsing tnsnames.ora");
                return false;
            }
            if (dbID.equalsIgnoreCase("UNSUPPORTED")) {
                OLogger.printlnOnLog("[FUSER FALLBACK] WARNING : Unable to get the SIDB.Hence ps command will not run. Please make sure thatservices are properly shutdown");
                return false;
            }
            OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
            String op = this.cmdToExecute(cmdToRun.toString());
            boolean sidbstatus = false;
            if (!outputExists) return false;
            String[] cmdOPCRS = op.split(System.lineSeparator());
            int i2 = 0;
            while (i2 < cmdOPCRS.length) {
                if (cmdOPCRS[i2].contains("ora_pmon_" + dbID)) {
                    System.out.println("WARNING : SIDB instance \"" + dbID + "\" is running.  Please shutdown the services of OH : \n" + cmdOPCRS[i2]);
                    return true;
                }
                ++i2;
            }
            return sidbstatus;
        }
        if (type.equalsIgnoreCase("CRS")) {
            OLogger.printlnOnLog("[FUSER FALLBACK] Type of the home is : " + type);
            cmdToRun = new StringBuffer();
            Path getCRSHomeCmd = Paths.get(oh, File.separator, "srvm", File.separator, "admin", File.separator, "getcrshome");
            String crsHomeOp = "";
            if (getCRSHomeCmd.toFile().exists()) {
                crsHomeOp = this.cmdToExecute(getCRSHomeCmd.toString()).trim();
            }
            OLogger.printlnOnLog("[FUSER FALLBACK] CRS Home from " + getCRSHomeCmd.toString() + " is : " + crsHomeOp);
            if (crsHomeOp != "" && crsHomeOp != null) {
                if (crsHomeOp.equalsIgnoreCase(oh)) {
                    this.crsctlLoc = Paths.get(oh, File.separator, "bin", File.separator, "crsctl");
                    cmdToRun.append(this.crsctlLoc);
                    cmdToRun.append(" check crs");
                    boolean crsComplete = false;
                    OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
                    String op = this.cmdToExecute(cmdToRun.toString());
                    if (!outputExists) return false;
                    OLogger.printlnOnLog("[FUSER FALLBACK] Command output : \n" + op);
                    String[] cmdOPCRS = op.split(System.lineSeparator());
                    int i3 = 0;
                    while (i3 < cmdOPCRS.length) {
                        if (cmdOPCRS[i3].contains("is online")) {
                            System.out.println("WARNING : CRS Service is running.  Please shutdown the services of CRS OH\n");
                            System.out.println("CRS status :\n");
                            String[] stringArray = cmdOPCRS;
                            int n2 = stringArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String st = stringArray[n3];
                                System.out.println(st);
                                ++n3;
                            }
                            return true;
                        }
                        ++i3;
                    }
                    return crsComplete;
                }
                OLogger.printlnOnLog("[FUSER FALLBACK] CRS home is not matches with Original home and hence OPatch will continue patching");
                return false;
            }
            OLogger.printlnOnLog("[FUSER FALLBACK] Error : Unable to run : " + getCRSHomeCmd.toString());
            return false;
        }
        if (!type.equalsIgnoreCase("HAS")) return false;
        OLogger.printlnOnLog("[FUSER FALLBACK] Type of the home is : " + type);
        cmdToRun = new StringBuffer();
        Path getCRSHomeCmd = Paths.get(oh, File.separator, "srvm", File.separator, "admin", File.separator, "getcrshome");
        String crsHomeOp = "";
        if (getCRSHomeCmd.toFile().exists()) {
            crsHomeOp = this.cmdToExecute(getCRSHomeCmd.toString()).trim();
        }
        OLogger.printlnOnLog("[FUSER FALLBACK] CRS Home from " + getCRSHomeCmd.toString() + " is : " + crsHomeOp);
        if (crsHomeOp != "" && crsHomeOp != null) {
            if (crsHomeOp.equalsIgnoreCase(oh)) {
                this.crsctlLoc = Paths.get(oh, File.separator, "bin", File.separator, "crsctl");
                cmdToRun.append(this.crsctlLoc);
                cmdToRun.append(" check has");
                boolean crsComplete = false;
                OLogger.printlnOnLog("[FUSER FALLBACK] Running :" + cmdToRun.toString());
                String op = this.cmdToExecute(cmdToRun.toString());
                if (!outputExists) return false;
                OLogger.printlnOnLog("[FUSER FALLBACK] Command output : \n" + op);
                String[] cmdOPCRS = op.split(System.lineSeparator());
                int i4 = 0;
                while (i4 < cmdOPCRS.length) {
                    if (cmdOPCRS[i4].contains("is online")) {
                        System.out.println("WARNING : HAS Service is running.  Please shutdown the services of CRS OH\n");
                        System.out.println("HAS status :\n");
                        String[] stringArray = cmdOPCRS;
                        int n4 = stringArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String st = stringArray[n5];
                            System.out.println(st);
                            ++n5;
                        }
                        return true;
                    }
                    ++i4;
                }
                return crsComplete;
            }
            OLogger.printlnOnLog("[FUSER FALLBACK] HAS home is not matches with Original home and hence OPatch will continue patching");
            return false;
        }
        OLogger.printlnOnLog("[FUSER FALLBACK] Error : Unable to run : " + getCRSHomeCmd.toString());
        OLogger.printlnOnLog("[FUSER FALLBACK] OPatch cannot continue patching for the home :" + oh);
        return false;
    }
}

