/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.opatch.JarActionEntity;
import oracle.opatch.JarActionEntityTree;
import oracle.opatch.JarActionHelper;
import oracle.opatch.MultiJarUtil;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchComponent;
import oracle.opatch.Rules;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class DeleteJarAction
extends JarActionEntity {
    private boolean required;

    public DeleteJarAction(PatchComponent pc, String jarName, String jarPath, String className, int lineNumber, boolean required) throws NullPointerException, Exception {
        super(pc, jarName, jarPath, className, lineNumber);
        this.required = required;
    }

    public boolean isReq() {
        return this.required;
    }

    @Override
    public String getActionName() {
        return "DeleteJarAction";
    }

    @Override
    public String getActionDesc() {
        return "Delete Jar entry from jar/ear/war.";
    }

    @Override
    public String getApplyDescription(String oracleHomePath) {
        return "Delete the given class file from the jar inside ORACLE_HOME.";
    }

    @Override
    public String getRollbackDescription(String oracleHomePath) {
        return "Jar the file deleted into the jar inside ORACLE_HOME from the backup.";
    }

    @Override
    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getJarName());
        String src = this.getClassPath();
        String nonApplicableDesc = this.getNonApplicableDesc();
        if (nonApplicableDesc == null || nonApplicableDesc.isEmpty()) {
            nonApplicableDesc = JarActionHelper.isRequiredDescCacheForApply.containsKey(this) ? JarActionHelper.isRequiredDescCacheForApply.get(this) : "";
        }
        String desc = OLogger.getString("OUI-69302", new Object[]{owningComp, dst, src}) + System.lineSeparator() + nonApplicableDesc;
        return desc;
    }

    @Override
    public String getRollbackableDesc(String oracleHomePath, String owningComp) {
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getJarName());
        String src = this.getClassPath();
        String nonRollbackableDesc = this.getNonRollbackableDesc();
        if (nonRollbackableDesc == null || nonRollbackableDesc.isEmpty()) {
            nonRollbackableDesc = JarActionHelper.isRequiredDescCacheForRollback.containsKey(this) ? JarActionHelper.isRequiredDescCacheForRollback.get(this) : "";
        }
        String desc = nonRollbackableDesc + System.lineSeparator() + OLogger.getString("OUI-69303", new Object[]{owningComp, dst, src});
        return desc;
    }

    @Override
    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws NullPointerException {
        StringBuffer buff = new StringBuffer(this.getActionName() + "::getRollbackScriptEntry()");
        OLogger.debug(buff);
        buff = new StringBuffer(this.getActionName() + "::getRollbackScriptEntry(): ");
        buff.append("jarName=\"");
        buff.append(this.getJarName());
        buff.append("\", jarPath=\"");
        buff.append(this.getJarPath());
        buff.append("\", className=\"");
        buff.append(this.getClassName());
        buff.append("\"");
        OLogger.debug(buff);
        StringBuffer rollbackStr = new StringBuffer("\n");
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer("JarAction::getRollbackScriptEntry(): ");
            buff.append("Cannot parse the Delete Jar path, jarName=\"");
            buff.append(this.getJarName());
            buff.append("\", jarPath=\"");
            buff.append(this.getJarPath());
            buff.append("\", className=\"");
            buff.append(this.getClassName());
            buff.append("\"");
            OLogger.debug(buff);
            return rollbackStr.toString();
        }
        boolean isWindow = OPatchEnv.isWindows();
        StringBuffer deleteJarCommand = null;
        String[] systemCommand = null;
        Path dstClassFile = null;
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.getClassName());
        String src = path.toString();
        path = new StringBuffer(this.getParentDirPath(oracleHomePath));
        path.append(File.separator);
        path.append(this.getJarList()[0]);
        String dst = path.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        StringBuffer tmp = new StringBuffer(this.getActionName() + "::getRollbackScriptEntry() extract file \"");
        tmp.append(src);
        tmp.append("\" to jar file ");
        tmp.append(dst);
        tmp.append("\"");
        OLogger.debug(tmp);
        systemCommand = new String[2];
        String[] jarList = this.getJarList();
        String[] jarAbsPathList = this.getJarAbsPathList();
        String[] jarPathList = this.getJarPathList();
        try {
            for (int i2 = 0; i2 < jarList.length - 1; ++i2) {
                deleteJarCommand = new StringBuffer(OPatchEnv.getJarCommand_ExtractOption());
                if (!jarAbsPathList[i2].equals("")) {
                    deleteJarCommand.append(jarAbsPathList[i2]);
                    deleteJarCommand.append(File.separator);
                }
                deleteJarCommand.append(jarList[i2]);
                deleteJarCommand.append(" ");
                if (!jarList[i2 + 1].equals("")) {
                    deleteJarCommand.append(jarList[i2 + 1]);
                    deleteJarCommand.append(File.separator);
                }
                deleteJarCommand.append(jarList[i2 + 1]);
                systemCommand[0] = deleteJarCommand.toString();
                String runDir = jarAbsPathList[i2];
                rollbackStr.append("cd ");
                rollbackStr.append(runDir);
                rollbackStr.append("\n");
                rollbackStr.append(systemCommand[0]);
                rollbackStr.append("\n");
            }
            StringBuffer tmpJarPath = new StringBuffer(jarAbsPathList[jarList.length - 1]);
            tmpJarPath.append(File.separator);
            tmpJarPath.append(jarList[jarList.length - 1]);
            dstClassFile = WrapperFactory.getNioServiceWrapper().getPath(tmpJarPath.toString(), new String[0]);
            if (isWindow) {
                rollbackStr.append("copy /Y ");
            } else {
                rollbackStr.append("\\cp -f ");
            }
            rollbackStr.append(srcFile.toString());
            rollbackStr.append(" ");
            rollbackStr.append(dstClassFile.toString());
            for (int i3 = jarList.length - 1; i3 > 0; --i3) {
                deleteJarCommand = new StringBuffer(OPatchEnv.getJarCommand_UpdateOption());
                if (!jarAbsPathList[i3 - 1].equals("")) {
                    deleteJarCommand.append(jarAbsPathList[i3 - 1]);
                    deleteJarCommand.append(File.separator);
                }
                deleteJarCommand.append(jarList[i3 - 1]);
                deleteJarCommand.append(" -C ");
                deleteJarCommand.append(jarAbsPathList[i3 - 1]);
                deleteJarCommand.append(" ");
                if (!jarPathList[i3].equals("")) {
                    deleteJarCommand.append(this.getJarPathList()[i3]);
                    deleteJarCommand.append(File.separator);
                }
                deleteJarCommand.append(jarList[i3]);
                systemCommand[0] = deleteJarCommand.toString();
                String runDir = jarAbsPathList[i3 - 1];
                rollbackStr.append("\n");
                rollbackStr.append("cd ");
                rollbackStr.append(runDir);
                rollbackStr.append("\n");
                rollbackStr.append(systemCommand[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        OLogger.debug(new StringBuffer(this.getActionName() + "::getRollbackScriptEntry() done"));
        return rollbackStr.toString();
    }

    @Override
    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    @Override
    public boolean applicable(String oracleHomePath, String patchLocation) {
        boolean result;
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuffer buff = new StringBuffer(this.getActionName() + "::applicable() ");
        OLogger.debug(buff);
        buff = new StringBuffer("  class name = \"");
        buff.append(this.getClassName());
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer("  processDeleteJarActionPaths() returns false");
            OLogger.debug(buff);
            buff = new StringBuffer(this.getActionName() + " could not be processed, hence the action is not applicable.");
            this.setNonApplicableDesc(buff.toString());
            return false;
        }
        String[] jarList = this.getJarList();
        StringBuffer tmpB = new StringBuffer(this.getParentDirPath(oracleHomePath));
        tmpB.append(File.separator);
        tmpB.append(jarList[0]);
        String dst = tmpB.toString();
        buff = new StringBuffer(this.getActionName() + " details: dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        buff = new StringBuffer("  checking on destination ");
        buff.append(dst);
        OLogger.debug(buff);
        if (!Files.exists(dstFile, new LinkOption[0]) || !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile)) {
            buff = new StringBuffer(this.getActionName() + ":: Destination File \"");
            buff.append(dst);
            buff.append("\" does not exists or is not writeable");
            this.setNonApplicableDesc(buff.toString());
            return false;
        }
        if (this.isReq() && !(result = this.checkRequiedDuringApply(oracleHomePath))) {
            if (JarActionHelper.isRequiredDescCacheForApply.containsKey(this)) {
                this.setNonApplicableDesc(JarActionHelper.isRequiredDescCacheForApply.get(this));
            } else {
                buff = new StringBuffer(this.getActionName() + ":: CheckRequird has failed for File \"");
                buff.append(this.getClassName());
                buff.append("\" in " + dst);
                this.setNonApplicableDesc(buff.toString());
            }
            return false;
        }
        return true;
    }

    private boolean checkRequiedDuringApply(String oracleHomePath) {
        if (JarActionHelper.isRequiredCacheForApply.containsKey(this)) {
            return JarActionHelper.isRequiredCacheForApply.get(this);
        }
        JarActionEntityTree.TreeNode root = JarActionEntityTree.getRoot();
        HashMap failedMap = new HashMap();
        ArrayList failed = new ArrayList();
        StringBuffer buff = new StringBuffer(this.getActionName() + ":: checkRequiedDuringApply() called");
        if (root == null || root.isLeaf()) {
            buff = new StringBuffer("The Delete jar action tree has not been contructed.");
            OLogger.debug(buff);
            JarActionHelper.isRequiredDescCacheForApply.put(this, buff.toString());
            JarActionHelper.isRequiredCacheForApply.put(this, false);
            return false;
        }
        boolean cont = Rules.SystemWrite_continue();
        ArrayList topLevelJars = root.getChilds();
        if (topLevelJars == null) {
            buff = new StringBuffer("The Delete jar action tree is not contructed properly");
            OLogger.debug(buff);
            JarActionHelper.isRequiredDescCacheForApply.put(this, buff.toString());
            JarActionHelper.isRequiredCacheForApply.put(this, false);
            return false;
        }
        for (int i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionEntityTree.TreeNode patchingNode;
            JarActionEntityTree.TreeNode tn = (JarActionEntityTree.TreeNode)topLevelJars.get(i2);
            String jarName = tn.getJarName();
            String jarPath = tn.getJarPath();
            String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
            String curJarPath = this.getJarPath();
            if (!curJarPath.startsWith(File.separator)) {
                curJarPath = File.separator + curJarPath;
            }
            if (!(patchingNode = new JarActionEntityTree.TreeNode(0, this.getRootJarName(), curJarPath, null)).equals(tn)) continue;
            try {
                Path srcJar = WrapperFactory.getNioServiceWrapper().getPath(patchingJarFilePath, new String[0]);
                if (!Files.exists(srcJar, new LinkOption[0])) {
                    buff = new StringBuffer(this.getActionName() + "::checkRequiedDuringApply() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    JarActionHelper.isRequiredDescCacheForApply.put(this, buff.toString());
                    JarActionHelper.isRequiredCacheForApply.put(this, false);
                    return false;
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID());
                this.checkRequiedBasedOnJarTreeDuringApply(tn, patchingJarFilePath, scratchLocation, patchingJarFilePath);
                break;
            }
            catch (Exception e2) {
                buff = new StringBuffer(this.getActionName() + "::checkRequiedDuringApply() for Jar file \"" + "ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed ");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                JarActionHelper.isRequiredDescCacheForApply.put(this, buff.toString());
                JarActionHelper.isRequiredCacheForApply.put(this, false);
                return false;
            }
        }
        if (JarActionHelper.isRequiredCacheForApply.containsKey(this)) {
            return JarActionHelper.isRequiredCacheForApply.get(this);
        }
        return true;
    }

    private void checkRequiedBasedOnJarTreeDuringApply(JarActionEntityTree.TreeNode node, String jarIn, String scratchLocation, String relativeWorkName) {
        StringBuffer buff = new StringBuffer(this.getActionName() + "::checkRequiedBasedOnJarTreeDuringApply() called");
        OLogger.debug(buff.toString());
        if (node == null || node.isLeaf()) {
            return;
        }
        ArrayList childs = node.getChilds();
        String parentPath = MultiJarUtil.combineEntry(relativeWorkName, node.getJarPath());
        ZipInputStream patchedJar = null;
        try {
            Path patchJarFile = WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]);
            if (!Files.exists(patchJarFile, new LinkOption[0])) {
                buff = new StringBuffer("checkRequiedBasedOnJarTreeDuringApply() failed.  File not exist : \"");
                buff.append(jarIn);
                buff.append("\"");
                OLogger.printlnOnLog(buff.toString());
                return;
            }
            patchedJar = new ZipInputStream(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]), new OpenOption[0]));
        }
        catch (IOException e2) {
            ArrayList failedEntries = new ArrayList();
            MultiJarUtil.getAllLeavesForNode(node, failedEntries, MultiJarUtil.JarOperation.VERIFY, true, e2.getMessage());
            buff = new StringBuffer("Creating input stream for \"" + jarIn + "\"");
            buff.append(" failed.");
            buff.append(e2.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return;
        }
        ZipEntry entry = null;
        try {
            block6: while ((entry = patchedJar.getNextEntry()) != null) {
                boolean entryExist = false;
                for (int i2 = 0; i2 < childs.size(); ++i2) {
                    JarActionEntityTree.TreeNode curNode = (JarActionEntityTree.TreeNode)childs.get(i2);
                    if (!MultiJarUtil.foundEntry(entry.getName(), curNode.getEntryName())) continue;
                    entryExist = true;
                    String curEntry = curNode.getEntryName();
                    String completeRelativePath = MultiJarUtil.combineEntry(parentPath, curEntry);
                    if (curNode.isLeaf()) {
                        if (!curNode.getJarAction().getActionName().equals("DeleteJarAction")) continue block6;
                        DeleteJarAction dja = (DeleteJarAction)curNode.getJarAction();
                        JarActionHelper.isRequiredCacheForApply.put(dja, true);
                        continue block6;
                    }
                    String workJarFile = MultiJarUtil.getWorkPath(scratchLocation, completeRelativePath);
                    buff = new StringBuffer("Unzip multi-level jar : ");
                    buff.append("Extract low-level jar to \"" + workJarFile + "\"");
                    OLogger.debug(buff.toString());
                    try {
                        MultiJarUtil.writeOneZipEntryToFile(workJarFile, patchedJar);
                    }
                    catch (IOException e3) {
                        buff = new StringBuffer("Unzip multi-level jar failed: \n");
                        buff.append("Failed Jar Action Entries: ");
                        ArrayList failedEntries = new ArrayList();
                        MultiJarUtil.getAllLeavesForNode(curNode, failedEntries, MultiJarUtil.JarOperation.VERIFY, true, e3.getMessage());
                        buff.append(e3.getStackTrace());
                        OLogger.printlnOnLog(buff.toString());
                        continue block6;
                    }
                    this.checkRequiedBasedOnJarTreeDuringApply(curNode, workJarFile, scratchLocation, parentPath);
                    continue block6;
                }
            }
            if (patchedJar != null) {
                patchedJar.close();
            }
        }
        catch (IOException e4) {
            buff = new StringBuffer("Close Jar File \"" + jarIn);
            buff.append("\" failed");
            buff.append(e4.getMessage());
            OLogger.printlnOnLog(buff.toString());
        }
        for (int i3 = 0; i3 < childs.size(); ++i3) {
            DeleteJarAction dja;
            JarActionEntityTree.TreeNode childNode = (JarActionEntityTree.TreeNode)childs.get(i3);
            if (!childNode.isLeaf() || !JarActionEntityTree.isDeleteJarActionNode(childNode) || JarActionHelper.isRequiredCacheForApply.containsKey(dja = (DeleteJarAction)childNode.getJarAction())) continue;
            buff = new StringBuffer("Destination file \"");
            buff.append(childNode.getEntryName());
            buff.append("\" does not exist");
            JarActionHelper.isRequiredDescCacheForApply.put(dja, buff.toString());
            JarActionHelper.isRequiredCacheForApply.put(dja, false);
        }
    }

    @Override
    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        boolean result;
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuffer buff = new StringBuffer(this.getActionName() + "::rollbackable()");
        OLogger.debug(buff);
        buff = new StringBuffer(this.getActionName() + " details: jarName = \"");
        if (this.getJarName() != null) {
            buff.append(this.getJarName());
        }
        buff.append("\", jarPath = \"");
        if (this.getJarPath() != null) {
            buff.append(this.getJarPath());
        }
        buff.append("\", className = \"");
        if (this.getClassName() != null) {
            buff.append(this.getClassName());
        }
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer(this.getActionName() + "::rollbackable(): jarName = \"");
            buff.append(this.getJarName());
            buff.append("\", jarPath = \"");
            buff.append(this.getJarPath());
            buff.append("\", className = \"");
            buff.append(this.getClassName());
            buff.append("\", return false.");
            OLogger.debug(buff);
            return false;
        }
        if (this.isBuiltFrom101Home()) {
            String pathJarName = this.getJarPath() + File.separator + this.getJarName();
            String justClassName = this.getClassName().substring(pathJarName.length());
            StringBuffer path = new StringBuffer(oracleHomePath);
            path.append(File.separator);
            path.append(".patch_storage");
            path.append(File.separator);
            path.append(cookedPatchID);
            path.append(File.separator);
            path.append(this.getJarPath());
            path.append(File.separator);
            path.append(justClassName);
            path.append("_");
            path.append(this.getJarName());
            String preFileName = path.toString() + "_pre_" + cookedPatchID;
            Path preF = WrapperFactory.getNioServiceWrapper().getPath(preFileName, new String[0]);
            if (Files.exists(preF, new LinkOption[0])) {
                if (!Files.isReadable(preF)) {
                    buff = new StringBuffer(this.getActionName() + ":: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" is not readable.");
                    this.setNonRollbackableDesc(buff.toString());
                    return false;
                }
                if (Files.isDirectory(preF, new LinkOption[0])) {
                    buff = new StringBuffer(this.getActionName() + ":: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" is a directory.");
                    this.setNonRollbackableDesc(buff.toString());
                    return false;
                }
            } else {
                String newFileName = path.toString() + "_opatch_new_" + cookedPatchID;
                Path newF = WrapperFactory.getNioServiceWrapper().getPath(newFileName, new String[0]);
                if (!Files.exists(newF, new LinkOption[0])) {
                    buff = new StringBuffer(this.getActionName() + ":: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" does not exists.");
                    this.setNonRollbackableDesc(buff.toString());
                    return false;
                }
            }
            return true;
        }
        String psCookedPatchIDPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        boolean isPSExist = this.checkPatchStorageExist(psCookedPatchIDPath);
        if (!isPSExist) {
            buff = new StringBuffer(this.getActionName() + ":: Directory \"");
            buff.append(WrapperFactory.getNioServiceWrapper().getPath(psCookedPatchIDPath, new String[0]).toAbsolutePath().toString());
            buff.append("\" does not exists or is not readable. ");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        buff = new StringBuffer(this.getActionName() + "::rollbackble() : calling OPatchEnv.getRollbackDirectoryPath()");
        OLogger.debug(buff);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.getClassName());
        buff = new StringBuffer(this.getActionName() + "::rollbackable() : path = \"");
        buff.append(path);
        buff.append("\"");
        OLogger.debug(buff);
        String src = path.toString();
        String parentPath = this.getParentDirPath(oracleHomePath);
        buff = new StringBuffer(this.getActionName() + "::rollbackable() : parentPath = \"");
        buff.append(parentPath);
        buff.append("\"");
        OLogger.debug(buff);
        path = new StringBuffer(parentPath);
        path.append(File.separator);
        path.append(this.getJarList()[0]);
        buff = new StringBuffer(this.getActionName() + "::rollbackable() : parentPath changes to \"");
        buff.append(parentPath);
        buff.append("\"");
        OLogger.debug(buff);
        String dst = path.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (!Files.exists(dstFile, new LinkOption[0]) || !Files.isReadable(dstFile)) {
            buff = new StringBuffer(this.getActionName() + ":: Destination file \"");
            buff.append(dst);
            buff.append("\", does not exist or is not readable.");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        if (Files.exists(dstFile, new LinkOption[0]) && Files.isDirectory(dstFile, new LinkOption[0])) {
            buff = new StringBuffer(this.getActionName() + ":: Destination file \"");
            buff.append(dstFile.toAbsolutePath().toString());
            buff.append("\" is a directory.");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile)) {
            buff = new StringBuffer(this.getActionName() + ":: Source file \"");
            buff.append(src);
            buff.append("\", does not exist or is not readable.");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        if (Files.isDirectory(srcFile, new LinkOption[0])) {
            buff = new StringBuffer(this.getActionName() + ":: Source file \"");
            buff.append(dstFile.toAbsolutePath().toString());
            buff.append("\" is a directory.");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        Path parentFile = srcFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        if (!Files.exists(parentFile, new LinkOption[0]) || !Files.isReadable(parentFile)) {
            buff = new StringBuffer(this.getActionName() + ":: Cannot mkdirs on \"");
            try {
                buff.append(parentFile.toAbsolutePath().normalize().toString());
            }
            catch (Exception e2) {
                // empty catch block
            }
            buff.append("\".");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        if (this.isReq() && !(result = this.checkRequiedDuringRollback(oracleHomePath, cookedPatchID))) {
            if (JarActionHelper.isRequiredDescCacheForRollback.containsKey(this)) {
                this.setNonApplicableDesc(JarActionHelper.isRequiredDescCacheForRollback.get(this));
            } else {
                buff = new StringBuffer(this.getActionName() + ":: CheckRequird has failed for File \"");
                buff.append(this.getClassName());
                buff.append("\" in " + dst);
                this.setNonApplicableDesc(buff.toString());
            }
            return false;
        }
        return true;
    }

    private boolean checkRequiedDuringRollback(String oracleHomePath, String cookedPatchID) {
        if (JarActionHelper.isRequiredCacheForRollback.containsKey(this)) {
            return JarActionHelper.isRequiredCacheForRollback.get(this);
        }
        JarActionEntityTree.TreeNode root = JarActionEntityTree.getRoot();
        HashMap failedMap = new HashMap();
        ArrayList failed = new ArrayList();
        StringBuffer buff = new StringBuffer(this.getActionName() + ":: checkRequiedDuringRollback() called");
        if (root == null || root.isLeaf()) {
            buff = new StringBuffer("The Delete jar action tree has not been contructed.");
            OLogger.debug(buff);
            JarActionHelper.isRequiredDescCacheForRollback.put(this, buff.toString());
            JarActionHelper.isRequiredCacheForRollback.put(this, false);
            return false;
        }
        boolean cont = Rules.SystemWrite_continue();
        ArrayList topLevelJars = root.getChilds();
        if (topLevelJars == null) {
            buff = new StringBuffer("The Delete jar action tree has not been contructed properly");
            OLogger.debug(buff);
            JarActionHelper.isRequiredDescCacheForRollback.put(this, buff.toString());
            JarActionHelper.isRequiredCacheForRollback.put(this, false);
            return false;
        }
        for (int i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionEntityTree.TreeNode patchingNode;
            JarActionEntityTree.TreeNode tn = (JarActionEntityTree.TreeNode)topLevelJars.get(i2);
            String jarName = tn.getJarName();
            String jarPath = tn.getJarPath();
            String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
            String curJarPath = this.getJarPath();
            if (!curJarPath.startsWith(File.separator)) {
                curJarPath = File.separator + curJarPath;
            }
            if (!(patchingNode = new JarActionEntityTree.TreeNode(0, this.getRootJarName(), curJarPath, null)).equals(tn)) continue;
            try {
                Path srcJar = WrapperFactory.getNioServiceWrapper().getPath(patchingJarFilePath, new String[0]);
                if (!Files.exists(srcJar, new LinkOption[0])) {
                    buff = new StringBuffer(this.getActionName() + "::checkRequiedDuringRollback() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    JarActionHelper.isRequiredDescCacheForRollback.put(this, buff.toString());
                    JarActionHelper.isRequiredCacheForRollback.put(this, false);
                    return false;
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID());
                String backForRollBackPath = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID);
                this.checkRequiedBasedOnJarTreeDuringRollback(tn, patchingJarFilePath, scratchLocation, backForRollBackPath, patchingJarFilePath);
                break;
            }
            catch (Exception e2) {
                buff = new StringBuffer(this.getActionName() + "::checkRequiedDuringRollback() for Jar file \"" + "ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                JarActionHelper.isRequiredDescCacheForRollback.put(this, buff.toString());
                JarActionHelper.isRequiredCacheForRollback.put(this, false);
                return false;
            }
        }
        if (JarActionHelper.isRequiredCacheForRollback.containsKey(this)) {
            return JarActionHelper.isRequiredCacheForRollback.get(this);
        }
        return true;
    }

    private void checkRequiedBasedOnJarTreeDuringRollback(JarActionEntityTree.TreeNode node, String jarIn, String scratchLocation, String backForRollBackPath, String relativeWorkName) {
        StringBuffer buff = new StringBuffer(this.getActionName() + "::checkRequiedBasedOnJarTreeDuringRollback() called");
        OLogger.debug(buff.toString());
        if (node == null || node.isLeaf()) {
            return;
        }
        ArrayList childs = node.getChilds();
        String parentPath = MultiJarUtil.combineEntry(relativeWorkName, node.getJarPath());
        ZipInputStream patchedJar = null;
        try {
            Path patchJarFile = WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]);
            if (!Files.exists(patchJarFile, new LinkOption[0])) {
                buff = new StringBuffer("checkRequiedBasedOnJarTreeDuringRollback() failed.  File not exist : \"");
                buff.append(jarIn);
                buff.append("\"");
                OLogger.printlnOnLog(buff.toString());
                return;
            }
            patchedJar = new ZipInputStream(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]), new OpenOption[0]));
        }
        catch (IOException e2) {
            ArrayList failedEntries = new ArrayList();
            MultiJarUtil.getAllLeavesForNode(node, failedEntries, MultiJarUtil.JarOperation.VERIFY, true, e2.getMessage());
            buff = new StringBuffer("Creating input stream for \"" + jarIn + "\"");
            buff.append(" failed.");
            buff.append(e2.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return;
        }
        ZipEntry entry = null;
        try {
            block6: while ((entry = patchedJar.getNextEntry()) != null) {
                boolean entryExist = false;
                for (int i2 = 0; i2 < childs.size(); ++i2) {
                    JarActionEntityTree.TreeNode curNode = (JarActionEntityTree.TreeNode)childs.get(i2);
                    if (!MultiJarUtil.foundEntry(entry.getName(), curNode.getEntryName())) continue;
                    entryExist = true;
                    String curEntry = curNode.getEntryName();
                    String completeRelativePath = MultiJarUtil.combineEntry(parentPath, curEntry);
                    if (curNode.isLeaf()) {
                        if (!curNode.getJarAction().getActionName().equals("DeleteJarAction")) continue block6;
                        DeleteJarAction dja = (DeleteJarAction)curNode.getJarAction();
                        buff = new StringBuffer("Destination file \"");
                        buff.append(curEntry);
                        buff.append("\"");
                        buff.append(" exist. It should have been deleted");
                        JarActionHelper.isRequiredDescCacheForRollback.put(dja, buff.toString());
                        JarActionHelper.isRequiredCacheForRollback.put(dja, false);
                        continue block6;
                    }
                    String workJarFile = MultiJarUtil.getWorkPath(scratchLocation, completeRelativePath);
                    buff = new StringBuffer("Unzip multi-level jar : ");
                    buff.append("Extract low-level jar to \"" + workJarFile + "\"");
                    OLogger.debug(buff.toString());
                    try {
                        MultiJarUtil.writeOneZipEntryToFile(workJarFile, patchedJar);
                    }
                    catch (IOException e3) {
                        buff = new StringBuffer("Unzip multi-level jar failed: \n");
                        buff.append("Failed Jar Action Entries: ");
                        ArrayList failedEntries = new ArrayList();
                        MultiJarUtil.getAllLeavesForNode(curNode, failedEntries, MultiJarUtil.JarOperation.VERIFY, true, e3.getMessage());
                        buff.append(e3.getStackTrace());
                        OLogger.printlnOnLog(buff.toString());
                        continue block6;
                    }
                    this.checkRequiedBasedOnJarTreeDuringRollback(curNode, workJarFile, scratchLocation, backForRollBackPath, parentPath);
                    continue block6;
                }
            }
            if (patchedJar != null) {
                patchedJar.close();
            }
        }
        catch (IOException e4) {
            buff = new StringBuffer("Close Jar File \"" + jarIn);
            buff.append("\" failed");
            buff.append(e4.getMessage());
            OLogger.printlnOnLog(buff.toString());
        }
        for (int i3 = 0; i3 < childs.size(); ++i3) {
            DeleteJarAction dja;
            JarActionEntityTree.TreeNode childNode = (JarActionEntityTree.TreeNode)childs.get(i3);
            if (!childNode.isLeaf() || !JarActionEntityTree.isDeleteJarActionNode(childNode) || JarActionHelper.isRequiredCacheForRollback.containsKey(dja = (DeleteJarAction)childNode.getJarAction())) continue;
            if (dja.isReq()) {
                if (MultiJarUtil.isBackupFileExistsInPatchStorage(childNode, backForRollBackPath)) {
                    JarActionHelper.isRequiredCacheForRollback.put(dja, true);
                    continue;
                }
                buff = new StringBuffer("Destination file \"");
                buff.append(node.getEntryName());
                buff.append("\"");
                buff.append(" does not have backup for rollback in patch storage");
                JarActionHelper.isRequiredDescCacheForRollback.put(dja, buff.toString());
                JarActionHelper.isRequiredCacheForRollback.put(dja, false);
                continue;
            }
            JarActionHelper.isRequiredCacheForRollback.put(dja, true);
        }
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof DeleteJarAction) {
            String myName = this.getJarName();
            String myPath = this.getJarPath();
            String myClass = this.getClassName();
            DeleteJarAction ja = (DeleteJarAction)o2;
            String itName = ja.getJarName();
            String itPath = ja.getJarPath();
            String itClass = ja.getClassName();
            if (myName.equals(itName) && myPath.equals(itPath) && myClass.equals(itClass)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 13;
        result = 37 * result + this.getJarName().length();
        result = 37 * result + this.getClassName().length();
        result = 37 * result + this.getJarPath().length();
        return result;
    }
}

