/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.cas.client.CASClientFactory;
import oracle.opatch.opatchlogger.OLogger;

public class IsCasReposPresentSession
implements IOPatchSession {
    @Override
    public void process(String oracleHome) {
        if (OPatchEnv.isHelp()) {
            this.displayHelp();
            return;
        }
        try {
            OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
            if (CASClientFactory.getCASClient().isCasReposPresent()) {
                CasReposOutput.GOOD.show();
            } else {
                CasReposOutput.NON_EXIST.show();
            }
        }
        catch (Throwable t) {
            CasReposOutput.BAD.show();
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "iscasrepospresent_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }

    @Override
    public boolean isOUIBased() {
        return false;
    }

    public static enum CasReposOutput {
        NON_EXIST(77, "Cas repos does not exist."),
        BAD(55, "Cas repos is invalid."),
        GOOD(0, "Cas repos is validated.");

        private int exitCode;
        private String message;

        private CasReposOutput(int exitCode, String message) {
            this.exitCode = exitCode;
            this.message = message;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void show() {
            OPatchEnv.setOpatchExitCode(this.exitCode);
            OLogger.println(this.message);
        }
    }
}

