/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import oracle.opatch.Bug;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.NotFoundException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.Platform;
import oracle.opatch.WLSPatch;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class LsPatchesPrinter {
    protected static void printBasicInfoForPatches(String oracleHomePath, OneOffEntry[] oneOffs, boolean showBugs) throws NotFoundException {
        OneOffEntry entry;
        int i2;
        StringBuffer buff = new StringBuffer("LsPatchesPrinter::printBasicInfoForPatches() call.");
        OLogger.debug(buff);
        if (oneOffs == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NotFoundException(buff.toString());
        }
        Arrays.sort(oneOffs);
        if (oneOffs.length == 0) {
            String noPatchesMsg = OLogger.getString("OUI-67095");
            noPatchesMsg = noPatchesMsg.substring(0, noPatchesMsg.length() - 1);
            noPatchesMsg = noPatchesMsg + " \"" + oracleHomePath + "\".";
            OLogger.println(noPatchesMsg);
            return;
        }
        HashMap<String, TreeSet<String>> cumulativeBugs = new HashMap<String, TreeSet<String>>();
        for (i2 = 0; i2 < oneOffs.length; ++i2) {
            entry = oneOffs[i2];
            if (!entry.getIsComposite()) continue;
            String activeConsituentID = CompositePatchObject.getActiveConstituent(oracleHomePath, entry.getID());
            if (entry.getID().equals(activeConsituentID)) continue;
            TreeSet<String> cumulative = (TreeSet<String>)cumulativeBugs.get(activeConsituentID);
            if (cumulative == null) {
                cumulative = new TreeSet<String>();
                cumulativeBugs.put(activeConsituentID, cumulative);
            }
            cumulative.addAll(Arrays.asList(entry.getBugIDsFixed()));
            cumulativeBugs.put(activeConsituentID, cumulative);
        }
        for (i2 = 0; i2 < oneOffs.length; ++i2) {
            entry = oneOffs[i2];
            if (entry.getIsComposite() && !entry.getID().equals(CompositePatchObject.getActiveConstituent(oracleHomePath, entry.getID()))) continue;
            buff = new StringBuffer();
            buff.append(entry.getID());
            buff.append(";");
            if (entry.getPatchDesc() != null && !entry.getPatchDesc().equals("")) {
                buff.append(entry.getPatchDesc());
            }
            if (entry.isOnlinePatch()) {
                buff.append(";(online)");
            }
            if (showBugs) {
                TreeSet cumulatives;
                buff.append(";");
                String[] bugs = entry.getBugIDsFixed();
                if (entry.getIsComposite() && (cumulatives = (TreeSet)cumulativeBugs.get(entry.getID())) != null) {
                    cumulatives.addAll(Arrays.asList(bugs));
                    bugs = new String[cumulatives.size()];
                    cumulatives.toArray(bugs);
                }
                for (int j2 = 0; j2 < bugs.length; ++j2) {
                    String bugId = bugs[j2];
                    if (j2 != bugs.length - 1) {
                        buff.append(bugId + ",");
                        continue;
                    }
                    buff.append(bugId);
                }
            }
            OLogger.println(buff.toString());
        }
    }

    protected static void printMetadataForPatches(String oracleHomePath, OneOffEntry[] oneOffs, boolean required) throws NotFoundException {
        StringBuffer buff = new StringBuffer("LsPatchesPrinter::printMetadataforPatches() call");
        OLogger.debug(buff);
        if (oneOffs == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NotFoundException(buff.toString());
        }
        if (oneOffs.length == 0) {
            String noOneOff = OLogger.getString("OUI-67095");
            noOneOff = noOneOff.substring(0, noOneOff.length() - 1);
            noOneOff = noOneOff + " \"" + oracleHomePath + "\".";
            throw new NotFoundException(noOneOff);
        }
        HashMap<String, ArrayList<String>> subPatchMap = new HashMap<String, ArrayList<String>>();
        ArrayList compositeOrder = new ArrayList();
        for (int i2 = 0; i2 < oneOffs.length; ++i2) {
            OneOffEntry entry = oneOffs[i2];
            if (!entry.getIsComposite()) continue;
            String activeConstituentID = entry.getActiveConstituent();
            if (!entry.getID().equals(activeConstituentID)) {
                ArrayList<String> subPatches = (ArrayList<String>)subPatchMap.get(activeConstituentID);
                if (subPatches == null) {
                    subPatches = new ArrayList<String>();
                    subPatchMap.put(activeConstituentID, subPatches);
                }
                subPatches.add(entry.getID());
                subPatchMap.put(activeConstituentID, subPatches);
                continue;
            }
            String compositeXMLPath = OPatchEnv.getCompositeXMLPath();
            if (compositeXMLPath.equals("")) {
                compositeXMLPath = CompositePatchObject.getCompositeFilePathFromOH(oracleHomePath, entry.getID());
            }
            if (!Files.exists(WrapperFactory.getNioServiceWrapper().getPath(compositeXMLPath, new String[0]), new LinkOption[0])) continue;
            compositeOrder = CompositePatchObject.getCompositesOrder(entry.getID(), compositeXMLPath);
        }
        OneOffEntry[] sortedOneOffs = new OneOffEntry[oneOffs.length];
        if (compositeOrder.size() > 0) {
            int compositeIndex = 0;
            for (int index = 0; index < oneOffs.length; ++index) {
                int compositeLen = compositeOrder.size();
                String currentID = oneOffs[index].getID();
                if (compositeOrder.indexOf(currentID) == compositeLen - 1) {
                    sortedOneOffs[compositeIndex] = oneOffs[index];
                    ++compositeIndex;
                    compositeOrder.remove(currentID);
                    continue;
                }
                sortedOneOffs[oneOffs.length - index - 1] = oneOffs[index];
            }
        } else {
            sortedOneOffs = oneOffs;
        }
        for (int i3 = 0; i3 < sortedOneOffs.length; ++i3) {
            Platform[] supPlatforms;
            OneOffEntry entry = sortedOneOffs[i3];
            buff = new StringBuffer();
            String patchID = "patch_id:" + entry.getID();
            buff.append(patchID + "\n");
            if (!required) {
                String uid = entry.getPSENumber();
                String createDate = entry.getCreationDate();
                Date appliedDate = entry.getAppliedDate();
                String patchDesc = entry.getPatchDesc();
                String bundleDesc = entry.getBundleDesc();
                if (entry.getIsComposite()) {
                    ArrayList subPatches;
                    String activeID = entry.getActiveConstituent();
                    if (entry.getID().equals(activeID) && (subPatches = (ArrayList)subPatchMap.get(activeID)) != null) {
                        String subPatchString = "";
                        for (int z = 0; z < subPatches.size(); ++z) {
                            subPatchString = subPatchString + "," + subPatches.get(z);
                        }
                        if (subPatchString.startsWith(",")) {
                            subPatchString = subPatchString.substring(1);
                        }
                        buff.append("sub-patches:" + subPatchString + "\n");
                    }
                }
                if (uid != null && !uid.equals("")) {
                    buff.append("unique_patch_id:" + uid + "\n");
                }
                buff.append("date_of_patch:" + createDate + "\n");
                if (appliedDate != null) {
                    SimpleDateFormat format = new SimpleDateFormat("d MMM yyyy, HH:mm:ss 'hrs' zz", Locale.ENGLISH);
                    String appliedDateString = format.format(appliedDate);
                    buff.append("applied_date:" + appliedDateString + "\n");
                }
                if (patchDesc != null && !patchDesc.equals("")) {
                    buff.append("patch_description:" + patchDesc + "\n");
                }
                if (bundleDesc != null && !bundleDesc.equals("")) {
                    buff.append("bundle_description:" + bundleDesc + "\n");
                }
            }
            PatchComponent[] allComps = entry.getAllComponents();
            ArrayList<PatchComponent> reqComps = new ArrayList<PatchComponent>();
            if (required) {
                for (int j2 = 0; j2 < allComps.length; ++j2) {
                    PatchComponent comp = allComps[j2];
                    if (!comp.isRequired()) continue;
                    reqComps.add(comp);
                }
                allComps = new PatchComponent[reqComps.size()];
                reqComps.toArray(allComps);
            }
            if (allComps.length > 0) {
                buff.append("component:");
            }
            boolean firstComp = false;
            for (int j3 = 0; j3 < allComps.length; ++j3) {
                PatchComponent comp = allComps[j3];
                String id = comp.getID();
                String version = comp.getVersion();
                boolean reqOpt = comp.isRequired();
                if (required && !reqOpt) continue;
                if (firstComp) {
                    buff.append("; ");
                }
                firstComp = true;
                buff.append(id + ",");
                buff.append(version + ",");
                buff.append(reqOpt ? "required" : "optional");
            }
            if (allComps.length > 0) {
                buff.append("\n");
            }
            if ((supPlatforms = entry.getSupportedPlatforms()).length > 0) {
                buff.append("platform:");
            }
            for (int j4 = 0; j4 < supPlatforms.length; ++j4) {
                Platform platform = supPlatforms[j4];
                String desc = platform.getDesc();
                String id = platform.getID();
                buff.append(id + ",");
                buff.append(desc);
                if (j4 != supPlatforms.length - 1) {
                    buff.append("; ");
                    continue;
                }
                buff.append("\n");
            }
            String[] exes = entry.getExecutables();
            if (exes.length > 0) {
                buff.append("executable:");
            }
            for (int j5 = 0; j5 < exes.length; ++j5) {
                buff.append(exes[j5]);
                if (j5 != exes.length - 1) {
                    buff.append("; ");
                    continue;
                }
                buff.append("\n");
            }
            String[] prePID = entry.getPrereqPatchIDs();
            if (prePID.length > 0) {
                buff.append("prereq_oneoffs:");
            }
            for (int j6 = 0; j6 < prePID.length; ++j6) {
                String prereqPatchId = prePID[j6];
                buff.append(prereqPatchId);
                if (j6 != prePID.length - 1) {
                    buff.append("; ");
                    continue;
                }
                buff.append("\n");
            }
            String[] coreq = entry.getCoreqPatchIDs();
            if (coreq.length > 0) {
                buff.append("coreq_oneoffs:");
            }
            for (int j7 = 0; j7 < coreq.length; ++j7) {
                buff.append(coreq[j7]);
                if (j7 != coreq.length - 1) {
                    buff.append("; ");
                    continue;
                }
                buff.append("\n");
            }
            WLSPatch[] wlsPrereq = entry.getWlsPrereqPatchIDs();
            if (wlsPrereq.length > 0) {
                buff.append("wls_prereq_oneoffs:");
            }
            for (int j8 = 0; j8 < wlsPrereq.length; ++j8) {
                WLSPatch wlsp = wlsPrereq[j8];
                buff.append(wlsp.getPatchID());
                if (j8 != wlsPrereq.length - 1) {
                    buff.append("; ");
                    continue;
                }
                buff.append("\n");
            }
            if (!required) {
                String productFamily;
                boolean instanceShutdown = entry.isInstanceShutdown();
                boolean isRolling = entry.isRolling();
                boolean isAuto = entry.isAuto();
                String shutdownMsg = entry.getInstanceShutdownMessage();
                String[] overlays = entry.getOverLayPatchIDs();
                String patchType = entry.getPatchType();
                buff.append("instance_shutdown:" + instanceShutdown + "\n");
                if (shutdownMsg != null && !shutdownMsg.equals("")) {
                    buff.append("instance_shutdown_message:" + shutdownMsg + "\n");
                }
                buff.append("online_rac_installable:" + isRolling + "\n");
                if (overlays.length > 0) {
                    buff.append("overlay_oneoffs:");
                }
                for (int j9 = 0; j9 < overlays.length; ++j9) {
                    buff.append(overlays[j9]);
                    if (j9 != overlays.length - 1) {
                        buff.append("; ");
                        continue;
                    }
                    buff.append("\n");
                }
                if (patchType != null && !patchType.equals("")) {
                    buff.append("patch_type:" + patchType + "\n");
                }
                if ((productFamily = entry.getProductFamily()) != null && !productFamily.equals("")) {
                    buff.append("product_family:" + productFamily + "\n");
                }
                buff.append("auto:" + isAuto + "\n");
                Bug[] bugs = entry.getBugsFixed();
                for (int j10 = 0; j10 < bugs.length; ++j10) {
                    Bug bug = bugs[j10];
                    buff.append("bug:" + bug.getBugID() + ", ");
                    buff.append(bug.getDesc() + "\n");
                }
            }
            OLogger.println(buff.toString());
            if (i3 == sortedOneOffs.length - 1) continue;
            OLogger.println("");
        }
    }
}

