/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.glcm.opatch.common.api.Result;
import oracle.opatch.ArchiveAction;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.JarAction;
import oracle.opatch.LsPatchesPrinter;
import oracle.opatch.MakeAction;
import oracle.opatch.NotFoundException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchPackageGenerator;
import oracle.opatch.Rules;
import oracle.opatch.Verifiable;
import oracle.opatch.VerifyFailedException;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchsdk.OPatchBundlePatch;
import oracle.opatch.patchsdk.OPatchCompositePatch;
import oracle.opatch.patchsdk.OPatchSingletonPatch;
import oracle.opatch.patchsdk.patchmodel.GenericPatch;
import oracle.opatch.patchsdk.patchmodel.GenericSingletonPatch;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LsPatchesSession
extends OPatchSession {
    protected LsPatchesSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    @Override
    public void process(String oracleHomePath) throws RuntimeException, NotFoundException {
        StringBuffer buff = new StringBuffer("LsPatchesSession::process() invoke");
        OLogger.debug(buff);
        String patchId = OPatchEnv.getRollbackPatchid();
        String patchLoc = OPatchEnv.getPatchloc();
        String qfile = OPatchEnv.getLsp_queryfile();
        int patchFormat = OPatchEnv.getPatchFormat();
        if (patchFormat == 4) {
            throw new RuntimeException(OLogger.getString("OUI-68011") + " Please use opatchauto.");
        }
        boolean required = OPatchEnv.isLsp_Required();
        boolean verify = OPatchEnv.isLsp_Verified();
        boolean bugs = OPatchEnv.isLsp_bugs();
        boolean specifiedID = patchId != null && !patchId.equals("");
        boolean specifiedLoc = patchLoc != null && !patchLoc.equals("");
        boolean queryFile = qfile != null && !qfile.equals("");
        boolean verifyPatchExist = Rules.shouldVerifyPatchExist(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        boolean shouldPrintInstalledPatch = Rules.printInstalledPatchInfo(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        boolean shouldPrintStagedPatch = Rules.printStagedPatchInfo(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        boolean shouldQueryFile = Rules.shouldQueryFile(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        boolean verifyStagedPatch = Rules.verifyStagedPatch(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        buff = new StringBuffer("Option: [ required:" + required + " ] ");
        buff.append(" [ verify:" + verify + " ] ");
        buff.append(" [ bugs:" + bugs + " ] ");
        buff.append(" [ specifiedID:" + specifiedID + " ] ");
        buff.append(" [ specifiedLoc:" + specifiedLoc + " ] ");
        buff.append(" [ queryFile:" + queryFile + " ] \n");
        buff.append("Rules : [ verifyPatchExist:" + verifyPatchExist + " ] ");
        buff.append("[ shouldPrintInstalledPatch:" + shouldPrintInstalledPatch + " ] ");
        buff.append("[ shouldPrintStagedPatch:" + shouldPrintStagedPatch + " ] ");
        buff.append("[ shouldQueryFile:" + shouldQueryFile + " ] ");
        buff.append("[ verifyStagedPatch:" + verifyStagedPatch + " ] ");
        OLogger.debug(buff);
        if (verifyPatchExist) {
            this.verifyInstalledPatch(oracleHomePath, patchId);
        }
        if (shouldQueryFile) {
            this.verifyFileBelongstoSomePatch(oracleHomePath, qfile);
        }
        if (shouldPrintStagedPatch) {
            this.loadAndPrintStagedPatchMetadata(oracleHomePath, patchLoc, required);
        }
        if (shouldPrintInstalledPatch) {
            this.loadAndPrintInstalledPatchMetadata(oracleHomePath, patchId, bugs, required);
        }
        if (verifyStagedPatch) {
            this.verifyStagedPatch(oracleHomePath, patchLoc);
        }
    }

    private void verifyStagedPatch(String oracleHomePath, String patchLoc) throws RuntimeException, NotFoundException, VerifyFailedException {
        StringBuffer buff = new StringBuffer("LsPatchesSession::verifyStagedPatch() call");
        OLogger.debug(buff);
        boolean patchFound = false;
        boolean patchOK = false;
        RuntimeException re = null;
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            String patchID = "";
            if (!readServices.isInventoryLoaded()) {
                boolean alreadyLocked = readServices.isLocked();
                try {
                    if (!alreadyLocked) {
                        readServices.lock(oracleHomePath);
                    }
                    readServices.loadInventory(oracleHomePath);
                    if (!readServices.isInventoryLoaded()) {
                        buff = new StringBuffer("verifyStagedPatch() was not able to get a Session.");
                        OLogger.log(OLogger.SEVERE, buff.toString());
                        throw new RuntimeException(buff.toString());
                    }
                }
                catch (Throwable ti) {
                    throw ti;
                }
                finally {
                    if (!alreadyLocked) {
                        readServices.release();
                    }
                }
            }
            ArrayList<PatchObject> stagedPatches = new ArrayList<PatchObject>();
            int patchFormat = OPatchEnv.getPatchFormat();
            if (patchFormat == 3) {
                String bundleFile = patchLoc + File.separator + "bundle.xml";
                Document document = PatchObjectUtil.parseXMLFile(WrapperFactory.getNioServiceWrapper().getPath(bundleFile, new String[0]));
                NodeList entityList = document.getElementsByTagName("entity");
                ArrayList<String[]> giPatchesLocs = new ArrayList<String[]>();
                ArrayList<String[]> dbPatchesLocs = new ArrayList<String[]>();
                for (int j2 = 0; j2 < entityList.getLength(); ++j2) {
                    Node entity = entityList.item(j2);
                    String bundleLoc = patchLoc + File.separator + entity.getAttributes().item(0).getNodeValue();
                    PatchObject po = null;
                    try {
                        po = PatchObject.getInstance(bundleLoc);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (po == null) continue;
                    if (po.getPatchType().equals("bundle_top")) {
                        giPatchesLocs.add(new String[]{bundleLoc, po.getPatchID()});
                        continue;
                    }
                    dbPatchesLocs.add(new String[]{bundleLoc, po.getPatchID()});
                }
                if (dbPatchesLocs.size() == 0 && giPatchesLocs.size() == 0) {
                    throw new NotFoundException(OLogger.getString("OUI-67736", new Object[]{patchLoc}));
                }
                OPatchEnv.setPatchFormat(-1);
                ArrayList<String[]> notFound = new ArrayList<String[]>();
                ArrayList<String[]> verifyFailed = new ArrayList<String[]>();
                if (readServices.isCRSHome()) {
                    String[] dbHomes = OPatchSessionHelper.getDBHomes(oracleHomePath);
                    for (int i3 = 0; i3 < giPatchesLocs.size(); ++i3) {
                        String[] locToId = (String[])giPatchesLocs.get(i3);
                        String[] pairs = new String[]{locToId[0], locToId[1], oracleHomePath};
                        try {
                            this.verifyStagedPatch(oracleHomePath, locToId[0]);
                            continue;
                        }
                        catch (NotFoundException notFoundException) {
                            notFound.add(pairs);
                            continue;
                        }
                        catch (VerifyFailedException verifyFailedException) {
                            verifyFailed.add(pairs);
                        }
                    }
                    for (int i2 = 0; i2 < dbPatchesLocs.size(); ++i2) {
                        for (int j3 = 0; j3 < dbHomes.length; ++j3) {
                            String[] locToId = (String[])dbPatchesLocs.get(i2);
                            String[] stringArray = new String[]{locToId[0], locToId[1], dbHomes[j3]};
                            try {
                                this.verifyStagedPatch(dbHomes[j3], locToId[0]);
                                continue;
                            }
                            catch (NotFoundException e4) {
                                notFound.add(stringArray);
                                continue;
                            }
                            catch (VerifyFailedException e5) {
                                verifyFailed.add(stringArray);
                            }
                        }
                    }
                } else {
                    if (dbPatchesLocs.size() == 0) {
                        buff = new StringBuffer("Current oracle home is DB home while Combo Patch doesn't contain DB patches. Please set CRS home as current oracle home.");
                        throw new NotFoundException(buff.toString());
                    }
                    for (int i4 = 0; i4 < dbPatchesLocs.size(); ++i4) {
                        String[] locToId = (String[])dbPatchesLocs.get(i4);
                        String[] pairs = new String[]{locToId[0], locToId[1], oracleHomePath};
                        try {
                            this.verifyStagedPatch(oracleHomePath, locToId[0]);
                            continue;
                        }
                        catch (NotFoundException e6) {
                            notFound.add(pairs);
                            continue;
                        }
                        catch (VerifyFailedException e7) {
                            verifyFailed.add(pairs);
                        }
                    }
                }
                if (notFound.size() > 0) {
                    buff = new StringBuffer();
                    for (int i5 = 0; i5 < notFound.size(); ++i5) {
                        String[] pairs = (String[])notFound.get(i5);
                        buff.append("Patch [ " + pairs[1] + " ] staged in patch location \"" + pairs[0] + "\" is NOT registered in Oracle Home \"" + pairs[2] + "\" or can't load it's metadata.\n");
                    }
                    throw new NotFoundException(buff.toString());
                }
                if (verifyFailed.size() > 0) {
                    buff = new StringBuffer();
                    for (int i6 = 0; i6 < verifyFailed.size(); ++i6) {
                        String[] pairs = (String[])verifyFailed.get(i6);
                        buff.append("Patch [ " + pairs[1] + " ] staged in patch location \"" + pairs[0] + "\" have corruptted files in Oracle Home \"" + pairs[2] + "\".\n");
                    }
                    throw new VerifyFailedException(buff.toString());
                }
                return;
            }
            if (patchFormat == 1 || patchFormat == 2) {
                Path baseDir = WrapperFactory.getNioServiceWrapper().getPath(patchLoc, new String[0]);
                ArrayList baseDirList = new ArrayList();
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(baseDir);){
                    for (Path entry : stream) {
                        if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                        String subPatchLoc = "";
                        subPatchLoc = entry.toAbsolutePath().normalize().toString();
                        PatchObject tmp = null;
                        try {
                            tmp = PatchObject.getInstance(subPatchLoc);
                        }
                        catch (Exception pairs) {
                            // empty catch block
                        }
                        if (tmp == null) continue;
                        stagedPatches.add(tmp);
                    }
                }
                catch (IOException e8) {
                    OLogger.debug(e8.getMessage());
                }
            } else if (!OnlinePatchProcessor.isHybridOnlinePatch(patchLoc)) {
                PatchObject tmp = null;
                try {
                    tmp = PatchObjectUtil.loadPatch(patchLoc);
                }
                catch (Exception baseDirList) {
                    // empty catch block
                }
                if (tmp != null) {
                    stagedPatches.add(tmp);
                }
            } else {
                boolean online = false;
                if (!OnlinePatchProcessor.isOnlineOnlyPatch(patchLoc)) {
                    OneOffEntry[] actives = readServices.getInstalledPatches();
                    for (int i7 = 0; i7 < actives.length; ++i7) {
                        OneOffEntry oneOff = actives[i7];
                        if (oneOff == null) continue;
                        String id = oneOff.getID();
                        PatchObject tmp = null;
                        try {
                            tmp = PatchObjectUtil.loadPatch(patchLoc);
                            tmp.setOneOffEntryObj(oneOff);
                        }
                        catch (Exception subPatchLoc) {
                            // empty catch block
                        }
                        if (tmp == null || !id.equalsIgnoreCase(tmp.getPatchID()) || !oneOff.isOnlinePatch()) continue;
                        online = true;
                    }
                } else {
                    online = true;
                }
                if (online) {
                    OnlinePatchProcessor.setHybridPatchPart(patchLoc, PatchObject.HybridPatchPart.ONLINE);
                } else {
                    OnlinePatchProcessor.setHybridPatchPart(patchLoc, PatchObject.HybridPatchPart.OFFLINE);
                }
                PatchObject onlinePatch = null;
                try {
                    onlinePatch = PatchObjectUtil.loadPatch(patchLoc);
                }
                catch (Exception i7) {
                    // empty catch block
                }
                stagedPatches.add(onlinePatch);
            }
            if (stagedPatches.size() == 0) {
                throw new NotFoundException(OLogger.getString("OUI-67736", new Object[]{patchLoc}));
            }
            ArrayList<String> notFoundList = new ArrayList<String>();
            ArrayList<String> fileCheckFailedList = new ArrayList<String>();
            for (int len = 0; len < stagedPatches.size(); ++len) {
                PatchObject po = (PatchObject)stagedPatches.get(len);
                patchID = po.getPatchID();
                OneOffEntry[] inactive = readServices.getInactivePatches();
                for (int i8 = 0; i8 < inactive.length; ++i8) {
                    String id;
                    OneOffEntry inactiveOneoff = inactive[i8];
                    if (inactiveOneoff == null || !(id = inactiveOneoff.getID()).equalsIgnoreCase(patchID)) continue;
                    OLogger.println("Specified patch [ " + patchID + " ] is registered in Oracle Home \"" + oracleHomePath + "\" inventory but it is inactive. Skip verifying patch files.");
                    return;
                }
                OneOffEntry[] actives = readServices.getInstalledPatches();
                for (int i9 = 0; i9 < actives.length; ++i9) {
                    OneOffEntry oneOff = actives[i9];
                    if (oneOff == null) continue;
                    String id = oneOff.getID();
                    buff = new StringBuffer("Comparing patch ID ");
                    buff.append(patchID);
                    buff.append(" against ");
                    buff.append(id);
                    OLogger.log(OLogger.FINE, buff.toString());
                    if (!id.equalsIgnoreCase(patchID)) continue;
                    patchFound = true;
                    break;
                }
                Object[] oneOffs = new OneOffEntry[inactive.length + actives.length];
                System.arraycopy(actives, 0, oneOffs, 0, actives.length);
                System.arraycopy(inactive, 0, oneOffs, actives.length, inactive.length);
                Arrays.sort(oneOffs);
                HashMap<PatchAction, String> copyActions = new HashMap<PatchAction, String>();
                for (int i10 = oneOffs.length - 1; i10 >= 0; --i10) {
                    Object oneoff = oneOffs[i10];
                    PatchAction[] actions = ((OneOffEntry)oneoff).getPatchActions();
                    for (int i3 = 0; i3 < actions.length; ++i3) {
                        if (!(actions[i3] instanceof CopyAction)) continue;
                        copyActions.put(actions[i3], ((OneOffEntry)oneoff).getID());
                    }
                }
                if (patchFound) {
                    buff = new StringBuffer("Patch ID ");
                    buff.append(patchID);
                    buff.append(" is registered in Oracle Home inventory.");
                    OLogger.log(OLogger.FINE, buff.toString());
                    patchFound = false;
                    String oneOffLoc = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, po.getTripletPatchID());
                    buff = new StringBuffer("Search for patch meta-data under \"");
                    buff.append(oneOffLoc);
                    buff.append("\".");
                    OLogger.log(OLogger.FINE, buff.toString());
                    try {
                        PatchObject tmpP = PatchObjectUtil.loadPatch(oracleHomePath, po.getTripletPatchID());
                        buff = new StringBuffer("Successfully loaded the patchobject from \"");
                        buff.append(oneOffLoc);
                        buff.append("\", so patch is found properly, its ID is ");
                        buff.append(tmpP.getPatchID());
                        OLogger.debug(buff);
                        patchFound = true;
                    }
                    catch (Exception e9) {
                        patchFound = false;
                    }
                    if (!patchFound) {
                        buff = new StringBuffer("Inventory check failed: Patch ID ");
                        buff.append(patchID);
                        buff.append(" is registered in Oracle Home \"" + oracleHomePath + "\" inventory but OPatch can't load its meta-data.");
                        notFoundList.add(patchID);
                        OLogger.println(buff.toString());
                        continue;
                    }
                } else {
                    buff = new StringBuffer("Inventory check failed: Patch ID ");
                    buff.append(patchID);
                    buff.append(" is NOT registered in Oracle Home \"" + oracleHomePath + "\" inventory.");
                    notFoundList.add(patchID);
                    OLogger.println(buff.toString());
                    continue;
                }
                buff = new StringBuffer("Inventory check OK: Patch ID ");
                buff.append(patchID);
                buff.append(" is registered in Oracle Home \"" + oracleHomePath + "\" inventory with proper meta-data.");
                OLogger.println(buff.toString());
                HashSet<PatchComponent> compsToVerify = new HashSet<PatchComponent>();
                OLogger.log(OLogger.FINE, "Add all required components and their actions to list to be verified. Optional components not present in Oracle Home will be filtered out.");
                Map<PatchComponent, PatchComponentCheckResult> analyzedPCs = readServices.analyzePatchComponents(po, OPatchEnv.isNRollback());
                for (Map.Entry entry : analyzedPCs.entrySet()) {
                    PatchComponent pc = (PatchComponent)entry.getKey();
                    Result pcCheckResult = ((PatchComponentCheckResult)entry.getValue()).getResult();
                    if (!pc.isRequired() && !pcCheckResult.isProcessComponent()) continue;
                    compsToVerify.add(pc);
                }
                ArrayList<CopyAction> copyActionToVerify = new ArrayList<CopyAction>();
                ArrayList<JarAction> arrayList = new ArrayList<JarAction>();
                ArrayList<DeleteJarAction> deleteJarActionToVerify = new ArrayList<DeleteJarAction>();
                ArrayList<ArchiveAction> arActionToVerify = new ArrayList<ArchiveAction>();
                ArrayList<Verifiable> pluginActionToVerify = new ArrayList<Verifiable>();
                ArrayList<MakeAction> makeActionToVerify = new ArrayList<MakeAction>();
                for (PatchComponent pc : compsToVerify) {
                    int j2;
                    LinkedList cList = pc.getCopyList();
                    LinkedList jList = pc.getJarList();
                    LinkedList djList = pc.getDeleteJarList();
                    LinkedList aList = pc.getArchiveList();
                    LinkedList mList = pc.getMakeList();
                    LinkedList pList = pc.getPluginList();
                    for (int j5 = 0; j5 < cList.size(); ++j5) {
                        CopyAction ca = (CopyAction)cList.get(j5);
                        if (copyActions.containsKey(ca) && !copyActions.get(ca).toString().equals(patchID)) continue;
                        copyActionToVerify.add(ca);
                    }
                    for (j2 = 0; j2 < jList.size(); ++j2) {
                        JarAction ja = (JarAction)jList.get(j2);
                        arrayList.add(ja);
                    }
                    for (j2 = 0; j2 < aList.size(); ++j2) {
                        ArchiveAction aa = (ArchiveAction)aList.get(j2);
                        arActionToVerify.add(aa);
                    }
                    for (j2 = 0; j2 < pList.size(); ++j2) {
                        if (!(pList.get(j2) instanceof Verifiable)) continue;
                        Verifiable va = (Verifiable)pList.get(j2);
                        pluginActionToVerify.add(va);
                    }
                    for (j2 = 0; j2 < mList.size(); ++j2) {
                        MakeAction ma = (MakeAction)mList.get(j2);
                        makeActionToVerify.add(ma);
                    }
                    for (j2 = 0; j2 < djList.size(); ++j2) {
                        DeleteJarAction dja = (DeleteJarAction)djList.get(j2);
                        deleteJarActionToVerify.add(dja);
                    }
                }
                String finalPatchLoc = patchLoc;
                if (patchFormat == 1 || patchFormat == 2) {
                    finalPatchLoc = finalPatchLoc + File.separator + po.getPatchID();
                }
                if (!(patchOK = OPatchSessionHelper.verifyPatchAction(oracleHomePath, finalPatchLoc, copyActionToVerify, arrayList, arActionToVerify, pluginActionToVerify, makeActionToVerify, deleteJarActionToVerify, readServices))) {
                    buff = new StringBuffer("Files check failed: Some files under ORACLE_HOME \"" + oracleHomePath + "\" are not patched. ");
                    buff.append("Please see log file for details.");
                    fileCheckFailedList.add(patchID);
                    OLogger.println(buff.toString());
                    continue;
                }
                buff = new StringBuffer("Files check OK: Files from Patch ID ");
                buff.append(patchID);
                buff.append(" are present in Oracle Home \"" + oracleHomePath + "\".");
                OLogger.println(buff.toString());
            }
            if (notFoundList.size() > 0) {
                buff = new StringBuffer("Following patches [ ");
                for (int i2 = 0; i2 < notFoundList.size(); ++i2) {
                    buff.append(notFoundList.get(i2) + " ");
                }
                buff.append("] are NOT registered in Oracle Home \"" + oracleHomePath + "\" inventory or can't load its meta-data");
                throw new NotFoundException(buff.toString());
            }
            if (fileCheckFailedList.size() > 0) {
                buff = new StringBuffer("Following patches [ ");
                for (int i4 = 0; i4 < fileCheckFailedList.size(); ++i4) {
                    buff.append(fileCheckFailedList.get(i4) + " ");
                }
                buff.append(" ] have corruptted files under Oracle Home \"" + oracleHomePath + "\".");
                throw new VerifyFailedException(buff.toString());
            }
        }
        catch (NotFoundException e10) {
            throw e10;
        }
        catch (VerifyFailedException e11) {
            throw e11;
        }
        catch (Throwable t) {
            re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            buff = new StringBuffer("LsPatches::getInstance() returns");
            OLogger.debug(buff);
        }
    }

    private void verifyInstalledPatch(String oracleHomePath, String patchID) throws RuntimeException, NotFoundException, VerifyFailedException {
        PatchAction[] actions;
        OneOffEntry[] oneoffs;
        StringBuffer buff = new StringBuffer("LsPatchesSession::verifyInstalledPatch() call");
        OLogger.debug(buff);
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isInventoryLoaded()) {
            boolean alreadyLocked = readServices.isLocked();
            try {
                if (!alreadyLocked) {
                    readServices.lock(oracleHomePath);
                }
                readServices.loadInventory(oracleHomePath);
                if (!readServices.isInventoryLoaded()) {
                    buff = new StringBuffer("verifyInstalledPatch() was not able to get a Session.");
                    OLogger.log(OLogger.SEVERE, buff.toString());
                    throw new RuntimeException(buff.toString());
                }
            }
            catch (Throwable t) {
                buff = new StringBuffer("Throwable occured: " + t.getMessage());
                throw new RuntimeException(buff.toString(), t);
            }
            finally {
                if (!alreadyLocked) {
                    readServices.release();
                }
            }
        }
        if ((oneoffs = readServices.getInstalledPatches()).length == 0) {
            String noOneOff = OLogger.getString("OUI-67095");
            noOneOff = noOneOff.substring(0, noOneOff.length() - 1);
            noOneOff = noOneOff + " \"" + oracleHomePath + "\".";
            throw new NotFoundException(noOneOff);
        }
        OneOffEntry[] inactive = readServices.getInactivePatches();
        for (int i2 = 0; i2 < inactive.length; ++i2) {
            OneOffEntry inactiveOneoff = inactive[i2];
            if (!inactiveOneoff.getID().equals(patchID)) continue;
            OLogger.println("Specified patch [ " + patchID + " ] is registered in Oracle Home \"" + oracleHomePath + "\" inventory but it is inactive. Skip verifying patch files.");
            return;
        }
        HashMap<String, TreeSet<OneOffEntry>> compositePatches = new HashMap<String, TreeSet<OneOffEntry>>();
        for (int i3 = 0; i3 < oneoffs.length; ++i3) {
            OneOffEntry oneoff = oneoffs[i3];
            if (!oneoff.getIsComposite()) continue;
            String active = oneoff.getActiveConstituent();
            if (!oneoff.getID().equals(active) && oneoff.getID().equals(patchID)) {
                OLogger.println("Patch [ " + patchID + " ] is a non-active sub-patch of composite patch [ " + active + " ] installed in \"" + oracleHomePath + "\". Here is the output for 'opatch lspatches -id " + active + " -verify': \n");
                this.verifyInstalledPatch(oracleHomePath, active);
                return;
            }
            TreeSet<OneOffEntry> ids = (TreeSet<OneOffEntry>)compositePatches.get(active);
            if (ids == null) {
                ids = new TreeSet<OneOffEntry>();
            }
            ids.add(oneoff);
            compositePatches.put(active, ids);
        }
        Object[] allPatches = new OneOffEntry[oneoffs.length + inactive.length];
        System.arraycopy(oneoffs, 0, allPatches, 0, oneoffs.length);
        System.arraycopy(inactive, 0, allPatches, oneoffs.length, inactive.length);
        Arrays.sort(allPatches);
        HashMap<PatchAction, String> copyActions = new HashMap<PatchAction, String>();
        HashSet<File> copyActionsFiles = new HashSet<File>();
        ArrayList<Object> foundOneOffList = new ArrayList<Object>();
        for (int i4 = allPatches.length - 1; i4 >= 0; --i4) {
            Object object = allPatches[i4];
            if (patchID.contains("_")) {
                if (((OneOffEntry)object).getID().startsWith(patchID)) {
                    foundOneOffList.add(object);
                }
            } else if (((OneOffEntry)object).getID().equals(patchID)) {
                foundOneOffList.add(object);
            }
            actions = ((OneOffEntry)object).getPatchActions();
            CopyAction cpt = null;
            for (int j2 = 0; j2 < actions.length; ++j2) {
                if (!(actions[j2] instanceof CopyAction)) continue;
                copyActions.put(actions[j2], ((OneOffEntry)object).getTripletID());
                cpt = (CopyAction)actions[j2];
                File copyFile = new File(cpt.getParentFilePath(oracleHomePath));
                copyActionsFiles.add(copyFile);
            }
        }
        if (foundOneOffList.size() == 0) {
            buff = new StringBuffer(OLogger.getString("OUI-67735", new Object[]{patchID}));
            throw new NotFoundException(buff.toString());
        }
        for (OneOffEntry oneOffEntry : foundOneOffList) {
            actions = oneOffEntry.getPatchActions();
            boolean hasFileNotExist = false;
            boolean hasFileCannotDeleted = false;
            for (int i5 = 0; i5 < actions.length; ++i5) {
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(actions[i5].getParentFilePath(oracleHomePath), new String[0]);
                if (actions[i5] instanceof DeleteAction) {
                    if (copyActionsFiles.contains(f2.toFile()) || Files.isDirectory(f2, new LinkOption[0]) || !Files.exists(f2, new LinkOption[0])) continue;
                    hasFileCannotDeleted = true;
                    break;
                }
                if (Files.exists(f2, new LinkOption[0])) continue;
                hasFileNotExist = true;
                break;
            }
            if (oneOffEntry.getIsComposite()) {
                buff = new StringBuffer("Note: For a composite patch, we only check the files of the active sub-patch");
                OLogger.println(buff.toString());
            }
            if (hasFileNotExist) {
                buff = new StringBuffer("Files check failed: Some patches files under ORACLE_HOME are removed.");
                throw new VerifyFailedException(buff.toString());
            }
            if (hasFileCannotDeleted) {
                buff = new StringBuffer("Files check failed: Some patches files under ORACLE_HOME are not been deleted.");
                throw new VerifyFailedException(buff.toString());
            }
            buff = new StringBuffer("Files check OK: Files from Patch ID ");
            buff.append(patchID);
            buff.append(" are present in Oracle Home.");
            OLogger.println(buff.toString());
            ChecksumEntity[] checksums = oneOffEntry.getChecksumList();
            CopyAction copyAct = null;
            for (int i6 = 0; i6 < checksums.length; ++i6) {
                ChecksumEntity checksum = checksums[i6];
                String checkSumPath = checksum.getComputeFilePath(oracleHomePath, oneOffEntry.getCurrentAppVerDirs().size() > 0, OPatchEnv.getApplicationVersion(), oneOffEntry.getCurrentAppVerDirs());
                Path checksumFile = WrapperFactory.getNioServiceWrapper().getPath(checkSumPath, new String[0]);
                Iterator copyIte = copyActions.keySet().iterator();
                boolean isOverlay = false;
                while (copyIte.hasNext()) {
                    copyAct = (CopyAction)copyIte.next();
                    File copyFile = new File(copyAct.getParentFilePath(oracleHomePath));
                    if (!copyFile.equals(checksumFile) || copyActions.get(copyAct).toString().equals(oneOffEntry.getTripletID())) continue;
                    isOverlay = true;
                    break;
                }
                if (isOverlay) continue;
                String installedChecksum = checksum.getChecksum();
                String currentChecksum = "";
                try {
                    currentChecksum = OPatchSessionHelper.computeChecksum(checkSumPath);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                if (currentChecksum.equals(installedChecksum)) continue;
                buff = new StringBuffer("The patch file \"" + checkSumPath + "\" of the patch [ " + patchID + " ] installed in \"" + oracleHomePath + "\" was modified after applying. Current checksum of the file is [ " + currentChecksum + " ], while checksum at installed time was [ " + installedChecksum + " ].");
                throw new VerifyFailedException(buff.toString());
            }
            if (oneOffEntry.getIsComposite()) {
                TreeSet subPatches = (TreeSet)compositePatches.get(patchID);
                Iterator subPatchIterator = subPatches.iterator();
                buff = new StringBuffer("");
                while (subPatchIterator.hasNext()) {
                    buff.append("Inventory check OK: ");
                    buff.append("Patch ID ");
                    buff.append(((OneOffEntry)subPatchIterator.next()).getID());
                    buff.append(" is registered in Oracle Home \"");
                    buff.append(oracleHomePath);
                    buff.append("\" inventory. \n");
                }
            } else {
                buff = new StringBuffer("Inventory check OK: ");
                buff.append("Patch ID ");
                buff.append(patchID);
                buff.append(" is registered in Oracle Home \"");
                buff.append(oracleHomePath);
                buff.append("\" inventory.");
            }
            OLogger.println(buff.toString());
        }
    }

    private void verifyFileBelongstoSomePatch(String oracleHomePath, String verifyFile) throws RuntimeException, NotFoundException {
        block25: {
            StringBuffer buff = new StringBuffer("LsPatchesSession::verifyFileBelongstoSomePatch() call");
            OLogger.debug(buff);
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            try {
                int i2;
                if (!readServices.isInventoryLoaded()) {
                    boolean alreadyLocked = readServices.isLocked();
                    try {
                        if (!alreadyLocked) {
                            readServices.lock(oracleHomePath);
                        }
                        readServices.loadInventory(oracleHomePath);
                        if (!readServices.isInventoryLoaded()) {
                            OLogger.printlnres("OUI-67121");
                            return;
                        }
                    }
                    catch (Throwable ti) {
                        throw ti;
                    }
                    finally {
                        if (!alreadyLocked) {
                            readServices.release();
                        }
                    }
                }
                OneOffEntry[] active = readServices.getInstalledPatches();
                OneOffEntry[] inactive = readServices.getInactivePatches();
                if (active == null || inactive == null) {
                    buff = new StringBuffer("Can't get the registered oneoff patches from Oracle Home \"" + oracleHomePath + "\"");
                    throw new NotFoundException(buff.toString());
                }
                Object[] oneoffs = new OneOffEntry[active.length + inactive.length];
                for (i2 = 0; i2 < active.length; ++i2) {
                    oneoffs[i2] = active[i2];
                }
                for (i2 = 0; i2 < inactive.length; ++i2) {
                    oneoffs[i2 + active.length] = inactive[i2];
                }
                Arrays.sort(oneoffs);
                String belongTo = "";
                String tempVersion = "";
                Object oneoff = null;
                boolean isSnowball = false;
                for (int i3 = oneoffs.length - 1; i3 > -1; --i3) {
                    oneoff = oneoffs[i3];
                    buff = new StringBuffer("Search current patch file from patch [ " + ((OneOffEntry)oneoff).getID() + " ]");
                    OLogger.debug(buff);
                    PatchAction[] actions = ((OneOffEntry)oneoff).getPatchActions();
                    boolean found = false;
                    for (int j2 = 0; j2 < actions.length; ++j2) {
                        PatchAction action = actions[j2];
                        Path pfile = WrapperFactory.getNioServiceWrapper().getPath(action.getParentFilePath(oracleHomePath), new String[0]);
                        Path vfile = WrapperFactory.getNioServiceWrapper().getPath(verifyFile, new String[0]);
                        String cpPath = "";
                        String cvPath = "";
                        cpPath = pfile.toAbsolutePath().normalize().toString();
                        cvPath = vfile.toAbsolutePath().normalize().toString();
                        if (!Files.exists(pfile, new LinkOption[0])) {
                            throw new NotFoundException("Destination file \"" + cpPath + "\" does not exist in Oracle Home \"" + oracleHomePath + "\".");
                        }
                        buff = new StringBuffer("File path of registered patch :" + cpPath + "\n");
                        buff.append("Searching file path : " + cvPath);
                        OLogger.debug(buff);
                        if (!cvPath.equals(cpPath)) continue;
                        found = true;
                        if (action instanceof CopyAction) {
                            CopyAction copy = (CopyAction)action;
                            if (!copy.isHasFileVersion()) {
                                belongTo = ((OneOffEntry)oneoff).getID();
                                break;
                            }
                            isSnowball = true;
                            String newVersion = copy.getFileVersion();
                            if (!copy.isSnowBallCopyAction()) {
                                belongTo = ((OneOffEntry)oneoff).getID();
                                tempVersion = newVersion;
                                break;
                            }
                            int ret = OPatchSessionHelper.isGreaterDecimal(newVersion, tempVersion);
                            if (ret != 1) break;
                            belongTo = ((OneOffEntry)oneoff).getID();
                            tempVersion = newVersion;
                            break;
                        }
                        belongTo = ((OneOffEntry)oneoff).getID();
                        break;
                    }
                    if (!isSnowball && found) break;
                }
                if (belongTo != null && !belongTo.equals("")) {
                    if (oneoff != null && ((OneOffEntry)oneoff).getIsComposite()) {
                        buff = new StringBuffer("The specified file \"" + verifyFile + "\" belongs to sub-patch [ ");
                        buff.append(belongTo);
                        buff.append(" ] of the composite patch [ " + ((OneOffEntry)oneoff).getActiveConstituent() + " ] installed in \"");
                        buff.append(oracleHomePath);
                        buff.append("\".");
                        OLogger.println(buff.toString());
                    } else {
                        buff = new StringBuffer("The specified file \"" + verifyFile + "\" belongs to patch [ ");
                        buff.append(belongTo);
                        buff.append(" ] installed in \"");
                        buff.append(oracleHomePath);
                        buff.append("\".");
                        OLogger.println(buff.toString());
                    }
                    break block25;
                }
                buff = new StringBuffer("The specified file \"" + verifyFile + "\" does not belong to any registered patch in \"" + oracleHomePath + "\".");
                throw new NotFoundException(buff.toString());
            }
            catch (NotFoundException e2) {
                throw e2;
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadAndPrintInstalledPatchMetadata(String oracleHomePath, String patchId, boolean showbugs, boolean required) throws RuntimeException, NotFoundException {
        buff = new StringBuffer("LsPatchesSession::loadAndPrintInstalledPatch() call");
        OLogger.debug(buff);
        re = null;
        oneoffs = null;
        activeOneoff = null;
        inactive = null;
        readServices = IPM.INSTANCE.getReadServices();
        try {
            block37: {
                if (readServices.isInventoryLoaded()) ** GOTO lbl32
                alreadyLocked = readServices.isLocked();
                if (!alreadyLocked) {
                    readServices.lock(oracleHomePath);
                }
                readServices.loadInventory(oracleHomePath);
                if (readServices.isInventoryLoaded()) break block37;
                OLogger.printlnres("OUI-67121");
                if (!alreadyLocked) {
                    readServices.release();
                }
                return;
            }
            try {
                block39: {
                    if (!alreadyLocked) {
                        readServices.release();
                    }
                    break block39;
                    catch (Throwable ti) {
                        try {
                            throw ti;
                        }
                        catch (Throwable var13_19) {
                            if (!alreadyLocked) {
                                readServices.release();
                            }
                            throw var13_19;
                        }
                    }
                }
                activeOneoff = readServices.getInstalledPatches();
                inactive = readServices.getInactivePatches();
                if (activeOneoff == null || inactive == null) {
                    buff = new StringBuffer("Can't get the registered oneoff patches from Oracle Home \"" + oracleHomePath + "\"");
                    throw new NotFoundException(buff.toString());
                }
                oneoffs = new OneOffEntry[activeOneoff.length + inactive.length];
                for (i = 0; i < activeOneoff.length; ++i) {
                    oneoffs[i] = activeOneoff[i];
                }
                for (i = 0; i < inactive.length; ++i) {
                    oneoffs[i + activeOneoff.length] = inactive[i];
                }
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (Throwable t) {
                OLogger.error("OUI-67028", new Object[]{"LsPatchesSession::loadAndPrintInstalledPatch()"});
                re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            validOneOffs = new OneOffEntry[1];
            validOneOffsList = new ArrayList<OneOffEntry>();
            pidSpecified = false;
            if (patchId != null && !patchId.equals("")) {
                exist = false;
                pidSpecified = true;
                compositePatches = new HashMap<String, TreeSet<OneOffEntry>>();
                for (i = 0; i < oneoffs.length; ++i) {
                    entry = oneoffs[i];
                    if (entry.getIsComposite()) {
                        active = entry.getActiveConstituent();
                        if (!entry.getID().equals(active) && entry.getID().equals(patchId)) {
                            OLogger.println("Patch [ " + patchId + " ] is a non-active sub-patch of composite patch [ " + active + " ].Here is the output for 'opatch lspatches -id " + active + " ': \n");
                            this.loadAndPrintInstalledPatchMetadata(oracleHomePath, active, showbugs, required);
                            return;
                        }
                        ids = (TreeSet<OneOffEntry>)compositePatches.get(active);
                        if (ids == null) {
                            ids = new TreeSet<OneOffEntry>();
                        }
                        ids.add(entry);
                        compositePatches.put(active, ids);
                    }
                    if (patchId.contains("_")) {
                        if (!entry.getID().startsWith(patchId)) continue;
                        validOneOffsList.add(entry);
                        exist = true;
                        continue;
                    }
                    if (!entry.getID().equals(patchId)) continue;
                    validOneOffsList.add(entry);
                    exist = true;
                }
                if (validOneOffsList.size() > 0) {
                    validOneOffs = new OneOffEntry[validOneOffsList.size()];
                    validOneOffsList.toArray(validOneOffs);
                }
                if (!exist) {
                    throw new NotFoundException(OLogger.getString("OUI-67735", new Object[]{patchId, oracleHomePath}));
                }
                constituents = (TreeSet)compositePatches.get(validOneOffs[0].getID());
                if (constituents != null && constituents.size() > 0) {
                    validOneOffs = new OneOffEntry[constituents.size()];
                    constituents.toArray(validOneOffs);
                    sortedOrder = CompositePatchObject.getConstituentList(CompositePatchObject.getCompositeFilePathFromOH(oracleHomePath, patchId));
                    for (x = 0; x < sortedOrder.length; ++x) {
                        patchCount = 0;
                        for (y = 0; y < validOneOffs.length; ++y) {
                            currentEntryID = validOneOffs[y].getID();
                            if (!currentEntryID.equals(sortedOrder[x])) continue;
                            ++patchCount;
                            break;
                        }
                        if (patchCount != 1) {
                            throw new Exception();
                        }
                        currentEntry = validOneOffs[y];
                        validOneOffs[y] = validOneOffs[x];
                        validOneOffs[x] = currentEntry;
                    }
                }
            } else {
                validOneOffs = activeOneoff;
            }
            if (pidSpecified) {
                LsPatchesPrinter.printMetadataForPatches(oracleHomePath, validOneOffs, required);
            } else {
                LsPatchesPrinter.printBasicInfoForPatches(oracleHomePath, validOneOffs, showbugs);
            }
        }
        finally {
            buff = new StringBuffer("LsPatches::getInstance() returns");
            OLogger.debug(buff);
        }
    }

    private void loadAndPrintStagedPatchMetadata(String oracleHomePath, String patchLoc, boolean required) throws RuntimeException, NotFoundException {
        RuntimeException re = null;
        ArrayList<OneOffEntry> oneoffsArr = new ArrayList<OneOffEntry>();
        try {
            switch (OPatchEnv.getPatchFormat()) {
                case 3: {
                    PatchObject patchObj;
                    List<GenericPatch> subPatches = null;
                    OPatchBundlePatch bpo = (OPatchBundlePatch)PatchPackageGenerator.getPatchInstance(patchLoc);
                    subPatches = bpo.getSubPatches();
                    for (int i2 = 0; i2 < subPatches.size(); ++i2) {
                        PatchPackage subPatch = subPatches.get(i2);
                        if (subPatch instanceof OPatchCompositePatch) {
                            OPatchCompositePatch cpp = (OPatchCompositePatch)subPatch;
                            List<GenericSingletonPatch> subOfComposite = cpp.getSubPatches();
                            for (int j2 = 0; j2 < subOfComposite.size(); ++j2) {
                                patchObj = null;
                                OPatchSingletonPatch sigPo = (OPatchSingletonPatch)subOfComposite.get(j2);
                                try {
                                    patchObj = PatchObject.getInstance(sigPo.getPatchLocation());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (patchObj == null) continue;
                                oneoffsArr.add(patchObj.toOneOffEntry(oracleHomePath));
                            }
                            String compositeXML = CompositePatchObject.getCompositeFilePath(cpp.getPatchLocation());
                            String[] sortedOrder = CompositePatchObject.getConstituentList(compositeXML);
                            for (int x = 0; x < sortedOrder.length; ++x) {
                                int y;
                                int patchCount = 0;
                                for (y = 0; y < oneoffsArr.size(); ++y) {
                                    String currentEntryID = ((OneOffEntry)oneoffsArr.get(y)).getID();
                                    if (!currentEntryID.equals(sortedOrder[x])) continue;
                                    ++patchCount;
                                    break;
                                }
                                if (patchCount != 1) {
                                    throw new Exception();
                                }
                                OneOffEntry currentEntry = (OneOffEntry)oneoffsArr.get(y);
                                oneoffsArr.set(y, (OneOffEntry)oneoffsArr.get(x));
                                oneoffsArr.set(x, currentEntry);
                            }
                            continue;
                        }
                        String subPatchLoc = subPatch.getPatchLocation();
                        PatchObject po = PatchObject.getInstance(subPatchLoc);
                        oneoffsArr.add(po.toOneOffEntry(oracleHomePath));
                    }
                    if (oneoffsArr.size() == 0) {
                        throw new Exception();
                    }
                    break;
                }
                case 1: {
                    PatchObject patchObj;
                    Path compositeLoc = WrapperFactory.getNioServiceWrapper().getPath(patchLoc, new String[0]);
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(compositeLoc);){
                        for (Path entry : stream) {
                            patchObj = null;
                            String compPatchLoc = "";
                            compPatchLoc = entry.toAbsolutePath().normalize().toString();
                            try {
                                patchObj = PatchObject.getInstance(compPatchLoc);
                            }
                            catch (Exception patchCount) {
                                // empty catch block
                            }
                            if (patchObj == null) continue;
                            oneoffsArr.add(patchObj.toOneOffEntry(oracleHomePath));
                        }
                    }
                    catch (IOException e2) {
                        OLogger.debug(e2.getMessage());
                    }
                    if (oneoffsArr.size() == 0) {
                        throw new Exception();
                    }
                    String[] sortedOrder = CompositePatchObject.getConstituentList(OPatchEnv.getCompositeXMLPath());
                    for (int x = 0; x < sortedOrder.length; ++x) {
                        int y;
                        int patchCount = 0;
                        for (y = 0; y < oneoffsArr.size(); ++y) {
                            String currentEntryID = ((OneOffEntry)oneoffsArr.get(y)).getID();
                            if (!currentEntryID.equals(sortedOrder[x])) continue;
                            ++patchCount;
                            break;
                        }
                        if (patchCount != 1) {
                            throw new Exception();
                        }
                        OneOffEntry currentEntry = (OneOffEntry)oneoffsArr.get(y);
                        oneoffsArr.set(y, (OneOffEntry)oneoffsArr.get(x));
                        oneoffsArr.set(x, currentEntry);
                    }
                    break;
                }
                case 2: {
                    ArrayList subPatchFilesList = new ArrayList();
                    Path patchLocPath = WrapperFactory.getNioServiceWrapper().getPath(patchLoc, new String[0]);
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(patchLocPath);){
                        for (Path entry : stream) {
                            if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                            String subPatchLoc = "";
                            subPatchLoc = entry.toAbsolutePath().normalize().toString();
                            PatchObject po = null;
                            try {
                                po = PatchObject.getInstance(subPatchLoc);
                            }
                            catch (Exception e3) {
                                OLogger.debug(e3.getMessage());
                            }
                            if (po == null) continue;
                            oneoffsArr.add(po.toOneOffEntry(oracleHomePath));
                        }
                    }
                    catch (IOException e4) {
                        OLogger.debug(e4.getMessage());
                    }
                    if (oneoffsArr.size() == 0) {
                        throw new Exception();
                    }
                    break;
                }
                default: {
                    if (!OnlinePatchProcessor.isOnlineOnlyPatch(patchLoc)) {
                        PatchObject patchObj = PatchObject.getInstance(patchLoc);
                        oneoffsArr.add(patchObj.toOneOffEntry(oracleHomePath));
                    }
                    if (OnlinePatchProcessor.isHybridOnlinePatch(patchLoc)) {
                        OnlinePatchProcessor.setHybridPatchPart(patchLoc, PatchObject.HybridPatchPart.ONLINE);
                        PatchObject onlineObj = PatchObject.getInstance(patchLoc);
                        oneoffsArr.add(onlineObj.toOneOffEntry(oracleHomePath));
                    }
                }
            }
        }
        catch (Throwable t) {
            NotFoundException nfe = new NotFoundException(OLogger.getString("OUI-67736", new Object[]{patchLoc}));
            nfe.setStackTrace(t.getStackTrace());
            throw nfe;
        }
        try {
            OneOffEntry[] oneOffs = new OneOffEntry[oneoffsArr.size()];
            oneoffsArr.toArray(oneOffs);
            for (int i3 = 0; i3 < oneOffs.length; ++i3) {
                oneOffs[i3].setAppliedDate(null);
            }
            LsPatchesPrinter.printMetadataForPatches(oracleHomePath, oneOffs, required);
        }
        catch (NotFoundException e5) {
            throw e5;
        }
        catch (Throwable t) {
            re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    @Override
    public boolean helpPresent() {
        return true;
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "lspatches_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

