/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasPatchBuilderFactory;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasPatchRec;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasRec;
import oracle.glcm.opatch.common.api.alias.patch.PatchRec;
import oracle.glcm.opatch.common.helpers.MaintenanceAliasInfoHelper;
import oracle.glcm.opatch.common.impl.alias.patch.MaintenanceAliasPatchService;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.Rules;
import oracle.opatch.wrappers.WrapperFactory;

public class MaintenanceAliasPatchHelper {
    public static void applyMaintenanceAlias(String oracleHomePath, PatchObject patchObject) {
        Set<String> maintenanceAliasKeys = patchObject.getMaintenanceAliasKeys();
        if (maintenanceAliasKeys == null || maintenanceAliasKeys.isEmpty()) {
            return;
        }
        Path maintenanceAliasInfoXMLFilePath = null;
        Path maintenanceAliasPatchXMLFilePath = null;
        try {
            maintenanceAliasInfoXMLFilePath = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getMaintenanceAliasInfoFileLoc(oracleHomePath), new String[0]);
            maintenanceAliasPatchXMLFilePath = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getMaintenanceAliasPatchFileLoc(oracleHomePath), new String[0]);
            MaintenanceAliasInfoHelper maInfo = MaintenanceAliasInfoHelper.getInstance();
            MaintenanceAliasPatchService mapService = MaintenanceAliasPatchService.getInstance();
            if (!Files.exists(maintenanceAliasInfoXMLFilePath, new LinkOption[0])) {
                Path maintenanceAliasInfoXMLDirPath = maintenanceAliasInfoXMLFilePath.getParent();
                if (!Files.exists(maintenanceAliasInfoXMLDirPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(maintenanceAliasInfoXMLDirPath, new FileAttribute[0]);
                    }
                    catch (IOException e2) {
                        throw new IOException("Failed to create new directory at " + maintenanceAliasInfoXMLFilePath.getParent());
                    }
                }
                Files.createFile(maintenanceAliasInfoXMLFilePath, new FileAttribute[0]);
                maInfo.initMaintenanceAliasInfoFile(oracleHomePath);
            }
            if (!Files.exists(maintenanceAliasPatchXMLFilePath, new LinkOption[0])) {
                Path maintenanceAliasPatchXMLDirPath = maintenanceAliasPatchXMLFilePath.getParent();
                if (!Files.exists(maintenanceAliasPatchXMLDirPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(maintenanceAliasPatchXMLDirPath, new FileAttribute[0]);
                    }
                    catch (IOException e3) {
                        throw new IOException("Failed to create new diretory at " + maintenanceAliasPatchXMLFilePath.getParent());
                    }
                }
                Files.createFile(maintenanceAliasPatchXMLFilePath, new FileAttribute[0]);
                mapService.initMaintenanceAliasPatch(maintenanceAliasPatchXMLFilePath);
            } else if (!Files.isWritable(maintenanceAliasPatchXMLFilePath)) {
                throw new IOException(maintenanceAliasPatchXMLFilePath + " is not writeable.");
            }
            String patchUPI = patchObject.getPatchUniqID();
            String patchID = patchObject.getPatchID();
            String patchLocation = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchID);
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM_dd_yyyy_HH_mm_ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone(patchObject.getCreationZone()));
            Date patchCreationTime = dateFormat.parse(patchObject.getFormatCreationTimeString());
            Date patchAppliactionTime = new Date();
            MaintenanceAliasPatchRec mapRec = mapService.loadMaintenanceAliasPatch(maintenanceAliasPatchXMLFilePath);
            MaintenanceAliasPatchBuilderFactory builderFactory = mapService.getMaintenanceAliasPatchBuilderFactory();
            PatchRec patchRec = mapService.retrievePatch(mapRec, patchUPI);
            if (patchRec == null) {
                patchRec = builderFactory.getPatchRecBuilder(patchUPI).setId(patchID).setPatchLocation(patchLocation).setCreationTime(patchCreationTime).setApplicationTime(patchAppliactionTime).build();
                mapRec.addPatchRec(patchRec);
            }
            Set maintenanceAliasRecs = mapService.filterMaintenanceAlias(mapRec, maintenanceAliasKeys);
            if (!maintenanceAliasKeys.isEmpty()) {
                for (String maintenanceAliasKey : maintenanceAliasKeys) {
                    MaintenanceAliasRec maintenanceAliasRec = builderFactory.getMaintenanceAliasRecBuilder(maintenanceAliasKey).setPatchUpis(new HashSet()).build();
                    maintenanceAliasRecs.add(maintenanceAliasRec);
                    mapRec.addMaintenanceAliasRec(maintenanceAliasRec);
                }
            }
            for (MaintenanceAliasRec maintenanceAliasRec : maintenanceAliasRecs) {
                maintenanceAliasRec.addPatchUpi(patchUPI);
            }
            if (Rules.SystemWrite_continue()) {
                mapService.storeMaintenanceAliasPatch(mapRec, maintenanceAliasPatchXMLFilePath);
            }
        }
        catch (MaintenanceAliasException e4) {
            throw new RuntimeException("Errors occured when applying maintenance aliases", e4);
        }
        catch (ParseException e5) {
            throw new RuntimeException("Failed to parse time string to Date", e5);
        }
        catch (IOException e6) {
            throw new RuntimeException(e6.getMessage(), e6);
        }
    }

    public static void rollbackMaintenanceAlias(String oracleHomePath, PatchObject patchObject) {
        Set<String> maintenanceAliasKeys = patchObject.getMaintenanceAliasKeys();
        if (maintenanceAliasKeys == null || maintenanceAliasKeys.isEmpty()) {
            return;
        }
        try {
            Path maintenanceAliasPatchXMLFilePath = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getMaintenanceAliasPatchFileLoc(oracleHomePath), new String[0]);
            MaintenanceAliasPatchService mapService = MaintenanceAliasPatchService.getInstance();
            if (!Files.exists(maintenanceAliasPatchXMLFilePath, new LinkOption[0])) {
                throw new MaintenanceAliasException("Failed to fetch the maintenance alias patch file at " + maintenanceAliasPatchXMLFilePath.toAbsolutePath());
            }
            MaintenanceAliasPatchRec mapRec = mapService.loadMaintenanceAliasPatch(maintenanceAliasPatchXMLFilePath);
            String patchUPI = patchObject.getPatchUniqID();
            Set maintenanceAliasRecs = mapService.filterMaintenanceAlias(mapRec, maintenanceAliasKeys);
            for (MaintenanceAliasRec maintenanceAliasRec : maintenanceAliasRecs) {
                maintenanceAliasRec.delPatchUpi(patchUPI);
                if (!maintenanceAliasRec.getPatchUpis().isEmpty()) continue;
                mapRec.delMaintenanceAliasRec(maintenanceAliasRec.getMaintenanceAliasKey());
            }
            mapRec.delPatchRec(patchUPI);
            if (Rules.SystemWrite_continue()) {
                mapService.storeMaintenanceAliasPatch(mapRec, maintenanceAliasPatchXMLFilePath);
            }
        }
        catch (MaintenanceAliasException e2) {
            throw new RuntimeException("Errors occured when applying maintenance aliases", e2);
        }
    }
}

