/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.opatch.CmdLineParser;
import oracle.opatch.HelpSession;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOOPHelper;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchRestartException;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OUIVersion;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.PatchingFlow;
import oracle.opatch.StringResource;
import oracle.opatch.Version;
import oracle.opatch.nio.RepoFileSystemEnv;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchutil.CasClasspathLoader;
import oracle.opatch.opatchutil.OuiLoader;
import oracle.opatch.ops.EnvInfo;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OPatch {
    static final String ILLEGAL_ARGUMENT = "Illegal Argument: ";
    private static final String ohJavaPropertyOption = "OPatch.ORACLE_HOME";
    private static final String callerPropertyOption = "OPatch.CALLER";
    static final String ILLEGAL_ACCESS = "Illegal Access: ";
    static final String INVOCATION_EXCEPTION = "Invocation Exception: ";
    static final int ERROR = 1;
    static final int OK = 0;
    static final int OUI_VERSION_NOTAPPLICABLE_ERROR = 19;
    static String OHList = "";
    static boolean isOHList = false;

    private String getRecommendAction(int exitCode) {
        String recommendActionStr = "";
        String errorCodeStr = "";
        try {
            ResourceBundle rb = ResourceBundle.getBundle("oracle.opatch.OPatchErrorCodeRecommendMsgRes", Locale.getDefault());
            recommendActionStr = rb.getString(exitCode + "");
            return recommendActionStr;
        }
        catch (Exception e2) {
            recommendActionStr = "";
            try {
                InputStream is = this.getClass().getResourceAsStream("opatch_recommend_action.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String entry = null;
                while ((entry = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(entry, ":");
                    if (!st.hasMoreTokens() || exitCode != Integer.parseInt(errorCodeStr = st.nextToken()) || !st.hasMoreTokens()) continue;
                    recommendActionStr = st.nextToken();
                    recommendActionStr = recommendActionStr.trim();
                    break;
                }
                br.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return recommendActionStr;
        }
    }

    private String retrieveOPatchVersion() {
        return new Version().getOPatchVersion();
    }

    protected static void setupEnvironment(String oracleHomePath) {
        StringBuffer ouiLocation = null;
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        if (cmdOuiLocation == null || cmdOuiLocation.trim().length() == 0) {
            ouiLocation = new StringBuffer(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        } else {
            ouiLocation = new StringBuffer(cmdOuiLocation);
        }
        System.setProperty("oracle.installer.oui_loc", ouiLocation.toString());
        System.setProperty("oracle.installer.startup_location", ouiLocation.toString());
        String sLibraryLoc = OiixPathOps.concatPath((String)ouiLocation.toString(), (String)"lib");
        String dirName = OUIReplacer.Platform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)dirName);
        sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
        System.setProperty("oracle.installer.library_loc", sLibraryLoc);
        OPatchProperty dummy = new OPatchProperty();
        Properties userProp = dummy.getUserProperty();
        Properties bundledProp = dummy.getBundledProperty();
        Properties mergedProp = OPatchProperty.mergeProperties(userProp, bundledProp);
        OPatchEnv.setOPatchProperties(mergedProp);
    }

    private static void catReleaseDate() {
        String debug = System.getProperties().getProperty("OPatch.DEBUG");
        if (debug != null && debug.equalsIgnoreCase("true")) {
            StringBuffer releaseDate = new StringBuffer("Internal Release Date: ");
            releaseDate.append(Version.getReleaseDate());
            System.out.println(releaseDate.toString());
            StringBuffer hasCasVersion = null;
            hasCasVersion = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) ? new StringBuffer("This version of OPatch has CAS.") : new StringBuffer("This version of OPatch has no CAS.");
            System.out.println(hasCasVersion.toString());
        }
    }

    public static void process(String[] args) throws Throwable {
        CasClasspathLoader opatchCASLoader;
        String oracleHomePath;
        IOPatchSession isession;
        HelpSession INIT;
        block84: {
            String OH;
            OPatch opatch = new OPatch();
            INIT = new HelpSession();
            isession = null;
            oracleHomePath = null;
            String originalCmd = "";
            String commandName = "";
            StringBuffer opatchVersion = new StringBuffer("");
            opatchVersion.append(INIT.getVersion());
            Properties properties = System.getProperties();
            String CALLER = properties.getProperty(callerPropertyOption);
            if (args != null && args.length >= 1) {
                commandName = args[0];
                OPatchEnv.COMMIT_ABORT_WRAPPER.setCommandName(commandName);
                StringResource.opatch_command = commandName;
            }
            if (args != null && args.length >= 1) {
                StringBuffer cmdArg = new StringBuffer();
                for (int i2 = 0; i2 < args.length; ++i2) {
                    cmdArg.append(args[i2]).append(" ");
                }
                originalCmd = cmdArg.toString();
                OPatchEnv.setOPatchCLIMode(true);
                boolean simpleVersionCmd = true;
                boolean versionCmdWithOpt = false;
                for (int i3 = 0; i3 < args.length; ++i3) {
                    if (!args[i3].startsWith("-") || args[i3].length() <= 1) continue;
                    String subArg = args[i3].substring(1);
                    if (subArg.equals("all") || subArg.equals("help") || subArg.equals("h") || subArg.equals("ohs") || subArg.equals("ph") || subArg.equals("v2c")) {
                        simpleVersionCmd = false;
                        continue;
                    }
                    if (subArg.equals("verbose")) {
                        versionCmdWithOpt = true;
                        continue;
                    }
                    if (!subArg.equals("report")) continue;
                    OPatchEnv.setReport(true);
                }
                if (args[0].equals("version") && simpleVersionCmd) {
                    StringBuffer version = new StringBuffer("OPatch Version: ");
                    String releaseDate = Version.getReleaseDate();
                    version.append(opatch.retrieveOPatchVersion());
                    String debug = System.getProperties().getProperty("OPatch.DEBUG");
                    if (versionCmdWithOpt || debug != null && debug.equalsIgnoreCase("true")) {
                        version.append("\nOPatch Build Number: ");
                        version.append(Version.getBuildNumber());
                    }
                    System.out.println(version.toString());
                    OPatch.catReleaseDate();
                    OPatch.exit(0);
                }
            }
            if ((OH = properties.getProperty(ohJavaPropertyOption)) != null) {
                oracleHomePath = OH;
            }
            StringBuffer option = new StringBuffer("-");
            option.append("oh");
            String optionOH = option.toString();
            option = new StringBuffer("-");
            option.append("invptrloc");
            String optionInvPtrLoc = option.toString();
            String invPtrLoc = "";
            if (args != null) {
                for (int i4 = 0; i4 < args.length; ++i4) {
                    String arg = args[i4];
                    if (arg == null) continue;
                    if (arg.equals(optionOH)) {
                        String oh;
                        if (i4 + 1 >= args.length || (oh = args[i4 + 1]) == null) continue;
                        if (oh.indexOf(",") != -1) {
                            isOHList = true;
                            OHList = oh;
                            oracleHomePath = oh.split(",")[0].trim();
                        } else {
                            oracleHomePath = oh;
                        }
                        System.setProperty(ohJavaPropertyOption, oracleHomePath);
                        continue;
                    }
                    if (!arg.equalsIgnoreCase(optionInvPtrLoc) || i4 + 1 >= args.length) continue;
                    invPtrLoc = args[i4 + 1];
                }
            }
            if (oracleHomePath == null || oracleHomePath.equals("")) {
                System.out.println("OPatch cannot obtain the ORACLE_HOME value, exiting.");
                System.out.println("(Please set ORACLE_HOME in the environment or use -oh option)");
                OPatch.exit(1);
            }
            opatchCASLoader = new CasClasspathLoader();
            try {
                EnvInfo envInfo = new EnvInfo();
                if (envInfo.isCASJarsExists()) {
                    opatchCASLoader.loadCasJars();
                }
            }
            catch (Exception e2) {
                OPatchEnv.printCASDynamicLoadingToLog(opatchCASLoader.getDebugMsg(), true);
                throw new Exception("ERROR:CasJarLoader: Failed to load CAS jars dynamically", e2);
            }
            try {
                String oui_loc = OuiLoader.loadOUI(oracleHomePath);
                System.setProperty("OPatch.OUI_LOCATION", oui_loc);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                System.out.println(e3.getMessage());
                OPatch.exit(1);
            }
            OPatchEnv.setNextgenLogFile();
            if (invPtrLoc != null && !invPtrLoc.equals("")) {
                OPatchEnv.setInvPtrLoc(invPtrLoc);
            }
            if (!OPatchEnv.isObrepo()) {
                try {
                    RepoFileSystemEnv.setupCasRepoFileSystem(oracleHomePath);
                }
                catch (Exception e4) {
                    OLogger.debug(e4.getMessage());
                    System.out.println(e4.getMessage());
                    OPatch.exit(1);
                }
            }
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.OUI_BASED)) {
                int i5;
                PrereqResult result2;
                PrereqResult resObj;
                String cusLogLoc;
                PrereqAPI.isNextGenOracleHome(oracleHomePath);
                if (args != null) {
                    boolean customLogFlag = false;
                    for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                        if (args[argIndex].equalsIgnoreCase("-customLogDir")) {
                            if (argIndex + 1 < args.length && !args[argIndex + 1].startsWith("-")) {
                                Path custDir;
                                String dirVal = args[argIndex + 1];
                                if (dirVal == null || dirVal.equals("")) {
                                    System.out.println("Invalid value for custom log directory");
                                    OPatch.exit(1);
                                }
                                if (Files.isDirectory(custDir = WrapperFactory.getNioServiceWrapper().getPath(dirVal, new String[0]), new LinkOption[0]) && Files.isWritable(custDir)) {
                                    OPatchEnv.setCustomLogDir(custDir.toAbsolutePath().toString());
                                    customLogFlag = true;
                                } else {
                                    System.out.println("Input custom log directory \"" + dirVal + "\" does not exists or not a valid directory.");
                                    OPatch.exit(1);
                                }
                            } else {
                                System.out.println("No value provided for custom Log Directory.");
                                OPatch.exit(1);
                            }
                        }
                        if (!args[argIndex].equalsIgnoreCase("-disablelog")) continue;
                        OPatchEnv.setDisableLog(true);
                    }
                }
                if (OPatchEnv.getCustomLogDir() == "" && (cusLogLoc = System.getenv("CUSTOM_LOG_DIR")) != null && !cusLogLoc.equals("")) {
                    Path custDir = WrapperFactory.getNioServiceWrapper().getPath(cusLogLoc, new String[0]);
                    if (Files.isDirectory(custDir, new LinkOption[0]) && Files.isWritable(custDir)) {
                        OPatchEnv.setCustomLogDir(custDir.toAbsolutePath().toString());
                    } else {
                        System.out.println("The custom log dir" + cusLogLoc + "doesn't exist or isn't a writable dirctory.");
                        OPatch.exit(1);
                    }
                }
                if ((resObj = PrereqAPI.checkJDKCompatibleOUI(oracleHomePath)).getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    Vector resDetails = resObj.getResultDetails();
                    for (int i6 = 0; i6 < resDetails.size(); ++i6) {
                        System.out.println((String)resDetails.get(i6));
                    }
                    OPatch.exit(1);
                }
                OPatch.setupEnvironment(oracleHomePath);
                try {
                    boolean isRoot = OUIReplacer.isRootAccess(oracleHomePath);
                    if (isRoot) {
                        System.out.println("The user is root. OPatch cannot continue if the user is root.");
                        OPatch.exit(255);
                    }
                }
                catch (Exception e1) {
                    OLogger.println("Could not check if user is root. " + e1.getMessage());
                    OLogger.printStackTrace(e1);
                    OPatch.exit(255);
                }
                OPatchEnv.setOriginalCommand(originalCmd);
                PrereqResult result = PrereqAPI.isOHPathOK(oracleHomePath);
                if (result.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    Vector resDetails = result.getResultDetails();
                    for (int i7 = 0; i7 < resDetails.size(); ++i7) {
                        System.out.println(resDetails.get(i7).toString());
                    }
                    OPatch.exit(1);
                }
                if ((result2 = PrereqAPI.checkIfSupportCasDirectlyPatching(oracleHomePath)).getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    Vector resDetails = result2.getResultDetails();
                    for (i5 = 0; i5 < resDetails.size(); ++i5) {
                        System.out.println(resDetails.get(i5).toString());
                    }
                    OPatch.exit(1);
                }
                if (!OPatchEnv.isObrepo() && (result = PrereqAPI.isOUIVersionApplicableForOPatch(opatch.retrieveOPatchVersion(), oracleHomePath)).getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    Vector resDetails = result.getResultDetails();
                    for (i5 = 0; i5 < resDetails.size(); ++i5) {
                        System.out.println((String)resDetails.get(i5));
                    }
                    OPatch.exit(19);
                }
                OPatchSessionHelper.updateHistoryFile(oracleHomePath, args);
            }
            if (!commandName.equals("lspatches")) {
                OLogger.printlnres("OUI-67089", new Object[]{INIT.getVersion(), OLogger.getString("OUI-67213", new Object[]{StringResource.COPY_RIGHT_YEAR})});
            }
            if (!OPatchEnv.isLogDisabled()) {
                try {
                    OPatchACL.invokeOLogger(INIT, "initJavaLogger", new Object[]{oracleHomePath, "INFO", "INFO"});
                }
                catch (Exception resObj) {
                    // empty catch block
                }
            }
            try {
                if (args.length < 1) {
                    try {
                        OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
                    }
                    catch (Exception resObj) {
                        // empty catch block
                    }
                    OLogger.error("OUI-67014", new Object[]{"No command specified."});
                    INIT.process();
                    return;
                }
                String tempOracleHome = "";
                isession = CmdLineParser.parse(args);
            }
            catch (OnlinePatchException e5) {
                OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                OLogger.println(e5.getMessage());
                OPatchEnv.setOpatchExitCode(OnlinePatchException.getErrorCode());
                throw e5;
            }
            catch (RuntimeException e6) {
                boolean isObrepo;
                if (e6.getMessage().contains(OLogger.getString("OUI-68011"))) {
                    throw e6;
                }
                OLogger.error("OUI-67014", new Object[]{e6.getMessage()});
                String sessionName = OPatchSession.getSessionNameString(args[0]);
                StringBuffer sessionStr = new StringBuffer(" " + sessionName);
                if (OPatchEnv.isBeaHome() && (sessionName.equals("apply") || sessionName.equals("rollback")) && (OPatchEnv.getisAuto() || OPatchEnv.getFMWDomainName() != null)) {
                    sessionStr.append("-fmw");
                }
                String scriptName = (isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"))) ? "obrepo" : "opatch";
                OLogger.log(OLogger.INFO, "Please use the option '" + scriptName + sessionStr.toString() + " -help' to get correct syntax");
                if (!OPatchEnv.isOPatchSDKMode()) break block84;
                try {
                    OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e6;
            }
        }
        if (OPatchEnv.isSyntaxError()) {
            OLogger.error("OUI-67014", new Object[]{OPatchEnv.getSyntaxErrorMsg()});
            String sessionName = OPatchSession.getSessionNameString(args[0]);
            StringBuffer sessionStr = new StringBuffer(" " + sessionName);
            if ((sessionName.equals("apply") || sessionName.equals("rollback")) && (OPatchEnv.getisAuto() || OPatchEnv.getFMWDomainName() != null)) {
                sessionStr.append(" ");
                sessionStr.append("-fmw");
                sessionStr.append(" ");
            }
            if (sessionName.equals("lspatches")) {
                OPatchEnv.setOpatchExitCode(2);
            }
            boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
            if (sessionName.equals("lspatches") && !isObrepo) {
                OPatchEnv.setOpatchExitCode(2);
            }
            String scriptName = isObrepo ? "obrepo" : "opatch";
            OLogger.log(OLogger.INFO, "Please use the option '" + scriptName + sessionStr.toString() + " -help' to get correct syntax");
            if (OPatchEnv.isOPatchSDKMode()) {
                try {
                    OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            throw new UnsupportedOperationException(OLogger.getString("OUI-67014", new Object[]{OPatchEnv.getSyntaxErrorMsg()}));
        }
        if (OPatchEnv.isArgumentError()) {
            OLogger.error("OUI-67135", new Object[]{OPatchEnv.getArgumentErrorMsg()});
            OLogger.log(OLogger.INFO, "Please check the arguments and try again.");
            if (OPatchEnv.isOPatchSDKMode()) {
                try {
                    OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
                }
                catch (IllegalAccessException sessionName) {
                    // empty catch block
                }
            }
            throw new UnsupportedOperationException(OLogger.getString("OUI-67135", new Object[]{OPatchEnv.getArgumentErrorMsg()}));
        }
        if (isession == null) {
            INIT.process();
            return;
        }
        OPatchOOPHelper.setArgs(args);
        if (OPatchEnv.isRestarted()) {
            OPatchOOPHelper.updateClassPath();
            Thread.sleep(2000L);
        }
        OPatchEnv.printCASDynamicLoadingToLog(opatchCASLoader.getDebugMsg(), false);
        OPatchEnv.checkAndSetCupFlag(oracleHomePath);
        boolean pre19Db = false;
        String ouiversion = OUIVersion.getOUIVersion();
        if (ouiversion != null && (ouiversion.contains("11.2") || ouiversion.contains("12.1"))) {
            pre19Db = true;
        }
        if (OPatchEnv.isAllNode() && pre19Db) {
            String errorMsg = "Error: Remote patching is not supported for DB version older than 19";
            System.out.println(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (isession.isOUIBased()) {
            try {
                OPatchSession.process(isession, args);
            }
            catch (InvocationTargetException e7) {
                System.out.println(INVOCATION_EXCEPTION + e7.getMessage());
                throw e7;
            }
            catch (IllegalAccessException e8) {
                System.out.println(ILLEGAL_ACCESS + e8.getMessage());
                throw e8;
            }
            catch (IllegalArgumentException e9) {
                System.out.println(ILLEGAL_ARGUMENT + e9.getMessage());
                throw e9;
            }
        } else {
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.OUI_BASED)) {
                OPatchEnv.printOPatchHeader();
            }
            isession.process(oracleHomePath);
        }
        if (PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow()) && !OPatchEnv.isReport() && OPatchEnv.COMMIT_ABORT_WRAPPER.isCommitCommand()) {
            RepoFileSystemEnv.restoreMementoToOH(oracleHomePath);
        }
    }

    public static void main(String[] args) {
        OPatch opatch;
        int exitCode;
        block11: {
            exitCode = 0;
            opatch = new OPatch();
            try {
                OPatch.process(args);
            }
            catch (Throwable t) {
                OPatchRestartException re = null;
                re = OPatchOOPHelper.getOPatchRestartExceptionFromCauseChain(t);
                if (re != null) {
                    try {
                        String logMsg = "Lanching oop,opatch invoked by " + re.getTempOpatchHome();
                        OLogger.printlnOnLog(OLogger.INFO, logMsg);
                        OPatchOOPHelper.invokeOPatch(re.getTempOracleHome(), re.getTempOpatchHome(), re.getTempJavaHome(), Arrays.asList(args));
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        exitCode = 255;
                    }
                    OPatchEnv.setOpatchExitCode(0);
                }
                try {
                    OLogger.printStackTrace(t);
                }
                catch (Throwable tlog) {
                    t.printStackTrace();
                }
                exitCode = OPatchEnv.getOpatchExitCode();
                if (exitCode != 0) break block11;
                exitCode = 255;
            }
        }
        if (exitCode == 0) {
            exitCode = OPatchEnv.getOpatchExitCode();
        }
        if (exitCode != 0 && OPatchStateManagerFactory.getInstance().getCurrentState().getStateOrder() != 0 && !OPatchEnv.isExitWithUserReq() && !opatch.getRecommendAction(exitCode).equals("")) {
            StringBuffer recommendBuff = new StringBuffer("\nRecommended actions: ");
            recommendBuff.append(opatch.getRecommendAction(exitCode));
            OLogger.println(recommendBuff.toString());
        }
        try {
            OPatchACL.invokeOLogger(opatch, "closeLogFile", null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        OPatch.exit(exitCode);
    }

    public static void exit(int exitCode) {
        OPatchEnv.COMMIT_ABORT_WRAPPER.setExitCode(exitCode);
        System.exit(exitCode);
    }
}

