/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import oracle.opatch.Bug;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.InterviewContextVar;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchException;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.Platform;
import oracle.opatch.PrereqSession;
import oracle.opatch.TargetEntity;
import oracle.opatch.UpdateComponent;
import oracle.opatch.WLSPatch;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchactions.sqlAction;
import oracle.opatch.opatchactions.sqlprocAction;
import oracle.opatch.opatchext.Patch;
import oracle.opatch.opatchfafmw.OPatchFmwDS;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchverbs.ParserObject;

public class OneOffEntry
implements Cloneable,
Comparable {
    private boolean isComposite = false;
    private String compositeFileLocation = "";
    private OneOffEntry[] constituentOneOffs = new OneOffEntry[0];
    private String patchID;
    private String id;
    private String cookedID;
    private String tripletID;
    private String pse;
    private String tpse;
    private Date appliedDate;
    private String creationZone;
    private String creationDate;
    private String relativePatchLocation = "";
    private String[][] filesTouched = new String[0][0];
    private Bug[] bugsFixed = new Bug[0];
    private PatchAction[] patchActions = new PatchAction[0];
    private ArrayList<ParserObject> parserObjects = null;
    private PatchComponent[] reqdComponents = new PatchComponent[0];
    private PatchComponent[] optComponents = new PatchComponent[0];
    private boolean rollbackable = true;
    private String[] prereqOneOffs;
    private String[] coreqOneOffs;
    private String[] overLayOneOffs;
    private String[] prereqBugs;
    private HashSet<String> supersetPatchIDs = new HashSet();
    private HashSet<String> subsetPatchIDs = new HashSet();
    private String esysPatchID;
    private WLSPatch[] wlsPrereqOneOffs;
    private TargetEntity[] targetEntities;
    private boolean isShutdown;
    private boolean cannotAutoRollback;
    private String instanceShutdownMsg;
    private boolean rolling;
    private NameVersionPair[] systemComponentList = new NameVersionPair[0];
    private NameVersionPair[] applicationShutdownList = new NameVersionPair[0];
    private String patchType = "singleton";
    private String subType = "";
    private String productFamily;
    private OPatchFmwDS.DeployDS[] deployList = new OPatchFmwDS.DeployDS[0];
    private InterviewContextVar[] interviewList = new InterviewContextVar[0];
    private String producType;
    private boolean auto;
    private boolean translatable;
    private boolean exitIfPreScriptError;
    private boolean couldBeTranslation;
    private String patchDesc;
    private String bundleDesc;
    private String patchModel = "one-off";
    private String patchLanguage = "en";
    private String minOPatchVersion = "";
    private NameVersionPair[] productsList = new NameVersionPair[0];
    private Platform[] supportedPlatforms = new Platform[0];
    private String[] executables = new String[0];
    private boolean onlinePatch = false;
    private boolean portalPatch = false;
    private boolean miniPatchSet = false;
    private boolean isSqlPatch = false;
    private String sqlPatchDatabaseStartupMode = "";
    private boolean isFmwRolling = false;
    private boolean isFmwFeatureBearing = false;
    private ChecksumEntity[] cke = new ChecksumEntity[0];
    private Path checksum;
    private UpdateComponent[] updateCompsList = new UpdateComponent[0];
    private String language = "English";
    private String initDateStr = "";
    private String constituentActiveField = null;
    private String[] applicationDirs;
    private boolean deleteOldDirectory;
    private LinkedList componentList;
    private HashMap<String, String> currentAppVerDirs = new HashMap();
    private PatchObject po;
    private String oracleHome;
    private boolean autorollback = false;
    private boolean isRu = false;
    private String ruVersion = "";
    private String regressedOneOff = "";
    private boolean containsSymlinks = false;
    public static int counter = 1;
    public static int counter1 = 1;
    private Set<String> overridingUPIs = null;

    protected OneOffEntry() {
    }

    public PatchAction[] getPatchActions() {
        return this.patchActions;
    }

    public List<OrderedPatchAction> getOrderedActions() {
        ArrayList<OrderedPatchAction> actions = new ArrayList<OrderedPatchAction>();
        for (PatchAction pa : this.patchActions) {
            if (pa.isExecutionDelayed() || !(pa instanceof OrderedPatchAction)) continue;
            OrderedPatchAction opa = (OrderedPatchAction)pa;
            actions.add(opa);
        }
        Collections.sort(actions, new Comparator<OrderedPatchAction>(){

            @Override
            public int compare(OrderedPatchAction o1, OrderedPatchAction o2) {
                return (int)(o1.getOrder() - o2.getOrder());
            }
        });
        return actions;
    }

    public void setPatchActions(PatchAction[] pa) {
        this.patchActions = pa;
    }

    protected OneOffEntry(Patch p1) {
        this.id = p1.getPatchID();
        this.tripletID = p1.getTripletID();
        String[] patchBugsFixed = p1.getBugFixes();
        String[] overlayPatches = p1.getOverlayPatches();
        Bug[] bugsFixed = new Bug[patchBugsFixed.length];
        for (int i2 = 0; i2 < patchBugsFixed.length; ++i2) {
            Bug b2;
            bugsFixed[i2] = b2 = new Bug(patchBugsFixed[i2], "");
        }
        this.bugsFixed = bugsFixed;
        this.overLayOneOffs = overlayPatches;
    }

    public OneOffEntry(String constituentActiveField, boolean isComposite, String patchID, String id, String pse, String cookedID, Date appliedDate, Bug[] bugsFixed, String[][] filesTouched, PatchAction[] patchActions, String creationZone, String creationDate, boolean rollbackable, String[] prereqOneOffs, WLSPatch[] wlsPrereqOneOffs, String[] coreqOneOffs, String[] overLayOneOffs, String[] executables, Platform[] supportedPlatforms, boolean isShutdown, String instanceShutdownMsg, boolean rolling, boolean isSqlPatch, String sqlPatchDatabaseStartupMode, boolean isFmwRolling, boolean isFmwFeatureBearing, String patchType, String productFamily, PatchComponent[] reqdComps, PatchComponent[] optComps, NameVersionPair[] sysList, NameVersionPair[] appList, String productType, NameVersionPair[] productsList, String relativePatchLocation, boolean onlinePatch, boolean portalPatch, boolean miniPatchSet, UpdateComponent[] updateCompsList, OPatchFmwDS.DeployDS[] deployList, InterviewContextVar[] interviewList, boolean auto, boolean translatable, String patchDescription, String bundleDescription, String patchModel, String patchLanguage, String[] prereqBugs, boolean couldBeTranslation, ArrayList<ParserObject> parser, String minOPatchVersion, Path checksumFile, boolean cannotAutoRollback, boolean exitIfPreScriptError, String initDateStr, String compositeFileLocation, TargetEntity[] targetEntities, String esysPatchID, String tpse, String tripletID, String[] applicationDirs, boolean deleteOldDirectory, LinkedList componentList, HashMap currentAppVerDirs, boolean isRu, String ruVersion, String regressedOneOff, boolean containsSymlinks) {
        this.constituentActiveField = constituentActiveField;
        this.isComposite = isComposite;
        this.compositeFileLocation = compositeFileLocation;
        this.patchID = patchID;
        this.id = id;
        this.pse = pse;
        this.tripletID = tripletID;
        this.cookedID = cookedID;
        this.appliedDate = appliedDate;
        this.creationZone = creationZone;
        this.creationDate = creationDate;
        this.rollbackable = rollbackable;
        this.isShutdown = isShutdown;
        this.instanceShutdownMsg = instanceShutdownMsg;
        this.rolling = rolling;
        this.isSqlPatch = isSqlPatch;
        this.sqlPatchDatabaseStartupMode = sqlPatchDatabaseStartupMode;
        this.isFmwRolling = isFmwRolling;
        this.isFmwFeatureBearing = isFmwFeatureBearing;
        this.patchType = patchType;
        this.producType = productType;
        this.patchDesc = patchDescription;
        this.bundleDesc = bundleDescription;
        this.patchModel = patchModel;
        this.patchLanguage = patchLanguage;
        this.onlinePatch = onlinePatch;
        this.portalPatch = portalPatch;
        this.auto = auto;
        this.esysPatchID = esysPatchID;
        this.translatable = translatable;
        this.exitIfPreScriptError = exitIfPreScriptError;
        this.couldBeTranslation = couldBeTranslation;
        this.miniPatchSet = miniPatchSet;
        this.productFamily = productFamily;
        this.parserObjects = parser;
        this.minOPatchVersion = minOPatchVersion;
        this.cannotAutoRollback = cannotAutoRollback;
        this.applicationDirs = applicationDirs;
        this.deleteOldDirectory = deleteOldDirectory;
        this.componentList = componentList;
        this.currentAppVerDirs = currentAppVerDirs;
        this.isRu = isRu;
        this.ruVersion = ruVersion;
        this.regressedOneOff = regressedOneOff;
        this.containsSymlinks = containsSymlinks;
        if (OPatchEnv.isNextGen() && pse == "") {
            String UPINotFound = "OPatch expects unique patch ID (UPI) to be defined for a patch. Please use OPack to re-package the patch \"" + patchID + "\" with UPI.";
            OLogger.println(UPINotFound);
            throw new OPatchException(UPINotFound);
        }
        this.tpse = tpse;
        this.pse = pse;
        this.updateCompsList = updateCompsList == null ? new UpdateComponent[0] : updateCompsList;
        this.deployList = deployList == null ? new OPatchFmwDS.DeployDS[0] : deployList;
        this.checksum = checksumFile;
        this.interviewList = interviewList == null ? new InterviewContextVar[0] : interviewList;
        this.bugsFixed = bugsFixed == null ? new Bug[0] : bugsFixed;
        this.filesTouched = filesTouched == null ? new String[0][0] : filesTouched;
        this.patchActions = patchActions == null ? new PatchAction[0] : patchActions;
        this.prereqOneOffs = prereqOneOffs == null ? new String[0] : prereqOneOffs;
        this.wlsPrereqOneOffs = wlsPrereqOneOffs == null ? new WLSPatch[0] : wlsPrereqOneOffs;
        this.targetEntities = targetEntities == null ? new TargetEntity[0] : targetEntities;
        this.coreqOneOffs = coreqOneOffs == null ? new String[0] : coreqOneOffs;
        this.overLayOneOffs = overLayOneOffs == null ? new String[0] : overLayOneOffs;
        this.prereqBugs = prereqBugs == null ? new String[0] : prereqBugs;
        this.executables = executables == null ? new String[0] : executables;
        this.supportedPlatforms = supportedPlatforms == null ? new Platform[0] : supportedPlatforms;
        this.reqdComponents = reqdComps == null ? new PatchComponent[0] : reqdComps;
        this.optComponents = optComps == null ? new PatchComponent[0] : optComps;
        this.systemComponentList = sysList == null ? new NameVersionPair[0] : sysList;
        this.applicationShutdownList = appList == null ? new NameVersionPair[0] : appList;
        this.productsList = productsList == null ? new NameVersionPair[0] : productsList;
        this.relativePatchLocation = relativePatchLocation == null ? "" : relativePatchLocation;
        this.initDateStr = initDateStr == null ? "" : initDateStr;
    }

    public OneOffEntry(String patchID, String id, String pse, String cookedID, Date appliedDate, Bug[] bugsFixed, String[][] filesTouched, PatchAction[] patchActions, String creationZone, String creationDate, boolean rollbackable, String[] prereqOneOffs, WLSPatch[] wlsPrereqOneOffs, String[] coreqOneOffs, String[] overLayOneOffs, String[] executables, Platform[] supportedPlatforms, boolean isShutdown, String instanceShutdownMsg, boolean rolling, String patchType, String productFamily, PatchComponent[] reqdComps, PatchComponent[] optComps, NameVersionPair[] sysList, NameVersionPair[] appList, String productType, NameVersionPair[] productsList, String relativePatchLocation, boolean onlinePatch, boolean portalPatch, boolean miniPatchSet, UpdateComponent[] updateCompsList, OPatchFmwDS.DeployDS[] deployList, InterviewContextVar[] interviewList, boolean auto, boolean translatable, String patchDescription, String patchModel, String patchLanguage, String[] prereqBugs, boolean couldBeTranslation, ArrayList<ParserObject> parser, String minOPatchVersion, Path checksumFile, boolean cannotAutoRollback, boolean exitIfPreScriptError, String initDateStr, String compositeFileLocation, TargetEntity[] targetEntities, String esysPatchID, String tpse) {
        this.patchID = patchID;
        this.id = id;
        this.pse = pse;
        this.cookedID = cookedID;
        this.appliedDate = appliedDate;
        this.creationZone = creationZone;
        this.creationDate = creationDate;
        this.rollbackable = rollbackable;
        this.isShutdown = isShutdown;
        this.instanceShutdownMsg = instanceShutdownMsg;
        this.rolling = rolling;
        this.patchType = patchType;
        this.producType = productType;
        this.patchDesc = patchDescription;
        this.patchModel = patchModel;
        this.patchLanguage = patchLanguage;
        this.onlinePatch = onlinePatch;
        this.portalPatch = portalPatch;
        this.auto = auto;
        this.esysPatchID = esysPatchID;
        this.translatable = translatable;
        this.exitIfPreScriptError = exitIfPreScriptError;
        this.couldBeTranslation = couldBeTranslation;
        this.miniPatchSet = miniPatchSet;
        this.productFamily = productFamily;
        this.parserObjects = parser;
        this.minOPatchVersion = minOPatchVersion;
        this.cannotAutoRollback = cannotAutoRollback;
        this.updateCompsList = updateCompsList == null ? new UpdateComponent[0] : updateCompsList;
        this.deployList = deployList == null ? new OPatchFmwDS.DeployDS[0] : deployList;
        if (pse == "" && OPatchEnv.isNextGen()) {
            String UPINotFound = "OPatch expects unique patch ID (UPI) to be defined for a patch. Please use OPack to re-package the patch \"" + patchID + "\" with UPI.";
            OLogger.println(UPINotFound);
            throw new OPatchException(UPINotFound);
        }
        this.pse = pse;
        this.tpse = tpse;
        this.checksum = checksumFile;
        this.interviewList = interviewList == null ? new InterviewContextVar[0] : interviewList;
        this.bugsFixed = bugsFixed == null ? new Bug[0] : bugsFixed;
        this.filesTouched = filesTouched == null ? new String[0][0] : filesTouched;
        this.patchActions = patchActions == null ? new PatchAction[0] : patchActions;
        this.prereqOneOffs = prereqOneOffs == null ? new String[0] : prereqOneOffs;
        this.wlsPrereqOneOffs = wlsPrereqOneOffs == null ? new WLSPatch[0] : wlsPrereqOneOffs;
        this.targetEntities = targetEntities == null ? new TargetEntity[0] : targetEntities;
        this.coreqOneOffs = coreqOneOffs == null ? new String[0] : coreqOneOffs;
        this.overLayOneOffs = overLayOneOffs == null ? new String[0] : overLayOneOffs;
        this.prereqBugs = prereqBugs == null ? new String[0] : prereqBugs;
        this.executables = executables == null ? new String[0] : executables;
        this.supportedPlatforms = supportedPlatforms == null ? new Platform[0] : supportedPlatforms;
        this.reqdComponents = reqdComps == null ? new PatchComponent[0] : reqdComps;
        this.optComponents = optComps == null ? new PatchComponent[0] : optComps;
        this.systemComponentList = sysList == null ? new NameVersionPair[0] : sysList;
        this.applicationShutdownList = appList == null ? new NameVersionPair[0] : appList;
        this.productsList = productsList == null ? new NameVersionPair[0] : productsList;
        this.relativePatchLocation = relativePatchLocation == null ? "" : relativePatchLocation;
        this.initDateStr = initDateStr == null ? "" : initDateStr;
    }

    public void combineConstituent(OneOffEntry[] oneoffs) {
        int j2;
        int newBugLength = 0;
        int newActionsLength = 0;
        this.id = this.getActiveConstituent();
        this.patchID = this.getActiveConstituent();
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            if (!oneoffs[i2].getIsComposite()) continue;
            this.isComposite = true;
            this.compositeFileLocation = oneoffs[i2].compositeFileLocation;
            this.constituentOneOffs = oneoffs;
            this.relativePatchLocation = oneoffs[i2].relativePatchLocation;
        }
        int newPatchActionLength = 0;
        for (int i3 = 0; i3 < oneoffs.length; ++i3) {
            newBugLength += oneoffs[i3].bugsFixed.length;
            newPatchActionLength += oneoffs[i3].getPatchActions().length;
            newActionsLength += oneoffs[i3].getFilesTouched().length;
        }
        String[][] newFilesTouched = new String[newActionsLength][];
        int counter = 0;
        for (int i4 = 0; i4 < oneoffs.length; ++i4) {
            String[][] tmpFilesTouched = oneoffs[i4].getFilesTouched();
            for (j2 = 0; j2 < tmpFilesTouched.length; ++j2) {
                newFilesTouched[counter] = new String[tmpFilesTouched[j2].length];
                System.arraycopy(tmpFilesTouched[j2], 0, newFilesTouched[counter], 0, tmpFilesTouched[j2].length);
                ++counter;
            }
        }
        this.filesTouched = newFilesTouched;
        Bug[] newBugsFixed = new Bug[newBugLength];
        int currentIndex = 0;
        for (j2 = 0; j2 < oneoffs.length; ++j2) {
            System.arraycopy(oneoffs[j2].bugsFixed, 0, newBugsFixed, currentIndex, oneoffs[j2].bugsFixed.length);
            currentIndex += oneoffs[j2].bugsFixed.length;
        }
        this.bugsFixed = newBugsFixed;
        currentIndex = 0;
        PatchAction[] newPatchActions = new PatchAction[newPatchActionLength];
        for (int j3 = 0; j3 < oneoffs.length; ++j3) {
            System.arraycopy(oneoffs[j3].patchActions, 0, newPatchActions, currentIndex, oneoffs[j3].patchActions.length);
            currentIndex += oneoffs[j3].patchActions.length;
        }
        this.patchActions = newPatchActions;
        HashMap<String, PatchComponent> patchComponents = new HashMap<String, PatchComponent>();
        for (int i5 = 0; i5 < oneoffs.length; ++i5) {
            PatchComponent existingComponent;
            PatchComponent currentComponent;
            int j4;
            for (j4 = 0; j4 < oneoffs[i5].getOptionalComponents().length; ++j4) {
                currentComponent = oneoffs[i5].getOptionalComponents()[j4];
                if (patchComponents.containsKey(currentComponent.getID())) {
                    existingComponent = (PatchComponent)patchComponents.get(currentComponent.getID());
                    existingComponent = OneOffEntry.mergeTwoComponents(existingComponent, currentComponent);
                    continue;
                }
                patchComponents.put(currentComponent.getID(), (PatchComponent)currentComponent.clone());
            }
            for (j4 = 0; j4 < oneoffs[i5].getRequiredComponents().length; ++j4) {
                currentComponent = oneoffs[i5].getRequiredComponents()[j4];
                if (patchComponents.containsKey(currentComponent.getID())) {
                    existingComponent = (PatchComponent)patchComponents.get(currentComponent.getID());
                    existingComponent = OneOffEntry.mergeTwoComponents(existingComponent, currentComponent);
                    continue;
                }
                patchComponents.put(currentComponent.getID(), (PatchComponent)currentComponent.clone());
            }
        }
        Collection c2 = patchComponents.values();
        Iterator it = c2.iterator();
        ArrayList<PatchComponent> optionalComponents = new ArrayList<PatchComponent>();
        ArrayList<PatchComponent> requiredComponents = new ArrayList<PatchComponent>();
        while (it.hasNext()) {
            PatchComponent currentComponent = (PatchComponent)it.next();
            PatchAction[] actions = currentComponent.getAllActions();
            if (currentComponent.required) {
                requiredComponents.add(currentComponent);
                continue;
            }
            optionalComponents.add(currentComponent);
        }
        PatchComponent[] optComponents = new PatchComponent[optionalComponents.size()];
        PatchComponent[] reqdComponents = new PatchComponent[requiredComponents.size()];
        optComponents = optionalComponents.toArray(optComponents);
        reqdComponents = requiredComponents.toArray(reqdComponents);
        this.optComponents = optComponents;
        this.reqdComponents = reqdComponents;
    }

    private static PatchComponent mergeTwoComponents(PatchComponent c1, PatchComponent c2) {
        PatchComponent mergedComponent = c1;
        if (!mergedComponent.isRequired() && c2.isRequired()) {
            mergedComponent.required = true;
        }
        LinkedList newArchiveList = new LinkedList();
        newArchiveList.addAll(c1.getArchiveList());
        newArchiveList.addAll(c2.getArchiveList());
        mergedComponent.archiveList = newArchiveList;
        LinkedList newCopyList = new LinkedList();
        newCopyList.addAll(c1.getCopyList());
        newCopyList.addAll(c2.getCopyList());
        mergedComponent.copyList = newCopyList;
        LinkedList newJarList = new LinkedList();
        newJarList.addAll(c1.getJarList());
        newJarList.addAll(c2.getJarList());
        mergedComponent.jarList = newJarList;
        LinkedList newMakeList = new LinkedList();
        newMakeList.addAll(c1.getMakeList());
        newMakeList.addAll(c2.getMakeList());
        mergedComponent.makeList = newMakeList;
        LinkedList newStringSubsList = new LinkedList();
        newStringSubsList.addAll(c1.getStringSubsList());
        newStringSubsList.addAll(c2.getStringSubsList());
        mergedComponent.stringSubsList = newStringSubsList;
        LinkedList newPluginList = new LinkedList();
        newPluginList.addAll(c1.getPluginList());
        newPluginList.addAll(c2.getPluginList());
        mergedComponent.pluginList = newPluginList;
        return mergedComponent;
    }

    public void combineConstituent(ArrayList<OneOffEntry> oneoffs) {
        int newBugLength = 0;
        int newActionsLength = 0;
        this.id = this.getActiveConstituent();
        int newPatchActionLength = 0;
        for (int i2 = 0; i2 < oneoffs.size(); ++i2) {
            newBugLength += oneoffs.get((int)i2).bugsFixed.length;
            newPatchActionLength += oneoffs.get((int)i2).patchActions.length;
            newActionsLength += oneoffs.get(i2).getFilesTouched().length;
        }
        String[][] newFilesTouched = new String[newActionsLength][];
        int counter = 0;
        for (int i3 = 0; i3 < oneoffs.size(); ++i3) {
            for (int j2 = 0; j2 < oneoffs.get((int)i3).filesTouched.length; ++j2) {
                String[][] tmpFilesTouched = oneoffs.get(i3).getFilesTouched();
                newFilesTouched[counter] = new String[tmpFilesTouched[j2].length];
                System.arraycopy(tmpFilesTouched[j2], 0, newFilesTouched[counter], 0, tmpFilesTouched[j2].length);
                ++counter;
            }
        }
        this.filesTouched = newFilesTouched;
        Bug[] newBugsFixed = new Bug[newBugLength];
        int currentIndex = 0;
        for (int j3 = 0; j3 < oneoffs.size(); ++j3) {
            System.arraycopy(oneoffs.get((int)j3).bugsFixed, 0, newBugsFixed, currentIndex, oneoffs.get((int)j3).bugsFixed.length);
            currentIndex += oneoffs.get((int)j3).bugsFixed.length;
        }
        this.bugsFixed = newBugsFixed;
        currentIndex = 0;
        PatchAction[] newPatchActions = new PatchAction[newPatchActionLength];
        for (int j4 = 0; j4 < oneoffs.size(); ++j4) {
            OneOffEntry currentEntry = oneoffs.get(j4);
            System.arraycopy(currentEntry.patchActions, 0, newPatchActions, currentIndex, currentEntry.patchActions.length);
            currentIndex += currentEntry.patchActions.length;
        }
        this.patchActions = newPatchActions;
        HashMap<String, PatchComponent> patchComponents = new HashMap<String, PatchComponent>();
        for (int i4 = 0; i4 < oneoffs.size(); ++i4) {
            PatchComponent existingComponent;
            PatchComponent currentComponent;
            int j5;
            OneOffEntry currentEntry = oneoffs.get(i4);
            for (j5 = 0; j5 < currentEntry.getOptionalComponents().length; ++j5) {
                currentComponent = currentEntry.getOptionalComponents()[j5];
                if (patchComponents.containsKey(currentComponent.getID())) {
                    existingComponent = (PatchComponent)patchComponents.get(currentComponent.getID());
                    existingComponent = OneOffEntry.mergeTwoComponents(existingComponent, currentComponent);
                    continue;
                }
                patchComponents.put(currentComponent.getID(), (PatchComponent)currentComponent.clone());
            }
            for (j5 = 0; j5 < currentEntry.getRequiredComponents().length; ++j5) {
                currentComponent = currentEntry.getRequiredComponents()[j5];
                if (patchComponents.containsKey(currentComponent.getID())) {
                    existingComponent = (PatchComponent)patchComponents.get(currentComponent.getID());
                    existingComponent = OneOffEntry.mergeTwoComponents(existingComponent, currentComponent);
                    continue;
                }
                patchComponents.put(currentComponent.getID(), (PatchComponent)currentComponent.clone());
            }
        }
        Collection c2 = patchComponents.values();
        Iterator it = c2.iterator();
        ArrayList<PatchComponent> optionalComponents = new ArrayList<PatchComponent>();
        ArrayList<PatchComponent> requiredComponents = new ArrayList<PatchComponent>();
        while (it.hasNext()) {
            PatchComponent currentComponent = (PatchComponent)it.next();
            if (currentComponent.required) {
                requiredComponents.add(currentComponent);
                continue;
            }
            optionalComponents.add(currentComponent);
        }
        PatchComponent[] optComponents = new PatchComponent[optionalComponents.size()];
        PatchComponent[] reqdComponents = new PatchComponent[requiredComponents.size()];
        optComponents = optionalComponents.toArray(optComponents);
        reqdComponents = requiredComponents.toArray(reqdComponents);
        this.optComponents = optComponents;
        this.reqdComponents = reqdComponents;
    }

    public String getID() {
        return this.id;
    }

    public String getPatchID() {
        return this.patchID;
    }

    public String getTripletID() {
        return this.tripletID;
    }

    public String getPSENumber() {
        if (this.pse == "") {
            return this.getTmpPSENumber();
        }
        return this.pse;
    }

    public String getTmpPSENumber() {
        if (this.tpse == "") {
            long unix = this.convertToUnixTime(this.getCreationDate(), this.getCreationZone());
            return Long.toString(unix * -1L);
        }
        return this.tpse;
    }

    public String getPatchDesc() {
        return this.patchDesc;
    }

    public String getBundleDesc() {
        return this.bundleDesc;
    }

    public String getMinOPatchVersion() {
        return this.minOPatchVersion;
    }

    public String getPatchLanguage() {
        return this.patchLanguage;
    }

    public String getPatchModel() {
        return this.patchModel;
    }

    public ChecksumEntity[] getChecksumList() {
        if (this.getPatchType().equals("snowball")) {
            return new ChecksumEntity[0];
        }
        if (this.cke == null || OPatchEnv.isLoadPoh()) {
            this.cke = new ChecksumEntity[0];
        } else if (this.cke.length == 0) {
            try {
                this.cke = PatchObjectUtil.loadChecksumFile(this.checksum);
            }
            catch (Exception e2) {
                this.cke = new ChecksumEntity[0];
            }
        }
        return this.cke;
    }

    public OPatchFmwDS.DeployDS[] getDeployList() {
        return this.deployList;
    }

    public InterviewContextVar[] getInterviewList() {
        return this.interviewList;
    }

    public boolean isRollbackable() {
        return this.rollbackable;
    }

    public String getRollbackableDesc() {
        if (this.rollbackable) {
            return "true";
        }
        return "false";
    }

    public boolean isMiniPatchSet() {
        return this.miniPatchSet;
    }

    public Date getAppliedDate() {
        return this.appliedDate;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public boolean isTranslatable() {
        return this.translatable;
    }

    public boolean couldBeTranslation() {
        return this.couldBeTranslation;
    }

    protected void setUpdateCompsList(UpdateComponent[] uc) {
        this.updateCompsList = uc;
    }

    protected UpdateComponent[] getUpdateCompsList() {
        return this.updateCompsList;
    }

    public void setAppliedDate(Date date) {
        this.appliedDate = date;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getCreationZone() {
        return this.creationZone;
    }

    public String[] getBugIDsFixed() {
        StringBuffer buff = new StringBuffer("OneOffEntry::getBugIDsFixed()");
        OLogger.debug(buff);
        int len = this.bugsFixed != null ? this.bugsFixed.length : 0;
        Object[] bugs = new String[len];
        for (int i2 = 0; i2 < this.bugsFixed.length; ++i2) {
            Bug bug = this.bugsFixed[i2];
            String id = "";
            if (bug == null) continue;
            bugs[i2] = id = bug.getBugID();
        }
        buff = new StringBuffer("OneOffEntry::getBugIDsFixed() returns ");
        buff.append(len);
        buff.append(" bugs.");
        OLogger.debug(buff);
        Arrays.sort(bugs);
        return bugs;
    }

    public Bug[] getBugsFixed() {
        return this.bugsFixed;
    }

    public String getRelativePatchLocation() {
        return this.relativePatchLocation;
    }

    public String[][] getFilesTouched(String oracleHomePath) {
        if (this.filesTouched != null && this.filesTouched.length > 0) {
            return this.filesTouched;
        }
        if (this.po != null) {
            return PatchObjectUtil.getFilesTouched(this.oracleHome, this.patchActions);
        }
        return this.filesTouched;
    }

    public String[][] getFilesTouched() {
        if (this.filesTouched != null && this.filesTouched.length > 0) {
            return this.filesTouched;
        }
        if (this.po != null) {
            return PatchObjectUtil.getFilesTouched(this.oracleHome, this.patchActions);
        }
        return this.filesTouched;
    }

    public String[] getExecutedSql(String oracleHomePath) {
        String cookedPatchID = this.getCookedPatchID();
        ArrayList<String> dstPath = new ArrayList<String>();
        Properties prop = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
        if (prop != null) {
            String runSql = prop.getProperty("RUNSQL");
            if (runSql == null || runSql.equals("")) {
                return new String[0];
            }
            boolean isRunSql = Boolean.valueOf(runSql);
            if (isRunSql) {
                PatchAction[] pa = this.patchActions;
                for (int i2 = 0; i2 < pa.length; ++i2) {
                    sqlAction sa;
                    if (!(pa[i2] instanceof sqlAction) || !(sa = (sqlAction)pa[i2]).isApply()) continue;
                    String dstLocation = sa.getParentFilePath(oracleHomePath);
                    dstPath.add(dstLocation);
                }
                String[] retStr = new String[dstPath.size()];
                dstPath.toArray(retStr);
                return retStr;
            }
            return new String[0];
        }
        return new String[0];
    }

    public String getProceduresTouched(String oracleHomePath) {
        String cookedPatchID = this.getCookedPatchID();
        Properties prop = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
        ArrayList<String> procList = new ArrayList<String>();
        ArrayList<String> cleanList = new ArrayList<String>();
        int maxScreenLength = 74;
        if (prop != null) {
            String runSql = prop.getProperty("RUNSQL");
            if (runSql == null || runSql.equals("")) {
                return "";
            }
            boolean isRunSql = Boolean.valueOf(runSql);
            if (isRunSql) {
                PatchAction[] pa = this.patchActions;
                int tempLength = 0;
                boolean totalCount = false;
                for (int i2 = 0; i2 < pa.length; ++i2) {
                    if (!(pa[i2] instanceof sqlprocAction)) continue;
                    sqlprocAction spa = (sqlprocAction)pa[i2];
                    ArrayList procActionList = spa.getProcedureList();
                    for (int j2 = 0; j2 < procActionList.size(); ++j2) {
                        String procedure = (String)procActionList.get(j2);
                        if (cleanList.contains(procedure)) continue;
                        cleanList.add(procedure);
                        tempLength += procedure.length();
                        if (j2 != 0 || j2 != procActionList.size() || j2 == procActionList.size() && i2 != pa.length - 1) {
                            tempLength += 3;
                        }
                        if (tempLength > maxScreenLength) {
                            StringBuffer buff = new StringBuffer("\n     ");
                            buff.append(procedure);
                            procedure = buff.toString();
                            tempLength = 0;
                        }
                        procList.add(procedure);
                    }
                }
                String returnList = procList.toString();
                returnList = returnList.replace('[', ' ');
                returnList = returnList.replace(']', ' ');
                returnList = returnList.trim();
                return returnList;
            }
            return "";
        }
        return "";
    }

    public PatchComponent[] getAllComponents() {
        int i2;
        PatchComponent[] reqdComps = this.reqdComponents;
        PatchComponent[] optComps = this.optComponents;
        PatchComponent[] allComps = new PatchComponent[reqdComps.length + optComps.length];
        for (i2 = 0; i2 < reqdComps.length; ++i2) {
            allComps[i2] = reqdComps[i2];
        }
        for (i2 = 0; i2 < optComps.length; ++i2) {
            allComps[i2 + reqdComps.length] = optComps[i2];
        }
        return allComps;
    }

    public Object clone() {
        String constituentActiveField = this.constituentActiveField;
        boolean isComposite = this.isComposite;
        String compositeFileLocation = this.compositeFileLocation;
        String patchID = this.patchID;
        String id = this.id;
        String pse = this.pse;
        String tpse = this.tpse;
        String tripletID = this.tripletID;
        String cookedID = this.cookedID;
        Date appliedDate = this.appliedDate;
        String creationDate = this.creationDate;
        String creationZone = this.creationZone;
        String instanceShutdownMsg = this.instanceShutdownMsg;
        boolean rolling = this.rolling;
        boolean isSqlPatch = this.isSqlPatch;
        String sqlPatchDatabaseStartupMode = this.sqlPatchDatabaseStartupMode;
        boolean isFmwRolling = this.isFmwRolling;
        boolean isFmwFeatureBearing = this.isFmwFeatureBearing;
        boolean rollbackable = this.rollbackable;
        boolean auto = this.auto;
        boolean translatable = this.translatable;
        boolean exitIfPreScriptError = this.exitIfPreScriptError;
        boolean couldBeTranslation = this.couldBeTranslation;
        boolean instanceShutdown = this.isShutdown;
        boolean miniPatchSet = this.miniPatchSet;
        boolean cannotRollback = this.cannotAutoRollback;
        String patchType = this.patchType;
        String subType = this.subType;
        String patchDesc = this.patchDesc;
        String bundleDesc = this.bundleDesc;
        String patchLanguage = this.patchLanguage;
        String patchModel = this.patchModel;
        String productFamily = this.productFamily;
        String productType = this.producType;
        String relativePatchLocation = this.relativePatchLocation;
        String minOPatchVersion = this.minOPatchVersion;
        Bug[] bugs = (Bug[])this.bugsFixed.clone();
        UpdateComponent[] updateCompsList = (UpdateComponent[])this.updateCompsList.clone();
        String[][] filesTouched = (String[][])this.getFilesTouched().clone();
        String[] prereqOneOffs = (String[])this.prereqOneOffs.clone();
        WLSPatch[] wlsPrereqOneOffs = (WLSPatch[])this.wlsPrereqOneOffs.clone();
        String esysPatchID = this.esysPatchID;
        TargetEntity[] targetEntities = (TargetEntity[])this.targetEntities.clone();
        String[] coreqOneOffs = (String[])this.coreqOneOffs.clone();
        String[] overLayOneOffs = (String[])this.overLayOneOffs.clone();
        String[] prereqBugs = (String[])this.prereqBugs.clone();
        PatchAction[] patchActions = (PatchAction[])this.patchActions.clone();
        Platform[] suppPlatforms = (Platform[])this.supportedPlatforms.clone();
        String[] executables = (String[])this.executables.clone();
        PatchComponent[] reqdComps = (PatchComponent[])this.reqdComponents.clone();
        PatchComponent[] optComps = (PatchComponent[])this.optComponents.clone();
        InterviewContextVar[] interviewList = (InterviewContextVar[])this.interviewList.clone();
        OPatchFmwDS.DeployDS[] deployList = (OPatchFmwDS.DeployDS[])this.deployList.clone();
        Path checksumFile = this.checksum;
        NameVersionPair[] sysList = (NameVersionPair[])this.systemComponentList.clone();
        NameVersionPair[] appList = (NameVersionPair[])this.applicationShutdownList.clone();
        NameVersionPair[] productsList = (NameVersionPair[])this.productsList.clone();
        String[] applicationDirs = (String[])this.applicationDirs.clone();
        ArrayList<ParserObject> parser = this.getParserObject();
        String initDateStr = this.initDateStr;
        LinkedList componentList = (LinkedList)this.componentList.clone();
        Boolean isRu = this.isRu;
        String ruVersion = this.ruVersion;
        String regressedOneOff = this.regressedOneOff;
        boolean containsSymlinks = false;
        OneOffEntry oneOffEntry = null;
        if (this.po != null) {
            oneOffEntry = new OneOffEntry(constituentActiveField, isComposite, patchID, id, pse, cookedID, appliedDate, bugs, null, patchActions, creationZone, creationDate, rollbackable, prereqOneOffs, wlsPrereqOneOffs, coreqOneOffs, overLayOneOffs, executables, suppPlatforms, instanceShutdown, instanceShutdownMsg, rolling, isSqlPatch, sqlPatchDatabaseStartupMode, isFmwRolling, isFmwFeatureBearing, patchType, productFamily, reqdComps, optComps, sysList, appList, productType, productsList, relativePatchLocation, this.onlinePatch, this.portalPatch, miniPatchSet, updateCompsList, deployList, interviewList, auto, translatable, patchDesc, bundleDesc, patchModel, patchLanguage, prereqBugs, couldBeTranslation, null, minOPatchVersion, checksumFile, cannotRollback, exitIfPreScriptError, initDateStr, compositeFileLocation, targetEntities, esysPatchID, tpse, tripletID, applicationDirs, this.deleteOldDirectory, componentList, this.currentAppVerDirs, isRu, ruVersion, regressedOneOff, containsSymlinks);
            oneOffEntry.setPatchObject(this.po);
            oneOffEntry.setOracleHome(this.oracleHome);
        } else {
            oneOffEntry = new OneOffEntry(constituentActiveField, isComposite, patchID, id, pse, cookedID, appliedDate, bugs, filesTouched, patchActions, creationZone, creationDate, rollbackable, prereqOneOffs, wlsPrereqOneOffs, coreqOneOffs, overLayOneOffs, executables, suppPlatforms, instanceShutdown, instanceShutdownMsg, rolling, isSqlPatch, sqlPatchDatabaseStartupMode, isFmwRolling, isFmwFeatureBearing, patchType, productFamily, reqdComps, optComps, sysList, appList, productType, productsList, relativePatchLocation, this.onlinePatch, this.portalPatch, miniPatchSet, updateCompsList, deployList, interviewList, auto, translatable, patchDesc, bundleDesc, patchModel, patchLanguage, prereqBugs, couldBeTranslation, parser, minOPatchVersion, checksumFile, cannotRollback, exitIfPreScriptError, initDateStr, compositeFileLocation, targetEntities, esysPatchID, tpse, tripletID, applicationDirs, this.deleteOldDirectory, componentList, this.currentAppVerDirs, isRu, ruVersion, regressedOneOff, containsSymlinks);
        }
        if (subType != null && !subType.equals("")) {
            oneOffEntry.setSubType(subType);
        }
        return oneOffEntry;
    }

    public String getInitDateStr() {
        return this.initDateStr;
    }

    public void setInitDateStr(String initDateStr) {
        this.initDateStr = initDateStr;
    }

    public String getCompositeFileLocation() {
        return this.compositeFileLocation;
    }

    public String toString() {
        int iter;
        int fEntryLen;
        StringBuffer buff = new StringBuffer("[OneOffEntry: ");
        buff.append("id= ");
        buff.append(this.patchID);
        buff.append("triplet_id=");
        buff.append(this.tripletID);
        buff.append("description= ");
        buff.append(this.patchDesc);
        buff.append("Patch Model= ");
        buff.append(this.patchModel);
        buff.append("Language supported= ");
        buff.append(this.patchLanguage);
        buff.append("Is Auto?= ");
        buff.append(this.isAuto());
        buff.append("Is Translatatble?=");
        buff.append(this.isTranslatable());
        buff.append(", appliedDate= ");
        buff.append(this.appliedDate);
        buff.append(", isSqlPatch= ");
        buff.append(this.isSqlPatch);
        buff.append(", sqlPatchDatabasStartupMode= ");
        buff.append(this.sqlPatchDatabaseStartupMode);
        buff.append(", isFmwRolling= ");
        buff.append(this.isFmwRolling);
        buff.append(", isFmwFeatureBearing= ");
        buff.append(this.isFmwFeatureBearing);
        buff.append(", creationDate= ");
        buff.append(this.creationDate);
        buff.append(", ");
        Object obj = null;
        for (int i2 = 0; i2 < this.bugsFixed.length; ++i2) {
            Bug bug = this.bugsFixed[i2];
            buff.append(bug.toString());
        }
        buff.append(", ");
        String[][] filesTouched = this.getFilesTouched();
        int n2 = fEntryLen = filesTouched != null ? filesTouched.length : 0;
        if (fEntryLen == 0) {
            buff.append("\n * Warning: no filemap entries available.");
        } else {
            for (int iFileEntry = 0; iFileEntry < fEntryLen; ++iFileEntry) {
                String[] eachPath = filesTouched[iFileEntry];
                int fPathLen = eachPath != null ? eachPath.length : 0;
                buff.append("[Files Touched: ");
                if (fPathLen == 2) {
                    String K1 = eachPath[0];
                    String K2 = eachPath[1];
                    buff.append("name: ");
                    buff.append(K1);
                    buff.append(" , path: ");
                    buff.append(K2);
                }
                buff.append(" ]");
            }
        }
        buff.append(" ]");
        if (this.prereqOneOffs.length > 0) {
            buff.append(" [ Prereq OneOffs: ");
            for (iter = 0; iter < this.prereqOneOffs.length; ++iter) {
                buff.append(this.prereqOneOffs[iter]);
                buff.append(" ");
            }
            buff.append(" ]");
        }
        if (this.prereqBugs.length > 0) {
            buff.append(" [ Prereq Bugs: ");
            for (iter = 0; iter < this.prereqBugs.length; ++iter) {
                buff.append(this.prereqBugs[iter]);
                buff.append(" ");
            }
            buff.append(" ]");
        }
        if (this.wlsPrereqOneOffs.length > 0) {
            buff.append(" [ WLS Prereq OneOffs: ");
            for (iter = 0; iter < this.wlsPrereqOneOffs.length; ++iter) {
                buff.append("[Patch ID=" + this.wlsPrereqOneOffs[iter].getPatchID());
                buff.append(" Required=" + this.wlsPrereqOneOffs[iter].isRequired());
                buff.append("]   ");
            }
            buff.append(" ]");
        }
        if (this.targetEntities.length > 0) {
            buff.append(" [ Target Entities: ");
            for (iter = 0; iter < this.targetEntities.length; ++iter) {
                buff.append("[Target Type=" + this.targetEntities[iter].getTargetType());
                buff.append(" Target Version=" + this.targetEntities[iter].getTargetVersion());
                buff.append("] ");
            }
            buff.append(" ]");
        }
        if (this.coreqOneOffs.length > 0) {
            buff.append(" [ Coreq OneOffs: ");
            for (iter = 0; iter < this.coreqOneOffs.length; ++iter) {
                buff.append(this.coreqOneOffs[iter]);
                buff.append(" ");
            }
            buff.append(" ]");
        }
        if (this.overLayOneOffs.length > 0) {
            buff.append(" [ Overlay OneOffs: ");
            for (iter = 0; iter < this.overLayOneOffs.length; ++iter) {
                buff.append(this.overLayOneOffs[iter]);
                buff.append(" ");
            }
            buff.append(" ]");
        }
        return buff.toString();
    }

    public boolean equals(Object o2) {
        if (o2 instanceof OneOffEntry) {
            String myID = this.getTripletID();
            OneOffEntry oneOff = (OneOffEntry)o2;
            String itsID = oneOff.getTripletID();
            String itsLanguage = oneOff.getPatchLanguage();
            String myLanguage = this.getPatchLanguage();
            if (myID.equalsIgnoreCase(itsID) && myLanguage.equalsIgnoreCase(itsLanguage)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        String myID = this.getPatchID();
        int id = 12;
        try {
            id = Integer.parseInt(myID);
            result = 37 * result + id;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareTo(Object p2) {
        if (!(p2 instanceof OneOffEntry)) return -1;
        if (OPatchEnv.isLsinv_patch_id()) {
            String xPatchID = this.getPatchID();
            String yPatchID = ((OneOffEntry)p2).getPatchID();
            int ret = 0;
            try {
                long intPatchIDx = Long.parseLong(xPatchID);
                long intPatchIDy = Long.parseLong(yPatchID);
                ret = intPatchIDx < intPatchIDy ? -1 : (intPatchIDx > intPatchIDy ? 1 : 0);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
            }
            String sortOption = OPatchEnv.getLsinv_patch_id_order();
            if (sortOption.compareToIgnoreCase("desc") != 0) return ret;
            if (ret == 0) {
                return 0;
            }
            if (ret == 1) {
                return -1;
            }
            if (ret != -1) return -1;
            return 1;
        }
        Date itsDate = ((OneOffEntry)p2).getAppliedDate();
        Date myDate = this.getAppliedDate();
        int ret = myDate.compareTo(itsDate);
        String sortOption = OPatchEnv.getLsinv_patch_order();
        if (sortOption.compareToIgnoreCase("desc") != 0) return ret;
        if (ret == 0) {
            return 0;
        }
        if (ret == 1) {
            return -1;
        }
        if (ret != -1) return -1;
        return 1;
    }

    public String[] getOverLayPatchIDs() {
        return this.overLayOneOffs;
    }

    public String[] getTotalOverLayPatchIDs(String oracleHomePath, OneOffEntry[] oneOffsToApply) {
        HashSet<String> trueOverLayPatches = new HashSet<String>();
        for (int y = 0; y < this.overLayOneOffs.length; ++y) {
            trueOverLayPatches.add(this.overLayOneOffs[y]);
            ArrayList compositeImplicitOverLayPatches = OneOffEntry.getAllOverLaysForCompositePatch(this.overLayOneOffs[y], oracleHomePath);
            for (int z = 0; z < compositeImplicitOverLayPatches.size(); ++z) {
                trueOverLayPatches.add((String)compositeImplicitOverLayPatches.get(z));
            }
            for (int i2 = 0; i2 < oneOffsToApply.length; ++i2) {
                OneOffEntry oneOff = oneOffsToApply[i2];
                if (!oneOff.getIsComposite() || !oneOff.getID().equals(this.overLayOneOffs[y])) continue;
                String[] overlays = oneOff.getOverLayPatchIDs();
                for (int j2 = 0; j2 < overlays.length; ++j2) {
                    trueOverLayPatches.add(overlays[j2]);
                }
            }
        }
        String[] totalOverLayPatchIDs = new String[trueOverLayPatches.size()];
        totalOverLayPatchIDs = trueOverLayPatches.toArray(totalOverLayPatchIDs);
        return totalOverLayPatchIDs;
    }

    public static ArrayList getAllOverLaysForCompositePatch(String patchID, String oracleHomePath) {
        IIPMReadServices readServices;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable e2) {
            throw new RuntimeException("Problem loading generic inventory in getAllOverLaysForCompositePatch() function.");
        }
        OneOffEntry[] installedPatches = readServices.getInstalledPatches();
        ArrayList<String> lowerConstituents = new ArrayList<String>();
        for (int i2 = 0; i2 < installedPatches.length; ++i2) {
            if (!installedPatches[i2].getID().equals(patchID) || !installedPatches[i2].getIsComposite()) continue;
            String[] overlays = installedPatches[i2].getOverLayPatchIDs();
            for (int j2 = 0; j2 < overlays.length; ++j2) {
                lowerConstituents.add(overlays[j2]);
            }
        }
        return lowerConstituents;
    }

    public void setOverLayPatchIDs(String[] overlays) {
        this.overLayOneOffs = overlays;
    }

    public void addOverlayPatchIDs(String[] moreOverlays) {
        String[] current = this.overLayOneOffs;
        this.overLayOneOffs = new String[current.length + moreOverlays.length];
        System.arraycopy(current, 0, this.overLayOneOffs, 0, current.length);
        System.arraycopy(moreOverlays, 0, this.overLayOneOffs, current.length, moreOverlays.length);
    }

    public String[] getPrereqPatchIDs() {
        return this.prereqOneOffs;
    }

    public void setPrereqPatchIDs(String[] prereqs) {
        this.prereqOneOffs = prereqs;
    }

    public void addPrereqPatchIDs(String[] morePrereqs) {
        String[] current = this.prereqOneOffs;
        this.prereqOneOffs = new String[current.length + morePrereqs.length];
        System.arraycopy(current, 0, this.prereqOneOffs, 0, current.length);
        System.arraycopy(morePrereqs, 0, this.prereqOneOffs, current.length, morePrereqs.length);
    }

    public String getRegressedPatchID() {
        return this.regressedOneOff;
    }

    public String[] getPrereqBugIDs() {
        return this.prereqBugs;
    }

    public HashSet<String> getSupersetPatchIDs() {
        return this.supersetPatchIDs;
    }

    public void setSupersetPatchID(String supersetID) {
        this.supersetPatchIDs.add(supersetID);
    }

    public HashSet<String> getSubsetPatchIDs() {
        return this.subsetPatchIDs;
    }

    public void setSubsetPatchID(String supersetID) {
        this.subsetPatchIDs.add(supersetID);
    }

    public WLSPatch[] getWlsPrereqPatchIDs() {
        return this.wlsPrereqOneOffs;
    }

    public String getESysPatchID() {
        return this.esysPatchID;
    }

    public TargetEntity[] getTargetEntities() {
        return this.targetEntities;
    }

    public String[] getCoreqPatchIDs() {
        return this.coreqOneOffs;
    }

    public String[] getExecutables() {
        return this.executables;
    }

    public Platform[] getSupportedPlatforms() {
        return this.supportedPlatforms;
    }

    public UpdateComponent[] getUpdateComps() {
        return this.updateCompsList;
    }

    public NameVersionPair[] getSystemComponentList() {
        return this.systemComponentList;
    }

    public NameVersionPair[] getApplicationShutdownList() {
        return this.applicationShutdownList;
    }

    public NameVersionPair[] getProducts() {
        return this.productsList;
    }

    public PatchObject getPatchObject() {
        return this.po;
    }

    public void setPatchObject(PatchObject po) {
        this.po = po;
    }

    public ArrayList<ParserObject> getParserObject() {
        if (this.parserObjects != null && this.parserObjects.size() > 0) {
            return this.parserObjects;
        }
        if (this.po != null) {
            return this.po.getParserObject();
        }
        return this.parserObjects;
    }

    public String getPatchType() {
        return this.patchType;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getProductFamily() {
        return this.productFamily;
    }

    public String getProductType() {
        return this.producType;
    }

    public String getCookedPatchID() {
        return this.cookedID;
    }

    public boolean isInstanceShutdown() {
        return this.isShutdown;
    }

    public boolean isRolling() {
        return this.rolling;
    }

    public boolean isSqlPatch() {
        return this.isSqlPatch;
    }

    public String getSqlPatchDatabaseStartupMode() {
        return this.sqlPatchDatabaseStartupMode;
    }

    public boolean isFmwRolling() {
        return this.isFmwRolling;
    }

    public boolean isFmwFeatureBearing() {
        return this.isFmwFeatureBearing;
    }

    public boolean isOnlinePatch() {
        return this.onlinePatch;
    }

    public boolean isPortalPatch() {
        return this.portalPatch;
    }

    public boolean ContainsSymlinks() {
        return this.containsSymlinks;
    }

    public String getInstanceShutdownMessage() {
        return this.instanceShutdownMsg;
    }

    public PatchComponent[] getIncludedPatchComponents() {
        LinkedList<PatchComponent> includePatchComponentList = new LinkedList<PatchComponent>();
        for (PatchComponent pc : this.componentList) {
            if (pc.isExcluded()) continue;
            includePatchComponentList.add(pc);
        }
        PatchComponent[] cookedList = new PatchComponent[includePatchComponentList.size()];
        includePatchComponentList.toArray(cookedList);
        return cookedList;
    }

    public PatchComponent[] getRequiredComponents() {
        return this.reqdComponents;
    }

    public boolean isCannotAutoRollbackable() {
        return this.cannotAutoRollback;
    }

    public PatchComponent[] getOptionalComponents() {
        return this.optComponents;
    }

    public NameVersionPair getNameVersionPairObject(String name, ArrayList versions) {
        NameVersionPair obj = new NameVersionPair(name, versions);
        return obj;
    }

    public NameVersionPair getNameVersionPairObject(String name, ArrayList versions, boolean shutdown) {
        NameVersionPair obj = new NameVersionPair(name, versions, shutdown);
        return obj;
    }

    public boolean getIsComposite() {
        return this.isComposite;
    }

    public String getConstituentActiveField() {
        return this.constituentActiveField;
    }

    public String getActiveConstituent() {
        int index = this.constituentActiveField.lastIndexOf(",");
        if (index == -1) {
            return this.constituentActiveField;
        }
        return this.constituentActiveField.substring(index + 1);
    }

    public void setConstituentActiveField(String val) {
        this.constituentActiveField = val;
    }

    public boolean isOverlay(String patchID) {
        String[] overlayIDs = this.getOverLayPatchIDs();
        for (int i2 = 0; i2 < overlayIDs.length; ++i2) {
            if (!patchID.equals(overlayIDs[i2])) continue;
            return true;
        }
        return false;
    }

    public long convertToUnixTime(String time, String zone) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy, HH:mm:ss 'hrs'", Locale.ENGLISH);
        long unixtime = 0L;
        try {
            df.setTimeZone(TimeZone.getTimeZone(zone));
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
        try {
            unixtime = df.parse(time).getTime();
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
        }
        return unixtime;
    }

    public Set<String> getOverridingUPIs() {
        if (this.overridingUPIs != null) {
            return this.overridingUPIs;
        }
        String[] overridingUPIArray = CompositePatchObject.getOverrideUPIs(this.getCompositeFileLocation());
        this.overridingUPIs = new HashSet<String>(Arrays.asList(overridingUPIArray));
        return this.overridingUPIs;
    }

    public String[] getApplicationDirs() {
        return this.applicationDirs;
    }

    public boolean isDeleteOldDirectory() {
        return this.deleteOldDirectory;
    }

    public HashMap<String, String> getCurrentAppVerDirs() {
        return this.currentAppVerDirs;
    }

    public void setOracleHome(String oracleHome) {
        this.oracleHome = oracleHome;
    }

    public boolean getAutoRollback() {
        return this.autorollback;
    }

    public void setAutoRollback(boolean flag) {
        this.autorollback = flag;
    }

    public boolean getRu() {
        return this.isRu;
    }

    public String getRuVersion() {
        return this.ruVersion;
    }

    public class NameVersionPair
    implements Cloneable {
        private String name;
        private ArrayList version;
        private boolean shutdown;

        public NameVersionPair(String name, String ver) {
            this.name = name;
            this.version = new ArrayList();
            this.version.add(ver);
            this.shutdown = false;
        }

        public NameVersionPair(String name, ArrayList ver) {
            this.name = name;
            this.version = ver;
            this.shutdown = false;
        }

        public NameVersionPair(String name, String ver, boolean shutdown) {
            this.name = name;
            this.version = new ArrayList();
            this.version.add(ver);
            this.shutdown = shutdown;
        }

        public NameVersionPair(String name, ArrayList ver, boolean shutdown) {
            this.name = name;
            this.version = ver;
            this.shutdown = shutdown;
        }

        public String getName() {
            return this.name;
        }

        public ArrayList getVersions() {
            return this.version;
        }

        protected void setName(String val) {
            this.name = val;
        }

        protected void setVersions(ArrayList ver) {
            this.version = ver;
        }

        protected void addVersion(String ver) {
            this.version.add(ver);
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        public Object clone() {
            String name = this.name;
            ArrayList<String> versions = new ArrayList<String>();
            for (int i2 = 0; i2 < this.version.size(); ++i2) {
                String version = (String)this.version.get(i2);
                versions.add(version);
            }
            NameVersionPair nvp = new NameVersionPair(name, versions);
            return nvp;
        }
    }
}

