/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.opatch.Help;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.StringResource;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PQSession;

public class PrereqSession
extends OPatchSession
implements Help {
    public static IIPMReadServices getReadServices(String oracleHomePath) throws Throwable {
        if (oracleHomePath == null || oracleHomePath.equals("")) {
            throw new NullPointerException("PrereqSession::getReadServices() got a null oracleHomePath");
        }
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isInventoryLoaded() || !oracleHomePath.equals(readServices.getOracleHomePath())) {
            boolean isLocked = readServices.isLocked();
            try {
                if (!isLocked) {
                    readServices.lock(oracleHomePath);
                }
                readServices.loadInventory(oracleHomePath);
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                if (!isLocked) {
                    readServices.release();
                }
            }
        }
        return readServices;
    }

    public static void release(String oracleHomePath) throws Throwable {
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        readServices.release();
    }

    protected PrereqSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    @Override
    public boolean helpPresent() {
        return true;
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "opatchprereq/prereq_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }

    protected void process(String oracleHomePath, String prereqOption) throws RuntimeException, Error {
        OPatchSession.processDebugEnvironment();
        String[] nodes = new String[]{};
        String nodesStr = "";
        StringBuffer buff = new StringBuffer("PrereqSession::process() ");
        buff.append(oracleHomePath);
        OLogger.debug(buff);
        boolean isEsysPatch = PQSession.checkEsysForPrereq();
        if (isEsysPatch) {
            if (this.isSupportedByOpatchauto(prereqOption)) {
                throw new RuntimeException(OLogger.getString("OUI-68011") + " Please use opatchauto.");
            }
            throw new RuntimeException(OLogger.getString("OUI-68011"));
        }
        try {
            String className = "oracle.opatch.opatchprereq.PQSession";
            String functionName = prereqOption.toLowerCase();
            buff = new StringBuffer(" Checking on class ");
            buff.append(className);
            OLogger.debug(buff);
            Class<?> prereqClass = Class.forName(className);
            buff = new StringBuffer(" Get list of methods implemented by the class ");
            buff.append(className);
            OLogger.debug(buff);
            Method[] methods = prereqClass.getMethods();
            String defaultMethodName = "defaultOption";
            Class[] parameterTypes = new Class[1];
            String stringTypeName = "java.lang.String";
            buff = new StringBuffer(" Get a class of type ");
            buff.append(stringTypeName);
            OLogger.debug(buff);
            parameterTypes[0] = Class.forName(stringTypeName);
            buff = new StringBuffer(" Get the default method of the class ");
            buff.append(className);
            OLogger.debug(buff);
            Method defaultMethod = prereqClass.getMethod(defaultMethodName, parameterTypes);
            Object obj = null;
            Object[] args = new Object[]{oracleHomePath};
            boolean invoked = false;
            buff = new StringBuffer(" Begin searching for method ");
            buff.append(functionName);
            OLogger.debug(buff);
            for (int i2 = 0; i2 < methods.length; ++i2) {
                Method method = methods[i2];
                String methodName = method.getName();
                if (!methodName.equals(functionName)) continue;
                OLogger.println("Invoking prereq \"" + methodName + "\"");
                this.checkSrvmLibNeedLoad(functionName);
                Method m2 = prereqClass.getMethod(functionName, parameterTypes);
                m2.invoke(obj, args);
                invoked = true;
                break;
            }
            if (!invoked) {
                defaultMethod.invoke(obj, args);
            }
        }
        catch (ClassNotFoundException className) {
        }
        catch (InvocationTargetException e2) {
            buff = new StringBuffer("PrereqSession failed.");
            Throwable t = e2.getTargetException();
            if (t != null) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            OLogger.println(buff.toString());
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void checkSrvmLibNeedLoad(String methodName) {
        boolean needLoad = false;
        String[] needMethods = StringResource.PREREQ_SRVM_LOAD_METHODS;
        int len = needMethods.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!methodName.equals(needMethods[i2])) continue;
            needLoad = true;
            break;
        }
        if (needLoad) {
            OPatchSessionHelper.loadRACRelatedLibFile();
        }
    }

    private static boolean isDeprecatedOption(String prereqOption) {
        boolean isDeprecatedOption = false;
        String[] optionsRemoved = new String[]{"checkpatchsetupdatecompatible", "checkpatchsetupdatecomponents"};
        for (int i2 = 0; i2 < optionsRemoved.length; ++i2) {
            if (prereqOption.compareTo(optionsRemoved[i2]) != 0) continue;
            isDeprecatedOption = true;
        }
        return isDeprecatedOption;
    }

    private boolean isSupportedByOpatchauto(String option) {
        boolean isSupportedByOpatchauto = false;
        String[] supportedOptions = new String[]{"checkapplicable"};
        for (int i2 = 0; i2 < supportedOptions.length; ++i2) {
            if (!option.equalsIgnoreCase(supportedOptions[i2])) continue;
            isSupportedByOpatchauto = true;
            break;
        }
        return isSupportedByOpatchauto;
    }

    private boolean isNotApplicableForEsysPatch(String option) {
        boolean isNotApplicableForEsysPatch = false;
        String[] NATypes = new String[]{"checkfileversions", "checkfusionappscompatible", "checkforcrshomeifrac", "checkforidenticalpatchinoraclehome", "checkforinputvalues", "checkifohlockedforpatching", "checkinstalledoneoffs", "checkminimumopatchversion", "checkoneoffsuperset", "checkoraclehome", "checkoraInstlocation", "checkouilocation", "checkouiversioncompatible", "checkpatchrollbackdependents"};
        for (int i2 = 0; i2 < NATypes.length; ++i2) {
            if (option.compareTo(NATypes[i2]) != 0) continue;
            isNotApplicableForEsysPatch = true;
        }
        return isNotApplicableForEsysPatch;
    }

    private boolean isNoExChangeCommand(String option) {
        boolean isNoExChangeCommand = false;
        String[] NoExChanges = new String[]{"checkrollbackable", "checkrollbacksid", "checkstandalonehome", "checksystemcommandavailable", "checkuseradminpriviledge", "checkpatchingmodel"};
        for (int i2 = 0; i2 < NoExChanges.length; ++i2) {
            if (option.compareTo(NoExChanges[i2]) != 0) continue;
            isNoExChangeCommand = true;
        }
        return isNoExChangeCommand;
    }

    public static boolean isPrereqOptionValid(String prereqOption) {
        if (PrereqSession.isDeprecatedOption(prereqOption.toLowerCase())) {
            return false;
        }
        try {
            String className = "oracle.opatch.opatchprereq.PQSession";
            String functionName = prereqOption.toLowerCase();
            StringBuffer buff = new StringBuffer(" Checking on class ");
            buff.append(className);
            OLogger.debug(buff);
            Class<?> prereqClass = Class.forName(className);
            buff = new StringBuffer(" Get list of methods implemented by the class ");
            buff.append(className);
            OLogger.debug(buff);
            Method[] methods = prereqClass.getMethods();
            String defaultMethodName = "defaultOption";
            Class[] parameterTypes = new Class[1];
            String stringTypeName = "java.lang.String";
            buff = new StringBuffer(" Get a class of type ");
            buff.append(stringTypeName);
            OLogger.debug(buff);
            parameterTypes[0] = Class.forName(stringTypeName);
            buff = new StringBuffer(" Get the default method of the class ");
            buff.append(className);
            OLogger.debug(buff);
            buff = new StringBuffer(" Begin searching for method ");
            buff.append(prereqOption);
            OLogger.debug(buff);
            for (int i2 = 0; i2 < methods.length; ++i2) {
                Method method = methods[i2];
                String methodName = method.getName();
                if (!methodName.equals(functionName)) continue;
                OLogger.debug(new StringBuffer("Found prereq \"" + methodName + "\""));
                return true;
            }
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        return false;
    }
}

