/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.PatchObject;
import oracle.opatch.Rac;
import oracle.opatch.RacSrvm;
import oracle.opatch.Rules;
import oracle.opatch.opatchlogger.OLogger;

public class RacProcessor {
    protected static void pleaseShutdownFirstRollingNode(String localNode, String[] remoteNodes, boolean shutdown, String oracleHomePath, String sessionName, String shutdownMsg) throws RuntimeException {
        boolean prompt = shutdown;
        try {
            OPatchSessionHelper.checkArrayForNull("RemoteNodes", remoteNodes);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (prompt) {
            String nodesList = RacProcessor.getNodesString(remoteNodes);
            OLogger.printlnres("OUI-67170", new Object[]{nodesList, localNode, oracleHomePath, shutdownMsg});
            String question = OLogger.getString("OUI-67171");
            boolean proceed = OPatchEnv.proceedWithOperationDefaultYes(question + " " + "[y|n]");
            if (!proceed) {
                OPatchStateManagerFactory.getInstance().setErrorCode(204);
                StringBuffer errMsg = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                OLogger.info("OUI-67091", new Object[]{sessionName});
                ExitOPatchException oe = new ExitOPatchException(errMsg.toString());
                oe.setSysmodFailed();
                throw oe;
            }
        }
    }

    protected static void pleaseShutdownRollingNode(String node, boolean shutdown, String oracleHomePath, String sessionName, String shutdownMsg) throws RuntimeException {
        boolean prompt = shutdown;
        if (prompt) {
            OLogger.printlnres("OUI-67173", new Object[]{oracleHomePath, node});
            String question = OLogger.getString("OUI-67183", new Object[]{oracleHomePath, node, shutdownMsg});
            boolean proceed = OPatchEnv.proceedWithOperationDefaultYes(question + " " + "[y|n]");
            if (!proceed) {
                StringBuffer errMsg = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                OLogger.info("OUI-67091", new Object[]{sessionName});
                ExitOPatchException oe = new ExitOPatchException(errMsg.toString());
                oe.setSysmodFailed();
                throw oe;
            }
        }
    }

    protected static void pleaseShutdownNode(String oracleHomePath, String sessionName, String node, boolean shutdown, String shutdownMsg) throws RuntimeException {
        boolean prompt = shutdown;
        if (prompt) {
            String question;
            boolean proceed;
            if (OPatchEnv.isCASPhase2()) {
                OLogger.printlnres("OUI-67052", new Object[]{oracleHomePath, shutdownMsg});
            }
            if (!(proceed = OPatchEnv.proceedWithOperationDefaultYes((question = OLogger.getString("OUI-67178")) + " " + "[y|n]"))) {
                StringBuffer errMsg = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                OLogger.info("OUI-67091", new Object[]{sessionName});
                ExitOPatchException oe = new ExitOPatchException(errMsg.toString());
                oe.setSysmodFailed();
                throw oe;
            }
        }
    }

    protected static void pleaseStartupNode(String node, boolean shutdown, boolean waitForUserResponse) {
        boolean prompt = shutdown;
        if (prompt) {
            boolean silent = OPatchEnv.isSilent();
            boolean local = OPatchEnv.isLocal();
            OLogger.justlog(OLogger.INFO, "OUI-67179");
            if (silent) {
                return;
            }
            if (waitForUserResponse) {
                OPatchEnv.waitForUserEnter();
            }
        }
    }

    protected static void pleaseStartupFirstNode(String node, boolean shutdown) {
        boolean prompt = shutdown;
        if (prompt) {
            boolean silent = OPatchEnv.isSilent();
            boolean local = OPatchEnv.isLocal();
            OLogger.printlnres("OUI-67172", new Object[]{node});
        }
    }

    protected static void pleaseStartupRollingNode(String node, boolean shutdown) {
        boolean prompt = shutdown;
        if (prompt) {
            boolean silent = OPatchEnv.isSilent();
            boolean local = OPatchEnv.isLocal();
            OLogger.printlnres("OUI-67174", new Object[]{node});
        }
    }

    private static void pleaseShutdownNodes(String oracleHomePath, String[] doneNodes, String[] leftNodes, boolean shutdown, String sessionName, String shutdownMsg) throws RuntimeException {
        boolean prompt = shutdown;
        try {
            OPatchSessionHelper.checkArrayForNull("doneNodes", doneNodes);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        try {
            OPatchSessionHelper.checkArrayForNull("leftNodes", leftNodes);
        }
        catch (NullPointerException e3) {
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        if (prompt) {
            boolean silent = OPatchEnv.isSilent();
            String left = RacProcessor.getNodesString(leftNodes);
            String done = RacProcessor.getNodesString(doneNodes);
            OLogger.printlnres("OUI-67176", new Object[]{done, left, oracleHomePath, shutdownMsg});
            String question = OLogger.getString("OUI-67177");
            boolean proceed = OPatchEnv.proceedWithOperationDefaultYes(question + " " + "[y|n]");
            if (!proceed) {
                StringBuffer errMsg = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                OLogger.info("OUI-67091", new Object[]{sessionName});
                ExitOPatchException oe = new ExitOPatchException(errMsg.toString());
                oe.setSysmodFailed();
                throw oe;
            }
        }
    }

    private static void pleaseStartupSecondSet(String oracleHomePath, String[] nodes, boolean shutdown) throws RuntimeException {
        boolean prompt = shutdown;
        try {
            OPatchSessionHelper.checkArrayForNull("RemoteNodes", nodes);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (prompt) {
            boolean silent = OPatchEnv.isSilent();
            String nodeList = RacProcessor.getNodesString(nodes);
            OLogger.info("OUI-67182", new Object[]{oracleHomePath, nodeList});
        }
    }

    private static void pleaseShutdownLocalNodeFirst(String localNode, String oracleHomePath, String[] nodes, boolean shutdown, String sessionName, String shutdownMsg) throws RuntimeException {
        boolean prompt = shutdown;
        try {
            OPatchSessionHelper.checkArrayForNull("RemoteNodes", nodes);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (prompt) {
            boolean silent = OPatchEnv.isSilent();
            String nodeList = RacProcessor.getNodesString(nodes);
            String question = OLogger.getString("OUI-67175", new Object[]{oracleHomePath, shutdownMsg});
            boolean proceed = OPatchEnv.proceedWithOperationDefaultYes(question + " " + "[y|n]");
            if (!proceed) {
                StringBuffer errMsg = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                OLogger.info("OUI-67091", new Object[]{sessionName});
                ExitOPatchException oe = new ExitOPatchException(errMsg.toString());
                oe.setSysmodFailed();
                throw oe;
            }
        }
    }

    private static void pleaseStartupFirstSet(String oracleHomePath, String[] nodes, boolean shutdown) throws RuntimeException {
        boolean prompt = shutdown;
        try {
            OPatchSessionHelper.checkArrayForNull("RemoteNodes", nodes);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (prompt) {
            boolean silent = OPatchEnv.isSilent();
            String nodeList = RacProcessor.getNodesString(nodes);
            OLogger.info("OUI-67070", new Object[]{oracleHomePath, nodeList});
            if (!silent) {
                OPatchEnv.waitForUserEnter();
            }
        }
    }

    protected static void pleaseShutdownAllNodes(String[] remoteNodes, boolean shutdown, String localNode, String oracleHomePath, String sessionName, String shutdownMsg) throws RuntimeException {
        try {
            OPatchSessionHelper.checkArrayForNull("RemoteNodes", remoteNodes);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (remoteNodes.length == 0) {
            return;
        }
        boolean prompt = shutdown;
        if (!prompt) {
            return;
        }
        int len = remoteNodes.length;
        StringBuffer nodeList = new StringBuffer();
        for (int i2 = 0; i2 < len; ++i2) {
            String node = remoteNodes[i2];
            nodeList.append("'");
            nodeList.append(node);
            nodeList.append("' ");
        }
        OLogger.printlnres("OUI-67167", new Object[]{nodeList.toString(), localNode, oracleHomePath, shutdownMsg});
        String question = OLogger.getString("OUI-67168");
        boolean proceed = OPatchEnv.proceedWithOperationDefaultYes(question + " " + "[y|n]");
        if (!proceed) {
            StringBuffer errMsg = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
            OLogger.info("OUI-67091", new Object[]{sessionName});
            ExitOPatchException oe = new ExitOPatchException(errMsg.toString());
            oe.setSysmodFailed();
            throw oe;
        }
    }

    protected static void pleaseStartupAllNodes(String[] remoteNodes, boolean isShutDown) throws RuntimeException {
        try {
            OPatchSessionHelper.checkArrayForNull("RemoteNodes", remoteNodes);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (remoteNodes.length == 0) {
            return;
        }
        int len = remoteNodes.length;
        String nodeList = RacProcessor.getNodesString(remoteNodes);
        if (isShutDown) {
            OLogger.printlnres("OUI-67169", new Object[]{nodeList});
        }
    }

    private static String[] parseUserNodeSelection(String line) {
        String[] set = new String[]{};
        StringTokenizer token = new StringTokenizer(line, " ");
        int size = token.countTokens();
        set = new String[size];
        int i2 = 0;
        while (token.hasMoreTokens()) {
            String node = token.nextToken();
            set[i2] = node = node.trim();
            ++i2;
        }
        StringBuffer buff = new StringBuffer("parseUserNodeSelection() returns [");
        for (int i3 = 0; i3 < set.length; ++i3) {
            buff.append(set[i3]);
            buff.append(" ");
        }
        buff.append("]");
        OLogger.debug(buff);
        return set;
    }

    public static boolean subset(String[] set, String[] subset) {
        boolean isSubset = false;
        HashSet<String> hash = new HashSet<String>();
        if (set != null && subset != null) {
            String node;
            int i2;
            isSubset = true;
            for (i2 = 0; i2 < set.length; ++i2) {
                node = set[i2].toLowerCase();
                hash.add(node);
            }
            for (i2 = 0; i2 < subset.length; ++i2) {
                node = subset[i2].toLowerCase();
                if (hash.contains(node)) continue;
                isSubset = false;
            }
        }
        return isSubset;
    }

    public static String[] setSubtraction(String[] set, String[] subset) {
        String[] result = new String[]{};
        ArrayList<String> array = new ArrayList<String>();
        if (RacProcessor.subset(set, subset)) {
            int i2;
            Arrays.sort(set);
            Arrays.sort(subset);
            for (i2 = 0; i2 < set.length; ++i2) {
                String item = set[i2];
                boolean isThere = false;
                for (int j2 = 0; j2 < subset.length; ++j2) {
                    String subsetItem = subset[j2];
                    if (!subsetItem.equalsIgnoreCase(item)) continue;
                    isThere = true;
                }
                if (isThere) continue;
                array.add(item);
            }
            result = new String[array.size()];
            for (i2 = 0; i2 < array.size(); ++i2) {
                result[i2] = (String)array.get(i2);
            }
        } else {
            return set;
        }
        return result;
    }

    protected static int checkNodeSelection(String[] remoteNodes, String localNode, String[] selectionNodes) {
        int i2;
        boolean ok = false;
        StringBuffer buff = new StringBuffer("checkNodeSelection(): ");
        buff.append("remoteNodes are: ");
        for (i2 = 0; i2 < remoteNodes.length; ++i2) {
            buff.append(remoteNodes[i2]);
            buff.append(" ");
        }
        buff.append(", selectionNodes are: ");
        for (i2 = 0; i2 < selectionNodes.length; ++i2) {
            buff.append(selectionNodes[i2]);
            buff.append(" ");
        }
        buff.append(", local node is: ");
        buff.append(localNode);
        OLogger.debug(buff);
        if (remoteNodes != null && selectionNodes != null) {
            int rLen = remoteNodes.length;
            int sLen = selectionNodes.length;
            if (rLen == sLen) {
                for (int i3 = 0; i3 < rLen; ++i3) {
                    String remote = remoteNodes[i3];
                    String select = selectionNodes[i3];
                    if (remote.equals(select)) continue;
                    return 2;
                }
                return 0;
            }
            if (rLen == sLen - 1) {
                return 0;
            }
            boolean localNodeIncluded = false;
            for (int i4 = 0; i4 < selectionNodes.length; ++i4) {
                String node = selectionNodes[i4];
                if (!node.equals(localNode)) continue;
                localNodeIncluded = true;
                break;
            }
            if (localNodeIncluded) {
                return 3;
            }
            if (RacProcessor.subset(remoteNodes, selectionNodes)) {
                return 0;
            }
            return 2;
        }
        return 4;
    }

    private static String[] promptForNodeSelection(String localNode, String[] remoteNodes) {
        Object[] selectionNodes = new String[]{};
        boolean done = false;
        while (!done) {
            StringBuffer nodeList = new StringBuffer();
            for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
                String node = remoteNodes[i2];
                nodeList.append(node);
                nodeList.append("\n");
            }
            OLogger.printlnres("OUI-67058", new Object[]{nodeList.toString()});
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            String line = null;
            try {
                line = stdin.readLine();
                if (line.equals("")) {
                    OLogger.info("OUI-67059");
                    continue;
                }
                selectionNodes = RacProcessor.parseUserNodeSelection(line);
                Arrays.sort(remoteNodes);
                Arrays.sort(selectionNodes);
                int selectionCheck = RacProcessor.checkNodeSelection(remoteNodes, localNode, (String[])selectionNodes);
                if (selectionCheck == 0) {
                    StringBuffer list = new StringBuffer();
                    for (int i3 = 0; i3 < selectionNodes.length; ++i3) {
                        Object node = selectionNodes[i3];
                        list.append((String)node);
                        list.append("\n");
                    }
                    OLogger.info("OUI-67060", new Object[]{list, "[y|n]"});
                    boolean yes = OPatchEnv.waitForUserYesNo();
                    if (yes) {
                        done = true;
                        continue;
                    }
                    OLogger.info("OUI-67061");
                    continue;
                }
                if (selectionCheck == 2) {
                    OLogger.info("OUI-67062");
                    continue;
                }
                if (selectionCheck != 3) continue;
                OLogger.info("OUI-67062");
            }
            catch (IOException e2) {
                String msg = OLogger.warn("OUI-67063");
                RuntimeException rte = new RuntimeException(msg);
                rte.setStackTrace(e2.getStackTrace());
                throw rte;
            }
        }
        return selectionNodes;
    }

    public static String getNodesString(String[] nodes) {
        StringBuffer buff = new StringBuffer();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            buff.append("'");
            buff.append(nodes[i2]);
            buff.append("' ");
        }
        return buff.toString();
    }

    static RollingNodeSelection getNextNode(String[] nodes, boolean shutdown) throws IOException {
        int size = nodes.length;
        if (size > 1) {
            System.out.println("Remaining nodes to be patched: ");
            String nodeList = RacProcessor.getNodesString(nodes);
            System.out.println(nodeList);
            System.out.println("What is the next node to be patched?");
            boolean silent = OPatchEnv.isSilent();
            if (silent) {
                String nextNode = nodes[0];
                System.out.println(nextNode);
                String[] remainingNodes = new String[size - 1];
                for (int i2 = 1; i2 < size; ++i2) {
                    remainingNodes[i2 - 1] = nodes[i2];
                }
                RollingNodeSelection sel = new RollingNodeSelection(remainingNodes, nextNode);
                return sel;
            }
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            boolean done = false;
            while (!done) {
                int i3;
                String node = stdin.readLine();
                System.out.println("You have selected '" + node + "' from " + nodeList);
                boolean goodSelection = false;
                for (i3 = 0; i3 < size; ++i3) {
                    if (!node.equals(nodes[i3])) continue;
                    goodSelection = true;
                }
                if (!goodSelection) {
                    StringBuffer badSel = new StringBuffer("Bad node selection: \"");
                    badSel.append(node);
                    badSel.append("\".  ");
                    badSel.append("Select the next node to be patched again.");
                    System.out.println(badSel.toString());
                    continue;
                }
                String[] remainingNodes = new String[size - 1];
                int index = 0;
                for (i3 = 0; i3 < size; ++i3) {
                    String eachRemainingNode = nodes[i3];
                    if (node.equals(eachRemainingNode)) continue;
                    remainingNodes[index++] = eachRemainingNode;
                }
                RollingNodeSelection sel = new RollingNodeSelection(remainingNodes, node);
                return sel;
            }
        }
        throw new IOException("Calling getNextNode() with less than 2 remote nodes");
    }

    private static void processRollingMode(String oracleHomePath, String[] remoteNodes, String FP, String DP, String FR, String DR, String MP, String RC, boolean isShutDown, String sessionName, boolean apply, boolean rollback, boolean autoRollback, String patchStorageRac, String shutdownMsg, PatchObject[] patchObjects, PatchObject[] autoRolledBackPatchObjects, String localNode, boolean propagateToRemote, boolean runOnRemote) throws RuntimeException, Error {
        boolean done = false;
        String[] remainingNodes = remoteNodes;
        while (!done) {
            StringBuffer exitQuestion;
            boolean proceed;
            RollingNodeSelection selection = null;
            String nextNode = "";
            if (remainingNodes.length > 1) {
                try {
                    selection = RacProcessor.getNextNode(remainingNodes, isShutDown);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                nextNode = selection.getSelectNode();
                remainingNodes = selection.getRemainingNode();
            } else {
                nextNode = remainingNodes[0];
                remainingNodes = new String[]{};
                done = true;
            }
            boolean cont = true;
            try {
                RacProcessor.pleaseShutdownRollingNode(nextNode, isShutDown, oracleHomePath, sessionName, shutdownMsg);
            }
            catch (RuntimeException e3) {
                cont = false;
            }
            if (!cont && !(proceed = OPatchEnv.proceedWithOperationDefaultYes(exitQuestion = new StringBuffer("You may exit the patching session and patch remaining nodes later from an un-patched node.  Do you want to continue?")))) {
                StringBuffer errMsg = new StringBuffer("Patching aborted on node \"");
                errMsg.append(nextNode);
                errMsg.append("\"");
                if (remainingNodes.length > 0) {
                    String nodesStr = RacProcessor.getNodesString(remainingNodes);
                    errMsg.append(", remaining nodes are " + nodesStr);
                } else {
                    errMsg.append(", no remaining nodes.");
                }
                OLogger.println(errMsg.toString());
                throw new Error(errMsg.toString());
            }
            String[] patchingNodes = new String[]{nextNode};
            try {
                RacProcessor.patchGivenNodes(oracleHomePath, patchingNodes, FP, DP, FR, DR, MP, RC, apply, rollback, autoRollback, patchStorageRac, patchObjects, autoRolledBackPatchObjects, localNode, propagateToRemote, runOnRemote);
            }
            catch (RuntimeException e4) {
                throw e4;
            }
            catch (Error e5) {
                throw e5;
            }
            RacProcessor.pleaseStartupRollingNode(nextNode, isShutDown);
        }
    }

    private static void processAllNodeMode(String oracleHomePath, String[] remoteNodes, String FP, String DP, String FR, String DR, String MP, String RC, boolean isShutDown, String sessionName, boolean apply, boolean rollback, boolean autoRollback, String patchStorageRac, String shutdownMsg, PatchObject[] patchObjects, PatchObject[] autoRolledBackPatchObjects, String localNode, boolean propagateToRemote, boolean runOnRemote) throws RuntimeException, Error {
        try {
            RacProcessor.patchGivenNodes(oracleHomePath, remoteNodes, FP, DP, FR, DR, MP, RC, apply, rollback, autoRollback, patchStorageRac, patchObjects, autoRolledBackPatchObjects, localNode, propagateToRemote, runOnRemote);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Error e3) {
            throw e3;
        }
        RacProcessor.pleaseStartupAllNodes(remoteNodes, isShutDown);
    }

    protected static MinDowntimeNodeSelection getUserNodeSelection(String localNode, String[] remoteNodes) {
        String[] selectedNodes = RacProcessor.promptForNodeSelection(localNode, remoteNodes);
        int nNodesSelected = selectedNodes != null ? selectedNodes.length : 0;
        String[] leftNodes = RacProcessor.setSubtraction(remoteNodes, selectedNodes);
        int nLeftNodes = leftNodes.length;
        MinDowntimeNodeSelection selects = new MinDowntimeNodeSelection(selectedNodes, leftNodes);
        return selects;
    }

    private static void processMinDowntimeMode(String oracleHomePath, String[] remoteNodes, String FP, String DP, String FR, String DR, String MP, String RC, boolean shutdown, String sessionName, MinDowntimeNodeSelection selects, boolean apply, boolean rollback, boolean autoRollback, String patchStorageRac, String shutdownMsg, PatchObject[] patchObjects, PatchObject[] autoRolledBackPatchObjects, String localNode, boolean propagateToRemote, boolean runOnRemote) throws RuntimeException, Error {
        String[] selectedNodes = selects.getSelectSet();
        int nNodesSelected = selectedNodes != null ? selectedNodes.length : 0;
        String nodeList = RacProcessor.getNodesString(selectedNodes);
        boolean prompt = shutdown;
        OLogger.printlnres("OUI-67181", new Object[]{nodeList});
        if (prompt) {
            boolean silent = OPatchEnv.isSilent();
            String question = OLogger.getString("OUI-67180", new Object[]{oracleHomePath, nodeList, shutdownMsg});
            boolean proceed = OPatchEnv.proceedWithOperationDefaultYes(question + " " + "[y|n]");
            if (!proceed) {
                OPatchStateManagerFactory.getInstance().setErrorCode(205);
                StringBuffer errMsg = new StringBuffer(OLogger.getString("OUI-67091", new Object[]{sessionName}));
                OLogger.info("OUI-67091", new Object[]{sessionName});
                ExitOPatchException oe = new ExitOPatchException(errMsg.toString());
                oe.setSysmodFailed();
                throw oe;
            }
        }
        if (nNodesSelected > 0) {
            try {
                RacProcessor.patchGivenNodes(oracleHomePath, selectedNodes, FP, DP, FR, DR, MP, RC, apply, rollback, autoRollback, patchStorageRac, patchObjects, autoRolledBackPatchObjects, localNode, propagateToRemote, runOnRemote);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Error e3) {
                throw e3;
            }
        }
        String[] leftNodes = selects.getLeftNodes();
        String left = RacProcessor.getNodesString(leftNodes);
        int nLeftNodes = leftNodes.length;
        if (nLeftNodes > 0) {
            boolean cont = true;
            boolean done = false;
            while (!done) {
                try {
                    RacProcessor.pleaseShutdownNodes(oracleHomePath, selectedNodes, leftNodes, shutdown, sessionName, shutdownMsg);
                    done = true;
                }
                catch (RuntimeException e4) {
                    cont = false;
                }
                if (cont) continue;
                StringBuffer exitQuestion = new StringBuffer("You may exit the patching session and patch remaining nodes later from an un-patched node.  Do you want to continue?");
                boolean proceed = OPatchEnv.proceedWithOperationDefaultYes(exitQuestion);
                if (!proceed) {
                    StringBuffer errMsg = new StringBuffer("Patching aborted.  ");
                    errMsg.append("Remaining nodes are ");
                    errMsg.append(left);
                    OLogger.println(errMsg.toString());
                    throw new Error(errMsg.toString());
                }
                done = true;
            }
        }
        OLogger.println("");
        RacProcessor.pleaseStartupFirstSet(oracleHomePath, selectedNodes, shutdown);
        if (nLeftNodes > 0) {
            RacProcessor.patchGivenNodes(oracleHomePath, leftNodes, FP, DP, FR, DR, MP, RC, apply, rollback, autoRollback, patchStorageRac, patchObjects, autoRolledBackPatchObjects, localNode, propagateToRemote, runOnRemote);
            RacProcessor.pleaseStartupSecondSet(oracleHomePath, leftNodes, shutdown);
        }
    }

    public static MinDowntimeNodeSelection shutDownLogicsForProcessLocal(String sessionName, String oracleHomePath, Rac.RacType racType, Rules.RacPatchOrder order, String localNode, String[] remoteNodes, boolean shutdown, String shutdownMsg) throws RuntimeException {
        String[] firstSet = new String[]{};
        String[] leftNodes = new String[]{};
        MinDowntimeNodeSelection selects = new MinDowntimeNodeSelection(firstSet, leftNodes);
        String racRemindingMsg = racType.getRacDiagMessage();
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        OLogger.printlnOnLog(racRemindingMsg);
        if (rac.shouldPropagate(racType)) {
            if (order == Rules.RacPatchOrder.ALL_NODES) {
                RacProcessor.pleaseShutdownAllNodes(remoteNodes, shutdown, localNode, oracleHomePath, sessionName, shutdownMsg);
            } else if (order == Rules.RacPatchOrder.MIN_DOWN_TIME) {
                String nodeList = RacProcessor.getNodesString(remoteNodes);
                OLogger.printlnres("OUI-67071", new Object[]{nodeList, localNode, oracleHomePath, shutdownMsg});
                selects = RacProcessor.getUserNodeSelection(localNode, remoteNodes);
                firstSet = selects.getSelectSet();
                leftNodes = selects.getLeftNodes();
                RacProcessor.pleaseShutdownLocalNodeFirst(localNode, oracleHomePath, firstSet, shutdown, sessionName, shutdownMsg);
            } else if (order == Rules.RacPatchOrder.ROLLING) {
                RacProcessor.pleaseShutdownFirstRollingNode(localNode, remoteNodes, shutdown, oracleHomePath, sessionName, shutdownMsg);
            } else if (order == Rules.RacPatchOrder.LOCAL) {
                RacProcessor.pleaseShutdownNode(oracleHomePath, sessionName, localNode, shutdown, shutdownMsg);
            }
        } else {
            RacProcessor.pleaseShutdownNode(oracleHomePath, sessionName, localNode, shutdown, shutdownMsg);
        }
        return selects;
    }

    public static void startupLogicsForProcessLocal(Rac.RacType racType, Rules.RacPatchOrder order, String localNode, String[] remoteNodes, boolean isShutdown) {
        Rac rac = OPatchExternalFactory.getRac(null);
        if (rac.shouldPropagate(racType)) {
            if (order != Rules.RacPatchOrder.ALL_NODES && order != Rules.RacPatchOrder.MIN_DOWN_TIME) {
                if (order == Rules.RacPatchOrder.ROLLING) {
                    RacProcessor.pleaseStartupFirstNode(localNode, isShutdown);
                } else if (order == Rules.RacPatchOrder.LOCAL) {
                    boolean waitForUserResponse = false;
                    RacProcessor.pleaseStartupNode(localNode, isShutdown, waitForUserResponse);
                }
            }
        } else {
            boolean waitForUserResponse = false;
            RacProcessor.pleaseStartupNode(localNode, isShutdown, waitForUserResponse);
        }
    }

    public static void patchRemoteNodes(String oracleHomePath, String[] remoteNodes, Rules.RacPatchOrder order, String FP, String DP, String FR, String DR, String MP, String RC, boolean isShutDown, String sessionName, MinDowntimeNodeSelection selects, boolean apply, boolean rollback, boolean autoRollback, String patchStorageRac, String shutdownMsg, PatchObject[] patchObjects, PatchObject[] autoRolledBackPatchObjects, String localNode, boolean propagateToRemote, boolean runOnRemote) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer(order.toString());
        OLogger.debug(buff);
        Arrays.sort(remoteNodes);
        buff = new StringBuffer("patchRemoteNodes() for the following nodes:\n");
        for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
            buff.append(remoteNodes[i2]);
            buff.append(" ");
        }
        OLogger.debug(buff);
        if (order != Rules.RacPatchOrder.LOCAL) {
            if (order == Rules.RacPatchOrder.ROLLING) {
                try {
                    OLogger.printlnres("OUI-67198");
                    RacProcessor.processRollingMode(oracleHomePath, remoteNodes, FP, DP, FR, DR, MP, RC, isShutDown, sessionName, apply, rollback, autoRollback, patchStorageRac, shutdownMsg, patchObjects, autoRolledBackPatchObjects, localNode, propagateToRemote, runOnRemote);
                }
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Error e3) {
                    throw e3;
                }
                finally {
                    OLogger.printlnres("OUI-67660");
                }
            }
            if (order == Rules.RacPatchOrder.ALL_NODES) {
                try {
                    OLogger.printlnres("OUI-67199");
                    RacProcessor.processAllNodeMode(oracleHomePath, remoteNodes, FP, DP, FR, DR, MP, RC, isShutDown, sessionName, apply, rollback, autoRollback, patchStorageRac, shutdownMsg, patchObjects, autoRolledBackPatchObjects, localNode, propagateToRemote, runOnRemote);
                }
                catch (RuntimeException e4) {
                    throw e4;
                }
                catch (Error e5) {
                    throw e5;
                }
            }
            if (order == Rules.RacPatchOrder.MIN_DOWN_TIME) {
                try {
                    OLogger.printlnres("OUI-67197");
                    RacProcessor.processMinDowntimeMode(oracleHomePath, remoteNodes, FP, DP, FR, DR, MP, RC, isShutDown, sessionName, selects, apply, rollback, autoRollback, patchStorageRac, shutdownMsg, patchObjects, autoRolledBackPatchObjects, localNode, propagateToRemote, runOnRemote);
                }
                catch (RuntimeException e6) {
                    throw e6;
                }
                catch (Error e7) {
                    throw e7;
                }
            }
        }
    }

    private static void patchGivenNodes(String oracleHomePath, String[] nodes, String FP, String DP, String FR, String DR, String MP, String RC, boolean apply, boolean rollback, boolean auto_rollback, String patchStorageRac, PatchObject[] patchObjects, PatchObject[] autoRolledBackPatchObjects, String localNode, boolean propagateToRemote, boolean runOnRemote) throws RuntimeException, Error {
        boolean inventoryMod = Rules.OUIWrite_continue();
        boolean systemWrite = Rules.SystemWrite_continue();
        RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
        StringBuffer buff = new StringBuffer("patchGivenNodes()");
        OLogger.debug(buff);
        if (nodes == null) {
            OPatchStateManagerFactory.getInstance().setErrorCode(206);
            buff = new StringBuffer(" Null list of nodes");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (nodes.length == 0) {
            OPatchStateManagerFactory.getInstance().setErrorCode(206);
            buff = new StringBuffer(" Empty list of nodes");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        int nNodes = nodes.length;
        String nodesBuff = RacProcessor.getNodesString(nodes);
        StringBuffer report = new StringBuffer("\nBegin patching the following nodes:\n");
        report.append(nodesBuff.toString());
        report.append("\n");
        OLogger.verbose(null, report);
        try {
            racSrvm.updateRemoteNodes(oracleHomePath, nodes, apply, rollback, auto_rollback, FP, DP, FR, DR, MP, RC, patchStorageRac, patchObjects, autoRolledBackPatchObjects, localNode, propagateToRemote, runOnRemote);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Error e3) {
            throw e3;
        }
    }

    public static void main(String[] args) {
        String[] remoteNodes = new String[]{"node1", "node2", "node3"};
        String localNode = "node0";
        Object patchObject = null;
        boolean local = false;
        boolean minDT = true;
        boolean rolling = false;
        boolean allNode = true;
        boolean shutdown = true;
        boolean propagateBackupPatchToNode = true;
        String oracleHomePath = "C:\\oracle\\10g";
        try {
            OPatchACL.invokeOLogger(new RacProcessor(), "setDebug", new Object[]{true});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        boolean silent = true;
        OPatchEnv.setSilent(silent);
        Rac.RacType racType = Rac.RacType.NO_RAC;
        Rules.RacPatchOrder order = Rules.getRacPatchOrder(racType, local, rolling, minDT, allNode, silent);
        System.out.println("patch order is: " + order.toString());
        try {
            PatchObject[] autoRolledBackPatchObjects = new PatchObject[]{};
            boolean rolledBack = false;
            MinDowntimeNodeSelection minDowntimeNodeSelection = RacProcessor.getUserNodeSelection(localNode, remoteNodes);
        }
        catch (RuntimeException e2) {
            System.out.println("Exception in RacProcessor::main(): " + e2.getMessage());
            OLogger.printStackTrace(e2);
        }
        catch (Error e3) {
            System.out.println("Error in RacProcessor::main(): " + e3.getMessage());
            OLogger.printStackTrace(e3);
        }
    }

    public static class RollingNodeSelection {
        String[] remainingNodes;
        String selectNode;

        public RollingNodeSelection(String[] remainingNodes, String selectNode) {
            this.remainingNodes = remainingNodes;
            this.selectNode = selectNode;
        }

        String[] getRemainingNode() {
            return this.remainingNodes;
        }

        String getSelectNode() {
            return this.selectNode;
        }
    }

    public static class MinDowntimeNodeSelection {
        String[] selectSet = new String[0];
        String[] leftNodes = new String[0];

        public MinDowntimeNodeSelection(String[] selectSet, String[] leftNodes) {
            if (selectSet != null) {
                this.selectSet = selectSet;
            }
            if (leftNodes != null) {
                this.leftNodes = leftNodes;
            }
        }

        protected String[] getSelectSet() {
            return this.selectSet;
        }

        protected String[] getLeftNodes() {
            return this.leftNodes;
        }
    }
}

