/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;

class ReaderThread
extends Thread {
    private InputStreamReader isr;
    private String name;
    public String outputString;
    public static boolean printConsole = false;
    public static boolean printOnLog = false;

    public ReaderThread(InputStreamReader isr, String name) {
        this.isr = isr;
        this.name = name;
    }

    @Override
    public void run() {
        try {
            OPatchACL.invokeOLogger(this, "managedByParentThread", new Object[]{SystemCall.mainThread});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        StringBuffer buff = new StringBuffer("ReaderThread::run(): Stream ");
        buff.append(this.name);
        buff.append(" about to be read");
        OLogger.debug(buff);
        try {
            if (!OPatchEnv.isRunTimeExecMessageNeeded()) {
                return;
            }
            BufferedReader br = new BufferedReader(this.isr);
            StringBuffer sb = new StringBuffer();
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
                if (printConsole) {
                    OLogger.printlnOnConsole(line);
                }
                if (!printOnLog) continue;
                OLogger.printlnOnLog(line);
            }
            this.outputString = sb.toString();
            buff = new StringBuffer("ReaderThread::run(): Stream ");
            buff.append(this.name);
            buff.append(" reading completed");
            OLogger.debug(buff);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
    }
}

